/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import org.dbdoclet.service.StringServices;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.dom.CharacterDataImpl;
import org.dbdoclet.xiphias.dom.CommentImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class CommentEditor extends DocBookEditor {

	@Override
	public EditorInstruction edit(EditorInstruction values) throws EditorException {

		try {

			setValues(super.edit(values));

			NodeImpl parent = getParent();
			getCurrent();

			CharacterDataImpl node = getCharacterDataNode();

			if (node instanceof CommentImpl == false) {
				return finalizeValues();
			}

			CommentImpl comment = (CommentImpl) node;
			String text = comment.getData();

			if (text == null) {
				return finalizeValues();
			}

			text = text.trim();
			text = StringServices.cutPrefix(text, "<!--");
			text = StringServices.cutSuffix(text, "-->");
			text = text.trim();
			text = StringServices.cutPrefix(text, "[:dbdoclet:]");
			text = text.trim();

			if (text.startsWith("insert ")) {

				text = StringServices.cutPrefix(text, "insert");
				text = text.trim();

				text = XmlServices.textToXml(text);
				text = StringServices.replace(text, "(", "<");
				text = StringServices.replace(text, ")", ">");
				text = StringServices.replace(text, "<<", "(");
				text = StringServices.replace(text, ">>", ")");

				parent.appendChild(text, false);
			}

			return finalizeValues();

		} catch (Exception oops) {
			throw new EditorException(oops);
		}
	}
}
