#!/usr/bin/bash

### INSTALL / REMOVE SCRIPT ###

# Test if running as root
if [[ "$EUID" -ne 0 ]]; then
	printf "\n\e[31mMust run as root , use sudo install.sh\e[0m\n\n"
	exit 1
fi

# Usage
USAGE="
Arguements:
	-i || install 	- install display-dhammapada
	-u || uninstall	- uninstall display-dhammapada 
"

# Set source for display-dhammapada
SOURCE_FILES="usr/share/display-dhammapada"
SOURCE_BIN="usr/local/bin"

# Set destination for display-dhammapada
DEST_BIN="/usr/local/bin"
DEST_FILES="/usr/share/display-dhammapada"

if [[ "$#" -gt "1" ]]; then printf "%s\n" "$USAGE"; exit 1; fi

case "$1" in
	-i | install )
		[[ -f /usr/share/man/man1/fortune-dhammapada.1.gz ]] || { printf "\n\e[31mInstall fortune-dhammapada then re-run install.display-dhamapada.sh\n\n\e[0mDownload fortune-dhammapada from https://gitlab.com/bodhi.zazen/fortune-dhammapada\n\n" ; exit 1 ; }
		if [[ -x "$DEST_BIN"/display-dhammapada ]] ; then 
			printf "\n\e[32mdisplay-dhammapada already installed\e[0m\n\n"
			exit 1
		else
			cp -v "$SOURCE_BIN"/* "$DEST_BIN"/
		if [[ ! -f /usr/share/man/man1/display-dhammapada.1.gz ]] ; then 
			gzip -c man/display-dhammapada.1 > /usr/share/man/man1/display-dhammapada.1.gz
		fi
		if [[ ! -d "$DEST_FILES" ]]; then
			mkdir -p "$DEST_FILES"
		fi
		cp "$SOURCE_FILES"/*.about "$DEST_FILES"/
		printf "\n\e[32mInstall successful\e[0m\n\n"
		exit 0
		fi
		;;
	-u | uninstall)
		if [[ ! -x "$DEST_BIN"/display-dhammapada ]] ; then
			printf "\n\e[32mdisplay-dhammapada not installed\e[0m\n\n"
			exit 1
		fi
		rm -rv "$DEST_FILES"
		rm -v "$DEST_BIN"/display-dhammapada
		rm -v /usr/share/man/man1/display-dhammapada.1.gz
		printf "\n\e[32mRemoval successful\e[0m\n\n"
		exit 0
		;;
	*)
	printf "%s\n" "$USAGE"
	exit 1
	;;
esac
