#!/bin/bash

# Copyright (C) 2025 Pädagogisches Landesinstitut Rheinland-Pfalz
# Copyright (C) 2025 by Mike Gabriel <mike.gabriel@it-zukunft-schule.de>
#
# This script is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This script is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

# Block squid_d-e-r_acl_watcher.service from restarting/reloading Squid.
echo "BLOCKING_PID=\"$$\""                    >  "${FILTERLISTS_PATH}/work-in-progress"
echo "BLOCKING_DATE=\"$(LANG=C.UTF-8 date)\"" >> "${FILTERLISTS_PATH}/work-in-progress"

###
common_file="/usr/share/debian-edu-router/debian-edu-router.common"
# Load common functions, variables and stuff.
if [ -s "$common_file" ]; then
	source "$common_file"
else
	echo "Could not load common file at "$common_file"."
	exit 0;
fi
###

# Obtain whitelists/blacklists for e2guardian (if SSL bumping is enabled, e2guardian handles
# processing of filterlists).
debian-edu-router_refresh-blacklists_e2guardian $@

# Obtain whitelists/blacklists for squid (if SSL bumping is disabled, squid handles
# processing of filterlists).
debian-edu-router_refresh-blacklists_squid $@

# Reload Squid.
notice_log "Reloading all Squid processes..."
if [[ "${NO_SERVICE_RESTARTS}" != "true" ]]; then
	manage_unit "start" "squid_d-e-r_acl_watcher.service" && {
		notice_log "Success!"
	} || {
		error_log "Error happened while reloading Squid processes (starting Squid ACL watcher service)!"
	}
fi
