/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/



/**
a multifont textline
*/

class multifont_label :  public multiline_label{

public:

  /**
   *Costruttore di default, riempie i valori con immondizia.
   */

  multifont_label();

  multifont_label(int nfont, int ndim , int ncr, int ncg, int ncb);

  multifont_label(const multifont_label& other);

  multifont_label(const multifont_label* other);

  multifont_label& operator=(const multifont_label& other);

  virtual ~multifont_label();

  virtual void disegna();

  virtual void insert_string_in_curr_pos(std::string str,int type);

  virtual void insert_char_in_curr_pos(char add, int type);

  virtual void manage_sub_super(int check, int troublesome,std::string car);

  virtual bool manage_add_sub_super_next_normal_str(int type);

  virtual bool manage_add_sub_next_super(int type);

  virtual bool cursor_one_step_fwd(int &curr_type);

  virtual bool cursor_one_step_back(int &curr_type);


  virtual void delete_char_curr_pos(bool before);



protected:

  virtual void format_paragraph();

  virtual int break_lines_into_sublabel();

  virtual int break_line_into_sublabel(etichetta* to_break,
                                        vector <etichetta*>& new_lines_of_text);



  virtual int atomize_normal_string(etichetta* the_template,
                                     std::string the_string,
                                     vector <etichetta*>& new_lines_of_text);


  virtual void fall_apart_line_and_add_normal_string(char add);

};
