# What caused the degeneration of the Russian Revolution?

As is well known, the Russian Revolution failed. Rather than produce
socialism, the Bolshevik revolution gave birth to an autocratic party
dictatorship presiding over a state capitalist economy. In turn, this regime
gave rise to the horrors of Stalinism. While Stalinism was denounced by all
genuine socialists, a massive debate has existed within the Marxist movement
over when, exactly, the Russian Revolution failed and why it did.

Indeed, it is fair to say that the date choosen indicates much about the
individual's or party's other politics. Some argue around 1928, others say
around 1924, a few -- anarchists and libertarian Marxists -- argue from the
Bolshevik seizure of power 1917. The reasons for the failure tend to be more
readily agreed upon within pro-Bolshevik Marxist circles than the date:
isolation, the economic and social costs of civil war, the "backward" nature
of Russian society and economy are usually listed as the key factors. As we
shall see, these are often referred to as "objective factors" in constrast to
the "subjective factors" of Bolshevik ideology, decisions and actions.

Moreover, what the Stalinist regime was is also discussed heatedly in Marxist
circles. While anarchists agree with Emma Goldman's summation that it was _"an
absolute despotism politically and the crassest form of state capitalism
economically"_ [ **Red Emma Speaks** , p. 420] so confirming in practice
Kropotkin's analysis that _"State Socialism . . . is in reality nothing but
State capitalism"_ [ _"Caesarism,"_ , **Freedom** , June 1899], mainstream
Marxists have had more difficulty agreeing -- some (orthodox Trotskyists)
claiming it was a _"degenerated workers state,"_ others (such as the neo-
Trotskyist British SWP) that it was _"state capitalist"_ (although, as
discussed in [section H.3.13](secH3.md#sech313), for different reasons than
anarchists). Indeed, after describing the various Marxist theories on the
Russian regime, one expert concluded that _"it is perfectly clear that Soviet
society can hardly be explained in orthodox-Marxian terms at all. If it is
accepted that the USSR was not communist in a Marxian sense, the analysis
becomes almost impossible"_. [Marcel van der Linden, **Western Marxism and the
Soviet Union** , p. 317]

For anarchists, however, the failure of Bolshevism did not come as a surprise.
In fact, just as with the reformist fate of the Social Democrats, the failure
of the Russian Revolution provided empirical evidence for Bakunin's critique
of Marx ([section H.1.1](secH1.md#sech11)). As Emma Goldman recounts in her
memoirs:

> _"Professor Harold Laski . . . expressed the opinion that I ought to take
> some comfort in the vindication anarchism had received by the Bolsheviki. I
> agreed, adding that not only their regime, but their stepbrothers as well,
> the Socialists in power in other countries, had demonstrated the failure of
> the Marxian State better than any anarchist argument. Living proof was
> always more convincing than theory. Naturally I did not regret the Socialist
> failure but I could not rejoice in it in the face of the Russian tragedy."_
> [ **Living My Life** , vol. 2, p. 969]

Alexander Berkman, like Goldman an eye-witness to developments between 1920
and 1922, provides an excellent overview of what had happened in Russia after
the October Revolution:

> _"The elective system was abolished, first in the army and navy, then in the
> industries. The Soviets of peasants and workers were castrated and turned
> into obedient Communist Committees, with the dreaded sword of the Cheka
> [political para-military police] ever hanging over them. The labour unions
> governmentalised, their proper activities suppressed, they were turned into
> mere transmitters of the orders of the State. Universal military service,
> coupled with the death penalty for conscientious objectors; enforced labour,
> with a vast officialdom for the apprehension and punishment of 'deserters';
> agrarian and industrial conscription of the peasantry; military Communism in
> the cities and the system of requisitioning in the country . . . ; the
> suppression of workers' protests by the military; the crushing of peasant
> dissatisfaction with an iron hand . . ."_ [ **The Russian Tragedy** , p. 27]

Given that Leninists claim that the Russian revolution was a success (at least
initially) and so proves the validity of their ideology, anarchists have a
special duty to analyse and understand what went wrong. Simply put, if the
Russian Revolution was a success, Leninism does not need failures!

This appendix aims to discuss these pro-Bolshevik explanations for the failure
of Bolshevism in more detail than in [section H.6.1](secH6.md#sech61),
indicating why anarchists are not convinced by Leninist accounts of why
Bolshevism created a new class system rather than socialism. This subject is
no mere historical discussion. Unless we learn the lessons of history, we will
be doomed to repeat them. More, given the fact that many people who become
interested in socialist ideas will come across the remnants of Leninist
parties it is important that libertarians explain clearly and convincingly why
the Russian Revolution failed and the role of Bolshevik ideology in that
process. We need to account why a popular revolution became a state capitalist
party dictatorship. As Noam Chomsky put it:

> _"In the stages leading up to the Bolshevik coup in October 1917, there
> **were** incipient socialist institutions developing in Russia -- workers'
> councils, collectives, things like that. And they survived to an extent once
> the Bolsheviks took over -- but not for very long; Lenin and Trotsky pretty
> much eliminated them as they consolidated their power. I mean, you can argue
> about the **justification** for eliminating them, but the fact is that the
> socialist initiatives were pretty quickly eliminated._

> _"Now, people who want to justify it say, 'The Bolsheviks had to do it' --
> that's the standard justification: Lenin and Trotsky had to do it, because
> of the contingencies of the civil war, for survival, there wouldn't have
> been food otherwise, this and that. Well, obviously the question is, was
> that true. To answer that, you've got to look at the historical facts: I
> don't think it was true. In fact, I think the incipient socialist structures
> in Russia were dismantled **before** the really dire conditions arose . . .
> reading their own writings, my feeling is that Lenin and Trotsky knew what
> they were doing, it was conscious and understandable."_ [ **Understanding
> Power** , p. 226]

As we discussed in [section H.6](secH6.md), Chomsky's feeling is more than
supported by the historical record. The elimination of meaningful working
class freedom and self-management began from the creation of the new regime
after the October Revolution and was firmly in place before the start of the
civil war at the end of May, 1918. The civil war simply accelerated processes
which had already began, strengthened policies that had already been applied.
Indeed, it could be argued that rather than impose alien policies onto
Bolshevism, the civil war simply brought the hidden (and not-so-hidden) state
capitalist and authoritarian politics of Leninism (and mainstream Marxism) to
the fore.

Which is why analysing the failure of the revolution is important. If the
various arguments presented by Leninists on why Bolshevism failed (and,
consequently, why Stalinism developed) can be refuted, then we are left with
the key issues of revolutionary politics -- whether Bolshevik politics had a
decisive negative impact on the development of the Russian Revolution and, if
so, whether there was an alternative to those politics. As regards the first
issue, as we discussed in [section H.6.2](secH6.md#sech62), anarchists argue
that this was the case: Bolshevik ideology itself played a key role in the
degeneration of the revolution (also see the appendix on ["How did Bolshevik
ideology contribute to the failure of the Revolution?"](append44.md)). And
as regards the second, anarchists can point to the example of the Makhnovist
movement active in Ukraine during the same revolution, which proves that
alternative policies were possible and could be applied with radically
different outcomes (see the appendix on ["Why does the Makhnovist movement
show there is an alternative to Bolshevism?"](append46.md)).

Before continuing, we must note that our division of the discussion into
objective and subjective factors is, of course, artifical and purely
presentational. It is impossible to discuss everything at once and, moreover,
this reflects pro-Bolshevik accounts of the regime which focus primarily on
"objective factors" and rarely address ideological and structural influences
(beyond lamenting that their often all-too-idealised version of Bolshevik
ideology had to be undermined to secure the survival of the revolution). So it
must be noted that anarchists stress the interplay between the "objective
factors" and the subjective ones such as party ideology. Faced with difficult
circumstances, people and parties react in different ways. If they did not
then it would imply what people think has no impact at all on their actions,
that the politics of the Bolsheviks played no role in their decisions -- which
raises the interesting contradiction of why Leninists stress the power and
importance of having the correct (their!) ideology. Unsurprisingly, this
position simply cannot be maintained. As [section H](secHcon.md) indicates,
Leninist ideology itself played a key role in the rise of Stalinism.

Leninists, of course, try to distance themselves from Stalinism, correctly
arguing that it was a brutal and undemocratic system (although some did, and
do, defend it against attacks from the right). The problem is that it was when
Lenin and Trotsky were at the head of the so-called "workers' state" rather
than when Stalin occupied that position that the regime broke strikes,
repressed protests, shot strikers, banned left papers along with radical
organisations and party factions, sent workers and revolutionaries to prison,
advocated and introduced one-man management and piece-work in the workplace,
eliminated democracy in the military, packed soviets to secure party power and
shut down soviets elected with the "wrong" (i.e. non-Bolshevik) majorities,
eliminated independent trade unions, and so on.

Many Leninists know nothing of this. Their parties simply do not present their
members with the full facts of when Lenin and Trotsky were in power, nor do
they encourage an atmosphere of independent analysis and investigation to
discover these themselves. Others do know and either ignore than when
discussing the revolution or attempt to justify these actions. When anarchists
discuss why the Russian Revolution failed, these Leninists have basically one
reply. They argue that anarchists never seem to consider the objective forces
at play during the Russian revolution, namely the civil war, the legacy of
World War One, the international armies of counter-revolution and economic
disruption. These "objective factors" meant that the revolution was,
basically, suffocated and were the overriding cause for the rise of
authoritarianism and the crushing of socialism.

Thus, as one British Leninist puts it, the _"degree to which workers can 'make
their own history' depends on the weight of objective factors bearing down on
them . . . To decide in any given circumstance the weight of the subjective
and objective factors demands a concrete analysis of the balance of forces."_
The conditions in Russia meant that the _"subjective factor"_ of Bolshevik
ideology _"was reduced to a choice between capitulation to the Whites or
defending the revolution with whatever means were at hand. Within these limits
Bolshevik policy was decisive. But it could not wish away the limits and start
with a clean sheet. It is a tribute to the power of the Bolsheviks' politics
and organisation that they took the measures necessary and withstood the siege
for so long."_ [John Rees, _"In Defence of October,"_ pp. 3-82,
**International Socialism** , no. 52, p. 30]

For anarchists and other libertarian socialists, such "objective factors" do
not explain why the Russian Revolution failed. This is because almost all
revolutions will face the same, or similar, problems. As we indicate in
[section 1](append43.md#app1) of this appendix, anarchists like Kropotkin
had long indicated that a revolution would suffer such events and argued for
strategies and structures which would mitigate their impact by encouraging
mass participation and local initiative. More, as discussed in [section
2](append43.md#app2) the Bolsheviks themselves, with Lenin at their head,
argued at the time that such factors would affect every revolution. In
[section 3](append43.md#app3), we build on this by arguing that any defence
of Bolshevism based on blaming the impact of the civil war is both factually
and logically flawed, not least because as we discussed in [section
H.2.1](secH2.md#sech21), Leninists like to claim that they are "realistic"
(unlike the "utopian" anarchists) and recognise the need for a "workers'
state" because civil war is inevitable in a revolution. As far as economic
disruption goes, as we discuss in [section 4](append43.md#app4) this
explanation of Bolshevik authoritarianism is unconvincing as **every**
revolution -- indeed, every revolutionary situation -- has faced and will face
this problem. Then [section 5](append43.md#app5) analyses the common
Leninist argument that the revolution failed because the Russian working class
became "atomised" or "declassed," showing that the Russian working class was
more than capable of collective action throughout the 1918 to 1921 period (and
beyond). The problem for the Leninists, which explains why they are
disinclined to discuss it, is that it was directed **against** the Bolshevik
party. As [section 6](append43.md#app6) shows, the Bolshevik leaders at the
time did not explain their actions in terms of the _"objective factors"_ they
faced. Then [section 7](append43.md#app7) discusses the ideological utility
that stressing "objective factors" has for Leninist ideology (namely, it
shifts perspectives away from the Bolshevik vision of socialism) while
[section 8](append43.md#app8) highlights how Leninists also stress the
importance of the very ideology they seek to discount.

Three final points.

First, anarchists do not criticise the Bolshevik regime because it was not
perfect. Anarchists, as indicated in [section H.2.5](secH2.md#sech25), have
never thought there could be an "over-night" revolution which would usher in
an ideal and so we subject the Bolshevik regime to realistic criteria, namely
whether it was encouraging or undermining socialist tendencies. _"Not that I
expected to find Russia a proletarian Eldorado,"_ Alexander Berkman recalled.
_"By no means. I knew the great travail of a revolutionary period, how
stupendous the difficulties to be overcome."_ [ **The Bolshevik Myth** ,
328-9] Emma Goldman likewise summed up this position well:

> _"Both these criticisms would be justified had I come to Russia expecting to
> find Anarchism realised, or if I were to maintain that revolutions can be
> made peacefully . . . I do not therefore expect Anarchism to follow in the
> immediate footsteps of centuries of despotism and submission. And I
> certainly did not expect to see it ushered in by the Marxian theory._

> _"I did, however, hope to find in Russia at least the beginnings of the
> social changes for which the Revolution had been fought. Not the fate of the
> individual was my main concern as a revolutionist. I should have been
> content if the Russian workers and peasants as a whole had derived essential
> social betterment as a result of the Bolshevik régime._

> _"Two years of earnest study, investigation, and research convinced me that
> the great benefits brought to the Russian people by Bolshevism exist only on
> paper, painted in glowing colours to the masses of Europe and America by
> efficient Bolshevik propaganda. As advertising wizards the Bolsheviki excel
> anything the world had ever known before. But in reality the Russian people
> have gained nothing from the Bolshevik experiment."_ [ **My Disillusionment
> in Russia** , p. xlvii-xlviii]

Second, we must stress that libertarians do not think any future revolution
will suffer as terrible conditions as that experienced by the Russian one.
However, it might and we need to base our politics on the worse case
possibility. That said, we argue that Bolshevik policies made things worse --
by centralising economic and political power, they automatically hindered the
participation of working class people in the revolution, smothering any
creative self-activity under the dead-weight of state officialdom. As a
libertarian revolution would be based on maximising working class self-
activity (at all levels, locally and upwards) we would argue that it would be
better placed to respond to even the terrible conditions facing the Russian
Revolution.

Third, it must be stressed that we are discussing these factors individually
simply because it is easier to do so. It reality, they all interacted. Civil
war undoubtedly meant economic disruption, economic disruption meant
unemployment and that affected the working class via fewer goods available,
fewer goods made it harder to exchange with the peasants for food,
necessitating forced requisition by the regime, for example. So just because
we separate the specific issues for discussion purposes, it should not be
taken to imply that we are not aware of their combined impact. Likewise,
recognising the impact of certain developments does not mean the responses to
them are above criticism nor made the situation worse. Thus in our example
above key links in that chain could have been broken by different policies.

To conclude: while mechanically invoking "objective factors" may be sufficient
for the followers of Bolshevism, it cannot be sufficient for anyone who wants
to learn from history, tather than repeat it. For, ultimately, if difficult
times back in 1918-21 justified suppressing working class political and
economic freedom and self-management, imprisoning and shooting anarchists and
other socialists, implementing and glorifying party dictatorship, what might
we expect during difficult times in the future? Simply put, if your defence of
the Bolsheviks rests simply on "difficult circumstances" then it can only mean
one thing, namely if "difficult circumstances" occur again (and they will) we
can expect the same outcome.

Worse, perhaps a future revolution will be less destructive, less isolated,
less resisted than the Russian (although, as we note below in [section
2](append43.md#app2), leading Bolsheviks like Lenin, Trotsky and Bukharin
argued that this would **not** be the case). That **is** a possibility.
However, should we embrace an ideology whose argument is based on the hope
that fate will be kinder to them this time? Particularly when, even assuming
these better "objective circumstances," while we may manage to avoid the
horrors of Stalinism we would not avoid the recreation of a some kind of new
class system as such an outcome is inherent in state-socialism?

So while it cannot be denied that objective factors influenced how certain
Bolshevik policies were shaped and applied, the inspiration of those policies
came from Bolshevik ideology. An acorn will grow and develop depending on the
climate and location it finds itself in, but regardless of the "objective
factors" it will still grow into an oak tree, however stunted. Similarly with
the Russian revolution. While the circumstances it faced influenced its
growth, Bolshevik ideology could not help but produce an authoritarian regime
with no relationship with **real** socialism.

## 1 Do anarchists ignore the objective factors facing the Russian revolution?

It is often asserted by Leninists that anarchists simply ignore the "objective
factors" facing the Bolsheviks when we discuss the degeneration of the Russian
Revolution. According to this argument, anarchists present a basically
idealistic analysis of the failure of Bolshevism, one not rooted in the
material conditions (civil war, economic chaos, etc.) facing Lenin and
Trotsky. As one Trotskyist puts it, anarchists _"do not make the slightest
attempt at a serious analysis of the situation"_ and so _"other
considerations, of a different, 'theoretical' nature, are to be found in their
works."_ [Pierre Frank, _"Introduction,"_ Lenin and Trotsky, **Kronstadt** ,
p. 22] Thus:

> _"Bureaucratic conceptions beget bureaucracy just as opium begets sleep by
> virtue of its sleep-inducing properties. Trotsky was wrong to explain the
> proliferation and rise of the bureaucracy on the basis of the country's
> backwardness, low cultural level, and the isolation of the revolution. No,
> what gave rise to a social phenomenon like Stalinism was a conception or
> idea . . . it is ideas, or deviations from them, that determine the
> character of revolutions. The most simplistic kind of philosophical idealism
> has laid low historical materialism."_ [Frank, **Op. Cit.** , pp. 22-3]

Many other Trotskyists take a similar position (although most would include
the impact of the Civil War on the rise of Bolshevik authoritarianism and the
bureaucracy). Duncan Hallas, for example, argues that the account of the
Bolshevik counter-revolution given in the Cohn-Bendit brothers' **Obsolete
Communism** is marked by a _"complete omission of any consideration of the
circumstances in which [Bolshevik decisions] took place. The ravages of war
and civil war, the ruin of Russian industry, the actual disintegration of the
Russian working class: all of this, apparently, has no bearing on the
outcome."_ [ **Towards a Revolutionary Socialist Party** , p. 41]

So, it is argued, by ignoring the problems facing the Bolsheviks and
concentrating on their **ideas** , anarchists fail to understand **why** the
Bolsheviks acted as they did. Unsurprisingly anarchists are not impressed with
this argument. This is for numerous reasons.

First, and most obvious, the rise of bureaucracies is hardly limited to
Bolshevik Russia. As Trotskyists themselves note as regards the trade unions
and social democratic parties, although they exist in advanced capitalist
countries with a high cultural level these have ruling bureaucracies (and had
them for many decades, indeed since before the First World War). Similarly,
all States have bureaucracies regardless of their cultural level. Indeed, Marx
himself noted the bureaucratic machine which existed in France and the role it
played in society since the 1800s (see [section H.3.9](secH3.md#sech39)).
Even Trotsky had to admit that the Bolshevik Party itself -- like all Social
Democratic Parties across the globle -- had a bureaucracy before the
revolution (see [section H.5.12](secH5.md#sech512)), something which
internal critics of every Leninist party which exists today echo, including
those in the most advanced nations with a high cultural level (see [section
H.5.11](secH5.md#sech511)). The list goes on.

Do anarchists argue that "ideas" produce these bureucracies? No, far from it
-- specific forms of social structure generate them. Thus hierarchical and
centralised structures will inevitably generate bureaucracies -- a theory
generated from a careful analysis of countless organisations, including the
State and mainstream trade unions. Nor do these structures just appear, but
rather reflect specific class interests and needs -- minority classes cannot
favour social structures which include the masses. Thus _"the ideal of the
**Jacobin State** . . . had been designed from the viewpoint of the bourgeois,
in direct opposition to the egalitarian and communist tendencies of the people
which had arisen during the Revolution"_ [Peter Kropotkin, **Modern Science
and Anarchy** , p. 366] Likewise, previous revolutions saw a similar process,
as Kropotkin noted:

> _"It is often thought that it would be easy for a revolution to economise in
> the administration by reducing the number of officials. This was certainly
> not the case during the Revolution of 1789-1793, which with each year
> extended the functions of the State, over instruction, judges paid by the
> State, the administration paid out of the taxes, an immense army, and so
> forth."_ [ **The Great French Revolution** , vol. II, p. 460]

So based on an analysis of the State which recognised that it had its own
vested interests (as outlined in [section B.2](secB2.md)), anarchists
correctly predicted the _"new form of wage-labour which would arise if the
State took possession of the means of production and exchange . . . New
powers, industrial powers, added to those which it [already] possesses . . .
would create a new, formidable instrument of tyranny."_ [Kropotkin, **Modern
Science and Anarchy** , p. 170] Trotsky's post-hoc analysis sought to explain
something unanticipated in his own ideology and from which it had to be
excused all responsibility, regardless of the facts and logic.

Given that Bolshevik ideology favoured adding more and more functions to the
("workers") state, extending its reach into economic matters, it comes as no
surprise that its bureaucracy likewise grew -- at least to non-Trotskyists. As
such, rather than express the _"most simplistic kind of philosophical
idealism"_ , the anarchist critique is rooted in a clear materialist analysis
of the effects of certain organisational structures and why these develop.
Insofar as ideas played a role in the fate of Russian Revolution, they are
reflected in Bolshevik preferences for centralised structures and the social
relationships these produced when they were built -- as we discuss elsewhere
(see [section H.6.2](secH6.md#sech62) and its related appendix, ["How did
Bolshevik ideology contribute to the failure of the Revolution?"](append44)).
Rather than Trotsky's attempts to understand a degeneration he failed to
recognise until 1923, anarchists saw the signs when they first arose precisely
due to our theory (indeed, Trotsky's ability to recognise and explain
Stalinism could only be hindered by him being one of the main architects of
the degeneration).

Second, according to anarchist theory, the "objective factors" facing the
Bolsheviks are to be expected in **any** revolution. Indeed, the likes of
Bakunin and Kropotkin predicted that a revolution would face the very
"objective factors" which Leninists use to justify and rationalise Bolshevik
actions.

As such, to claim that anarchists ignore the "objective factors" facing the
Bolsheviks is simply a joke: how can anarchists be considered to ignore what
we consider to be the inevitable results of a revolution? Moreover, these
Bolshevik assertions ignore the fact that the anarchists who wrote extensively
about their experiences in Russia never failed to note that difficult
objective factors facing it. Alexander Berkman in **The Bolshevik Myth**
paints a clear picture of the problems facing the revolution, as does Emma
Goldman in **My Disillusionment in Russia**. This is not to mention anarchists
like Voline, Arshinov and Maximoff who took part in the Revolution,
experiencing the "objective factors" first hand (and in the case of Voline and
Arshinov, participating in the Makhnovist movement which, facing the same --
if not worse -- factors, managed **not** to act as the Bolsheviks did).

However, as the claim that anarchists ignore the "objective circumstances"
facing the Bolsheviks is relatively common, it is important to refute it once
and for all -- even if it means repeating some of arguments made in [section
H.6.1](secH6.md#sech61).

Anarchists take it for granted that, to quote Bakunin, revolutions _"are not
child's play"_ and that they mean _"war, and that implies the destruction of
men and things."_ The _"Social Revolution must put an end to the old system of
organisation based upon violence, giving full liberty to the masses, groups,
communes, and associations, and likewise to individuals themselves, and
destroying once and for all the historic cause of all violences, the power and
existence of the State."_ This meant a revolution would be _"spontaneous,
chaotic, and ruthless, always presupposes a vast destruction of property."_ [
**The Political Philosophy of Bakunin** , p. 372, p. 373, p. 380] He took it
for granted that counter-revolution would exist, arguing that it was necessary
to _"constitute the federation of insurgent associations, communes and
provinces . . . to organise a revolutionary force capable of defeating
reaction"_ and _"for the purpose of self-defence."_ [ **Micheal Bakunin:
Selected Writings** , p. 171]

It would, of course, be strange if this necessity for defence and
reconstruction would have little impact on the economic conditions in the
revolutionised society. The expropriation of the means of production and the
land by a free federation of workers' associations would have an impact on the
economy. Kropotkin built upon Bakunin's arguments, stressing that a **social**
revolution would, by necessity, involve major difficulties and harsh objective
circumstances. It is worth quoting one of his many discussions of this at
length:

> _"Suppose we have entered a revolutionary period, with or without civil war
> -- it does not matter, -- a period when old institutions are falling into
> ruins and new ones are growing in their place. The movement may be limited
> to one State, or spread over the world, -- it will have nevertheless the
> same consequence: an immediate slackening of individual enterprise all over
> Europe. Capital will conceal itself, and hundreds of capitalists will prefer
> to abandon their undertakings and go to watering-places rather than abandon
> their unfixed capital in industrial production. And we know how a
> restriction of production in any one branch of industry affects many others,
> and these in turn spread wider and wider the area of depression._

> _"Already, at this moment, millions of those who have created all riches
> suffer from want of what must be considered **necessaries** for the life of
> a civilised man. . . Let the slightest commotion be felt in the industrial
> world, and it will take the shape of a general stoppage of work. Let the
> first attempt at expropriation be made, and the capitalist production of our
> days will at once come to a stop, and millions and millions of 'unemployed'
> will join the ranks of those who are already unemployed now._

> _"More than that . . . The very first advance towards a Socialist society
> will imply a thorough reorganisation of industry as **to what we have to
> produce.** Socialism implies . . . a transformation of industry so that it
> may be adapted to the needs of the customer, not those of the profit-maker.
> Many a branch of industry must disappear, or limits its production; many a
> new one must develop. We are now producing a great deal for export. But the
> export trade will be the first to be reduced as soon as attempts at Social
> Revolution are made anywhere in Europe . . . All that **can** be, and
> **will** be reorganised in time -- not by the State, of course (why, then,
> not say by Providence?), but by the workers themselves. But, in the
> meantime, the worker . . . cannot wait for the gradual reorganisation of
> industry . . . The great problem of how to supply the wants of millions will
> thus start up at once in all its immensity. And the necessity of finding an
> **immediate solution** for it is the reason we consider that a step in the
> direction of [libertarian] Communism will be imposed on the revolted society
> -- not in the future, but as soon as it applies its crowbar to the first
> stones of the capitalist edifice."_ [ **Act for Yourselves** , pp. 57-9]

This perspective was at the core of Kropotkin's politics -- he was an
anarchist not because he thought the revolution would be easy but because he
recognised it would be difficult. His classic work **The Conquest of Bread**
was based on this clear understanding of the nature of a social revolution and
the objective problems it will face. As he put it, while a _"political
revolution can be accomplished without shaking the foundations of industry"_ a
revolution _"where the people lay hands upon property will inevitably paralyse
exchange and production . . . This point cannot be too much insisted upon; the
reorganisation of industry on a new basis . . . cannot be accomplished in a
few days."_ Indeed, he considered it essential to _"show how tremendous this
problem is."_ [ **The Conquest of Bread** , pp. 72-3]

He pointed to the experience of the French Revolution as evidence for this, as
it showed, _"[o]ne of the great difficulties in every Revolution is the
feeding of the large towns."_ This was because the _"large towns of modern
times are centres of various industries that are developed chiefly for the
sake of the rich or for the export trade"_ and these _"two branches fail
whenever any crisis occurs, and the question then arises of how these great
urban agglomerations are to be fed."_ This crisis, rather than making
revolution impossible, spurred the creation of what Kropotkin terms _"the
communist movement"_ in which _"the Parisian proletariat had already formed a
conception of its class interests and had found men to express them well."_ [
**The Great French Revolution** , vol. II, p. 457 and p. 504]

As for self-defence, he reproached the authors of classic syndicalist utopia
**How we shall bring about the Revolution** for _"considerably attenuat[ing]
the resistance that the Social Revolution will probably meet with on its
way."_ He stressed that the _"check of the attempt at Revolution in Russia [in
1905] has shown us all the danger that may follow from an illusion of this
kind."_ Elsewhere he argued that _"[i]f armed brigands attack a people, is not
that same people, armed with good weapons, the surest rampart to oppose to the
foreign aggressor?"_ He recognised that _"a society in which the workers would
have a dominant voice"_ would require a revolution to create, _"a revolution
far more profound than any of the revolutions which history had on record."_
In such a rebellion, however, _"the workers would have against them, not the
rotten generation of aristocrats against whom the French peasants and
republicans had to fight in the [eighteenth] century -- and even that fight
was a desperate one -- but the far more powerful, intellectually and
physically, middle-classes, which have at their service all the potent
machinery of the modern State."_ Thus _"each time that such a period of
accelerated evolution and reconstruction on a grand scale begins, civil war is
liable to break out on a small or large scale."_ [ **Direct Struggle Against
Capital** , p. 561, p. 121 and pp. 495-6]

It must, therefore, be stressed that the very "objective factors" supporters
of Bolshevism use to justify the actions of Lenin and Trotsky were correctly
predicted by anarchists decades before hand. Indeed, rather than ignore them
anarchists like Kropotkin based their political and social ideas on these
difficulties. As such, it seems ironic for Leninists to attack anarchists for
allegedly ignoring these factors. It is even more ironic as these very same
Leninists are meant to know that **any** revolution will involve these exact
same "objective factors," something that Lenin and other leading Bolsheviks
eventually acknowledged (see the [next section](append43.md#app2)).

Therefore, as noted [above](append43.md), when anarchists like Emma Goldman
and Alexander Berkman arrived in Russia they were aware of the problems it,
like any revolution, would face. Their critique of Bolshevism was not based on
decrying what they considered as inevitable, but rather the (counter-
productive) Bolshevik response. Unsurprisingly, this extremely realistic
perspective can be found in their later works. Berkman, for example, stressed
that _"when the social revolution had become thoroughly organised and
production is functioning normally there will be enough for everybody. But in
the first stages of the revolution, during the process of re-construction, we
must take care to supply the people the best we can, and equally, which means
rationing."_ This was because the _"first effect of the revolution is reduced
production."_ This would be initially due to the general strike which is its
_"starting point."_ However, _"[w]hen the social revolution begins in any
land, its foreign commerce stops: the importation of raw materials and
finished products is suspended. The country may even be blockaded by the
bourgeois governments."_ In addition, he thought it important not to suppress
_"small scale industries"_ as they would be essential when _"a country in
revolution is attacked by foreign governments, when it is blockaded and
deprived of imports, when its large-scale industries threaten to break down or
the railways do break down."_ Rather than assume the problem away, it was
essential that to counteract isolation workers must understand _"that their
cause is international"_ and that _"the organisation of labour"_ must develop
_"beyond national boundaries."_ However, _"the probability is not to be
discounted that the revolution may break out in one country sooner than in
another"_ and _"in such a case it would become imperative . . . not to wait
for possible aid from outside, but immediately to exert all her energies to
help herself supply the most essential needs of her people by her own
efforts."_ [ **What is Anarchism?** , p. 215, p. 223 p. 228, p. 229 and p.
227]

Emma Goldman, likewise, noted that it was _"a tragic fact that all revolutions
have sprung from the loins of war. Instead of translating the revolution into
social gains the people have usually been forced to defend themselves against
warring parties."_ _"It seems,"_ she noted, _"nothing great is born without
pain and travail"_ as well as _"the imperative necessity of defending the
Revolution."_ However, in spite of these inevitable difficulties she pointed
to how the Spanish anarchists _"have shown the first example in history **how
Revolutions should be made** "_ by _"the constructive work"_ of _"socialising
of the land, the organisation of the industries."_ [ **Vision on Fire** , p.
218, p. 222 and pp. 55-56]

These opinions were, as can be seen, to be expected from revolutionary
anarchists schooled in the ideas of Bakunin and Kropotkin. Clearly, then, far
from ignoring the "objective factors" facing the Bolsheviks, anarchists have
based their politics around them. We have always argued that a social
revolution would face isolation, economic disruption and civil war and have,
for this reason, stressed the importance of mass participation (and the
appropriate **federalist** structures required to foster it) in order to
overcome them. As such, when Leninists argue that these inevitable "objective
factors" caused the degeneration of Bolshevism, anarchists simply reply that
if it cannot handle the inevitable then Bolshevism should be avoided: just as
we would avoid a submarine which worked perfectly well until it was placed in
the sea.

Moreover, what is to be made of this Leninist argument against anarchism? In
fact, given the logic of their claims we have to draw the conclusion that the
Leninists seem to think a revolution **could** happen **without** civil war
and economic disruption. As such it suggests that the Leninists have the
"utopian" politics in this matter. After all, if they argue that civil war is
inevitable then how can they blame the degeneration of the revolution on it?
Simply put, if Bolshevism cannot handle the inevitable it should be avoided at
all costs.

Ironically, as indicated in the [next section](append43.md#app2), we can
find ample arguments to refute the Trotskyist case against the anarchist
analysis in the works of leading Bolsheviks like Lenin, Trotsky and Bukharin.
Indeed, their arguments provide a striking confirmation of the anarchist
position as they, like Kropotkin, stress that difficult "objective factors"
will face **every** revolution. This means to use these factors to justify
Bolshevik authoritarianism simply results in proving that Bolshevism is simply
non-viable or that a liberatory social revolution is, in fact, impossible
(and, as a consequence, genuine socialism).

There are, of course, other reasons why the Leninist critique of the anarchist
position is false. In terms of theory, the Leninist position is the crudest
form of economic determinism. As we discuss in [section
7](append43.md#app7), ideas **do** matter and, as Marx himself stressed, can
play a key in how a social process develops. In terms of the empirical
evidence against the Trotskyist explanation, as we indicate in [section
3](append43.md#app3), soviet democracy and workers' power in the workplace
was **not** undermined by the civil war. Rather, the process had began before
the civil war started and, equally significantly, continued after its end in
November 1920.

Third, in terms of the economic and social backwardness of Russia, the similar
(if not worse) backwardness of Germany in 1847 did not stop Marx arguing that
socialist central planning was viable -- indeed, in the **Philosophy of
Philosophy** he berated Ricardian Socialist John Bray for suggesting using
labour-notes _"for a period of transition"_ to communism while in the
**Communist Manifesto** he asserted that _"the bourgeois revolution in Germany
will be but the prelude to an immediately following proletarian revolution."_
[ **Marx-Engels Collected Works** , vo. 6, p. 142 and p. 519] Moreover, the
notion that Russia was only ready for a **bourgeois** revolution was held by
the Mensheviks (reflecting the mainstream position of Marxist social-
democracy) and accordingly denounced by Leninists, then and now. So being
predominantly a peasant society with little, if any, large-scale industy did
not stop Marx issuing a very public call for communist revolution in Germany
in 1847 (indeed, this was the social situation across whole of Continental
Europe during Marx's lifetime and for **many** decades afterwards).

Nor does the then backwardness of Russia hinder the adoption of various
aspects of Bolshevism -- such as vanguardism, the necessity of party
dictatorship, the centralised structure of socialism, one-man management, etc.
-- by Marxists in the West after 1917, indeed until now. As such,
"backwardness" is a selective excuse -- not least because few Leninists would
agree that vanguardism was a product of Tsarist Russia and so applicable only
there and then. In short, if Leninists took the issue of "backwardness"
seriously then they would question **all** aspects of their ideology and
hopefully -- like the German Council Communists -- recognise that Leninism is
permeated with the social conditions of a semi-feudal regime and has little to
offer modern revolutionaries (or revolutionaries active in the advanced
capitalist nations of post-war Europe).

Fourth, there is the example of the Makhnovist movement. Operating in the same
"objective circumstances," facing the same "objective factors," the
Makhnovists did **not** implement the same policies as the Bolsheviks. As we
discussed in the appendix ["Why does the Makhnovist movement show there is an
alternative to Bolshevism?"](append46.md), rather than undermine soviet,
soldier and workplace democracy and replace all with party dictatorship, the
Makhnovists applied these as fully as they could. Now, if "objective factors"
explain the actions of the Bolsheviks, then why did the Makhnovists not pursue
identical policies? Why did the Makhnovists not raise the necessity of party
dictatorship to an ideological truism?

In summary, regardless of Trotskyist assertions, anarchists do not ignore the
objective factors facing the Bolsheviks during the revolution. As indicated,
we predicted the problems they faced and developed our ideas to counter them.
As the example of the Makhnovists showed, our ideas were more than adequate
for the task -- unlike those of the Bolsheviks.

## 2 Can "objective factors" really explain the failure of Bolshevism?

As noted in the [previous section](append43.md#app1) Leninists falsely argue
that anarchists downplay (at best) or ignore (at worse) the "objective
factors" facing the Bolsheviks during the Russian Revolution. However, there
is more to it than that. Leninists also claim to be revolutionaries, they
claim to know that revolutions will face problems, that civil war is
inevitable and so forth. It therefore strikes anarchists as being somewhat
hypocritical for Leninists to blame these very same "objective" but allegedly
inevitable factors for the failure of Bolshevism in Russia.

Ironically enough, Lenin and Trotsky agree with these anarchist arguments.
Looking at Trotsky, he dismissed the CNT's leaderships' arguments in favour of
collaborating with the bourgeois state as follows:

> _"The leaders of the Spanish Federation of Labour (CNT) . . . became, in the
> critical hour, bourgeois ministers. They explained their open betrayal of
> the theory of anarchism by the pressure of 'exceptional circumstances.' But
> did not the leaders of the German social democracy invoke, in their time,
> the same excuse? Naturally, civil war is not a peaceful and ordinary but an
> 'exceptional circumstance.' Every serious revolutionary organisation,
> however, prepares precisely for 'exceptional circumstances' . . . We have
> not the slightest intention of blaming the anarchists for not having
> liquidated the state with the mere stroke of a pen. A revolutionary party,
> even having seized power (of which the anarchist leaders were incapable in
> spite of the heroism of the anarchist workers), is still by no means the
> sovereign ruler of society. But all the more severely do we blame the
> anarchist theory, which seemed to be wholly suitable for times of peace, but
> which had to be dropped rapidly as soon as the 'exceptional circumstances'
> of the... revolution had begun. In the old days there were certain generals
> -- and probably are now -- who considered that the most harmful thing for an
> army was war. Little better are those revolutionaries who complain that
> revolution destroys their doctrine."_ [ _"Stalinism and Bolshevism,"_
> **Writings of Leon Trotsky 1936-37** , pp. 423-4]

Thus to argue that the _"exceptional circumstances"_ caused by the civil war
are the only root cause of the degeneration of the Russian Revolution is a
damning indictment of Bolshevism: Lenin did not argue in **State and
Revolution** that the application of soviet democracy was dependent only in
_"times of peace."_ Rather, he stressed that they were for the _"exceptional
circumstance"_ of revolution and the civil war he considered its inevitable
consequence. As such, we must note that Trotsky's followers do not apply this
critique to their own politics, which are also a form of the _"exceptional
circumstances"_ excuse. Given how quickly Bolshevik "principles" (as expressed
in **The State and Revolution** ) were dropped, we can only assume that
Bolshevik ideas are also suitable purely for _"times of peace"_ as well.

But, then, Trotsky was not above using such arguments himself (making later-
day Trotskyists at least ideologically consistent in their hypocrisy). In the
same essay, for example, he justifies the prohibition of other Soviet parties
in terms of a _"measure of defence of the dictatorship in a backward and
devastated country, surrounded by enemies on all sides."_ In other words, an
appeal to the exceptional circumstances facing the Bolsheviks! Perhaps
unsurprisingly, his followers have tended to stress this (contradictory)
aspect of his argument rather than his comments that those _"who propose the
abstraction of Soviets to the party dictatorship should understand that only
thanks to the party leadership were the Soviets able to lift themselves out of
the mud of reformism and attain the state form of the proletariat. The
Bolshevik party achieved in the civil war the correct combination of military
art and Marxist politics."_ [ **Op. Cit.** , p. 426 and p. 430] Which, of
course, suggests that the prohibition of other parties had little impact on
levels of soviet "democracy" allowed under the Bolsheviks.

This dismissal of the _"exceptional circumstances"_ argument did not originate
with Trotsky. Lenin repeatedly stressed that any revolution would face civil
war and economic disruption. In early January, 1918, he was pointing to _"the
incredibly complications of war and economic ruin"_ in Russia and noting that
_"the fact that Soviet power has been established . . . is why civil war has
acquired predominance in Russia at the present time."_ [ **Collected Works** ,
vol. 26, p. 453 and p. 459] A few months later he states quite clearly that
_"it will never be possible to build socialism at a time when everything is
running smoothly and tranquilly; it will never be possible to realise
socialism without the landowners and capitalists putting up a furious
resistance."_ He reiterated this point, acknowledging that the _"country is
poor, the country is poverty-stricken, and it is impossible just now to
satisfy all demands; that is why it is so difficult to build the new edifice
in the midst of disruption. But those who believe that socialism can be built
at a time of peace and tranquillity are profoundly mistake: it will be
everywhere built at a time of disruption, at a time of famine. That is how it
must be."_ [ **Op. Cit.** , vol. 27, p. 520 and p. 517]

As regards civil war, he noted that _"not one of the great revolutions of
history has take place"_ without one and _"without which not a single serious
Marxist has conceived the transition from capitalism to socialism."_ Moreover,
_"there can be no civil war -- the inevitable condition and concomitant of
socialist revolution -- without disruption."_ [ **Op. Cit.** , p. 496 and p.
497] He considered this disruption as being applicable to advanced capitalist
nations as well:

> _"In Germany, state capitalism prevails, and therefore the revolution in
> Germany will be a hundred times more devastating and ruinous than in a
> petty-bourgeois country -- there, too, there will be gigantic difficulties
> and tremendous chaos and imbalance."_ [ **Op. Cit.** , vol. 28, p. 298]

Lenin reiterated this point again and again. He argued that _"we see famine
not only in Russia, but in the most cultured, advanced countries, like Germany
. . . it is spread over a longer period than in Russia, but it is famine
nevertheless, still more severe and painful than here."_ In fact, _"today even
the richest countries are experiencing unprecedented food shortages and that
the overwhelming majority of the working masses are suffering incredible
torture."_ [ **Op. Cit.** , vol. 27, p. 460 and p. 461] And from June, 1918:

> _"We must be perfectly clear in our minds about the new disasters that civil
> war brings for every country. The more cultured a country is the more
> serious will be these disasters. Let us picture to ourselves a country
> possessing machinery and railways in which civil war is raging, and this
> civil war cuts off communication between the various parts of the country.
> Picture to yourselves the condition of regions which for decades have been
> accustomed to living by the interchange of manufactured goods and you will
> understand that every civil war brings forth disasters."_ [ **Op. Cit.** ,
> vol. 27, p. 463]

As we discuss in [section 4](append43.md#app4), the economic state of
Germany immediately after the end of the war suggests that Lenin had a point:
the German economy was in a serious state of devastation, a state equal to
that of Russia during the equivalent period of its revolution. If economic
conditions made party dictatorship inevitable in Bolshevik Russia (as pro-
Leninists argue) it would mean that soviet democracy and revolution cannot go
together.

Lenin, unlike many of his latter day followers, did not consider these grim
objective conditions as making revolution impossible. Rather, for him, there
was _"no other way out of this war"_ which is causing the problems _"except
revolution, except civil war . . . a war which always accompanies not only
great revolutions but every serious revolution in history."_ He continued by
arguing that we _"must be perfectly clear in our minds about the new disasters
that civil war brings for every country. The more cultured a country is the
more serious will be these disasters. Let us picture to ourselves a country
possessing machinery and railways in which civil war is raging, and this civil
war cuts communication between the various parts of the country. Picture to
yourselves the condition of regions which for decades have been accustomed to
living by interchange of manufactured goods and you will understand that every
civil war brings fresh disasters."_ [ **Op. Cit.** , p. 463] The similarities
to Kropotkin's arguments made three decades previously are clear (see [section
1](append43.md#app1) for details).

Indeed, he mocked those who would argue that revolution could occur without
_"exceptional circumstances"_ :

> _"A revolutionary would not 'agree' to a proletarian revolution only 'on the
> condition' that it proceeds easily and smoothly, that there is, from the
> outset, combined action on the part of proletarians of different countries,
> that there are guarantees against defeats, that the road of the revolution
> is broad, free and straight, that it will not be necessary during the march
> to victory to sustain the heaviest casualties, to 'bide one's time in a
> besieged fortress,' or to make one's way along extremely narrow, impassable,
> winding and dangerous mountain tracks. Such a person is no revolutionary."_
> [ **Op. Cit.** , vol. 28, p. 68]

Thus industrial collapse and terrible difficulties would face any revolution.
As Lenin noted, _"in revolutionary epochs the class struggle has always,
inevitably, and in every country, assumed the form of **civil war,** and civil
war is inconceivable without the severest destruction, terror and the
restriction of formal democracy in the interests of this war."_ Moreover,
_"[w]e know that fierce resistance to the socialist revolution on the part of
the bourgeoisie is inevitable in all countries, and that this resistance will
**grow** with the growth of the revolution."_ [ **Op. Cit.** , p. 69 and p.
71] To blame the inevitable problems of a revolution for the failings of
Bolshevism suggests that Bolshevism is simply not suitable for revolutionary
situations.

At the 1920 Comintern Congress Lenin lambasted a German socialist who argued
against revolution because _"Germany was so weakened by the War"_ that if it
had been _"blockaded again the misery of the German masses would have been
even more dreadful,"_ dismissing this argument:

> _"A revolution . . . can be made only if it does not worsen the workers'
> conditions 'too much.' Is it permissible, in a communist party, to speak in
> a tone like this, I ask? This is the language of counter-revolution. The
> standard of living in Russia is undoubtedly lower than in Germany, and when
> we established the dictatorship, this led to the workers beginning to go
> more hungry and to their conditions becoming even worse. The workers'
> victory cannot be achieved without sacrificing, without a temporary
> deterioration of their conditions. . . If the German workers now want to
> work for the revolution, they must make sacrifices and not be afraid to do
> so . . . The labour aristocracy, which is afraid of sacrifices, afraid of
> 'too great' impoverishment during the revolutionary struggle, cannot belong
> to the party. Otherwise the dictatorship is impossible, especially in
> western European countries."_ [ **Proceedings and Documents of the Second
> Congress 1920** , pp. 382-3]

In 1921 he repeated this, arguing that _"every revolution entails enormous
sacrifice on the part of the class making it. . . The dictatorship of the
proletariat in Russia has entailed for the ruling class -- the proletariat --
sacrifices, want and privation unprecedented in history, and the case will, in
all probability, be the same in every other country."_ [ **Collected Works** ,
vol. 32, p. 488]

So Lenin is on record as saying these "objective factors" will always be the
circumstances facing a socialist revolution. Indeed, in November 1922 he
stated that rather than having undermined the revolution, _"Soviet rule in
Russia is celebrating its fifth anniversary. It is now sounder than ever."_ [
**Op. Cit.** , vol. 33, p. 417]

All of which must be deeply embarrassing to Leninists. After all, here is
Lenin arguing that the factors Leninists list as being responsible for the
degeneration of the Russian Revolution were inevitable side effects of **any**
revolution and, moreover, the revolution was more sound than ever! Of course,
Lenin did not ponder how _"Soviet rule"_ was compatible with party
dictatorship, but then neither did Trotsky.

Nor was this perspective limited to Lenin. The inevitability of economic
collapse being associated with a revolution was not lost on Trotsky either.
For example, in **Terrorism and Communism** he argued that _"[a]ll periods of
transition have been characterised by . . . tragic features"_ of an _"economic
depression"_ such as exhaustion, poverty and hunger. Every class society _"is
violently swept off [the arena] by an intense struggle, which immediately
brings to its participants even greater privations and sufferings than those
against which they rose."_ He gave the example of the French Revolution
_"which attained its titanic dimensions under the pressure of the masses
exhausted with suffering, itself deepened and rendered more acute their
misfortunes for a prolonged period and to an extraordinary extent."_ He
rhetorically asked: _"Can it be otherwise?"_ So _"revolutions which drag into
their whirlpool millions of workers"_ automatically affect the _"economic life
of the country."_ By _"[d]ragging the mass of the people away from labour,
drawing them for a prolonged period into the struggle, thereby destroying
their connection with production, the revolution in all these ways strikes
deadly blows at economic life, and inevitably lowers the standard which it
found at its birth."_ This affects the socialist revolution as the _"more
perfect the revolution, the greater are the masses it draws in; and the longer
it is prolonged, the greater is the destruction it achieves in the apparatus
of production, and the more terrible inroads does it make upon public
resources. From this there follows merely the conclusion which did not require
proof -- that a civil war is harmful to economic life."_ Given these
inevitable circumstances, he justified Bolshevik policies as being the _"only
solution . . . that is correct from the point of view both of principle and of
practice"_ and, moreover, _"dictatorship of the Soviets became possible only
by means of the dictatorship of the party._ [ **Terrorism and Communism** , p.
7, p. 135 and p. 109]

While this argument does have its self-serving elements -- generalising to all
revolutions problems created or made worse by Bolshevik policies, decisions
and prejudices -- the general point remains valid: revolutions are disruptive.

Another leading Bolshevik, Nikolai Bukharin, wrote his (infamous) **The
Economics of the Transition Period** to make theoretical sense of (i.e.
rationalise and justify) the party's changing policies and their social
consequences since 1918 in terms of the inevitability of bad "objective
factors" facing the revolution. While some Leninists like to paint Bukharin's
book (like most Bolshevik ideas of the time) as "making a virtue out of
necessity," Bukharin (like the rest of the Bolshevik leadership) did not. As
one commentator, Stephan F. Cohen, notes, Bukharin _"belive[d] that he was
formulating universal laws of proletarian revolution."_ [ **In Praise of War
Communism: Bukharin's The Economics of the Transition Period** , p. 195]

Bukharin listed four _"real costs of revolution,"_ namely _"the physical
destruction or deterioration of material and living elements of production,
the atomisation of these elements and of sectors of the economy, and the need
for unproductive consumption (civil war materials, etc.). These costs were
interrelated and followed sequentially. Collectively they resulted in ' **the
curtailment of the process of reproduction** ' (and 'negative expanded
reproduction') and Bukharin's main conclusion: 'the production "anarchy" . . .
, "the revolutionary disintegration of industry," is an historically
inevitable stage which no amount of lamentation will prevent.'"_ This was part
of a general argument and his _"point was that great revolutions were always
accompanied by destructive civil wars . . . But he was more intent on proving
that a proletarian revolution resulted in an even greater temporary fall in
production than did its bourgeois counterpart."_ To do this he formulated the
_"costs of revolution"_ as _"a law of revolution."_ [ **Op. Cit.** , pp. 195-6
and p. 195]

Cohen notes that while this _"may appear to have been an obvious point, but it
apparently came as something of a revelation to many Bolsheviks. It directly
opposed the prevailing Social Democratic assumption that the transition to
socialism would be relatively painless . . . Profound or not, Bolsheviks
generally came to accept the 'law' and to regard it as a significant discovery
by Bukharin."_ [ **Op. Cit.** , p. 196] To quote Bukharin himself:

> _"during the transition period the labour apparatus of society inevitably
> disintegrates, that reorganisation presupposes disorganisation, and that
> there the temporary collapse of productive forces is a law inherent to
> revolution."_ [quoted by Cohen, **Op. Cit.** , p. 196]

It would appear that this _"obvious point"_ would **still** come _"as
something of a revelation to many Bolsheviks"_ today! Significantly, of
course, Kropotkin had formulated this law decades previously and so the
**real** question is how the Bolsheviks sought to cope with this inevitable
law is what signifies the difference between anarchism and Leninism. Simply
put, Bukharin endorsed the coercive measures of war communism as the means to
go forward to socialism. As Cohen summarises, _"force and coercion . . . were
the means by which equilibrium was to be forged out of disequilibrium."_ [
**Op. Cit.** , p. 198] Given that Bukharin argued that a workers' state, by
definition, could not exploit the workers, he -- like Lenin and Trotsky --
opened up the possibility for rationalising all sorts of abuses as well as
condoning numerous evils because they were "progressive."

It should be noted that Lenin showed _"ecstatic praise for the most 'war
communist' sections"_ of Bukharin's work. _"Almost every passage,"_ Cohen
notes, _"on the role of the new state, statisation in general, militarisation
and mobilisation met with 'very good,' often in three languages, . . . Most
striking, Lenin's greatest enthusiasm was reserved for the chapter on the role
of coercion . . . at the end [of which] he wrote, 'Now this chapter is
superb!'"_ [ **Op. Cit.** , pp. 202-3] Compare this to Kropotkin's comment
that the _"revolutionary tribunal and the guillotine could not make up for the
lack of a constructive communist theory."_ [ **The Great French Revolution** ,
vol. II, p. 519]

Ultimately, claims that "objective factors" caused the degeneration of the
revolution are mostly attempts to let the Bolsheviks of the hook for
Stalinism. This approach was started by Trotsky and has continued to this day.
Anarchists, unsurprisingly, do not think much of these explanations: the
"objective factors" listed to explain the degeneration of the revolution are
simply a list of factors **every** revolution would (and has) faced -- as
Lenin, Bukharin and Trotsky all admitted at the time. Bertrand Russell noted
this after his trip to Soviet Russia, that while since October 1917 _"the
Soviet Government has been at war with almost all the world, and has at the
same time to face civil war at home"_ this was _"not to be regarded as
accidental, or as a misfortune which could not be foreseen. According to
Marxian theory, what has happened was bound to happen."_ [ **The Theory and
Practice of Bolshevism** , p. 103]

So we have the strange paradox of Leninists dismissing or ignoring the
arguments of their ideological gurus. For Trotsky, just as for Lenin, it was a
truism that revolutionary politics had to handle _"objective factors"_ and
_"exceptional circumstances"_ and both thought they **had** during the Russian
revolution in a manner consistent with their ideology: yet for their
followers, these explain the failure of Bolshevism. Tony Cliff, one of
Trotsky's less orthodox followers, gives us a means of understanding this
strange paradox. Discussing the **Platform of the United Opposition** he notes
that it _"also suffered from the inheritance of the exceptional conditions of
the civil war, when the one-party system was transformed from a necessity into
a virtue."_ [ **Trotsky** , vol. 3, pp. 248-9] Clearly, _"exceptional
circumstances"_ explain nothing and are simply an excuse for bad politics
while _"exceptional conditions"_ explain everything and defeat even the best
politics!

As such, it seems extremely ironic that Leninists blame the civil war for the
failure of the revolution as they continually raise the inevitability of civil
war in a revolution to attack anarchism (see [section
H.2.1](secH2.md#sech21) for example). Yet, if civil war and the other
factors listed by Leninists (but considered inevitable by Lenin) preclude the
implementation of the radical democracy Lenin argued for in 1917 as the means
to suppress the resistance of the capitalists then his followers should come
clean and say that his book has no bearing on their vision of revolution.
Given that the usual argument for the "dictatorship of the proletariat" is
that it is required to repress counter-revolution, it seems somewhat ironic
that the event it was said to be designed for (i.e. revolution) should be
responsible for its degeneration.

As such, anarchists think these sorts of explanations of Bolshevik
dictatorship are incredulous. After all, as **revolutionaries** the people who
expound these "explanations" are meant to know that civil war, imperialist
invasion and blockade, economic disruption, and a host of other _"extremely
difficult circumstances"_ are part and parcel of a revolution. They seem to be
saying, "if only the ruling class had not acted as our political ideology
predicts they would then the Bolshevik revolution would have been fine"!

In summary, anarchists are not at all convinced by the claims that _"objective
factors"_ can explain the failure of the Russian Revolution for, according to
Lenin and Trotsky, these factors were to be expected in **any** revolution.
That is why they say they want a _"dictatorship of the proletariat,"_ to
defend against counter-revolution (see [section H.3.8](secH3.md#sech38) on
how, once in power, Lenin and Trotsky revised this position). Now, if
Bolshevism cannot handle what it says is inevitable, then it should be
avoided. To use an analogy:

> **Bolshevik: _"Join with us, we have a great umbrella which will keep us
> dry."_**

> **Anarchist: _"Last time it was used, it did not work. We all got
> soaked!"_**

> **Bolshevik: _"But what our anarchist friend fails to mention is that it was
> raining at the time!"_**

Not very convincing! Yet, sadly, this is the logic of the common Leninist
justification of Bolshevik authoritarianism during the Russian Revolution.

## 3 Can the civil war explain the failure of Bolshevism?

One of the most common assertions against the anarchist case against
Bolshevism is that while we condemn the Bolsheviks, we fail to mention the
civil war and the wars of intervention. Indeed, for most Leninists the civil
war is usually considered the key event in the development of Stalinism as
well as explaining and justifying all anti-socialist acts of the Bolsheviks
after they seized power in 1917.

For anarchists, such an argument is flawed on two levels, namely logical and
factual. The logical flaw is that Leninist argue that civil war is inevitable
after a revolution. They maintain, correctly, that it is unlikely that the
ruling class will disappear without a fight. Then they turn round and complain
that because the ruling class did what the Marxists predicted they would do
the Russian Revolution failed while also (incorrectly) asserting about
anarchists do not recognise the need to defend a revolution (see [section
H.2.1](secH2.md#sech21)).

So, obviously, this line of defence is nonsense. If civil war is inevitable,
then it cannot be used to justify the failure of Bolshevism. Marxists simply
want to have their cake and eat it to: you simply cannot argue that civil war
is inevitable and then blame it for the failure of the Russian Revolution.

Also, by stressing civil war and denouncing those who _"forget the years of
Civil War"_ , Trotsky and his followers end up being _"Apologist[s] for
Stalinism"_ for the civil war _"was initiated by the international
bourgeoisie. And thus the ugly sides of Bolshevism under Lenin, as well as
under Stalin, find their chief and final cause in capitalism’s enmity to
Bolshevism which, if it is a monster, is only a reluctant monster, killing and
torturing in mere self-defence._ In short, _"so, if only in a roundabout way,
Trotsky’s Bolshevism, despite its saturation with hatred for Stalin, leads in
the end merely to a defence of Stalinism as the only possible self-defence for
Trotsky. This explains the superficiality of the ideological differences
between Stalinism and Trotskyism. The impossibility of attacking Stalin
without attacking Lenin helps to explain, furthermore, Trotsky's great
difficulties as an oppositionist. Trotsky's own past and theories preclude on
his part the initiation of a movement to the **left** of Stalinism and
condemned 'Trotskyism' to remain a mere collecting agency for unsuccessful
Bolsheviks. As such it could maintain itself outside of Russia because of the
ceaseless competitive struggles for power and positions within the so-called
'communist' world-movement. But it could not achieve significance for it had
nothing to offer but the replacement of one set of politicians by another. The
Trotskyist defence of Russia in the Second World War was consistent with all
the previous policies of this, Stalin’s most bitter, but also most loyal,
opposition."_ [Paul Mattick, _"Bolshevism and Stalinism"_ , **Anti-Bolshevik
Communism** , pp. 68-9]

The other flaw in this defence of Bolshevism is the factual one, namely the
awkward fact that Bolshevik authoritarianism started **before** the civil war
broke out at the end of May, 1918. Simply put, it is difficult to blame a
course of actions on an event which had not started yet. Moreover, Bolshevik
authoritarianism **increased** after the civil war finished. This,
incidentally, caused the few remaining anarchists who supported the regime to
some degree to re-evaluate their position. In the words of Alexander Berkman:

> _"I would not concede the appalling truth. Still the hope persisted that the
> Bolsheviki, though absolutely wrong in principle and practice, yet grimly
> held on to **some** shreds of the revolutionary banner. 'Allied
> interference,' 'the blockade and civil war,' 'the necessity of the
> transitory stage' -- thus I sought to placate my outraged conscience . . .
> At last the fronts were liquidated, civil war ended, and the country at
> peace. But Communist policies did not change. On the contrary . . . The
> party groaned under the unbearable yoke of the Party dictatorship. . . .
> Then came Kronstadt and its simultaneous echoes throughout the land . . .
> Kronstadt was crushed as ruthlessly as Thiers and Gallifet slaughtered the
> Paris Communards. And with Kronstadt the entire country and its last hope.
> With it also my faith in the Bolsheviki."_ [ **The Bolshevik Myth** , p.
> 331]

If Berkman had been in Russia in 1918, he may have realised that Bolshevik
tyranny after the end of the civil war which climaxed with the attack on
Kronstadt (see the appendix on ["What was the Kronstadt
Rebellion?"](append42.md)) was not at odds with their pre-civil war
activities to maintain their power. The simple fact is that Bolshevik
authoritarianism was **not** caused by the pressures of the civil war, rather
it started before then. All the civil war did was strengthen certain aspects
of Bolshevik ideology and practice which had existed from the start. Needless
to say, we cannot cover everything here and will by necessity focus on certain
key developments which historian S.A. Smith summarises well:

> _"The Bolsheviks established their power in the localities through soviets,
> soldiers' committees, factory committees, and Red Guards. Numbering less
> than 350,000 in October 1917, the party had little option but to allow such
> independent organisations extensive leeway. Yet the same desperate problems
> of unemployment and lack of food and fuel that helped turn the workers
> against the Provisional Government soon began to turn workers against the
> Bolsheviks. In the first half of 1918, some 100,000 to 150,000 workers
> across Russia took part in strikes, food riots and other protests, roughly
> on a par with labour unrest on the eve of the February Revolution. In this
> context, the Bolsheviks struggled to concentrate authority in the hands of
> the party and state organs . . . In spring 1918, worker discontent
> translated into a renewal of support for the Mensheviks and, to a lesser
> extent, the SRs, causing the Bolsheviks to cancel soviet elections and close
> down soviets that proved uncooperative, thus initiating the process whereby
> soviets and trade unions were turned into adjuncts to a one-party state.
> When the Whites seized leadership of the anti-Bolshevik movement in the
> latter months of 1918, however, most workers swung back in support of the
> government. During the civil war, labour unrest continued . . . the
> Bolsheviks generally reacted by rushing in emergency supplies and by
> arresting the leaders of the protest, who were often Mensheviks or Left SRs
> . . . they did not scruple when they deemed it necessary to deploy armed
> force to suppress strikes, to confiscate ration cards or even to dismiss
> strikers en masse and then rehire them selectively. The Bolsheviks expected
> the working class to speak with one voice – in favour of the regime –- and
> when they didn't they, who had once excoriated the Mensheviks for their
> refusal to accept that a true proletariat existed in Russia, charged the
> working class with being no more than a mass of uprooted peasants with a
> thoroughly petty-bourgeois psychology."_ [ **Revolution and the People in
> Russia and China** , p. 201]

The most important development during this period was the suppression of
soviet democracy and basic working class freedoms. As we discuss in [section
H.6.1](secH6.md#sech61), the Bolsheviks pursued a policy of systematically
undermining soviet democracy from the moment they seized power. The first act
was the creation of a Bolshevik government **over** the soviets, so
marginalising the very organs they claimed ruled in Russia (and directly
against the promises made by Lenin in **The State and Revolution** \-- and not
the last, as discussed in [section H.1.7](secH1.md#sech17)). The process was
repeated in the local soviets, with the executive committees holding real
power while the plenary sessions became increasingly infrequent and of little
consequence. Come the spring of 1918, faced with growing working class
opposition they started to delay soviet elections. When finally forced to hold
elections, the Bolsheviks responded in two ways to maintain their power:
either they packed the soviets with representatives of Bolshevik dominated
organisation (making elections from the workplace irrelevant or they simply
disbanded them by force if they lost (and repressed by force any protests
against this). This was the situation at the grassroots, at the summit of the
soviet system the Bolsheviks simply marginalised the Central Executive
Committee of the soviets: real power was held by the Bolshevik government.
They also packed the Fifth All-Russian Soviet Congress held in July 1918,
using their control over the credentials committee to increase the number of
Bolsheviks by seating delegates from bodies they controlled). The power of the
soviets had simply become a fig-leaf for a "soviet power" -- the handful of
Bolsheviks who made up the government and the party's central committee.

It should be stressed that the Bolshevik assault on the soviets occurred in
March, April and May 1918. That is, **before** the Czech uprising and the
onset of full-scale civil war. So, to generalise, it cannot be said that it
was the Bolshevik party that alone whole-heartedly supported Soviet power: the
facts are, in the words of left-Menshevik Julius Martov, the Bolsheviks loved
Soviets only when they were _"in the hands of the Bolshevik party."_ [quoted
by Getzler, **Martov** , p. 174] If the workers voted for others, "soviet
power" was openly replaced by party power (the real aim, as discussed in
[section H.3.11](secH3.md#sech311)). The Bolsheviks had consolidated their
position by early 1918, turning the Soviet State into a de facto one party
state by packing, gerrymandering and disbanding soviets **before** the start
of the Civil War.

Given this legacy of repression, Leninist Tony Cliff's assertion that it was
only _"under the iron pressure of the civil war [that] the Bolshevik leaders
were forced to move, as the price of survival, to **a one-party system** "_
needs serious revising. Similarly, his comment that the _"civil war undermined
the operation of the local soviets"_ is equally inaccurate, as his is claim
that _"for some time -- i.e. until the armed uprising of the Czechoslovak
Legion -- the Mensheviks were not much hampered in their propaganda work."_
Simply put, Cliff's statement that _"it was about a year after the October
Revolution before an actual monopoly of political power was held by one
party"_ is false. [ **Lenin** , vol. 3, p. 163, p. 150, p. 167 and p. 172]
Such a monopoly existed **before** the start of the civil war, with extensive
political repression existing **before** the uprising of the Czechoslovak
Legion which began it. There was a **de facto** one-party state by the spring
of 1918: it took about a year for this reality to be reflected in Bolshevik
ideology and rhetoric.

Other Leninists are just as loose with the facts as Cliff. His fellow British
SWP member Chris Harman suggested that the Bolsheviks were really democrats
and that _"[u]ntil the Civil War was well under way, this democratic dialectic
of party and class could continue. The Bolsheviks held power as the majority
party in the Soviets. But other parties continued to exist there too. The
Mensheviks continued to operate legally and compete with the Bolsheviks for
support until June 1918."_ Harman does not specifically indicate when he
considered the civil war to have started, but almost always it is said to have
began with the revolt of the Czech Legion at the end of May 1918 (a date he
seems to agree with, as he writes that the _"Right Social Revolutionaries were
instigators of the counter-revolution"_ ). The Bolsheviks excluded the Right-
SRs and Mensheviks from the government on 14 June of that year so _"well under
way"_ appears to mean around 3 weeks. While opposition parties were sometimes
tolerated and allowed to stand for election to soviets after this date, the
reality was that the soviets had become little more than a fig-leaf of
Bolshevik Party by July 1918 yet Harman proclaims _"[o]f necessity the Soviet
State of 1917 had been replaced by the single-party State of 1920 onwards."_ [
_"How the Revolution was Lost"_ , pp. 13-36, Peter Binns, Tony Cliff, Chris
Harman, **Russia: From Workers' State to State Capitalism** , pp. 18-9]

The suppression of Soviet democracy reached it logical conclusion in 1921 when
the Kronsdadt soviet, heart of the 1917 revolution, was stormed by Bolshevik
forces, the rebels executed, imprisoned or forced into exile. Soviet democracy
was not just an issue of debate but one many workers died in fighting for:
similar events to those at Kronstadt had occurred three years previously.

Before turning to other Bolshevik attacks on working class power and freedom,
we need to address one issue. It will be proclaimed by pro-Bolsheviks that the
Mensheviks (and SRs) were _"counter-revolutionaries"_ and so Bolshevik actions
against them were justified. However, the Bolsheviks started to suppress
opposition soviets **before** the civil war broke out, so at the time neither
group could be called _"counter-revolutionary"_ in any meaningful sense of the
word. The Civil War started on the 25th of May and the SRs and Mensheviks were
expelled from the Soviets on the 14th of June. The right-SRs **did** support
the revolt of the Czech Legion to form what was called the democractic
counter-revolution, based on reforming the Constituent Assembly in Samara (the
White generals came later, displacing the SRs and fighting for the restoration
of the Tsarist regime). The Mensheviks refused to support this strategy and
while the Bolsheviks _"offered some formidable fictions to justify the
expulsions"_ there was _"of course no substance in the charge that the
Mensheviks had been mixed in counter-revolutionary activities on the Don, in
the Urals, in Siberia, with the Czechoslovaks, or that they had joined the
worst Black Hundreds."_ The real reason was the political loses in the soviets
before the Civil War: the Bolsheviks _"drove them underground, just on the eve
of the elections to the Fifth Congress of Soviets in which the Mensheviks were
expected to make significant gains."_ [Getzler, **Op. Cit.** , p. 181]

Official Menshevik policy was to utilise soviet democracy to secure a change
in government and policy, with any member found to have supported the armed
rebellion of the right-SRs was expelled. This included a member of the
Menshevik central committee who went _"without its knowledge"_ to Samara and
was _"expelled from the party"_. Likewise, the Volga Mensheviks were _"sharply
reproved by Martov and the Menshevik Central Committee and instructed that
neither party organisations nor members could take part in . . . such
adventures."_ [Getzler **Op. Cit.** , p. 185] Such legal opposition did not
stop the Bolsheviks repeatedly tolerating and banning the organisation
(interestingly, periods of tolerance co-incidenced with the **decline** of the
White threat and the corresponding rise of working class protest). In summary,
then, the charge that the Mensheviks _"were active supporters of intervention
and of counter-revolution"_ was _"untrue . . . and the Communists, if they
ever believed it, never succeeded in establishing it."_ [Leonard Schapiro,
**The Origin of the Communist Autocracy** , p. 193]

Attacks on working class freedoms and democracy were not limited to the
soviets. Before seizing power, the Bolsheviks had long presented economic
visions much at odds with what libertarians consider as fundamentally
socialist. Lenin, in April 1918, was arguing for one-man management and
_"[o]bedience, and unquestioning obedience at that, during work to the one-man
decisions of Soviet directors, of the dictators elected or appointed by Soviet
institutions, vested with dictatorial powers."_ His support for a new form of
wage slavery involved granting state appointed _"individual executives
dictatorial powers (or 'unlimited' powers)."_ Large-scale industry ( _"the
foundation of socialism"_ ) required _"thousands subordinating their will to
the will of one,"_ and so the revolution _"demands"_ that _"the people
**unquestioningly obey the single will** of the leaders of labour."_ Lenin's
_"superior forms of labour discipline"_ were simply hyper-developed capitalist
forms. The role of workers in production was the same, but with a novel twist,
namely _"unquestioning obedience to the orders of individual representatives
of the Soviet government during the work."_ [ **Collected Works** , vol. 27,
p. 316, p. 267-9 and p. 271]

This simply replaced private capitalism with **state** capitalism. _"In the
shops where one-man management (Lenin's own preference) replaced collegial
management,"_ notes historian Diane Koenker, _"workers faced the same kinds of
authoritarian management they thought existed only under capitalism."_ [
**Labour Relations in Socialist Russia** , p. 177] If, as many Leninists
claim, one-man management was a key factor in the rise of Stalinism and/or
_"state-capitalism"_ in Russia, then, clearly, Lenin's input into these
developments cannot be ignored (see [section H.3.13](secH3.md#sech313) on
the obvious similarities between state socialism and state capitalism). After
advocating _"one-man management"_ and _"state capitalism"_ in early 1918, he
remained a firm supporter of both and looking back at this time from April
1920, he reiterated his position ( _"Dictatorial powers and one-man management
are not contradictory to socialist democracy"_ ) while also stressing that
this was not forced upon the Bolsheviks by civil war. Discussing how, as in
April 1918, the civil war was ended and it was time to build socialism he
argued that the _"whole attention of the Communist Party and the Soviet
government is centred on peaceful economic development, on problems of the
dictatorship and of one-man management . . . When we tackled them for the
first time in 1918, there was no civil war and no experience to speak of."_ So
it was _"not only experience"_ of civil war, argued Lenin _"but something more
profound . . . that has induced us now, as it did two years ago, to
concentrate all our attention on labour discipline."_ [ **Op. Cit.** , vol.
30, p. 503 and p. 504]

In the light of this it is bizarre that some later day Leninists claim that
the Bolsheviks only introduced one-man management because of the Civil War.
Clearly, this was **not** the case: it was **this** period (before the civil
war) that saw Lenin advocate and start to take the control of the economy out
of the hands of the workers and place it into the hands of the Bolshevik party
and the state bureaucracy. Thus what pro-Leninists like to portray as
Stalinist had its roots in Lenin's regime, as can be seen when neo-Trotskyists
like the British SWP's Peter Binns argue that Stalinism must be defined as
_"state capitalism"_ because of the _"exploitation and powerlessness of the
Russian working class"_ , created when it was _"decreed"_ that _"all managers'
orders"_ were -- to quote a 1929 resolution of the Communist Party's Central
Committee -- to be _"unconditionally binding on his subordinate administrative
staff and on all workers"_. [ _"The Theory of State Capitalism"_ , pp. 73-98,
**Russia: From Workers' State to State Capitalism** , p. 75] Given Lenin's
imposition of one-man management in early 1918, why was Bolshevism **not**
state-capitalist? Do social relationships change their nature dependent on who
imposes them, whether it was Lenin or Stalin?

Needless to say, the Bolshevik undermining of the factory committee movement
and, consequently, genuine worker's self-management of production in favour of
state capitalism cannot be gone into great depth here (see [section
H.6.2](secH6.md#sech62), for more discussion). Suffice to say, the factory
committees were deliberately submerged in the trade unions and state control
replaced workers' control. This involved practising one-man management and, as
Lenin put in at the start of May 1918, _"our task is to study the state
capitalism of the Germans, to spare **no effort** in copying it and not to
shrink from adopting **dictatorial** methods to hasten the copying of it."_ He
stressed that this was no new idea, rather he _"gave it **before** the
Bolsheviks seized power."_ [ **Op. Cit.** , vol. 27, p. 340 and p. 341]

It will be objected that Lenin advocated _"workers' control."_ This is true,
but a "workers' control" of a **very** limited nature. As we discuss in
[section H.3.14](secH3.md#sech314), rather than seeing it as workers
managing production directly, he always saw it in terms of workers'
"controlling" or "supervising" those who did and his views on this matter were
**radically** different to those of the factory committees. This is not all,
as Lenin always placed his ideas in a statist context -- rather than base
socialist reconstruction on working class self-organisation from below, the
Bolsheviks started _"to build, from the top, its 'unified administration'"_
based on central bodies created by the Tsarist government in 1915 and 1916.
[Maurice Brinton, **The Bolsheviks and Workers' Control** , p. 36] The
institutional framework of capitalism would be utilised as the principal
(almost exclusive) instruments of "socialist" transformation. Lenin's support
for _"one-man management"_ must be seen in this context, namely his vision of
"socialism."

Bolshevik advocating and implementing of _"one-man management"_ was not
limited to the workplace. On 30th of March 1918 Trotsky, as Commissar of
Military Affairs, set about reorganising the army. The death penalty for
disobedience under fire was reintroduced, as was saluting officers, special
forms of address, separate living quarters and privileges for officers.
Officers were no longer elected. [Brinton, **Op. Cit.** , pp. 37-8] Trotsky
made it clear: _"the principle of election is politically purposeless and
technically inexpedient, and it has been, in practice, abolished by decree"_.
[ _"Work, Discipline, Order"_ , **How the Revolution Armed** , vol. I, pp.
46-7] The soldiers were given no say in their fate, as per bourgeois armies.

Lenin's proposals also struck at the heart of workers' power in other ways.
For example, he argued that _"we must raise the question of piece-work and
apply it . . . in practice."_ [ _"The Immediate Tasks Of The Soviet
Government"_ , **Collected Works** , vol. 27, p. 258] As Leninist Tony Cliff
(of all people) noted, _"the employers have at their disposal a number of
effective methods of disrupting th[e] unity [of workers as a class]. Once of
the most important of these is the fostering of competition between workers by
means of piece-work systems."_ He notes that this was used by the Nazis and
the Stalinists _"for the same purpose."_ [ **State Capitalism in Russia** ,
pp. 18-9] Obviously piece-work is different when Lenin introduces it!

Finally, there is the question of general political freedom. It was also in
this time period that the Bolsheviks first used the secret police (the Cheka,
formed in December 1917) against left-wing opposition groups. The anarchists
in Moscow were attacked on the night of April 11-12, with armed detachments of
the Cheka raiding 26 anarchist centres, killing or wounding 40 and jailing
500. Shortly afterwards the Cheka carried out similar raids in Petrograd and
in the provinces. In May **Burevestnik** , **Anarkhiia** , **Golos Truda** and
other leading anarchist periodicals closed down. [Paul Avrich, **The Russian
Anarchists** , pp. 184-5] It must surely be a coincidence that there had been
a _"continued growth of anarchist influence among unskilled workers"_ after
the October revolution and, equally coincidentally, that _"[b]y the spring of
1918, very little was heard from the anarchists in Petrograd."_ [David Mandel,
**The Petrograd Workers and the Soviet Seizure of Power** , p. 357]

All this **before** the Trotsky provoked revolt of the Czech legion at the end
of May, 1918, and the consequent "democratic counter-revolution" in favour of
the Constituent Assembly (which the right-Socialist Revolutionaries led) and
long before the rise of the White Armies (which replaced the right-SRs as the
main threat to "soviet power" by the end of 1918) and Allied intervention. In
summary, it was **before** large-scale civil war took place, in an interval of
relative peace, that we see the introduction of most of the measures Leninists
now try and pretend were necessitated by the Civil War itself. As discussed in
[sections H.1.7](secH1.md#sec17), the promises of 1917 did not last six
months.

This factual problem with the "civil war caused Bolshevik authoritarianism"
excuse is the best answer to it. If the Bolsheviks pursued authoritarian
policies before the civil war started, it is hard to justify their actions in
terms of something that had not started yet. This explains why some Leninists
have tried to muddy the waters somewhat by obscuring when the civil war
started. For example, John Rees states that _"[m]ost historians treat the
revolution and the civil war as separate processes"_ yet _"[i]n reality they
were one."_ He presents a catalogue of _"armed resistance to the revolution,"_
including such _"precursors of civil war before the revolution"_ as the
suppression after the July days and the Kornilov revolt in 1917. [John Rees,
_"In Defence of October,"_ pp. 3-82, **International Socialism** , no. 52, p.
31-2]

Ironically, Rees fails to see how this blurring of when the civil war started
actually **harms** Leninism. After all, most historians place the start of the
civil war when the Czech legion revolted **because** it marked large-scale
conflict between armies. It is one thing to say that authoritarianism was
caused by war -- large-scale conflict -- and another to say **any** form of
conflict caused it. Simply put, if the Bolshevik state could not handle
relatively minor forms of counter-revolution then where does that leave
Lenin's **State and Revolution**? It is even worse if "civil war" is pushed
back to **before** the actual revolution for then revolution is equated to
civil war and so doomed to degeneration before it even starts. So while the
period from October to May of 1918 was not trouble free, it was not one where
the survival of the new regime looked to be seriously threatened as it was
after that, particularly in 1919 and 1920. Thus "civil war" should be used, as
is commonly done, to refer to the period from the Czech revolt (late May 1918)
to the final defeat of Wrangel (November 1920).

This means attempts to push the start of the civil war back to October 1917
(or even earlier) simply weakens the Leninist argument. It still leaves the
major problem for the "blame it on the civil war" position, namely to explain
why the months **before** May of 1918 saw soviets being closed down, the start
of the suppression of the factory committees, restrictions on freedom of
speech and association, plus the repression of opposition groups (like the
anarchists). Either any level of "civil war" makes Lenin's **State and
Revolution** redundant or the source of Bolshevik authoritarianism must be
found elsewhere. Given that Leninists to this day continue to point to Lenin's
work as what they "really" standfor, it seems unlikely that they will take
their rationales for the Bolshevik's violating it in practice to their logical
position and place that work in the dustbin of history.

That covers the period **before** the start of the civil war. We now turn to
the period **after** it finished. Here we find the same problem, namely an
**increase** of authoritarianism even after the proclaimed cause for it (civil
war) had ended.

The last White General Wrangel evacuated what remained of his forces to
Constantinople in November 1920. With this defeat the Russian civil war had
come to an end and the Bolsheviks started to demoblise the Red Army (halving
its size to around 2,500,000 by the start of 1921). Those familiar with the
history of the revolution will realise that it was some 4 months **later**
that yet another massive strike wave occurred and the Kronstadt revolt took
place (see the appendix ["What was the Kronstadt Rebellion?"](append42.md)),
while within the party, the 10th Congress banned factions. The repression of
the strikes and Kronstadt revolt effectively destroying hope for mass pressure
for change from below and the faction ban within the party closed off the very
last "legal" door for those who opposed the regime from the left (although, as
discussed in the appendix ["Were any of the Bolshevik oppositions a real
alternative?"](append45.md), given that **all** the main factions did not
question the necessity of party dictatorship there was no possibility for real
socialist change).

It could be argued that the Bolsheviks were still fighting peasant
insurrections and strikes across the country, but this has everything to do
with Bolshevik policies and could only be considered "counter-revolutionary"
if you think the Bolsheviks had a monopoly of what socialism and revolution
meant. In the case of the Makhnovists in the Ukraine, the Bolsheviks started
that conflict by betraying them once they had played a key role in defeating
Wrangel. As such, any resistance to Bolshevik rule by the working class and
peasantry of Russia indicated the lack of democracy within the country rather
than some sort of "counter-revolutionary" conflict.

So even the end of the Civil War causes problems for this defence of the
Bolsheviks. Simply put, with the defeat of the Whites it would be expected
that some return to democratic norms would happen. It did not, in fact the
reverse happened. Factions were banned, even the smallest forms of opposition
was finally eliminated from both the party and society as a whole. Those
opposition groups and parties which had been tolerated during the civil war
were finally smashed. Popular revolts for reform, such as the Kronstadt
rebellion and the strike wave which inspired it (see [section 5]() below),
were put down by force. No form of opposition was tolerated, no freedom
allowed. If civil war **was** the cause of Bolshevik authoritarianism, it
seems strange that it got worse after it was finished.

This grim reality was what convinced anarchists like Emma Goldman and
Alexander Berkman to finally break with the regime. After rationalising away
their doubts with the hope that the end of the civil war would see change, the
continuation of repression showed them the error of their ways. As Goldman put
it:

> _"We must not fail to consider the Bolsheviki **continue** to employ exactly
> the same methods today as they did in 'the moments of grim necessity, in
> 1919, 1920, and 1921.' . . . The military fronts have long ago been
> liquidated; internal counter-revolution is suppressed; the old bourgeoisie
> is eliminated; the 'moments of grim necessity' are past . . . but the
> Terror, the Tchecka, suppression of free speech and press, and all the other
> Communist methods of former years still remain in force. Indeed, they are
> being applied even more brutally and barbarously since the death of Lenin.
> Is it to 'preserve the remnants of civilisation' or to strengthen the
> weakening Party dictatorship?"_ [ **My Disillusionment in Russia** , pp.
> liii-liv]

This, then, is the main factual problem with the "blame the civil war"
approach beloved by Leninists to this day: Bolshevik authoritarianism had not
began with the start of the civil war, nor did it stop when the civil war
ended.

As we discuss in [section H.6](secH6.md), the root causes for Bolshevik
authoritarianism post-October was Bolshevik ideology combined with state
power. After all, how "democratic" is it to give all power to the Bolshevik
party central committee? Surely socialism involves more than voting for a new
government? Is it not about mass participation, the kind of participation
centralised government precludes and Bolshevism vanguardism fears -- as
discussed in [section H.5](secH5.md) \-- as being inevitably influenced by
_"bourgeois ideology"_? In such circumstances, moving from party rule to party
dictatorship is not such a leap.

That "civil war" cannot explain what happened can be shown by a counter-
example which effectively shows that civil war did not inevitably mean party
dictatorship ruling over a state capitalist economy (and protesting workers
and peasants!). The Makhnovists (an anarchist influenced partisan army)
managed to defend the revolution and encourage soviet democracy, freedom of
speech, and so on, while doing so (see the appendix ["Why does the Makhnovist
movement show there is an alternative to Bolshevism?"](append46.md)). Which,
of course, does not really fit in with the Bolsheviks being forced to be anti-
democratic due to the pressures of civil war.

So, in summary, civil war and imperialist intervention cannot be blamed for
Bolshevik authoritarianism simply because the latter had started before the
former existed. Moreover, the example of the Makhnovists suggests that
Bolshevik policies during the civil war were also not driven purely by the
need for survival. As Kropotkin argued in 1920, _"all foreign armed
intervention necessarily strengthens the dictatorial tendencies of the
government . . . The evils inherent in a party dictatorship have been
accentuated by the conditions of war in which this party maintains its power.
This state of war has been the pretext for strengthening dictatorial methods
which centralise the control of every detail of life in the hands of the
government, with the effect of stopping an immense part of the ordinary
activity of the country. The evils natural to state communism have been
increased ten-fold under the pretext that all our misery is due to foreign
intervention."_ [ **Anarchism** , p. 253]

In other words, while the civil war may have increased Bolshevik
authoritarianism, it did not create it.

## 4 Did economic collapse and isolation destroy the revolution?

One of the most common Trotskyist explanations for the failure of the Russian
revolution is that the Bolsheviks faced terrible economic conditions, which
forced them to be less than democratic. Combined with the failure of the
revolution to spread to more advanced countries, party dictatorship, it is
argued, was inevitable. In the words of Leninist John Rees:

> _"In a country where the working class was a minority of the population,
> where industry had been battered by years of war and in conditions of White
> and imperialist encirclement, the balance gradually titled towards greater
> coercion. Each step of the way was forced on the Bolsheviks by dire and
> pressing necessities."_ [ _"In Defence of October,"_ **International
> Socialism** , no. 52, p. 41]

Thus _"economic devastation"_ played a key part in the degeneration of the
revolution. [ **Op. Cit.** , p. 31] Other Leninists have made similar
arguments, with Victor Serge noting that the _"decline in production was
uninterrupted. It should be noted that this decline had already begun before
the revolution. In 1916 the output of agricultural machinery, for example, was
down by 80 per cent compared with 1913. The year 1917 had been marked by a
particularly general, rapid and serious downturn. The production figures for
the principal industries in 1913 and 1918 were, in millions of **poods** :
coal, from 1,738 to 731 (42 per cent); iron ore, from 57, 887 to 1,686; cast-
iron, from 256 to 31.5 (12.3 per cent); steel, from 259 to 24.5; rails, from
39.4 to 1.1. As a percentage of 1913 production, output of linen fell to 75
per cent, of sugar to 24 per cent, and tobacco to 19 per cent."_ Moreover,
production continued _"to fall until the end of civil war . . . For 1920, the
following indices are given as a percentage of output in 1913: coal, 27 per
cent; cast iron, 2.4 per cent; linen textiles, 38 per cent."_ [ **Year One of
the Russian Revolution** , p. 352 and p. 425]

Likewise Tony Cliff (like Serge, another of Rees's references), who argued
that war-damaged industry _"continued to run down"_ in the spring of 1918:
_"One of the causes of famine was the breakdown of transport . . . Industry
was in a state of complete collapse. Not only was there no food to feed the
factory workers; there was no raw material or fuel for industry . . . The
collapse of industry meant unemployment for the workers."_ Cliff provides
economic indexes. For large scale industry, taking 1913 as the base, 1917 saw
production fall to 77%. In 1918, it was at 35% of the 1913 figure, 1919 it was
26% and 1920 was 18%. Productivity per worker also fell, from 85% in 1917, to
44% in 1918, 22% in 1919 and then 26% in 1920. [ **Lenin** , vol. 3, pp. 67-9,
p. 86 and p. 85]

In such circumstances, it is argued, how can you expect the Bolsheviks to
subscribe to democratic and socialist norms? This meant that the success or
failure of the revolution depended on whether the revolution spread to more
advanced countries. Leninist Duncan Hallas argues that the _"failure of the
German Revolution in 1918-19 . . . seems, in retrospect, to have been decisive
. . . for only substantial economic aid from an advanced economy, in practice
from a socialist Germany, could have reversed the disintegration of the
Russian working class."_ [ _"Towards a revolutionary socialist party,"_ pp.
38-55, **Party and Class** , Alex Callinicos (ed.), p. 44]

Anarchists are not convinced by these arguments. This is for two reasons.

Firstly, we are aware that revolutions are disruptive no matter where they
occur and, moreover, Leninists are meant to know this too (see [section
1](append43.md#app1)). Simply put, there is a certain incredulous element to
these arguments. Lenin himself had argued that _"[e]very revolution . . . by
its very nature implies a crisis, and a very deep crisis at that, both
political and economic. This is irrespective of the crisis brought about by
the war."_ [ **Collected Works** , vol. 30, p. 341] Serge also considered
crisis as inevitable, arguing that the _"conquest of production by the
proletariat was in itself a stupendous victory, one which saved the
revolution's life. Undoubtedly, so thorough a recasting of all the organs of
production is impossible without a substantial decline in output; undoubtedly,
too, a proletariat cannot labour and fight at the same time."_ [ **Op. Cit.**
, p. 361] As we discussed in detail in [section 2](append43.md#app2), this
was a common Bolshevik position at the time and so it seems strange that --
yet again -- Leninists blame events they consider inevitable for the
degeneration of the Bolshevik regime.

Secondly, and more importantly, every revolution or revolutionary situation
has been accompanied by economic crisis. This means that **if** Bolshevik
authoritarianism is blamed on the state of the economy, it is not hard to
conclude that **every** Bolshevik-style revolution will suffer the same fate
as the Russian one. For example, as we will shortly prove, Germany itself was
in a state of serious economic disruption and falling production in 1918 and
1919, a collapse which would have got worse is a Bolshevik-style revolution
had occurred there. This suggests that the common Leninist idea that a
successful revolution in, say, Germany would have ensured the success of the
Russian Revolution is flawed. Looking at Europe during the period immediately
after the first world war, we discover great economic hardship. To quote one
Trotskyist editor:

> _"In the major imperialist countries of Europe, production still had not
> recovered from wartime destruction. A limited economic upswing in 1919 and
> early 1920 enabled many demobilised soldiers to find work, and unemployment
> fell somewhat. Nonetheless, in 'victorious' France overall production in
> 1920 was still only two-thirds its pre-war level. In Germany industrial
> production was little more than half its 1914 level, human consumption of
> grains was down 44 per cent, and the economy was gripped by spiralling
> inflation. Average per capita wages in Prague in 1920, adjusted for
> inflation, were just over one-third of pre-war levels."_ [John Riddell,
> _"Introduction,"_ **Proceedings and Documents of the Second Congress, 1920**
> , vol. I, p. 17]

Now, if economic collapse was responsible for Bolshevik authoritarianism and
the subsequent failure of the revolution, it seems hard to understand why an
expansion of the revolution into similarly crisis ridden countries would have
had a major impact in the development of the revolution. Since most Leninists
agree that a successful German Revolution would have made the difference, we
will discuss this in more detail before going onto other revolutions and
revolutionary situations.

By 1918, Germany was in a bad state. Victor Serge noted _"the famine and
economic collapse which caused the final ruin of the Central Powers."_ [ **Op.
Cit.** , p. 361] The semi-blockade of Germany during the war badly effected
the economy, the _"dynamic growth"_ of which before the war _"had been largely
dependent on the country's involvement in the world market"_. The war _"proved
catastrophic to those who had depended on the world market and had been
involved in the production of consumer goods . . . Slowly but surely the
country slithered into austerity and ultimately economic collapse"_ and
_"overall food production declined further after poor harvests in 1916 and
1917. Thus grain production, already well below its prewar levels, slumped
from 21.8 million to 14.9 million tons in those two years."_ [V. R. Berghahn,
**Modern Germany** , p. 47, pp. 47-8, p. 50]

The parallels with pre-revolution Russia are striking and it is hardly
surprising that revolution did break out in Germany in November 1918. Workers'
councils sprang up all across the country, inspired in part by the example of
the Russian soviets (and what people **thought** was going on in Russia under
the Bolsheviks). A Social-Democratic government was founded, which used the
Free Corps (right-wing volunteer troops) to crush the revolution from January
1919 onwards. This meant that Germany in 1919 was marked by extensive civil
war and in January 1920 a state of siege was re-introduced across half the
country.

This social turmoil was matched by economic turmoil. As in Russia, Germany
faced massive economic problems, problems which the revolution inherited.
Taking 1928 as the base year, the index of industrial production in Germany
was slightly lower in 1913, namely 98 in 1913 to 100 in 1928 and so Germany
effectively lost 15 years of economic activity. In 1917, the index was 63 and
by 1918 (the year of the revolution), it was 61 (i.e. industrial production
had dropped by nearly 40%). In 1919, it fell again to 37, rising to 54 in 1920
and 65 in 1921. Thus, in 1919, the _"industrial production reached an all-time
low"_ and it _"took until the late 1920s for [food] production to recover its
1912 level . . . In 1921 grain production was still . . . some 30 per cent
below the 1912 figure."_ Coal production was 69.1% of its 1913 level in 1920,
falling to 32.8% in 1923. Iron production was 33.1% in 1920 and 25.6% in 1923.
Steel production likewise fell to 48.5% in 1920 and fell again to 36% in 1923.
[V. R. Berghahn, **Op. Cit.** , p. 258, pp. 67-8, p. 71 and p. 259]

Significantly, one of the first acts of the Bolshevik government towards the
new German Social-Democratic government was _"the offer by the Soviet
authorities of two trainloads of grain for the hungry German population. It
was a symbolical gesture and, in view of desperate shortages in Russia itself,
a generous one."_ The offer, perhaps unsurprisingly, was rejected in favour of
grain from America. [E.H. Carr, **The Bolshevik Revolution** , vol. 3, p. 106]

The similarities between Germany and Russia are clear. As noted above, in
Russia, the index for large scale industry fell to 77 in 1917 from 100 in
1913, falling again to 35 in 1918, 26 in 1919 and 18 in 1920. [Tony Cliff,
**Lenin** , vol. 3, p. 86] In other words, a fall of 23% between 1913 and
1917, 54.5% between 1917 and 1918, 25.7% in 1918 and 30.8% in 1919. A similar
process occurred in Germany, where the fall in production was 37.7% between
1913 and 1917, 8.2% between 1917 and 1918 and 33.9% between 1918 and 1919 (the
year of revolution). While production did rise in 1920 by 45.9%, it was still
around 45% less than before the war.

Thus, comparing the two countries we discover a similar picture of economic
collapse. In the year the revolution started, production had fallen by 23% in
Russia (from 1913 to 1917) and by 43% in Germany (from 1913 to 1918). Once
revolution had effectively started, production fell even more. In Russia, it
fell to 65% of its pre-war level in 1918, in Germany it fell to 62% of its
pre-war level in 1919. Of course, in Germany revolution did not go as far as
in Russia, and so production did rise somewhat in 1920 and afterwards. What is
significant is that in 1923, production fell dramatically by 34% (from around
70% of its pre-war level to around 45% of that level). This economic collapse
did not deter the Communists from trying to provoke a revolution in Germany
that year, so suggesting that economic disruption played no role in their
evaluation of the success of a revolution.

This economic chaos in Germany is never mentioned by Leninists when they
discuss the "objective factors" facing the Russian Revolution. However, once
these facts are taken into account, the superficiality of the typical Leninist
explanation for the degeneration of the revolution becomes obvious. The very
problems which, it is claimed, forced the Bolsheviks to act as they did were
also rampant in Germany. If economic collapse made socialism impossible in
Russia, it would surely have had the same effect in Germany? This means, given
that the economic collapse in both 1918/19 and 1923 was as bad as that facing
Russia in 1918 and that the Bolsheviks had started to undermine soviet and
military democracy along with workers' control by spring and summer of that
year (see [section 3](append43.md#app3)), to blame Bolshevik actions on
economic collapse would mean that any German revolution would have been
subject to the same authoritarianism **if** the roots of Bolshevik
authoritarianism were forced by economic events rather than a product of
applying a specific political ideology via state power. Few Leninists draw
this obvious conclusion from their own arguments although there is no reason
for them not to.

So the German Revolution was facing the same problems the Russian one was.
This means that when John Rees argues that giving machinery or goods to the
peasants in return for grain instead of simply seizing it required
_"revolution in Germany, or at least the revival of industry"_ in Russia, he
completely fails to indicate the troubles facing the German revolution (and
the role Bolshevik policies and prejudices played in the collapse of industry,
as noted in [section H.6.2](secH6.md#sech62)). _"Without a successful German
revolution,"_ he writes, _"the Bolsheviks were thrown back into a bloody civil
war with only limited resources. The revolution was under siege."_ [John Rees,
_"In Defence of October,"_ pp. 3-82, **International Socialism** , no. 52, p.
40 and p. 29] Yet given the state of the German economy at the time, it is
hard to see how much aid a successful German revolution could have given and
so his belief that a successful German Revolution would have mitigated
Bolshevik authoritarianism seems exactly that, a belief without any real
evidence to support it. As Lenin argued against the Russian left-communists in
early 1918:

> _"Yes, we shall see the world revolution, but for the time being it is a
> very good fairy-tale . . . But I ask, is it proper for a serious
> revolutionary to believe in fairy-tales? . . . [I]f you tell the people that
> civil war will break out in German and also guarantee that instead of a
> clash with imperialism we shall have a field revolution on a world-wide
> scale, the people will say you are deceiving them. In doing this you will be
> overcoming the difficulties with which history has confronted us only in
> your minds, by your wishes . . . You are staking everything on this card! If
> the revolution breaks out, everything is saved . . . But if it does not turn
> out as we desire, if it does not achieve victory tomorrow -- what then? Then
> the masses will say to you, you acted like gamblers -- you staked everything
> on a fortunate turn of events that did not take place . . ."_ [ **Collected
> Works** , vol. 27, p. 102]

It seems ironic that modern-day Leninists subscribe to such _"fairy-tales"_ in
their attempts to excuse Lenin's regime.

The same can be said of other revolutions as well. The Paris Commune, for
example, was born after a four-month-long siege _"had left the capital in a
state of economic collapse. The winter had been the severest in living memory.
Food and fuel had been the main problems . . . Unemployment was widespread.
Thousands of demobilised soldiers wandered loose in Paris and joined in the
general hunt for food, shelter and warmth. For most working men the only
source of income was the 1.50 francs daily pay of the National Guard, which in
effect had become a form of unemployment pay."_ The city was _"near starving"_
and by March it was _"in a state of economic and political crisis."_ [Stewart
Edwards, _"Introduction,"_ **The Communards of Paris, 1871** , p. 23] Yet this
economic collapse and isolation did not stop the commune from introducing and
maintaining democratic forms of decision making, both political and economic.
A similar process occurred during the French Revolution, where mass
participation via the _"sections"_ was not hindered by economic collapse. It
was finally stopped by state action organised by the Jacobins to destroy
popular participation and initiative (see Kropotkin's **The Great French
Revolution** for details).

During the Spanish Revolution, _"overall Catalan production fell in the first
year of war by 30 per cent, and in the cotton-working sector of the textile
industry by twice as much. Overall unemployment (complete and partial) rose by
nearly a quarter in the first year, and this despite the military mobilisation
decreed in September 1936. The cost of living quadrupled in just over two
years; wages . . . only doubled."_ [Ronald Fraser, **Blood of Spain** , p.
234] Markets, both internally and externally, for goods and raw materials were
disrupted, not to mention the foreign blockade and the difficulties the war
and revolution imposed in trying to buy products from other countries. This
came on top of problems caused by the great depression of the 1930s which
affected Spain along with most other countries. Yet, libertarian socialist
norms of economic and social decision making continued in spite of economic
disruption. Ironically, given the subject of this discussion, it was only once
the Stalinist counter-revolution got going were they fatally undermined or
destroyed.

Thus economic disruption need not automatically imply authoritarian policies.
And just as well, given the fact that revolution and economic disruption seem
to go hand in hand.

Looking further afield, even revolutionary situations can be accompanied with
economic collapse. For example, the Argentine revolt against neo-liberalism
which started in 2001 took place when economy was a mess, with poverty and
unemployment at disgusting levels. Four years of recession saw the poverty
rate balloon from 31 to 53 percent of the population of 37 million, while
unemployment climbed from 14 to 21.4 percent, according to official figures.
Yet in the face of such economic problems, working class people acted
collectively, forming popular assemblies and taking over workplaces (see
**Horizontalism: Voices of Popular Power in Argentina** , edited by Marina
Sitrin).

The Great Depression of the 1930s in America saw a much deeper economic
contradiction. Indeed, it was as bad as that associated with revolutionary
Germany and Russia after the first world war. According to Howard Zinn, after
the stock market crash in 1929 _"the economy was stunned, barely moving. Over
five thousand banks closed and huge numbers of businesses, unable to get
money, closed too. Those that continued laid off employees and cut the wages
of those who remained, again and again. Industrial production fell by 50
percent, and by 1933 perhaps 15 million (no one knew exactly) -- one-forth or
one-third of the labour force -- were out of work."_ [ **A People's History of
the United States** , p. 378] Specific industries were badly affected. For
example, total GNP fell to 53.6% in 1933 compared to its 1929 value. The
production of basic goods fell by much more. Iron and Steel saw a 59.3%
decline, machinery a 61.6% decline and non-ferrous metals and products, a
55.9% decline. Transport was also affected, with transportation equipment
declining by 64.2% railroad car production dropping by 73.6% and locomotion
production declining by 86.4%. Furniture production saw a decline of 57.9%.
The workforce was equally affected, with unemployment reaching 25% in 1933. In
Chicago 40% of the workforce was unemployed. Union membership, which had
fallen from 5 million in 1920 to 3.4 million in 1929 fell to less than 3
million by 1933. [Lester V. Chandler, **America's Greatest Depression,
1929-1941** , p. 20, p. 23, p. 34, p. 45 and p. 228]

Yet in the face of this economic collapse, no Leninist proclaimed the
impossibility socialism. In fact, the reverse was the case. Similar arguments
could apply to, say, post-world war two Europe, when economic collapse and war
damage did not stop Trotskyists looking forward to, and seeking, revolutions
there. Nor did the massive economic collapse that occurred after the fall of
Stalinism in Russia in the early 1990s deter Leninist calls for revolution.
Indeed, you can rest assured that any drop in economic activity, no matter how
large or small, will be accompanied by Leninist articles arguing for the
immediate introduction of socialism.

And this was the case in 1917 as well, when economic crisis had been a fact of
Russian life throughout the year. Lenin, for example, argued at the end of
September that _"[u]navoidable catastrophe is threatening Russia . . . The
danger of a great catastrophe and of famine is imminent . . . Six months of
revolution have elapsed. The catastrophe is even closer. Unemployment has
assumed a mass scale. To think that there is a shortage of goods in the
country"_. [ _"The Threatening Catastrophe and how to Fight It"_ , **Collected
Works** , vol. 25, p. 327] This did not stop him calling for revolution and
seizing power, arguing that only a genuine socialist government -- a Bolshevik
one, naturally -- could implement the policies needed to solve the crisis. Nor
did this crisis stop the creation of democratic working class organisations,
such as soviets, trade unions and factory committees being formed. It did not
stop mass collective action to combat those difficulties. It appears,
therefore, that while the economic crisis of 1917 did not stop the development
of socialist tendencies to combat it, the seizure of power by a socialist
party did.

Given that no Leninist has argued that a revolution could not nor should not
take place in Russia in 1917, in Germany after the First World War, in the USA
during the darkest months of the Great Depression, nor in Europe after the
devastation of the Second World War, the argument that the grim economic
conditions facing Bolshevik Russia made socialist democracy impossible seem
weak. By arguing that, for example, Germany in 1918 to 1921 could create a
viable socialist revolution in economic conditions just as bad as those facing
Soviet Russia, the reasons why the Bolsheviks created a party dictatorship
must be looked for elsewhere. Moreover, **if** the pro-Bolshevik argument
Rees, Cliff and others expound **is** correct, then the German Revolution
would have been subject to the same authoritarianism as befell the Bolshevik
one simply because it was facing a similar economic crisis.

In short, if these arguments are taken seriously them you would have to
conclude that, for Leninists, economic collapse only makes socialism
impossible once **they** are in power. Which is hardly convincing, or
inspiring.

Finally, the situation is not as bleak as these Leninist argument would
suggest. Yes, revolutions and economic disruption do go together but this does
not make revolution undesirable or impossible. It means that revolutionaries
need to be aware of these predictable -- and predicted, at least by
anarchists! -- developments and be aware of the solutions can only be found in
decentralisation, federalism and self-management. As Kropotkin put it:

> _"The first months of emancipation will inevitably increase consumption of
> goods and production will diminish. And, furthermore, any country achieving
> social revolution will be surrounded by a ring of neighbours either
> unfriendly or actually enemies . . . The demands upon products will increase
> while production decreases, and finally famine will come. There is only one
> way of avoiding it. We should understand that as soon as a revolutionary
> movement begins in any country the only possible way out will consist in the
> workingmen [and women] and peasants from the beginning taking the whole
> national economy into their hands and organising it themselves . . . But
> they will not be convinced of this necessity except when all responsibility
> for national economy, today in the hands of a multitude of ministers and
> committees, is presented in a simple form to each village and city, in every
> factory and shop, as their own affair, and when they understand that they
> must direct it themselves."_ [Kropotkin, **Anarchism** , pp. 77-8]

Anarchists have always recognised that a revolution would face problems and
difficult "objective factors" and has developed our ideas accordingly. We
argue that to blame "objective factors" for the failure of the Russian
Revolution simply shows that believing in fairy-tales is sadly far too common
on the "serious" Leninist "revolutionary" left. As we discuss in the appendix
on ["How did Bolshevik ideology contribute to the failure of the
Revolution?"](append44.md), Marxist ideas were important and decisive in
developments. In other words, economic disruption need not undermine a
revolution if libertarian principles are applied. In Russia, this inevitable
economic distruption was made worse by Bolshevik ideology due to the policies
it inspired and the centralised structures it created.

## 5 Was the Russian working class atomised or "declassed"?

A standard Leninist explanation for the dictatorship of the Bolshevik party
(and subsequent rise of Stalinism) is based on the "atomisation" or
"declassing" of the proletariat. Neo-Trotskyist John Rees summarises this
argument as follows:

> _"The civil war had reduced industry to rubble. The working class base of
> the workers' state, mobilised time and again to defeat the Whites, the rock
> on which Bolshevik power stood, had disintegrated. The Bolsheviks survived
> three years of civil war and wars in intervention, but only at the cost of
> reducing the working class to an atomised, individualised mass, a fraction
> of its former size, and no longer able to exercise the collective power that
> it had done in 1917 . . . The bureaucracy of the workers' state was left
> suspended in mid-air, its class base eroded and demoralised. Such conditions
> could not help but have an effect on the machinery of the state and
> organisation of the Bolshevik Party . . . The vice-like pressure of the
> civil war had transformed the state in other ways. The weight of the
> bureaucracy, of the army, of the Cheka, had grown enormously during the
> civil war. Without these institutions the October regime would have been
> swept away in a bloody, reactionary counter-revolution. With them the
> October revolution had become sclerotic and authoritarian . . . The power of
> the bureaucracy, and within the bureaucracy the power of its top layers,
> grew."_ [ _"In Defence of October,"_ pp. 3-82, **International Socialism** ,
> no. 52, pp. 65-6]

It is these objective factors which explain why the Bolshevik party
substituted itself for the Russian working class. _"Under such conditions,"_
argues Tony Cliff, _"the class base of the Bolshevik Party disintegrated --
not because of some mistakes in the policies of Bolshevism, not because of one
or another conception of Bolshevism regarding the role of the party and its
relation to the class -- but because of mightier historical factors. The
working class had become declassed . . . Bolshevik 'substitutionism' . . . did
not jump out of Lenin's head as Minerva out of Zeus's, but was born of the
objective conditions of civil war in a peasant country, where a small working
class, reduced in weight, became fragmented and dissolved into the peasant
masses."_ [ **Trotsky on Substitutionism** , pp. 62-3] In other words, because
the working class was so decimated the replacement of class power by party
power and then by that of the bureaucracy (Stalinism) was inevitable.

Before discussing it, we should point out that this argument dates back to
Lenin. For example, he argued in 1921 that the proletariat, _"owning to the
war and to the desperate poverty and ruin, has become declassed, i.e.
dislodged from its class groove, and had ceased to exist as a proletariat . .
. the proletariat has disappeared."_ [ **Collected Works** , vol. 33, p. 65]
However, unlike his later-day followers, Lenin was sure that while it _"would
be absurd and ridiculous to deny that the fact that the proletariat is
declassed is a handicap"_ it could still _"fulfil its task of wining and
holding state power."_ [ **Op. Cit.** , vol. 32, p. 412]

Anarchists do not find these arguments particularly convincing. This is for
two reasons.

First, it seems incredulous to blame the civil war for the "substitution" of
Bolshevik power for working class power as party power had been Lenin's stated
aim in 1917 (and long before) and October saw the seizure of power by the
Bolsheviks, **not** the soviets (see [section H.3.11](secH3.md#sech311%22)).
As we saw in [section 3](append43.md#app3), the Bolsheviks started to
gerrymander and disband soviets to remain in power **before** the civil war
started. As such, to blame the civil war and the problems it caused for the
usurpation of power by the Bolsheviks is unconvincing. Simply put, the
Bolsheviks had "substituted" itself for the proletariat from the start, from
the day it seized power in the October revolution.

Second, the fact is the Russian working class was far from "atomised." Rather
than being incapable of collective action, as Leninists assert, Russia's
workers were more than capable of taking collective action throughout the
civil war period. The problem for Leninists is, of course, that any such
collective action was directed **against** the Bolshevik regime. This caused
the party no end of problems for if the working class **was** the ruling class
under the Bolsheviks, then who was it striking and protesting against? Emma
Goldman explains the issue well:

> _"In my early period the question of strikes had puzzled me a great deal.
> People had told me that the least attempt of that kind was crushed and the
> participants sent to prison. I had not believed it, and, as in all similar
> things, I turned to Zorin [a Bolshevik] for information. 'Strikes under the
> dictatorship of the proletariat!' he had proclaimed; 'there's no such
> thing.' He had even upbraided me for crediting such wild and impossible
> tales. Against whom, indeed, should the workers strike in Soviet Russia, he
> argued. Against themselves? They were the masters of the country,
> politically as well as industrially. To be sure, there were some among the
> toilers who were not yet fully class-conscious and aware of their own true
> interests. These were sometimes disgruntled, but they were elements incited
> by . . . self-seekers and enemies of the Revolution . . . no better than out
> and out counter-revolutionists, and of course the Soviet authorities had to
> protect the country against their kind."_ [ **Living My Life** , vol. 2, pp.
> 872-3]

This still seems to be the position in pro-Bolshevik accounts of the
Revolution and its degeneration. After the Bolshevik seizure of power, the
working class as an active agent almost immediately disappears from their
accounts and any mention of strikes and protests is short and fleeting, if it
exists at all. This is unsurprising, as it does not bode well for maintaining
the Bolshevik Myth to admit that workers were resisting the so-called
"proletarian dictatorship" from the start. The notion that the working class
had "disappeared" fits into this selective blindness well: why discuss the
actions of a class which did not exist? Thus we have a logical circle from
which reality can be excluded: the working class is "atomised" and so cannot
take industrial action, evidence of industrial action need not be looked for
nor mentioned because the class is "atomised."

As discussed in [section H.6.3](secH6.md#sech63), the Russian working class
**did** take extensive collective action throughout this period (from the
Bolshevik seizure of power to well after the end of the civil war) and faced
substantial State repression as a result. Here we provide more evidence of the
existence of working class collective struggle throughout the period 1918 to
1923 but before doing so, it is necessary to place Lenin's comments on the
"declassing" of the working class in context: rather than being the result of
a **lack** of collective industrial direct action and solidarity, Lenin's
arguments were the product of its opposite -- the **rise** in collective
struggle by the Russian working class. As one historian notes, _"[a]s
discontent amongst workers became more and more difficult to ignore, Lenin . .
. began to argue that the consciousness of the working class had deteriorated
. . . workers had become 'declassed.'"_ _"Lenin's analysis,"_ he continues,
_"had a superficial logic but it was based on a false conception of working-
class consciousness. There is little evidence to suggest that the demands that
workers made at the end of 1920 . . . represented a fundamental change in
aspirations since 1917"_. Moreover, _"an analysis of the industrial unrest in
1921 shows that long-standing workers were prominent in protest."_ [Jonathan
Aves, **Workers Against Lenin** , pp. 90-1]

Lenin's pessimistic analysis of 1921 is in sharp contrast to the optimistic
mood of early 1920 in Bolshevik ranks produced by the defeat of the White
armies. For example, writing in May 1920, Trotsky seemed oblivious to the
atomisation of the Russian working class so much bemoaned later, arguing that
_"in spite of political tortures, physical sufferings and horrors, the
labouring masses are infinitely distinct from political decomposition, from
moral collapse, or from apathy . . . Today, in all branches of industry, there
is going on an energetic struggle for the establishment of strict labour
discipline, and for the increase of the productivity of labour. The party
organisations, the trade unions, the factory and workshop administrative
committees, rival each one another in this respect, with the undivided support
of the working class as a whole."_ Indeed, they _"concentrate their attention
and will on collective problems"_ ( _"Thanks to a regime which, though it had
inflicted great hardship upon them, has given their life a purpose and a high
goal"_!). Needless to say, the party had _"the undivided support of the public
opinion of the working class as a whole."_ [ **Terrorism and Communism** , p.
6]

The turn around in perspective after this period did not happen by accident,
independently of the working class resistance to Bolshevik rule. After all,
the defeat of the Whites in early of 1920 saw the Bolsheviks take _"victory as
a sign of the correctness of its ideological approach and set about the task
of reconstruction on the basis of an intensification of War Communism policies
with redoubled determination."_ This led to _"an increase in industrial unrest
in 1920,"_ including _"serious strikes."_ The resistance was _"becoming
increasingly politicised."_ Thus, the stage was set for Lenin's turn around
and his talk of "declassing." In early 1921 _"Lenin argued that workers, who
were no more demoralised than they were in early 1920, had become 'declassed'
in order to justify a political clamp-down."_ [Aves, **Op. Cit.** , p. 37, p.
80 and p. 18]

Other historians also note this context. For example, while the _"working
class had decreased in size and changed in composition, . . . the protest
movement from late 1920 made clear that it was not a negligible force and that
in an inchoate way it retained a vision of socialism which was not identified
entirely with Bolshevik power . . . Lenin's arguments on the declassing of the
proletariat was more a way of avoiding this unpleasant truth than a real
reflection of what remained, in Moscow at least, a substantial physical and
ideological force."_ [Richard Sakwa, **Soviet Communists in Power** , p. 261]
In the words of Diane Koenker, _"[i]f Lenin's perceptions of the situation
were at all representative, it appears that the Bolshevik party made
deurbanisation and declassing the scapegoat for its political difficulties,
when the party's own policies and its unwillingness to accept changing
proletarian attitudes were also to blame."_ Ironically, this was not the first
time that the Bolsheviks had blamed its problems on the lack of a "true"
proletariat and its replacement by "petty-bourgeois" elements: _"This was the
same argument used to explain the Bolsheviks' lack of success in the early
months of 1917 -- that the cadres of conscious proletarians were diluted by
non-proletarian elements."_ [ _"Urbanisation and Deurbanisation in the Russian
Revolution and Civil War,"_ pp. 424-450, **The Journal of Modern History** ,
vol. 57, no. 3, p. 449 and p. 428]

It should be noted that the "declassing" argument does have a superficial
validity if you accept the logic of vanguardism. After all, if you accept the
premise that the party alone represents socialist consciousness and that the
working class, by its own efforts, can only reach a reformist level of
political conscious (at best), then any deviation in working class support for
the party obviously represents a drop in class consciousness or a "declassing"
of the proletariat (see [section H.5.1](secH5.md#sech51)). Thus working
class protest against the party can be dismissed as evidence of "declassing"
which has to be suppressed rather than what it really is, namely evidence of
working class autonomy and collective struggle for what it considers **its**
interests to be against a new master class. The "declassing" argument is
related to the vanguardist position which, in turn, justifies the dictatorship
of the party **over** the class (see [section H.5.3](secH5.md#sech53)).

So the "declassing" argument is not some neutral statement based on the fact
that the numbers of industrial workers fell between October 1917 and 1921. It
was developed as a weapon in the class struggle, to justify Bolshevik
repression of collective working class struggle, to justify the continuation
of Bolshevik party dictatorship **over** the working class. This in turn
explains why working class struggle during this period generally fails to get
mentioned by later day Bolsheviks -- it simply undermines their justifications
for Bolshevik dictatorship. After all, how can they say that the working class
could not exercise _"collective power"_ when it was conducting mass strikes --
collective action -- throughout Russia during the period 1918 to 1923?

As such, it is not strange that most Leninist accounts of the revolution post-
October rarely, if ever, mention what the working class was actually doing. We
do get statistics on the drop of the numbers of industrial workers in the
cities (usually Petrograd and Moscow), but any discussion on working class
protest and strikes is limited at best, usually ignored. Which shows the
bankruptcy of what can be called the "statistical tendency" of analysing the
Russian working class. While statistics can tell us how many industrial
workers remained in Russia in, say, 1921, they do not provide any idea of
their combativeness or their ability to take collective decisions and action.
If statistics alone indicated that, then the massive labour struggles in 1930s
American would not have taken place. Millions had been made redundant: at the
Ford Motor Company, for example, 128,000 workers had been employed in the
spring of 1929 and only 37,000 were by August of 1931 (only 29% of the 1929
figure) while, by the end of 1930, almost half of the 280,000 textile mill
workers in New England were out of work. [Howard Zinn, **A People's History of
the United States** , p. 378] Yet in the face of this mass unemployment and
economic crisis, the workers organised themselves and fought back. Likewise,
the reduction in the number of Russian workers did not restrict their ability
to make collective decisions and collectively act on them -- Bolshevik
repression **did.**

Moreover, while Leninists usually point to the fall in population in Petrograd
and Moscow during the civil war, concentrating on these cities can be
misleading. _"Using the Petrograd figures,"_ notes Daniel R. Bower,
_"historians have painted a lurid picture of flight from the cities. In 1918
alone the former capital lost 850,000 people and was by itself responsible for
one-half of the total urban population decline of the Civil War years. If one
sets aside aggregate figures to determine the trend characteristic of most
cities, however, the experiences of Petrograd appears exception. Only a
handful of cities . . . lost half their population between 1917 and 1920, and
even Moscow, which declined by over 40 percent, was not typical of most towns
in the northern, food-importing areas. A study of all cities . . . found that
the average decline in the north (167 towns in all, excluding the capital
cities) amounted to 24 percent between 1917 and 1920. Among the towns in the
food-producing areas in the southern and eastern regions of the Russian
Republic (a total of 128), the average decline came to only 14 percent."_ [
_"'The city in danger': The Civil War and the Russian Urban Population,"_
**Party, State, and Society in the Russian Civil War** , Diane P. Koenker,
William G. Rosenberg and Ronald Grigor Suny (eds.), p. 61] Does this mean that
the possibility of soviet democracy declined less in these towns? Yet the
Bolsheviks applied their dictatorship even there, suggesting that declining
urban populations was not the source of their authoritarianism.

Equally, what are we to make of towns and cities which increased their
populations? For example, Minsk, Samara, Khar'kov, Tiflis, Baku, Rostov-on-
don, Tsaritsyn and Perm all grew in population (often by significant amounts)
between 1910 and 1920 while other cities shrunk. [Diane Koenker,
_"Urbanisation and Deurbanisation in the Russian Revolution and Civil War,"_
pp. 424-450, **The Journal of Modern History** , vol. 57, no. 3, p. 425] Does
that mean soviet democracy was possible in those towns but not in Petrograd or
Moscow? Or does the fact that the industrial workforce grew by 14.8% between
October 1920 and April 1921 mean that the possibility for soviet democracy
also grew by a related percentage? [Aves, **Workers Against Lenin** , p. 159]
In neither case was soviet democracy encouraged, in spite of the reversal of
the factor alleged to have undermined it.

Then there is the question of when the reduction of workers makes soviet
democracy impossible. After all, between May 1917 and April 1918 the city of
Moscow lost 300,000 of its two million inhabitants. Was soviet democracy
impossible in April 1918 because of this? During the civil war, Moscow lost
another 700,000 by 1920 (which is basically the same amount per year). [Diane
Koenker, **Op. Cit.** , p. 424] When did this fall in population mean that
soviet democracy was impossible?

Simply put, comparing figures of one year to another simply fails to
understand the dynamics at work, such as the impact of _"reasons of state"_
and working class resistance to Bolshevik rule. It, in effect, turns attention
away from the state of working class autonomy and on to number crunching.

Ultimately, the question of whether the working class was too "atomised" to
govern can only be answered by doing something Leninists rarely do: looking at
the class struggle in Russia during this period, by looking at the strikes,
demonstrations and protests that occurred under Bolshevik rule. Needless to
say, certain strike waves just cannot be ignored. The most obvious case is in
Petrograd just before the Kronstadt revolt in early 1921. After all, the
strikes (and subsequent Bolshevik repression) inspired the sailors to revolt
in solidarity with them. Faced with such events, in Leninist circles the scale
of the strikes and the Bolshevik repression is understated and the subject
quickly changed. As we noted in [section 10](append42.md#app10) of the
appendix on ["What was the Kronstadt Rebellion?"](append42.md), John Rees
states that Kronstadt was _"preceded by a wave of serious but quickly resolved
strikes."_ [ **Op. Cit.** , p. 61] Needless to say, he does not -- no more
than Trotsky before him -- mention that the strikes were _"resolved"_ by
_"serious"_ state repression as Emma Goldman recalled:

> _Trotsky . . . omits the most important reason for the seeming indifference
> of the workers of Petrograd. It is of importance, therefore, to point out
> that the campaign of slander, lies and calumny against the sailors began on
> the 2nd March, 1921. The Soviet Press fairly oozed poison against the
> sailors. The most despicable charges were hurled against them, and this was
> kept up until Kronstadt was liquidated on 17th March. In addition, Petrograd
> was put under martial law. Several factories were shut down . . . Under
> these iron-clad rules it was physically impossible for the workers of
> Petrograd to ally themselves with Kronstadt, especially as not one word of
> the manifestoes issued by the sailors in their paper was permitted to
> penetrate to the workers in Petrograd. In other words, Leon Trotsky
> deliberately falsifies the facts."_ [ _"Trotsky Protests Too Much"_ , [
> **Writings of Emma Goldman** , 264]

Nor does Rees explain how _"an atomised, individualised mass"_ **could**
conduct such _"serious"_ strikes, strikes which required martial law to break.
Little wonder, then, Rees does not expound on the strikes and what they mean
in terms of the revolution and his own argument. Ida Mett long ago stated the
obvious about these all-Russia strike waves: _"And if the proletariat was that
exhausted how come it was still capable of waging virtually total general
strikes in the largest and most heavily industrialised cities?"_ [ **The
Kronstadt Uprising** , p. 81]

Similarly, we find Victor Serge arguing that the _"working class often fretted
and cursed; sometimes it lent an ear to the Menshevik agitators, as in the
great strikes at Petrograd in the spring of 1919. But once the choice was
posed as that between the dictatorship of the White Generals and the
dictatorship of its own party -- and there was not and could not be any other
choice -- every fit man . . . came to stand . . . before the windows of the
local party offices."_ [ **Year One of the Russian Revolution** , pp. 365-6]
An exhausted and atomised working class capable of _"great strikes"_? That
seems unlikely. Significantly, Serge does not mention the Bolshevik acts of
repression used against the rebel workers (see below). This omission cannot
help distort any conclusions to be drawn from his account.

Which, incidentally, shows that the civil war was not all bad news for the
Bolsheviks. Faced with working class protest, they could play the "White card"
-- unless the workers went back to work, the Whites would win. This explains
why the strikes of early 1921 were larger than before and explains why they
were so important. As the "White card" could no longer be played, the
Bolshevik repression could not be excused in terms of the civil war. Indeed,
given working class opposition to the party, it would be fair to say that
civil war actually **helped** the Bolsheviks remain in power: without the
threat of the Whites, the working class would **not** have tolerated the
Bolsheviks longer than the Autumn of 1918. As Emma Goldman recounted,
_"Kropotkin emphasised, that the blockade and the continuous attacks on the
Revolution by the interventionists had helped to strengthen the power of the
Communist regime. Intervention and blockade were bleeding Russia to death, and
were preventing the people from understanding the real nature of the Bolshevik
regime."_ [ **My Disillusionment in Russia** , p. 99]

The fact is that working class collective struggle against the new regime --
the new boss class -- and, consequently, Bolshevik repression, started before
the outbreak of the civil war, continued throughout the civil war period and
reached a climax in the early months of 1921. Even the repression of the
Kronstadt rebellion did not stop it, with strikes continuing into 1923 (and,
to a lesser degree, afterward). Indeed, the history of the "workers' state" is
a history of the state repressing the revolt of the workers.

Needless to say, it would be impossible to give a full account of working
class resistance to Bolshevism. All we can do here is give a flavour of what
was happening and the sources for further information (also see [section
H.6.3](secH6.md#sech63)). What should be clear from our account is that the
idea that the working class in this period was incapable of collective
organisation and struggle is false, the idea that Bolshevik "substitutionism"
can be explained in such terms is also false. In addition, it will become
clear that Bolshevik repression explicitly aimed to break the ability of
workers to organise and exercise collective power. As such, it seems
hypocritical for modern-day Leninists to blame Bolshevik party dictatorship on
the "atomisation" of the working class when Bolshevik rule was dependent on
smashing working class collective organisation and resistance. Simply put, to
remain in power Bolshevism, from almost the start, had to crush working class
power. This is to be expected, given the centralised nature of the state and
the class structures and authoritarian social relationships it generates (see
[section H.3.9](secH3.md#sech39)) and the assumptions of vanguardism (see
[section H.5](secH5.md#sech53)). If you like, October 1917 did not see the
end of _"dual power"_ : rather the Bolshevik state replaced the bourgeois
state and working class power (as expressed in its collective struggle) came
into conflict with it. By 1921 these protests and strikes were threatening the
very existence of the Bolshevik dictatorship, forcing it to abandon key
aspects of its economic policies.

This struggle of the "workers' state" against the workers started early in
1918. _"By the early summer of 1918,"_ records one historian, _"there were
widespread anti-Bolshevik protests. Armed clashes occurred in the factory
districts of Petrograd and other industrial centres. Under the aegis of the
Conference of Factory and Plant Representatives . . . a general strike was set
for July 2."_ [William Rosenberg, **Russian Labour and Bolshevik Power** , p.
107] According to another historian, economic factors _"were soon to erode the
standing of the Bolsheviks among Petrograd workers . . . These developments,
in turn, led in short order to worker protests, which then precipitated
violent repressions against hostile workers. Such treatment further
intensified the disenchantment of significant segments of Petrograd labour
with Bolshevik-dominated Soviet rule."_ [Alexander Rabinowitch, **Early
Disenchantment with Bolshevik Rule** , p. 37]

The reasons for these protest movement were both political and economic. The
deepening economic crisis combined with protests against Bolshevik
authoritarianism to produce a wave of strikes aiming for political change.
Feeling that the soviets were distant and unresponsive to their needs (with
good reason, given Bolshevik postponement of soviet elections and
gerrymandering of the soviets -- see [section H.6.1](secH6.md#sech61)),
workers turned to direct action and the initially Menshevik inspired
_"Conference of Factory and Plant Representatives"_ (also known as the
_"Extraordinary Assembly of Delegates from Petrograd Factories and Plants"_ ,
EAD) to voice their concerns. At its peak, reports _"estimated that out of
146,000 workers still in Petrograd, as many as 100,000 supported the
conference's goals."_ [Rosenberg, **Op. Cit.** , p. 127] The aim of the
Conference (as per Menshevik policy) was to reform the existing system from
within and, as such, the Conference operated openly: _"for the Soviet
authorities in Petrograd, the rise of the Extraordinary Assembly of Delegates
from Petrograd Factories and Plants was an ominous portent of worker
defection."_ [Rabinowitch, **Op. Cit.** , p. 37]

The first wave of outrage and protests occurred after Bolshevik Red Guards
opened fire on a demonstration for the Constituent Assembly in early January
(killing 21, according to Bolshevik sources). This demonstration _"was notable
as the first time workers came out actively against the new regime. More
ominously, it was also the first time forces representing soviet power used
violence against workers."_ [David Mandel, **The Petrograd Workers and the
Soviet Seizure of Power** , p. 355] It would not be the last -- indeed
repression by the "workers' state" of workers became a recurring feature of
Bolshevism.

The general workers' opposition saw the growth of the EAD. _"The emergence of
the EAD"_ , Rabinowitch notes, _"was also stimulated by the widespread view
that trade unions, factory committees, and soviets . . . were no longer
representative, democratically run working-class institutions; instead they
had been transformed into arbitrary, bureaucratic government agencies. There
was ample reason for this concern."_ To counter the EAD, the Bolsheviks
organised non-party conferences which, in itself, shows that the soviets had
become as distant from the masses as the opposition argued. District soviets
_"were deeply concerned about their increasing isolation . . . At the end of
March . . . they resolved to convene successive nonparty workers' conferences
. . . in part to undercut the EAD by strengthening ties between district
soviets and workers."_ This was done amidst _"unmistakable signs of the
widening rift between Bolshevik-dominated political institutions and ordinary
factory workers."_ The EAD was an expression of the _"growing disenchantment
of Petrograd workers with economic conditions and the evolving structure and
operation of Soviet political institutions"_. [ **Op. Cit.** , p. 224, p. 232
and p. 231]

It _"appeared that the government was now ready to go to whatever extremes it
deemed necessary (including sanctioning the arrest and even shooting of
workers) to quell labour unrest. This in turn led to intimidation, apathy,
lethargy and passivity of other workers. In these circumstances, growth in
support of the [Extraordinary] Assembly slowed down."_ The Assembly's plans
for a May Day demonstration to protest the government's policies were
cancelled because of workers did not respond to the appeals to demonstrate, in
part because of _"Bolshevik threats against 'protesters'"_. This apathy did
not last long as events _"served to reinvigorate and temporarily radicalise
the Assembly. These developments included yet another drastic drop in food
supplies, the shooting of protesting housewives and workers in the Petrograd
suburb of Kolpino, the arbitrary arrest and abuse of workers in another
Petrograd suburb, Sestroresk, the closure of newspapers and the arrests of
individuals who had denounced the Kolpino and Sestroresk events, the
intensification of labour unrest and conflict with the authorities in the
Obukhov plant and in other Petrograd factories and districts."_ [Rabinowitch,
**Early Disenchantment with Bolshevik Rule** , pp. 40-1]

Early May saw _"the shooting of protesting housewives and workers in the
suburb of Kolpino"_ , the _"arbitrary arrest and abuse of workers"_ in
Sestroretsk, the _"closure of newspapers and arrests of individuals who
protested the Kolpino and Sestroretsk events"_ and _"the resumption of labour
unrest and conflict with authorities in other Petrograd factories."_ This was
no isolated event, as _"violent incidents against hungry workers and their
family demanding bread occurred with increasing regularity."_ [Alexander
Rabinowitch, **The Bolsheviks in Power** , pp. 229-30] The shooting at Kolpino
_"triggered a massive wave of indignation . . . Work temporarily stopped at a
number of plants."_ In Moscow, Tula, Kolomna, Nizhnii-Novoprod, Rybinsk, Orel,
Tver' and elsewhere _"workers gathered to issue new protests."_ In Petrograd,
_"textile workers went on strike for increased food rations and a wave of
demonstrations spread in response to still more Bolshevik arrests."_ This
movement was the _"first major wave of labour protest"_ against the regime,
with _"protests against some form of Bolshevik repression"_ being common.
[William Rosenberg, **Russian Labor and Bolshevik Power** , pp. 123-4]

While the Kolpino incident _"was hardly the first of its kind, it triggered a
massive wave of indignation . . . Work temporarily stopped at a number of
plants."_ Between Kolpino and early July, more than seventy incidents occurred
in Petrograd, including strikes, demonstrations and anti-Bolshevik meetings.
Many of these meetings _"were protests against some form of Bolshevik
repression: shootings, incidents of 'terroristic activities,' and arrests."_
In some forty incidents _"worker's protests focused on these issues, and the
data surely understate the actual number by a wide margin. There were as well
some eighteen separate strikes or some other work stoppages with an explicitly
anti-Bolshevik character."_ [Rosenberg, **Op. Cit.** , pp. 123-4] Then, _"[a]t
the very end of May and the beginning of June, when a wave of strikes to
protest at bread shortages broke out in the Nevskii district, a majority of
Assembly delegates . . . resolved to call on striking Nevskii district workers
to return to work and continue preparation for a general city-wide strike."_
[Rabinowitch, **Op. Cit.** , p. 42] Unfortunately, for the Assembly,
postponing the strikes until later, until a "better time", rather than
encouraging them gave the authorities time to prepare.

_"At the end of May and beginning of June, a wave of strikes to protest the
lack of bread swept Nivskii district factories"_ and _"strikes followed by
bloody clashes between workers and Soviet authorities had erupted in scattered
parts of central Russia."_ In Petrograd, things came to a head during and
after the soviet elections in June. On June 21, a general meeting of Obukhov
workers _"seized control of the plant"_ and the next day the assembled workers
_"resolved to demand that the EAD should declare political strikes . . . to
protest the political repression of workers."_ Orders were issued by the
authorities _"to shut down Obukhov plant"_ and _"the neighbourhood surrounding
the plant was placed under martial law."_ [Rabinowitch, **The Bolsheviks in
Power** , p. 231 and pp. 246-7] So faced with workers collective action, the
_"Bolsheviks responded by 'invading' the whole Nevskii district with troops
and shutting down Obukhov completely. Meetings everywhere were forbidden."_
However _"workers were not so readily pacified. In scores of additional
factories and shops protests mounted and rapidly spread along the railways."_
At the June 26th _"extraordinary session"_ of the Conference a general strike
was declared for July 2nd. The Bolshevik authorities acted quickly: _"Any sign
of sympathy for the strike was declared a criminal act. More arrests were
made. In Moscow, Bolsheviks raided the Aleksandrovsk railroad shops, not
without bloodshed. Dissidence spread."_ On July 1st, _"machine guns were set
up at main points throughout the Petrograd and Moscow railroad junctions, and
elsewhere in both cities as well. Controls were tightened in factories.
Meetings were forcefully dispersed."_ [Rosenberg, **Op. Cit.** , p. 127]
Unsurprisingly, _"as a result of extreme government intimidation, the response
to the Assembly's strike call on 2 July was negligible."_ [Rabinowitch,
**Early Disenchantment with Bolshevik Rule** , p. 42] This repression was not
trivial:

> _"Among other things, all newspapers were forced to print on their front
> pages Petrograd soviet resolutions condemning the Assembly as part of the
> domestic and foreign counter-revolution. Factories participating in the
> strike were warned that they would be shut down and individual strikers were
> threatened with the loss of work -- threats that were subsequently made
> good. Printing plants suspected of opposition sympathies were sealed, the
> offices of hostile trade unions were raided, martial law declared on rail
> lines, and armed strike-breaking patrols with authority to take whatever
> action was necessary to prevent work stoppages were formed and put on
> 24-hour duty at key points throughout Petrograd."_ [ **Op. Cit.** , p. 45]

Needless to say, _"the Petrograd authorities drew on the dubious mandate
provided by the stacked soviet elections to justify banning the Extraordinary
Assembly."_ [ **Op. Cit.** , p. 42] While the Bolsheviks had won around 50% of
workplace votes, they had gerrymandered the soviet making the election results
irrelevant. Faced with _"demands from below for the immediate re-election"_ of
the Soviet, before the long-postponed election took place the existing
Bolshevik-controlled Soviet confirmed new regulations _"to help offset
possible weaknesses"_ in their _"electoral strength in factories."_ The _"most
significant change in the makeup of the new soviet was that numerically
decisive representation was given to agencies in which the Bolsheviks had
overwhelming strength, among them the Petrograd Trade Union Council,
individual trade unions, factory committees in closed enterprises, district
soviets, and district non-party workers' conferences."_ This ensured that
_"[o]nly 260 of roughly 700 deputies in the new soviet were to be elected in
factories, which guaranteed a large Bolshevik majority in advance"_. In short,
the Bolsheviks _"contrived a majority"_ in the new Soviet long before gaining
127 of the 260 factory delegates and even these victories raised _"the nagging
question of how many Bolshevik deputies from factories were elected instead of
the opposition because of press restrictions, voter intimidation, vote fraud,
or the short duration of the campaign."_ Overall, then, the Bolshevik election
victory _"was highly suspect, even on the shop floor."_ [Alexander
Rabinowitch, **The Bolsheviks in Power** , pp. 248-252]

The fact the civil war had just started with the revolt of the Czech Legion at
the end of May also undoubtedly aided the Bolsheviks during this election, as
did the fact that the Mensheviks and Right-SRs had campaigned on a platform of
winning the soviet elections as the means of replacing soviet democracy by the
Constituent Assembly: many workers still viewed the soviets are **their**
organisations and aimed for a functioning soviet system rather than its end.
With their electoral "mandate," secured beforehand, the opposition fatally
weakened by its backward-looking perspective and the threat of counter-
revolution (albeit in the name of the Constituent Assembly rather than White
restoration), the Bolsheviks turned on the Conference, both locally and
nationally, and arrested its leading activists, so decapitating one of the few
independent working class organisations left in Russia. As Rabinowitch argues,
_"the Soviet authorities were profoundly worried by the threat posed by the
Assembly and fully aware if their growing isolation from workers (their only
real social base) . . . Petrograd Bolsheviks developed a siege mentality and a
corresponding disposition to consider any action -- from suppression of the
opposition press and manipulation of elections to terror even against workers
-- to be justified in the struggle to retain power until the start of the
imminent world revolution."_ [ **Early Disenchantment with Bolshevik Rule** ,
pp. 43-4]

In Moscow, workers also organised a Conference movement and _"[r]esentment
against the Bolsheviks was expressed through strikes and disturbances, which
the authorities treated as arising from supply difficulties, from 'lack of
consciousness,' and because of the 'criminal demagogy' of certain elements.
Lack of support for current Bolshevik practices was treated as the absence of
worker consciousness altogether, but the causes of the unrest was more
complicated. In 1917 political issues gradually came to be perceived through
the lens of party affiliation, but by mid-1918 party consciousness was
reversed and a general consciousness of workers' needs restored. By July 1918
the protest movement had lost its momentum in the face of severe repression
and was engulfed by the civil war."_ In the light of the fate of workers'
protest, the May 16th resolution by the Bogatyr' Chemical Plant calling (among
other things) for _"freedom of speech and meeting, and an end to the shooting
of citizens and workers"_ seems to the point. Unsurprisingly, _"[f]aced with
political opposition within the soviets and worker dissatisfaction in the
factories Bolshevik power increasingly came to reply on the party apparatus
itself."_ [Richard Sakwa, _"The Commune State in Moscow in 1918,"_ pp.
429-449, **Slavic Review** , vol. 46, no. 3/4, pp. 442-3, p. 442 and p. 443]
State repression also took place _"[i]n June 1918 [when] workers in Tula
protested a cut in rations by boycotting the local soviet. The regime declared
martial law and arrested the protestors. Strikes followed and were suppressed
by violence. In Sormovo, when a Menshevik-Social Revolutionary newspaper was
closed, 5,000 workers went on strike. Again firearms were used to break the
strike."_ Other techniques were used to break resistance. For example, the
regime often threatened rebellious factories with a lock out, which involved
numerous layouts, new rules of discipline, purges of workers' organisations
and the introduction of piece work. [Thomas F. Remington, **Building Socialism
in Bolshevik Russia** , p. 105 and p. 107] As discussed in [section
H.6.1](secH6.md#sech61), similar events happened in other cities with the
Bolsheviks disbanding soviets elected with non-Bolshevik majorities all across
Russia and suppressing the resulting working class protest.

Rather than the Civil War disrupting the relationship between the vanguard
party and the class it claimed to lead, it was in fact the Bolsheviks who did
so in face of rising working class dissent and disillusionment in the spring
of 1918. In fact, _"[b]y the early summer of 1918"_ there were _"widespread
anti-Bolshevik protests. Armed clashes occurred in the factory districts of
Petrograd and other industrial centres."_ and _"after the initial weeks of
'triumph' . . . Bolshevik labour relations after October"_ changed and _"soon
lead to open conflict, repression, and the consolidation of Bolshevik
dictatorship over the proletariat in place of proletarian dictatorship
itself."_ [Rosenberg, **Op. Cit.** , p. 107 and p. 117] Given this, the
outbreak of the civil war consolidated workers support for the Bolsheviks and
saved it from even more damaging workers' unrest. As Thomas F. Remington puts
it:

> _"At various times groups of workers rebelled against Bolshevik rule. But
> for the most part, forced to choose between 'their' regime and the unknown
> horrors of a White dictatorship, most willingly defended the Bolshevik
> cause. The effect of this dilemma may be seen in the periodic swings in the
> workers' political temper. When Soviet rule stood in peril, the war
> simulated a spirit of solidarity and spared the regime the defection of its
> proletarian base. During lulls in the fighting, strikes and demonstrations
> broke out."_ [ **Op. Cit.** , p. 101]

This cycle of resistance and repression was widespread. In July 1918, a
leading Bolshevik insisted _"that severe measures were needed to deal with
strikes"_ in Petrograd while in other cities _"harsher forms of repression"_
were used. For example, in Tula, in June 1918, the regime declared _"martial
law and arrested the protestors. Strikes followed and were suppressed by
violence"_. In Sormovo, 5,000 workers went on strike after a Menshevik-SR
paper was closed. Violence was _"used to break the strike."_ [Remington, **Op.
Cit.** , p. 105] It should also be noted that at the end of September, there
was a revolt by Baltic Fleet sailors demanding (as they did again in 1921) a
_"return to government by liberated, democratic soviets -- that is, 1917-type
soviets."_ The Left-SR controlled Kronstadt soviet had been disbanded and
replaced by a Bolshevik revolutionary committee in July 1918. [Rabinowitch,
**The Bolsheviks in Power** , p. 352 and p. 302]

This process of workers protest and state repression continued in 1919 and
subsequent years. It followed a cyclical pattern. There was a _"new outbreak
of strikes in March 1919 after the collapse of Germany and the Bolshevik re-
conquest of the Ukraine. The pattern of repression was also repeated. A strike
at a galosh factory in early 1919 was followed by the closing of the factory,
the firing of a number of workers, and the supervised re-election of its
factory committee. The Soviet garrison at Astrakhan mutinied after its bread
ration was cut. A strike among the city's workers followed in support. A
meeting of 10,000 Astrakhan workers was suddenly surrounded by loyal troops,
who fired on the crowd with machine guns and hand grenades, killing 2,000.
Another 2,000, taken prisoner, were subsequently executed. In Tula, when
strikes at the defence factories stopped production for five days, the
government responded by distributing more grain and arresting the strike
organisers . . . strikes at Putilov again broke out, at first related to the
food crisis . . . The government treated the strike as an act of counter-
revolution and responded with a substantial political purge and re-
organisation. An official investigation . . . concluded that many shop
committees were led by [Left] Social Revolutionaries . . . These committees
were abolished and management representatives were appointed in their stead."_
[Remington, **Op. Cit.** , pp. 109-10] In the Volga region, in March 1919
delegates to a conference of railroad workers _"protested the Cheka's arrest
of union members, which the delegates insisted further disrupted transport. It
certainly curbed the number of strikes."_ [Donald J. Raleigh, **Experiencing
Russia's Civil War** , p. 371]

The strikes in Petrograd centred around the Putilov shows the response of the
authorities to the "atomised" workers who were taking collective action. In
March 1919, _"fifteen factories struck together (roughly 35,000 workers were
involved) . . . workers at Putilov assembled and sent a delegation to the
works committee . . . and put forward a number of demands . . . On 12 March
Putilov stopped work. Its workers called to others to join them, and some of
them came out in a demonstration where they were fired upon by Cheka troops.
Strikes then broke out at fourteen other enterprises . . . On Sunday 16 March
an appeal was made to the Putilovtsy to return to normal working the following
day or . . . the sailors and soldiers would be brought in. After a poor
showing on the Monday, the sailor went in, and 120 workers were arrested; the
sailors remained until the 21st and by the 22nd normal work had been
resumed."_ In July strikes broke out again in response to the cancellation of
holidays which involved 25,000 workers in 31 strikes. [Mary McAuley, **Bread
and Justice** , pp. 251-253 and p. 254] In the Moscow area, while it is
_"impossible to say what proportion of workers were involved in the various
disturbances,"_ following the lull after the defeat of the workers' conference
movement in mid-1918 _"each wave of unrest was more powerful than the last,
culminating in the mass movement from late 1920."_ For example, at the end of
June 1919, _"a Moscow committee of defence (KOM) was formed to deal with the
rising tide of disturbances"_ The KOM _"concentrated emergency power in its
hands, overriding the Moscow Soviet, and demanding obedience from the
population. The disturbances died down under the pressure of repression."_
[Richard Sakwa, **Soviet Communists in Power** , p. 94 and pp. 94-5] In Tula
_"after strikes in the spring of 1919"_ local Menshevik party activists had
been arrested while Petrograd saw _"violent strikes"_ at around the same time.
[Jonathan Aves, **Workers Against Lenin** , p. 19 and p. 23]

Historian Vladimir Brovkin summarises the data he provides in his article
_"Workers' Unrest and the Bolshevik Response in 1919"_ (reproduced along with
data from other years in his book **Behind the Front Lines of the Civil War**
) as follows:

> _"Data on one strike in one city may be dismissed as incidental. When,
> however, evidence is available from various sources on simultaneous
> independent strikes in different cities and an overall picture begins to
> emerge . . . Workers' unrest took place in Russia's biggest and most
> important industrial centres: Moscow, Petrograd, Tver', Tula, Briansk, and
> Sormovo. Strikes affected the largest industries . . . Workers' demands
> reflected their grievances . . . The greatest diversity was in workers'
> explicitly political demands or expression of political opinion . . . all
> workers' resolutions demanded free and fair elections to the soviets . . .
> some workers . . . demanded the Constituent Assembly . . ._

> _"The strikes of 1919 . . . fill an important gap in the development of the
> popular movement between October 1917 and February 1921. On the one hand,
> they should be seen as antecedents of similar strikes in February 1921,
> which forced the Communists to abandon war communism. In the capitals,
> workers, just as the Kronstadt sailors had, still wanted fairly elected
> soviets and not a party dictatorship. On the other hand, the strikes
> continued the protests that had began in the summer of 1918. The variety of
> behavioural patterns displayed during the strikes points to a profound
> continuity. . ._

> _"In all known cases the Bolsheviks' initial response to strikes was to ban
> public meetings and rallies . . . In several cities . . . the authorities
> confiscated strikers' food rations in order to suppress the strike. In at
> least five cities . . . the Bolsheviks occupied the striking plant and
> dismissed the strikers en masse . . . In all known cases the Bolsheviks
> arrested strikers . . . In Petrograd, Briansk, and Astrakhan' the Bolsheviks
> executed striking workers."_ [ _"Workers' Unrest and the Bolshevik Response
> in 1919"_ , **Slavic Review** , vol. 49, no. 3, pp. 370-2]

Nor was this collective struggle stop in 1919 -- _"strike action remained
endemic in the first nine months of 1920"_ and _"in the first six months of
1920 strikes had occurred in seventy-seven per cent of middle-sized and large
works."_ For the Petrograd province, soviet figures state that in 1919 there
were 52 strikes with 65,625 participants and in 1920 73 strikes with 85,645,
both high figures as according to one set of figures, which are by no means
the lowest, there were 109,100 workers there. Strikes in 1920 _"were
frequently a direct protest against the intensification of War Communist
labour policies, the militarisation of labour, the implementation of one-man
management and the struggle against absenteeism, as well as food supply
difficulties. The Communist Party press carried numerous articles attacking
the slogan of 'free labour.'"_ Overall, _"the geographical extent of the
February-March strike wave is impressive"_ and the _"harsh discipline that
went with labour militarisation led to an increase in industrial unrest in
1920."_ [Aves, **Op. Cit.** , p. 69, p. 74 and p. 80]

The spring of 1920 _"saw discontent on the railways all over the country."_
This continued throughout the year. In Petrograd, the Aleksandrovskii
locomotive building works _"had seen strikes in 1918 and 1919"_ and in August
1920 it again stopped work. Workers had sent three representatives to the
works commissar, who had them arrested. Three days later, work stopped and the
strikers demanded their release. The authorities placed a guard of 70 sailors
outside the enterprise to lock the workers out. The Cheka then arrested the
workers' soviet delegates, who were from the SR (Minority) list, along with
thirty workers and then the _"opportunity was taken to carry out a general
round-up, and arrests were made"_ at three other works. After the arrests, _"a
meeting was held to elect new soviet delegates but the workers refused to co-
operate and a further 150 were arrested and exiled to Murmansk or transferred
to other workshops."_ The enormous Briansk works _"experienced two major
strikes in 1920"_ , and second one saw the introduction of martial law on both
the works and the settlement it was situated in. In Moscow, a strike in May by
printers resulted in their works _"closed and the strikers sent to
concentration camps after an attempt to start sympathy action failed."_ [Aves,
**Op. Cit.** , p. 44, pp. 45-7, pp. 48-9 and p. 59]

In January 1920, a strike followed a mass meeting at a railway repair shop in
Moscow. Attempts to spread were foiled by arrests. The workshop was closed,
depriving workers of their rations and 103 workers of the 1,600 employed were
imprisoned. _"In late March 1920 there were strikes in some factories"_ in
Moscow and _"[a]t the height of the Polish war the protests and strikes,
usually provoked by economic issues but not restricted to them, became
particularly frequent . . . The assault on non-Bolshevik trade unionism
launched at this time was probably associated with the wave of unrest since
there was a clear danger that they would provide a focus for opposition."_
[Sakwa, **Op. Cit.** , p. 95] The _"largest strike in Moscow in the summer of
1920"_ was by tram workers over the equalisation of rations. It began on
August 12th, when one tram depot went on strike, quickly followed by others
while workers _"in other industries joined in to."_ The tram workers _"stayed
out a further two days before being driven back by arrests and threats of mass
sackings."_ In the textile manufacturing towns around Moscow _"there were
large-scale strikes"_ in November 1920, with 1000 workers striking for four
days in one district and a strike of 500 mill workers saw 3,000 workers from
another mill joining in. [Simon Pirani, **The Russian Revolution in Retreat,
1920-24** , p. 32 and p. 43]

Strikes occurred in other places, such as Tula were the workforce _"contained
a high proportion of skilled, long-standing, hereditary workers."_ An _"all-
out strike"_ began at the start of June and on 8 June the local newspaper
published a declaration from the Tula soviet threatening the strikers with
_"the most repressive measures, including the application of the highest
measure of punishment"_. The following day the city was declared to be under a
_"state of siege"_ by the local military authorities. The strikers lost ration
cards and by 11 June there was a return to work. Twenty-three workers were
sentenced to a forced labour camp until the end of the war. However, the
_"combined impact of these measures did not prevent further unrest and the
workers put forward new demands."_ On 19 June, the soviet approved _"a
programme for the suppression of counter-revolution"_ and _"the transfer of
Tula to the position of an armed camp."_ The Tula strike _"highlights the way
in which workers, particularly skilled workers who were products of long-
standing shop-floor subcultures and hierarchies, retained the capability as
well as the will to defend their interests."_ [Aves, **Op. Cit.** , p. 50-55]
Saratov also saw a wave of factory occupations break out in June and mill
workers went out in July while in August, strikes and walkouts occurred in its
mills and other factories and these _"prompted a spate of arrests and
repression."_ In September railroad workers went out on strike, with arrests
making _"the situation worse, forcing the administration to accept the
workers' demands."_ [Raleigh, **Op. Cit.** , p. 375]

While strike activity _"was most common in Petrograd, where there had been 2.5
strikers for every workman,"_ the figure for Moscow was 1.75 and 1.5 in Kazan.
In early March _"a wave of strikes hit the Volga town of Samara"_ when a
strike by printers in spread to other enterprises. _"Strike action in Moscow
did not just include traditionally militant male metal workers."_ Textile
workers, tram workers and printers all took strike action. [Aves, **Op. Cit.**
, p. 69, p. 72 and pp. 77-8]

The end of the civil war did not see the end of working class protest. Quite
the reverse, for _"[b]y the beginning of 1921 a revolutionary situation with
workers in the vanguard had emerged in Soviet Russia"_ with _"the simultaneous
outbreak of strikes in Petrograd and Moscow and in other industrial regions."_
In February and March 1921, _"industrial unrest broke out in a nation-wide
wave of discontent or **volynka**. General strikes, or very widespread
unrest"_ hit all but one of the country's major industrial regions and
_"workers protest consisted not just of strikes but also of factory
occupations, 'Italian strikes', demonstrations, mass meetings, the beating up
of communists and so on."_ Faced with this massive strike wave, the Bolsheviks
did what many ruling elites do: they called it something else. Rather than
admit it was a strike, they _"usually employed the word **volynka** , which
means only a 'go-slow'"_. [Aves, **Op. Cit.** , p. 3, p. 109, p. 112 and pp.
111-2]

In Petrograd in the beginning of February _"strikes were becoming an everyday
occurrence"_ and by _"the third week of February the situation rapidly
deteriorated."_ The city was rocked by strikes, meetings and demonstrations.
In response to the general strike the Bolsheviks replied with a _"military
clamp-down, mass arrests and other coercive measures, such as the closure of
enterprises, the purging of the workforce and stopping of rations which
accompanied them."_ [Aves, **Op. Cit.** , p. 113 and p. 120] As Paul Avrich
recounts, in Petrograd these _"street demonstrations were heralded by a rash
of protest meetings"_ in workplaces. On the 24th of February, the day after a
workplace meeting, the Trubochny factory workforce downed tools and walked out
the factory. Additional workers from nearby factories joined in. The crowd of
2,000 was dispersed by armed military cadets. The next day, the Trubochny
workers again took to the streets and visited other workplaces, bringing them
out on strike too. In the face of a near general strike, a three-man Defence
Committee was formed. Zinoviev _"proclaimed martial law"_ and _"[o]vernight
Petrograd became an armed camp."_ Strikers were locked out and the
_"application of military force and the widespread arrests, not to speak of
the tireless propaganda waged by the authorities"_ was _"indispensable in
restoring order"_ (as were economic concessions). [ **Kronstadt 1921** , pp.
37-8, p. 39, pp. 46-7 and p. 50] Thus _"massive city-wide protest spread
through Petrograd . . . Strikes and demonstrations spread. The regime
responded as it had done in the past, with lock-outs, mass arrests, heavy show
of force -- and concessions."_ [Remington, **Op. Cit.** , p. 111] As we
discuss in ["What was the Kronstadt Rebellion?"](append42.md), these strikes
produced the Kronstadt revolt while the Bolshevik repression ensured the
Petrograd workers did not act with the sailors.

A similar process of workers revolt and state repression occurred in Moscow at
the same time. There _"industrial unrest"_ also _"turned into open
confrontation and protest spilled on to the streets"_ , starting with a _"wave
of strikes that had its centre in the heart of industrial Moscow."_ Meetings
were held, followed by demonstrations and strikes which spread to other
districts over the next few days. Workers demanded that elections to the
soviets be held. Striking railway workers sent emissaries along the railway to
spread the strike and soon strikes were _"also spreading outside Moscow city
itself into the surrounding provinces"_. In response, _"Moscow and Moscow
province were put under martial law."_ [Aves, **Op. Cit.** , p. 130, p. 138
and pp. 139-144] This strike wave started when _"[m]eetings in factories and
plants gathered and criticised government policies, beginning with supply and
developing into general political criticism."_ As was typical, the _"first
response of the civil authorities to the disturbances was increased
repression"_ although as _"the number of striking factories increased some
concessions were introduced."_ Military units called in against striking
workers _"refused to open fire, and they were replaced by the armed communist
detachments"_ which did. _"That evening mass protest meetings were held . . .
The following day several factories went on strike"_ and troops were
_"disarmed and locked in as a precaution"_ by the government against possible
fraternising. February 23rd saw a 10,000 strong street demonstration and
_"Moscow was placed under martial law with a 24-hour watch on factories by the
communist detachments and trustworthy army units."_ The disturbances were
accompanied by factory occupations and on the 1st of March the soviet called
on workers _"not to go on strike."_ However, _"wide-scale arrests deprived the
movement of its leadership."_ March 5th saw disturbances at the Bromlei works,
_"resulting in the now customary arrest of workers. A general meeting at the
plant on 25 March called for new elections to the Moscow Soviet. The
management dispersed the meeting but the workers called on other plants to
support the calls for new elections. As usual, the ringleaders were
arrested."_ [Sakwa, **Op. Cit.** , pp. 242-3, p. 245 and p. 246] As in
Petrograd, the mixture of (economic) concessions and coercion eventually broke
the will of the strikers.

The events at the Bromlei works were significant in that the March 25th a mass
meeting passed an anarchist and Left-SR initiated resolution supporting the
Kronstadt rebels. The party _"responded by having them sacked en masse"_. The
workers _"demonstrated through"_ their district _"and inspired some brief
solidarity strikes."_ Over 3000 workers joined the strikes and about 1000 of
these joined the flying picket (managers at one print shop locked their
workers in to stop them joining the protest). While the party was willing to
negotiate economic issues, _"it had no wish to discuss politics with workers"_
and so arrested those who initiated the resolution, sacked the rest of the
workforce and selectively re-employed them. Two more strikes were conducted
_"to defend the political activists in their midst"_ and two mass meetings
demanded the release of arrested ones. Workers also struck on supply issues in
May, July and August. [Pirani, **Op. Cit.** , pp. 83-4]

In Saratov, the strike started on March 3rd when railroad shop workers did not
return to their benches and instead rallied to discuss an anticipated further
reduction in food rations. The _"railroad workers debated resolutions recently
carried by the Moscow proletariat . . . The next day the strike spread to the
metallurgical plants and to most other large factories, as Saratov workers
elected representatives to an independent commission charged with evaluating
the functioning of all economic organs. When it convened, the body called for
the re-election of the soviets and immediate release of political prisoners."_
During the next two days, _"the assemblies held at factories to elect
delegates to the commission bitterly denounced the Communists."_ The _"unrest
spilled over into Pokrovsk."_ The commission of 270 had less than ten
Communists and _"demanded the freeing of political prisoners, new elections to
the soviets and to all labour organisations, independent unions, and freedom
of speech, the press, and assembly."_ While the ration cut _"represent[ed] the
catalyst, but not the cause, of the labour unrest"_ and _"the turmoil touched
all strata of the proletariat, male and female alike, the initiative for the
disturbances came from the skilled stratum that the Communists normally deemed
the most conscious."_ The Communists _"resolved to shut down the commission
before it could issue a public statement"_ and as they _"expected workers to
protest the dissolution of their elected representatives"_ , they also _"set
up a Provincial Revolutionary Committee . . . which introduced martial law
both in the city and the garrison. It arrested the ringleaders of the workers'
movement . . .the police crackdown depressed the workers' movement and the
activities of the rival socialist parties."_ The near general strike was
broken by a _"wave of repression"_ but _"railroad workers and dockworkers and
some printers refused to resume work."_ The Cheka sentenced 219 people to
death. [Donald J. Raleigh, **Op. Cit.** , p. 379 and pp. 387-9]

A similar _"little Kronstadt"_ broke out in the Ukrainian town of
Ekaterinoslavl at the end of May. The workers there _"clearly had strong
traditions of organisation"_ and elected a strike committee of fifteen which
_"put out a series of political ultimatums that were very similar in content
to the demands of the Kronstadt rebels."_ On June 1st, _"by a pre-arranged
signal"_ workers went on strike throughout the town, with workers joining a
meeting of the railway workers. The local Communist Party leader was
instructed _"to put down the rebellion without mercy . . . Use Budennyi's
[Red] cavalry."_ The strikers prepared a train and its driver instructed to
spread the strike throughout the network. Telegraph operators were told to
send messages throughout the Soviet Republic calling for _"free soviets"_ and
soon an area up to fifty miles around the town was affected. The Communists
used the Cheka to crush the movement, carrying out mass arrests and shooting
15 workers (and dumping their bodies in the River Dnepr). [Aves, **Op. Cit.**
, pp. 171-3] It must be noted that the call for _"free soviets"_ had
previously been raised by the anarchist-influenced Makhnovist movement.

Thus strike action was a constant feature of Bolshevik Russia during the civil
war. Rather than being an "atomised" mass, the workers repeatedly organised
themselves, made their demands and took collective action to achieve them. In
response, the Bolshevik regime used state repression to break this collective
activity: martial law, lock-outs, mass arrests, withholding rations and
shootings. As such, **if** the rise of Stalinism can, as modern-day Leninists
argue, be explained by the "atomisation" of the working class during the civil
war then the Bolshevik regime and its repression should be credited with
ensuring this happened.

Unsurprisingly, as Emma Goldman recounted, _"counter-revolutionists, and
bandits in Soviet penal institutions were a negligible minority. The bulk of
the prison population consisted of social heretics who were guilty of the
cardinal sin against the Communist Church. For no offence was considered more
heinous than to entertain political views in opposition to the party, and to
voice any protest against the evils and crimes of Bolshevism. I found that by
far the greatest number were political prisoners, as well as peasants and
workers guilty of demanding better treatment and conditions."_ [ **Living My
Life** , vol. 2, p. 873] Indeed, of the 17,000 camp detainees on whom
statistical information was available on 1 November 1920, peasants and workers
constituted the largest groups, at 39% and 34% respectively. Similarly, of the
40,913 prisoners held in December 1921 (of whom 44% had been committed by the
Cheka) nearly 84% were illiterate or minimally educated, clearly, therefore,
either peasants or workers. [George Leggett, **The Cheka: Lenin's Political
Police** , p. 178] Other rebel toilers were not so lucky:

> _"It is not possible to estimate with any degree of accuracy how many
> workers were shot by the Cheka during 1918-1921 for participation in labour
> protest. However, an examination of individual cases suggests that shootings
> were employed to inspire terror and were not simply used in the occasional
> extreme case."_ [Aves, **Op. Cit.** , p. 35]

After Kronstadt and the various strike waves and protests of that time,
Bolshevik repression of labour unrest continued. The economic crisis of 1921
which accompanied the introduction of the NEP saw unemployment rise while
workplaces _"that had been prominent in unrest were particularly hit by . . .
purges . . . The effect on the willingness of workers to support opposition
parties was predictable."_ Yet _"[d]espite the heavy toll of redundancies, the
ability to organise strikes did not disappear. Strike statistics for 1921
continue to provide only a very rough indicator of the true scale of
industrial unrest and appear not to include the first half of the year."_
[Aves, **Op. Cit.** , p. 182-183] For example, in early March, _"long
strikes"_ hit the textile towns around Moscow. At the Glukhovskaia mills 5000
workers struck for 5 days, 1000 at a nearby factory for 2 days and 4000 at the
Voskresenskaia mills for 6 days. In May, 1921, workers in the city of Moscow
reacted to supply problems _"with a wave of strikes. Party officials reckoned
that in a 24-day period in May there were stoppages at 66 large enterprises."_
These included a sit-down strike at one of Moscow's largest plants, while
_"workers at engineering factories in Krasnopresnia followed suit, and Cheka
agents reported 'dissent, culminating in strikes and occupation' in Bauman."_
August 1922 saw 19,000 workers strike in textile mills in Moscow region for
several days. Tram workers also struck that year, while teachers _"organised
strikes and mass meetings"_. Workers usually elected delegates to negotiate
with their trade unions as well as their bosses as both were Communist Party
members. Strike organisers, needless to say, were sacked. [Pirani, **Op.
Cit.** , p. 82, pp. 111-2 and p. 157]

The spring of 1922 likewise saw Soviet Russia _"hit by a new strike wave"_ and
the strikes _"continued to reflect enterprise traditions."_ That year saw 538
strikes with 197,022 participants recorded. [Aves, **Op. Cit.** , p. 183 and
p. 184] The following year saw more stoppages and in _"July 1923 more than 100
enterprises employing a total of some 50,000 people were on strike. In August
figures totalled some 140 enterprises and 80,00 workers. In September and
November the strike wave continued unabated."_ As in the civil war, the
managers shut down plants, fired the workers and rehired them on an individual
basis. In this way, trouble-makers were dismissed and "order" restored. The
_"pattern of workers' action and Bolshevik reaction played itself out
frequently in dozens of other strikes. The Bolsheviks acted with the explicit
purpose of rooting out the possibility of further protest. They tried to
condition workers that labour protest was futile."_ The GPU (the renamed
Cheka) _"used force to disperse workers demonstrating with the arrested strike
leaders."_ [Vladimir Brovkin, **Russia After Lenin** , p. 174, pp. 174-5 and
p. 175]

In Moscow, _"[b]etween 1921 and 1926, all branches of industry and transport .
. . experienced wildcat strikes or other spontaneous labour disturbances.
Strike waves peaked in the winter of 1920-21 . . . and in the summer and fall
of 1922 and 1923 . . . during July-December 1922, for example, 65 strikes and
209 other industrial disturbances were recorded in Moscow's state
enterprises."_ Metalworkers were arguably the most active sector at this time
while _"a number of large strikes"_ took place in the textile industry (where
_"strikes were sometimes co-ordinated by spontaneously organised strike
committees or 'parallel' factory committees"_ ). And in spite of repression,
_"politicisation continued to characterise many labour struggles"_ and, as
before, _"spontaneous labour activism hindered not only the party's economic
program but also the political and social stabilisation of the factories."_
[John B. Hatch, **Labour Conflict in Moscow, 1921-1925** , p. 62, p. 63, p.
65, pp. 66-7 and p. 67]

We even find one of the leading proponents of "atomised" excuse, neo-
Trotskyist Tony Cliff, noting against Stalinism that _"in 1922, 192,000
workers went on strike in state-owned enterprises; in 1923 the number was
165,000; in 1924, 43,000; in 1925, 34,000; in 1926, 32,900; in 1927, 20,100;
in the first half of 1928, 8,900. In 1922 the number of workers involved in
labour conflicts was three and a half million, and in 1923, 1,592,800."_ He
did not ponder how a class he claimed elsewhere had become atomised,
individualised, disintegrated and declassed could take such widescale
collective industrial action -- nor did he mention the use of State repression
under Lenin against such action, instead falsely asserting that before the
rise of Stalinism it _"was taken for granted that strikes were not to be
suppressed by the state."_ [ **State Capitalism in Russia** , p. 28]
Ultimately, if these strikes between 1922 and 1924 showed a social basis
existed to combat the rising Stalinist bureaucracy, surely the strikes between
1918 and 1921 likewise show a social basis existed to combat the existing
Leninist bureaucracy?

As well as repression of strike waves across the country, the end of the civil
war also saw the Bolsheviks finally destroy what was left of non-Bolshevik
trade unionism. In Moscow, this took place against fierce resistance of the
union members. As one historian concludes:

> _"Reflecting on the determined struggle mounted by printers, bakers and
> chemical workers in Moscow during 1920-1, in spite of appalling economic
> conditions, being represented by organisations weakened by constant
> repression . . . to retain their independent labour organisations it is
> difficult not to feel that the social basis for a political alternative
> existed."_ [Jonathan Aves, _"The Demise of Non-Bolshevik Trade Unionism in
> Moscow: 1920-21"_ , pp. 101- 33, **Revolutionary Russia** , vol. 2, no. 1,
> p. 130]

The also Bolsheviks dispersed provincial trade unions conferences in Vologda
and Vitebsk in 1921 _"because they had anti-communist majorities."_ [Aves,
**Workers Against Lenin** , p. 176] At the All-Russian Congress of
Metalworkers' Union in May, the delegates voted down the party-list of
recommended candidates for union leadership. The Central Committee of the
Party _"disregarded every one of the votes and appointed a Metalworkers'
Committee of its own. So much for 'elected and revocable delegates'. Elected
by the union rank and file and revocable by the Party leadership!"_ [Brinton,
**The Bolsheviks and Workers Control** , p. 83] Fear of arrest (and worse!)
was widespread and so, for example, a Moscow Metalworkers' Union conference in
early February 1921 saw the first speakers calling _"for the personal safety
of the delegates to be guaranteed"_ before criticisms would be aired. [Sakwa,
**Op. Cit.** , p. 244] Such an atmosphere is hardly supportive for the
encouragement of collective organisation!

Other forms of workers' organisation were also destroyed. For example, in his
1920 diatribe against Left-wing Communism, Lenin pointed to _"non-Party
workers' and peasants' conferences"_ and Soviet Congresses as means by which
the party secured its rule. Yet, **if** the congresses of soviets were _"
**democratic** institutions, the like of which even the best democratic
republics of the bourgeois have never known"_, the Bolsheviks would have no
need to _"support, develop and extend"_ non-Party conferences _"to be able to
observe the temper of the masses, come closer to them, meet their
requirements, promote the best among them to state posts"._ [ **The Lenin
Anthology** , p. 573] How the Bolsheviks met _"their requirements"_ is
extremely significant - they disbanded them, just as they had with soviets
with non-Bolshevik majorities in 1918. This was because _"[d]uring the
disturbances"_ of late 1920, _"they provided an effective platform for
criticism of Bolshevik policies."_ Their frequency was decreased and they
_"were discontinued soon afterward."_ [Sakwa, **Op. Cit.** , p. 203]

In the soviets themselves, workers turned to non-partyism, with non-party
groups winning majorities in soviet delegates from industrial workers'
constituencies in many places. This was the case in Moscow, where Bolshevik
support among _"industrial workers collapsed"_ in favour of non-party people.
Due to support among the state bureaucracy and the usual packing of the soviet
with representatives from Bolshevik controlled organisations, the party had,
in spite of this, a massive majority. Thus the Moscow soviet elections of
April-May 1921 _"provided an opportunity to revive working-class
participation. The Bolsheviks turned it down."_ [Pirani, **Op. Cit.** , pp.
97-100 and p. 23] Indeed, one Moscow Communist leader stated that these soviet
elections had seen _"a high level of activity by the masses and a striving to
be in power themselves."_ [quoted by Pirani, **Op. Cit.** , p. 101]

In short, an _"examination of industrial unrest after the Bolshevik seizure of
power . . . shows that the Revolution had brought to the surface resilient
traditions of organisation in society and had released tremendous forces in
favour of greater popular participation . . . The survival of the popular
movement through the political repression and economic devastation of the
Civil War testifies to its strength."_ [Aves, **Op. Cit.** , p. 186] The idea
that the Russian working class was incapable of collective struggle is hard to
defend given this series of struggles (and state repression). The class
struggle in Bolshevik Russia did not stop, it continued except the ruling
class had changed. All the popular energy and organisation this expressed,
which could have been used to combat the problems facing the revolution and
create the foundations of a genuine socialist society, were wasted in fighting
the Bolshevik regime. Ultimately, the _"sustained, though ultimately futile,
attempts to revive an autonomous workers' movement, especially in mid-1918 and
from late 1920, failed owing to repression."_ [Sakwa, **Op. Cit.** , p. 269]
Another historian notes that _"immediately after the civil war"_ there was _"a
revival of working class collective action that culminated in February-March
1921 in a widespread strike movement and the revolt at the Kronstadt naval
base."_ As such, the position expounded by Rees and other Leninists _"is so
one-sided as to be misleading."_ [Pirani, **Op. Cit.** , p. 7 and p. 23]

So, looking at the Moscow Tram strike of August 1920 as an example, in
addition to economic demands, strikers called for a general meeting of all
depots. This was _"significant: here the workers' movement was trying to get
on the first rung of the ladder of organisation, and being knocked off by the
Bolsheviks."_ The party _"responded to the strike in such a way as to
undermine workers' organisation and consciousness"_ and _"throttl[ed]
independent action"_ by _"repression of the strike by means reminiscent of
tsarism."_ The Bolshevik's _"dismissive rejection"_ of the demand for a city-
wide meeting _"spoke volumes about their hostility to the development of the
workers' movement, and landed a blow at the type of collective democracy that
might have better able to confront supply problems."_ This, along with the
other strikes that took place, showed that _"the workers' movement in Moscow
was, despite its numerical weakness and the burdens of civil war, engaged with
political as well as industrial issues . . . the working class was far from
non-existent, and when, in 1921, it began to resuscitate soviet democracy, the
party's decision to make the Moscow soviet its 'creature' was not effect but
cause."_ [Pirani, **Op. Cit.** , p. 32, p. 33, p. 37 and p. 23]

When such things happen, we can conclude that Bolshevik desire to remain in
power had a significant impact on whether workers were able to exercise
collective power or not. As Pirani concludes:

> _"one of the most important choices the Bolsheviks made . . . was to turn
> their backs on forms of collective, participatory democracy that workers
> briefly attempted to revive [after the civil war] . . . [Available evidence]
> challenges the notion . . . that political power was forced on the
> Bolsheviks because the working class was so weakened by the civil war that
> it was incapable of wielding it. In reality, non-party workers were willing
> and able to participate in political processes, but in the Moscow soviet and
> elsewhere, were pushed out of them by the Bolsheviks. The party's
> vanguardism, i.e. its conviction that it had the right, and the duty, to
> make political decisions on the workers' behalf, was now reinforced by its
> control of the state apparatus. The working class was politically
> expropriated: power was progressively concentrated in the party,
> specifically in the party elite."_ [ **Op. Cit.** , p. 4]

Given this collective rebellion all across the industrial centres of Russia
before, during and after the Civil War, it hard to take seriously claims that
Bolshevik authoritarianism was the product of an "atomisation" or "declassing"
of the working class or that it had ceased to exist in any meaningful sense.
Clearly it existed and was capable of collective action and organisation --
until it was repressed by the Bolsheviks and even then it keep returning. This
implies that a key factor in rise of Bolshevik authoritarianism was political
-- the simple fact that the workers would not vote Bolshevik in free soviet
and union elections and so they were not allowed to. As one Soviet Historian
put it, _"taking the account of the mood of the workers, the demand for free
elections to the soviets [raised in early 1921] meant the implementation in
practice of the infamous slogan of soviets without communists,"_ although
there is little evidence that the strikers actually raised that _"infamous"_
slogan. [quoted by Aves, **Op. Cit.** , p. 123] It must also be noted that
Bolshevik orthodoxy at the time stressed, and had done since at least early
1919, the necessity of Party dictatorship **over** the workers (see [section
H.1.2](secH1.md#sech12) for details).

Nor can it be said that this struggle can be blamed on "declassed" elements
within the working class itself. In her study of this question, Diane Koenker
notes that 90% of the change in the number of workers in Moscow _"is accounted
for by men. Working women did not leave the city,"_ their numbers dropping
from 90,000 in 1918 to 80,000 in 1920. Why these 80,000 women workers should
be denied a say in their own revolution is not clear, given the arguments of
the pro-Bolshevik left. After all, the same workers remained in roughly the
same numbers. Looking at the male worker population, their numbers fell from
215,000 to 124,000 during the same period. However, _"the skilled workers
whose class consciousness and revolutionary zeal had helped win the October
revolution did not entirely disappear, and the women who remained were likely
to be family members of these veterans of 1917."_ It was _"the loss of young
activists rather than all skilled and class conscious urban workers that
caused the level of Bolshevik support to decline during the civil war."_
Indeed _"the workers who remained in the city were among the most urbanised
elements."_ In summary, _"the deurbanisation of those years represented a
change in quantity but not entirely in quality in the cities. The proletariat
declined in the city, but it did not wither away . . . a core of the city's
working class remained."_ [ **Op. Cit.** , p. 440, p. 442, p. 447 and p. 449]
As Russian anarchist Ida Mett argued decades before in relation to the strikes
in early 1921 that inspired the Kronstadt sailor rebellion:

> _"The population was drifting away from the capital. All who had relatives
> in the country had rejoined them. The authentic proletariat remained till
> the end, having the most slender connections with the countryside._

> _"This fact must be emphasised, in order to nail the official lies seeking
> to attribute the Petrograd strikes that were soon to break out to peasant
> elements, 'insufficiently steeled in proletarian ideas.' The real situation
> was the very opposite. A few workers were seeking refuge in the countryside.
> The bulk remained. There was certainly no exodus of peasants into the
> starving towns! . . . It was the famous Petrograd proletariat, the
> proletariat which had played such a leading role in both previous
> revolutions, that was finally to resort to the classical weapon of the class
> struggle: the strike."_ [ **The Kronstadt Uprising** , p. 36]

In terms of struggle, links between the events in 1917 and those during the
civil war also exist. For example Jonathan Aves writes that there were
_"distinct elements of continuity between the industrial unrest in 1920 and
1917. This is not surprising since the form of industrial unrest in 1920, as
in the pre-revolutionary period and in 1917, was closely bound up with
enterprise traditions and shop-floor sub-cultures. The size of the Russian
industrial workforce had declined steeply during the Civil War but where
enterprises stayed open . . . their traditions of industrial unrest in 1920
shows that such sub-cultures were still capable of providing the leaders and
shared values on which resistance to labour policies based on coercion and
Communist Party enthusiasm could be organised. As might be anticipated, the
leaders of unrest were often to be found amongst the skilled male workers who
enjoyed positions of authority in the informal shop-floor hierarchies."_
Moreover, _"despite intense repression, small groups of politicised activists
were also important in initiating protest and some enterprises developed
traditions of opposition to the communists."_ Looking at the strike wave of
early 1921 in Petrograd, the _"strongest reason for accepting the idea that it
was established workers who were behind the **volynka** [i.e. the strike wave]
is the form and course of protest. Traditions of protest reaching back through
the spring of 1918 to 1917 and beyond were an important factor in the
organisation of the **volynka.** . . . There was also a degree of organisation
. . . which belies the impression of a spontaneous outburst."_ [ **Op. Cit.**
, p. 39 and p. 126]

Clearly, then, the idea that the Russian working class was atomised or
declassed cannot be defended given this series of struggles. As noted, the
notion that the workers were "declassed" was used to justify state repression
of collective working class struggle and defend the necessity of party
dictatorship in face of it. Emma Goldman was right to later note how the
_"thought oppressed me that what [the Bolsheviks] called 'defence of the
Revolution' was really only the defence of [their] party in power."_ [ **My
Disillusionment in Russia** , p. 57] The class struggle in Bolshevik Russia
did not stop, it continued except the ruling class had changed from
bourgeoisie to Bolshevik dictatorship:

> _"There is another objection to my criticism on the part of the Communists.
> Russia is on strike, they say, and it is unethical for a revolutionist to
> side against the workers when they are striking against their masters. That
> is pure demagoguery practised by the Bolsheviki to silence criticism._

> _"It is not true that the Russian people are on strike. On the contrary, the
> truth of the matter is that the Russian people have been **locked out** and
> that the Bolshevik State -- even as the bourgeois industrial master -- uses
> the sword and the gun to keep the people out. In the case of the Bolsheviki
> this tyranny is masked by a world-stirring slogan: thus they have succeeded
> in blinding the masses. Just because I am a revolutionist I refuse to side
> with the master class, which in Russia is called the Communist Party."_ [
> **My Disillusionment in Russia** , p. xlix]

All of which, incidentally, answers Leninist Brian Bambery's rhetorical
question: _"why would the most militant working class in the world, within
which there was a powerful cocktail of revolutionary ideas, and which had
already made two revolutions (in 1905 and in February 1917), allow a handful
of people to seize power behind its back in October 1917?"_ [ _"Leninism in
the 21st Century"_ , **Socialist Review** , no. 248, January 2001] Once the
Russian workers realised that a handful of people **had** seized power they
**did** protest the usurpation of their power and rights by the Bolsheviks.
The Bolsheviks repressed them.

Yes, as Lenin argued, _"it is clear that there is no freedom and no democracy
where there is suppression and where there is violence."_ In 1917 he was
talking of the _"freedom of the oppressors, the exploiters, the capitalists"_
but it equally applies to the working class -- if the so-called _"dictatorship
of the proletariat, i.e., the organisation of the vanguard of the oppressed as
the ruling class"_ is suppressing the working class itself then there can be
_"no freedom and no democracy"_ for the working class and so it **cannot** be
the ruling class. Rather, it is the self-proclaimed _"vanguard"_ party which
is in fact the ruling class and just like _"under capitalism we have the state
in the proper sense of the word, that is, a special machine for the
suppression of one class by another, and, what is more, of the majority by the
minority."_ Thus the so-called "workers state" became, as anarchists had long
predicted, like any other State, _"a power which arose from society but places
itself above it and alienates itself more and more from it"_ and _"consists of
special bodies of armed men having prisons, etc., at their command"_ [ _"The
State and Revolution,"_ **The Lenin Anthology** , p. 373, p. 374, p. 316] As
can be seen, the Bolshevik regime was most definitely a State... **in the
normal sense of the term.** That it prefixed the word "Red" onto these
instruments of minority rule matters little, as can be seen from the
repression of labour protest under Lenin from early 1918 onwards.

All in all, these strikes and subsequent repression confirms Bakunin's
prescient critique of Marxism (see [section H.1.1](secH1.md#sech11)). Based
on the anarchist analysis of the State as _"minority government, from the top
downward, of a vast quantity of men,"_ he correctly predicted that even the
so-called workers' State _"cannot be sure of its own self-preservation without
an armed force to defend it against its own **internal enemies** , against the
discontent of its people."_ [ **Michael Bakunin: Selected Writings** , p. 265]
Yes, of course, workers viewed the Bolshevik regime more favourably than the
possibility of a White victory -- but that is a very low bar indeed:
socialism, surely, should aspire to be somewhat more appealing than the
restoration of Tsarism!

Little wonder, then, that the role of the masses in the Russian Revolution
after October 1917 is rarely discussed by pro-Bolshevik writers. Indeed, the
conclusion to be reached is simply that for the Bolsheviks the role of workers
is to support the party, get it into power and then do what it tells them.
Unfortunately for the Bolsheviks, the Russian working class refused this
position, the same position it held under Tsarism and capitalism. Instead they
practised collective struggle in defence of their economic **and** political
interests, a struggle which inevitably brought them into conflict both with
the "workers' state" and their role in Bolshevik ideology. Faced with this
collective action, the Bolshevik leaders (beginning with Lenin) started to
talk about the "declassing" of the proletariat to justify their repression of
(and power **over** ) the working class. Ironically, it was the aim of
Bolshevik repression to "atomise" the working class as, fundamentally, their
rule depended on it. While Bolshevik repression did, in the end, succeed it
cannot be said that the working class in Russia did not resist this usurpation
of power by the Bolshevik party. As such, rather than "atomisation" or
"declassing" being the cause for Bolshevik power and repression, it was, in
fact, one of **results** of them -- and helped ensure the rise of Stalin.

## 6 Did the Bolsheviks blame "objective factors" for their actions?

In a word, no. At the time of the revolution and for some period afterwards,
the idea that "objective factors" were responsible for their policies was one
which few, if any, Bolshevik leaders expressed. As we discussed in [section
2](append43.md#app2), leading Bolsheviks like Lenin, Trotsky and Bukharin
argued that **any** revolution would face civil war and economic crisis. Lenin
**did** talk about the _"declassing"_ of the proletariat from 1920 onwards,
but that did not seem to affect the proletarian and socialist character of his
regime (indeed, Lenin's argument was developed in the context of
**increasing** working class collective action, **not** its absence).

This is not to say that the Bolshevik leaders were completely happy with the
state of their revolution after the final victory over the White counter-
revolution. Lenin, for example, expressed deep concern about the rising
bureaucratic deformations he saw in the soviet state (particularly after the
end of the civil war). Yet, while concerned about the bureaucracy, he was not
concerned about the Party's monopoly of power in spite of the obvious relation
between the two (how could a party dictatorship function without a
bureaucracy?). Similarly, he tried to combat the bureaucracy by increasing the
very structural forms which created it in the first place, namely by
increasing centralisation, which in turn increased the bureaucracy and its
power. In short, he fought the bureaucracy by "top-down" and, ironically,
bureaucratic methods, the only ones left to him. A similar position was held
by Trotsky, who was quite explicit in supporting the party dictatorship
throughout the 1920s (and, indeed, the 1930s -- as discussed in the appendix
["Reply to errors and distortions in David McNally's pamphlet _'Socialism from
Below'"_](append31.md)). Needless to say, due to the limitations of the
ideology, both failed to understand how bureaucracy arises and how it could be
effectively fought.

This position started to change, however, as the 1920s drew on and Trotsky was
increasingly sidelined from power. Then, faced with the rise of Stalinism,
Trotsky had to find a theory which allowed him to explain the degeneration of
the revolution and, at the same time, absolve Bolshevik ideology (and his own
actions!) from all responsibility for it. He did so by invoking the objective
factors facing the revolution. Since then, his various followers have utilised
this argument, with various changes in emphasis, to attack Stalinism while
defending Bolshevism.

The problem with this type of argument is that all the major evils usually
associated with Stalinism already existed under Lenin and Trotsky. Party
dictatorship, one-man management, repression of opposition groups and working
class protest, state bureaucracy and so on all existed before Stalin
manoeuvred himself into absolute power. Thus, for example, we find Peter Binns
of the British SWP lament in 1987 that:

> _"This exploitation and powerlessness of the Russian class [under Mikhail
> Gorbachev] is nothing new. It came about more than 50 years ago. The final
> vestiges of workers' rights disappeared in 1929 when it was decreed that all
> managers' orders were now to be 'unconditionally binding on his subordinate
> administrative staff and on all workers'. It was at this time that the trade
> unions ceased to be able to play any function on behalf of workers, in
> particular over the negotiation of wages. An internal passport system was
> introduced, and in 1930 all industrial enterprises were forbidden to employ
> workers who left their former jobs without permission . . . As the Russian
> authorities themselves cynically put it: 'With the entry of the USSR into
> the period of socialism, the possibility of using coercive measures by
> corrective labour have immeasurably increased.' . . . In fact all efforts to
> start **any** independent workers' initiatives, let alone workers' councils,
> are now suppressed and are standardly rewarded with extreme forms of
> repression."_ [ _"The Theory of State Capitalism"_ , pp. 73-98, **Russia:
> From Workers' State to State Capitalism** , p. 75]

Yet this describes the regime under Lenin and Trotsky! As noted in [section
H.3.14](secH3.md#sech314), in early 1918 Lenin advocated _"dictatorial"_
one-man management and started to impose it, so ending the experiments in
workers' control which had previously flourished since mid-1917. This was
followed a few years later by the _"militarisation of labour"_ , likewise
championed by Lenin and Trotsky:

> _"The militarisation of labour, rushed through the ninth Party Congress with
> typical Tammany Hall steam-roller methods, definitely turned every worker
> into a galley-slave. The substitution of one-man power in the shops and
> mills in place of co-operative management placed the masses again under the
> thumb of the very elements they had for three years been taught to hate as
> the worst menace . . . Insult was added to injury by the introduction of the
> labour book, which virtually stamped everyone a felon, robbed him of the
> last vestiges of freedom, deprived him of the choice of place and
> occupation, and fastened him to a given district without the right of
> straying too far, on pain of severest penalties."_ [Emma Goldman, **Living
> My Life** , vol. 2, p. 780]

As noted in the [last section](append43.md#app5), workers who protested
against the imposition of these policies and class relations were likewise
rewarded with repression. Indeed, Trotsky wrote a book defending this regime
against criticism by leading Marxist Karl Kautsky which included the comment
that _"[i]n point of fact, under Socialism there will not exist the apparatus
of compulsion itself, namely, the State: for it will have melted away entirely
into a producing and consuming commune. None the less, the road to Socialism
lies through a period of the highest possible intensification of the principle
of the State. And you and I are just passing through that period. Just as a
lamp, before going out, shoots up in a brilliant flame, so the State, before
disappearing, assumes the form of the dictatorship of the proletariat, i.e.,
the most ruthless form of State, which embraces the life of the citizens
authoritatively in every direction."_ [ **Terrorism and Communism** , pp.
169-70] As Stalin put in 1930 (apparently, according to Binns, when a new
class system had now developed):

> _"We are in favour of the withering away of the state, and at the same time
> we stand for the strengthening of the dictatorship of the proletariat, which
> represents the most powerful and mighty of all forms of the state which have
> existed up to the present day. The highest development of the power of the
> state, with the object of preparing the conditions of the withering away of
> the state: that is the Marxist formula. Is it 'contradictory'? Yes, it is
> 'contradictory.' But this contradiction is a living thing and wholly
> reflects the Marxist dialectic."_ [quoted by Alfred B. Evans Jr., **Soviet
> Marxism-Leninism: The Decline of an Ideology** , p. 39]

Thus Stalinism and Bolshevism was based on the same social-relations -- and a
social system is **not** defined by the individuals in charge and their
intentions but rather the relations within its social structures and the
power-relations these generate. While it can be argued that Stalinism was
worse -- that repression was more brutal and privileges were more extreme --
this does not change the **class** nature of the regime and the inequalities
that these authoritarian social relations created. As Emma Goldman saw at
first hand, _"better and more plentiful food was served Party members at the
Smolny dining-room and many similar injustices and evils"_ , there was a
_"special hospital for Communists, with every modern comfort, while other
institutions lacked the barest medical and surgical necessities"_ , _"housing
arrangements disclosed similar favouritism and injustice"_ along with general
_"inefficiency, mismanagement, and bureaucratic corruption"_. [ **Living My
Life** , vol. 2, p. 732, p. 754 and p. 900] That the bureaucracy under Stalin
gained more wealth and exercised greater power over its subjects hardly
changes the class nature of the regime. Indeed, the greater abuses of
Stalinism had their basis in the social relations created under Lenin and
Trotsky (and, of course, Stalin who was -- least we forget -- an _"old
Bolshevik"_ as well, indeed an older one than Trotsky).

Worse for the advocates of this position, with the exception of the state
bureaucracy, none of the mainstream Bolshevik leaders found anything to
complain about. Whether it is Lenin or Trotsky, the sad fact of the matter is
that a party dictatorship presiding over an essentially state capitalism
economy was not considered a bad thing. Indeed, the "gains" of October
Trotskyists claim that Stalinism destroyed were, in fact, long dead by 1921.
Soviet democracy, working class freedom of speech, association and assembly,
workers' self-management in the workplace, trade union freedom, the ability to
strike, and a host of other, elementary, working class rights had been
eliminated long before the end of the civil war (indeed, often before it
started) and _"there is no evidence indicating that Lenin or any mainstream
Bolshevik leaders lamented the loss of workers' control or of democracy in the
soviets, or at least referred to these losses as a retreat, as Lenin declared
with the replacement of War Communism by NEP in 1921."_ [Samuel Farber,
**Before Stalinism** , p. 44]

Which, of course, causes problems for those who seek to distance Lenin and
Trotsky from Stalinism and claim that Bolshevism is fundamentally "democratic"
in nature. The knots Leninists get into to do this can be ludicrous. A
particularly crazy example can be seen from the UK's Socialist Workers Party.
For John Rees, it is a truism that _"it was overwhelmingly the force of
circumstance which obliged the Bolsheviks to retreat so far from their own
goals. They travelled this route in opposition to their own theory, not
because of it -- no matter what rhetorical justifications were given at the
time."_ [ _"In Defence of October,"_ pp. 3-82, **International Socialism** ,
no. 52, p. 70] So we cannot judge the Bolsheviks on what they did **nor** what
they said! This is understandable for, as Rees implicitly admits, the
Bolsheviks did **not** blame "objective circumstances" for their decisions.
Rather, they viewed them as ideologically correct responses to difficulties
they thought **every** revolution would face.

So this sort of position has little substance to it. It is both logically and
factually flawed. Logically, it simply makes little sense as anything but an
attempt to narrow political discussion and whitewash Bolshevik practice and
politics. Given that Leninists constantly quote from Lenin's and Trotsky's
post-1918 works, it seems strange that they try to stop others so doing.
Strange, but not surprising, given their task is to perpetuate the Bolshevik
Myth. Where that leaves revolutionary politics is left unsaid, but it seems to
involve worshipping at the shrine of October and treating as a heretic anyone
who dares suggest we analysis it in any depth and perhaps learn lessons from
it. As discussed in the [next section](append43#app7), there is utility in
such spurious arguments.

Of course Rees' comments are little more than assertions. Given that he
dismisses the idea that we can actually take what any Bolshevik says at face
value, we are left with little more than a mind reading operation in trying to
find out what the likes of Lenin and Trotsky "really" thought. Perhaps the
root explanation of Rees' position is the awkward fact that there are no
quotes from any of the leading Bolsheviks which support it? After all, if they
were quotes from the hallowed texts expounding the position Rees says the
Bolshevik leaders "really" held then he would have provided them. The simple
fact is that Lenin and Trotsky, like all the Bolshevik leaders, considered a
one-party dictatorship presiding over a state capitalist economy as
"socialism" (it also explains Trotsky's difficulty in understanding the
obvious class-nature of Stalinism and his ambiguous position in terms of its
"achievements"). Can we really dismiss this simply as _"rhetorical
justifications"_ rather than an expression of _"their own theory"_? Can we
really ignore the awkward fact that they never expressed _"their own theory"_
and instead we have to make do with the _"rhetorical justifications"_ Rees is
at such pains for us to ignore?

Which shows that a major problem in discussing the failure of the Russian
Revolution is the attitude of modern day Leninists. Rees presents us with
another example when he asserts that _"what is required of historians,
particularly Marxists, is to separate phrase from substance."_ The Bolsheviks,
Rees argues, were _"inclined to make a virtue of necessity, to claim that the
harsh measures of the civil war were the epitome of socialism."_ Indeed, he
states that non-Leninists _"take Lenin or Trotsky's shouts of command in the
midst of battle and portray them as considered analyses of events."_ [ **Op.
Cit.** , p. 46]

Yet this argument is simply incredulous. After all, neither Lenin nor Trotsky
could be said to be anything **but** political activists who took the time to
consider events and analyse them in detail, however wrongly. Moreover, they
defended their arguments in terms of Marxism. Would Rees consider Lenin's
**State and Revolution** as an unimportant work? After all, this was produced
in the midst of the events of 1917, in often difficult circumstances (such as
when hiding from the police). If so, then why not his other, less appealing,
political proclamations (never mind actions)? Moreover, looking at just a few
of the works produced in this period it is clear that they are anything
**but** _"shouts of command in the midst of battle."_ Trotsky's **Terrorism
and Communism** is a substantial book, for example. It was **not** an ad hoc
comment made during a conference or _"in the midst of battle."_ Quite the
reverse, it was a detailed, substantial and thought-out reply to criticism by
the influential German social democrat Karl Kaustky (and, before Lenin, the
most respected Marxist thinker in the world). Indeed, Trotsky explicitly asks
the question ( _"Is there still theoretical necessity to justify revolutionary
terrorism?"_ ) and answers yes, his _"book must serve the ends of an
irreconcilable struggle against the cowardice, half-measures, and hypocrisy of
Kautskianism in all countries."_ [ **Terrorism and Communism** , p. 9 and p.
10]

This work was circulated at the Second Congress of the Communist International
along with Lenin's **'Left-wing' Communism: An Infantile Disorder** , a work
still recommended by the likes of SWP in spite of its defence of party
dictatorship (see [section H.3.3](secH3.md#sech33)) and so in spite of it
being, presumably, _"shouts of command in the midst of battle"_ rather than
_"considered analyses of events"_. Significantly, Congress attendee anarchist-
turned-Bolshevik Alfred Rosmer later opined that both works had _"lost none of
their value"_ and could _"still be profitably read today._ [ **Lenin's
Moscow** , p. 69]

Therefore, Rees's comments are hard to take seriously. It is even harder to do
so when it becomes clear that Rees does not apply his comments consistently or
logically. He does not object to quoting Lenin and Trotsky during this period
when they say something he **approves** of, regardless of how badly it
reflects their actions. This is hardly convincing, particularly when their
"good" quotes are so at odds with their practice and their "bad" quotes so
consistent with them: as Marx argued, we should judge people by what they do,
**not** by what they say. This seems a basic principle of scientific analysis
and it is significant, if not surprising, that Leninists like Rees want to
reject it.

Worse, as we note in [section H.6.2](secH6.md#sech62), Bolshevik ideology
played its role in the degeneration of the revolution from the start. Many --
but not all -- the negative developments within the Revolution were actually
consistent with the vision of socialism expounded in 1917. Others were, of
course, opposed to the claims made before the seizure of power but were
inevitable given these very claims -- not least the swift rise of a new
bureaucracy (as anarchists had warned about long before October) given Marxist
prejudices in favour of centralism and nationalisation. Focusing on "objective
circumstances" draws attention away from this negative impact of both the
Bolshevik vision of socialism which guided the policies being implemented and
the policies being imposed. The assumption that these policies were not only
driven by necessity but also successfully countered this necessity cannot be
maintained for the policies imposed not only reflected many of the pre-1918
positions of orthodox Marxism, they had a negative impact in-so-far as they
made a bad economic situation worse as well as expanding and empowering an
officialdom which soon enough became a new ruling class (for further
discussion see the appendix ["How did Bolshevik ideology contribute to the
failure of the Revolution?"](append44.md))

Ultimately, the theoretical problem with this position is that it denies the
importance of ideas. After all, even if it where true that the **theory** of
Bolshevism was different to its practice and the justifications for that
practice, it would leave us with the conclusion that this **theory** was not
sufficient when faced with the rigours of reality. In other words, that it is
impractical -- a conclusion that Leninists do not want to draw, hence the
stress on "objective factors" to explain its failure.

Similarly, there seems to be an idealist tint to Leninist accounts of the
Russian Revolution. They seem to portray the Lenin of 1921 as, essentially,
the same person as the Lenin of 1917. That seems to violate the basic ideas of
materialism. As Herbert Read points out, _"the phrase 'the dictatorship of the
proletariat' . . . became fatal through the interventions of two political
expedients -- the identification of the proletariat with the Bolshevik Party,
and the use of the State as an instrument of revolution. Expedients and
compromises may have been necessary for the defeat of the reactionary forces;
but there is no doubt whatsoever that what took place was a progressive
brutalisation of Lenin's own mind under the corrupting influence of the
exercise of power."_ [ **A One-Man Manifesto** , p. 51] It seems common sense
that if a political strategy exposes its followers to the corrupting effects
of power we should factor this into any evaluation of it. Sadly, Leninists
fail to do this -- even worse, they attempt to whitewash the post-October
Lenin (and Trotsky) by excluding the "bad" quotes which reflect their
practice, a practice which they are at pains to downplay (or ignore)!

As libertarian socialist Cornelius Castoriadis noted, this pro-Bolshevik
response _"teaches us nothing we could extend beyond the confines of the
Russian situation in 1920. The sole conclusion to be drawn from this kind of
'analysis' is that revolutionaries should ardently hope that future
revolutions break out in more advanced countries, that they should not remain
isolated, and that civil wars should not in the least be devastating."_ It
does not explain _"why it 'degenerated' precisely in such a way that it led to
the power of the bureaucracy"_ , which is perhaps unsurprising for _"[i]nsofar
as ideas play a role in the development of history -- and, **in the final
analysis** , they play an enormous role -- the Bolshevik ideology (and with
it, the Marxist ideology lying behind it) was a decisive factor in the birth
of the Russian bureaucracy."_ [ **The Role of Bolshevik Ideology in the Birth
of the Bureaucracy** , p. 92 and p. 104]

Then, of course, there is the attitude of the Bolshevik leaders themselves to
these so-called _"shouts of command in the midst of battle."_ Rather than
dismiss them as irrelevant, they continued to subscribe to them years later.
For example, Trotsky was still in favour of party dictatorship in the late
1930s (see [section H.1.2](secH1.md#sech12)). Looking at his justly infamous
**Terrorism and Communism** , we discover him in the 1930s reiterating his
support for his arguments of 1920. His preface to the 1936 French edition sees
him state that the book was _"devoted to a clarification of the methods of the
proletariat's revolutionary policy in our epoch."_ He concluded as follows:
_"Victory is conceivable only on the basis of Bolshevik methods, to the
defence of which the present work is devoted."_ The previous year, in his
introduction to the second English edition, he was equally unrepentant. _"The
British proletariat,"_ he argued, _"will enter upon a period of political
crisis and theoretical criticism . . . The teachings of Marx and Lenin for the
first time will find the masses as their audience. Such being the case, it may
be also that the present book will turn out to be not without its use."_ He
dismissed the _"consoling illusion"_ that _"the arguments of this book [were]
true for backward Russia"_ but _"utterly without application to advanced
lands."_ The _"wave of Fascist or militarised police dictatorships"_ in the
1920s and 1930s was the reason. It seems ironic that Trotsky's self-proclaimed
followers are now repeating the arguments of what he termed _"incurable
Fabians"_ , namely that arguments within it were irrelevant and not applicable
in circumstances other than those it was written in. [ **Terrorism and
Communism** , p. xix, p. xxxv, p. xlvii and p. xxxix]

So rather than distance himself from the authoritarian and state-capitalist
policies modern day Leninists claim were thrust upon an unwilling Bolshevik
party by "objective factors," Trotsky defended them. This is unsurprising,
given that as we noted above in [section 2](append43.md#app2), Trotsky
himself argues in that work that these "objective factors" would be faced in
**every** revolution. As it was, he argues that it was only the _"slow
development of the revolution in the West"_ which stopped _"a direct passage
from military Communism to a Socialistic system of production."_ Rather than
admit to _"illusions"_ caused by the _"iron necessity"_ of winning the civil
war, he talks about _"those economic hopes which were bound up with the
development of the world revolution."_ He even links Bolshevik practice with
Stalinism, noting that the _"idea of five-year plans was not only formulated
in that period [1918-1920], but in some economic departments it was also
technically worked out."_ Indeed, in 1920 he noted how the policies he was
implementing in practice and defending in theory were _"correct from the point
of view both of principle and of practice"_. [ **Op. Cit.** , p. xliii and p.
135]

Even his essay outlining what he considers the differences between Stalinism
and Bolshevism does not see him fundamentally distancing himself from the
positions modern day Leninists like to explain by "objective factors." He
stated that the _"Bolshevik party achieved in the civil war the correct
combination of military art and Marxist politics."_ What did that involve?
Immediately before making that claim he argued that the _"Bolshevik party has
shown the entire world how to carry out armed insurrection and the seizure of
power. Those who propose the abstraction of the Soviets from the party
dictatorship should understand that only thanks to the party leadership were
the Soviets able to lift themselves out of the mud of reformism and attain the
state form of the proletariat."_ Thus the _"party dictatorship"_ is seen as
being an example of _"Marxist politics"_ being successfully applied and not
something to be opposed. Moreover, _"the Bolshevik party was able to carry on
its magnificent 'practical' work only because it illuminated all its steps
with theory."_ [ _"Stalinism and Bolshevism,"_ **Writings of Leon Trotsky
1936-37** , pp. 430-1]

Clearly, rather than denounce the power of the party as being against
Bolshevik theory, as Rees claims, for Trotsky it represented its application.
While Trotsky excuses some Bolshevik actions (such as the banning of
opposition groups) as a product of "objective factors" (such as the civil
war), he clearly sees the degeneration of the revolution coming **after** the
civil war and its _"correct combination"_ of _"Marxist politics"_ and
_"military art,"_ which included _"party dictatorship"_ over the soviets.

This lack of distancing is to be expected. After, the idea that "objective
factors" caused the degeneration of the Russian Revolution was first developed
by Trotsky to explain, after his fall from power, the rise of Stalin. While
**he** was head of the Soviet state no such "objective" factors seemed to be
required to "explain" the party dictatorship over the working class. Indeed,
quite the reverse as he argued in 1923: _"If there is one question which
basically not only does not require revision but does not so much as admit the
thought of revision, it is the question of the dictatorship of the Party."_ [
**Leon Trotsky Speaks** , p. 158] In this he reflected party orthodoxy, as
expressed by Zinoviev to the delegates to the Second Congress of the Communist
International who were busy seeking wisdom from **Terrorism and Communism** :

> _"Today, people like Kautsky come along and say that in Russia you do not
> have the dictatorship of the working class but the dictatorship of the
> party. They think this is a reproach against us. Not in the least! We have a
> dictatorship of the working class and that is precisely why we also have a
> dictatorship of the Communist Party. The dictatorship of the Communist Party
> is only a function, an attribute, an expression of the dictatorship of the
> working class . . . [T]he dictatorship of the proletariat is at the same
> time the dictatorship of the Communist Party."_ [ **Proceedings and
> Documents of the Second Congress 1920** , vol. 2, pp. 151-2]

Trotsky in 1920 (and beyond!) was just stating mainstream Bolshevik ideology,
echoing a statement made in March 1923 by the Central Committee (of which he
and Lenin were members) to mark the 25th anniversary of the founding of the
Communist Party issued long after the need for _"shouts of command in the
midst of battle"_. It sums up the lessons gained from the revolution and
states that _"the party of the Bolsheviks proved able to stand out fearlessly
against the vacillations within its own class, vacillations which, with the
slightest weakness in the vanguard, could turn into an unprecedented defeat
for the proletariat."_ Vacillations, of course, are expressed by workers'
democracy. Little wonder the statement rejects it: _"The dictatorship of the
working class finds its expression in the dictatorship of the party."_ [ _"To
the Workers of the USSR"_ in G. Zinoviev, **History of the Bolshevik Party** ,
p. 213, p. 214]

So, as with all the leading Bolsheviks, he considered the party dictatorship
as an inevitable result of any proletarian revolution. Moreover, he did not
question the social relationships within production either. One-man management
held no fears for him and he considered the state-capitalist regime under
himself and Lenin "socialist" and defended it as such. He was fully supportive
of one-man management, going so far as to suggest in 1920 that _"if the civil
war had not plundered our economic organs of all that was strongest, most
independent, most endowed with initiative, we should undoubtedly have entered
the path of one-man management in the sphere of economic administration much
sooner and much less painfully."_ [ **Terrorism and Communism** , pp. 169–70]
Writing in the peace of 1923, he likewise argued that the _"system of actual
one-man management must be applied in the organisation of industry from top to
bottom. For leading economic organs of industry to really direct industry and
to bear responsibility for its fate, it is essential for them to have
authority over the selection of functionaries and their transfer and
removal."_ These economic organs must _"in actual practice have full freedom
of selection and appointment."_ [quoted by Robert V. Daniels, **A Documentary
History of Communism** , vol. 1, p. 237]

As can be seen, all of these post-civil war opinions fit in well with his
civil war opinions on the matter. Now, it seems strange that rather than
present what he "really" thought, Trotsky expounded what presumably was the
**opposite** of it. Surely the simplist conclusion to draw is that Trotsky
said what he really did think and expressed this in his so-called _"shouts of
command"_ made during the civil war? Can all these comments be dismissed as
_"rhetorical justifications"_ and not reflective of Trotsky's real ideas?
Ultimately, either you subscribe to the idea that Lenin and Trotsky were able
to clearly express their ideas themselves or you subscribe to the notion that
they hid their "real" politics and only modern-day Leninists can determine
what they, in fact, "really" meant to say and what they "really" stood for.
And as for all those "awkward" quotes which express the **opposite** of the
divined true faith, well, they can be ignored.

Which is, of course, hardly a convincing position to take, particularly as
Lenin and Trotsky were hardly shy in justifying their authoritarian policies
and expressing a distinct lack of concern over the fate of any **meaningful**
working class conquest of the revolution like, say, soviet democracy. Indeed,
as we note in [section 3](append45.md#app3) of the appendix ["Were any of
the Bolshevik oppositions a real alternative?"](append45.md), the sad fact
is that the inter-party conflicts of the 1920s were **not** about workers'
democracy at all rather party democracy, as admitted in 1925 by Max Eastman,
one of Trotsky's main supporters at the time, who noted that _"this programme
of democracy within the party [was] called 'Workers' Democracy' by Lenin"_ and
that _"Trotsky merely revived this original plea."_ [ **Since Lenin Died** ,
p. 35] Ironically, Trotskyists in soviet prisons in the early 1930s
_"continued to consider that 'Freedom to choose one's party -- that is
Menshevism'"_ and this was their _"final verdict."_ [Ante Ciliga, **The
Russian Enigma** , p. 280] No wonder they seemed surprised to be there!

Ultimately, Trotsky's issue with Stalinism was not based on **real** socialist
principles, such as meaningful working class freedoms and power. Rather it was
a case of _"the political centre of gravity ha[ving] shifted from the
proletarian vanguard to the bureaucracy"_ and this caused _"the party"_ to
change _"its social structure as well as in its ideology."_ [ _"Stalinism and
Bolshevism,"_ **Writings of Leon Trotsky 1936-37** , p. 422] The party
dictatorship had been replaced by the dictatorship of the state bureaucracy,
in other words. Once this happened, Trotsky sought to explain it. As analysing
the impact of Bolshevik ideology and practice were, by definition, out of the
question given his role in formulating and imposing it, that left the various
"objective factors" Trotsky turned to in order to explain developments after
1923, to explain Stalinism while keeping true to Bolshevik ideology **and**
practice.

This legacy shows itself with those who repeated it afterwards. Trotsky's
limited critique explains why, to quote Chris Harman (another member of the
British SWP), Trotsky _"continued to his death to harbour the illusion that
somehow, despite the lack of workers' democracy, Russia was a 'workers'
state.'"_ Simply put, there had been no workers' democracy under Lenin and
Trotsky and he considered that regime a _"workers' state"_ so why should this
be a key criteria for evaluating Stalinism? The question arises why **Harman**
thought that Lenin's Russia was some kind of "workers' state" if workers'
democracy is the criteria by which such things are to be judged. But, then
again, he thinks Trotsky's **Left Opposition** _"framed a policy along [the]
lines"_ of _"returning to genuine workers' democracy"_! [ **Bureaucracy and
Revolution in Eastern Europe** , p. 20 and p. 19] This also undermines the
SWP's "Stalinism was state-capitalism" position (it must be stressed, as noted
in [section H.3.13](secH3.md#sech313), this is **not** the same as the
anarchist analysis, even if the conclusions are the same). As orthodox
Trotskyist Ted Grant summarised in 1949:

> _"If Comrade Cliff's thesis is correct, that state capitalism exists in
> Russia today [under Stalin], then he cannot avoid the conclusion that state
> capitalism has been in existence since the Russian Revolution and the
> function of the revolution itself was to introduce this state capitalist
> system of society. For despite his tortuous efforts to draw a line between
> the economic basis of Russian society before the year 1928 and after, the
> economic basis of Russian society has in fact remained unchanged."_ [
> _"Against the Theory of State Capitalism: Reply to Comrade Cliff,"_ **The
> Unbroken Thread** , p. 199]

Indeed! Although Grant was wrong to view Stalin's Russia as a _"degenerated
workers' state"_ rather that reject Bolshevism for introducing state-
capitalism and party dictatorship in Russia, the fact is that in terms of
**social relations** he is correct -- Russia **was** state-capitalist under
Lenin and Trotsky. The awkward fact is that the Russian working class was
expropriated both politically and economically in the first few months. A new
State -- with its own bureaucracy and armed forces separate from the masses --
was emerging by January 1918, with the elimination of democracy within the
armed forces and workplaces imposed by March and April of that year. This
process was in place before "objective factors" like civil war started or had
a significant impact -- which undoubtedly explains why the Bolsheviks at the
time did **not** justify their policies in those terms, why Lenin in November
1919 stated that the _"organisation of the communist activity of the
proletariat and the entire policy of the Communists have now acquired a final,
lasting form; I am certain that we are on the right path and that progress
along that path is fully ensured."_ [ **Collected Works** , vol. 30, p. 144]

The major problem for Trotskyists of all kinds is that all the characteristics
which they claim differentiate Bolshevism and Stalinism were all applied under
Lenin and Trotsky. So, while most neo-Trotskyists like to proclaim that
socialism **has** to be politically and economically democratic to qualify as
socialist in order to exclude Stalinism from Marxism, the awkward fact is that
these same parties also consider Lenin's regime post-1917 as socialist in
spite of it being a party dictatorship politically and state-capitalist
economically: apparently, socialism need not be democratic after all.

For anarchists, however, the regime confirmed the _"belief that a revolution
**à la Bakunin** would have brought more constructive results, if not
immediate anarchism . . . the Russian Revolution had been **à la Bakunin** ,
but it had since been transformed **à la Karl Marx**. That seemed to be the
real trouble. I had not been naïve enough to expect anarchism to rise phoenix-
like from the ashes of the old. But I did hope that the masses, who had made
the Revolution, would also have the chance to direct its course."_ [Emma
Goldman, **Living My Life** , vol. 2, p. 826] As Kropotkin summarised, we
_"have always pointed out the effects of Marxism in action. Why be surprised
now?"_ In short, it was the case of _"a small political party which by its
false theories, blunders, and inefficiency has demonstrated how revolutions
must **not** be made."_ [quoted by Emma Goldman, **My Disillusionment in
Russia** , p. 36 and p. 98]

So, in summary, the leading Bolsheviks did not view "objective factors" as
explaining the failure of the revolution. Indeed, until Trotsky was squeezed
out of power they did not think that the revolution **had** failed: party
dictatorship and one-man management were considered as expressions of a
successful revolution. Trotsky's issue with Stalinism was simply that the
bureaucracy had replaced the _"the proletarian vanguard"_ (i.e. himself and
his followers) as the dominant force in the Soviet State and it had started to
use the techniques of political repression developed against opposition
parties and groups against him. The idea that "objective factors" caused the
failure of the revolution was not used to explain the party dictatorship but
rather the usurpation of **its** power by the bureaucracy. Its subsequent use
by both orthodox and neo-Trotskyists to rationalise Leninist policies do not
address the fundamental issue of **why** the revolution failed as it, as we
discuss in the [next section](append43.md#app7), exists to **exclude** the
impact of Bolshevik ideology in that process. Ultimately, it is unconvincing
when placed in the wider context of Leninist ideology before, during and after
the civil war.

## 7 What role does "objective factors" play in Leninist ideology?

As we discuss in the appendix on ["How did Bolshevik ideology contribute to
the failure of the Revolution?"](append44.md), Marxist ideology played a key
role in the degeneration of the revolution and in laying the groundwork for
the rise of Stalinism. However, this is a conclusion which no Leninist could
entertain for a moment and this explains the popularity of "objective factors"
within these cirlces -- for its role is to obscure this key factor in the
failure of the revolution. Kropotkin stated the obvious, namely that the
problems were increased but not created by the counter-revolution and other
"objective factors":

> _"The evils naturally inherent in party dictatorship have thus been
> increased by the war conditions under which this party maintained itself.
> The state of war has been an excuse for strengthening the dictatorial
> methods of the party, as well as its tendency to centralise every detail of
> life in the hands of the Government, with the result that immense branches
> of the usual activities of the nation have been brought to a standstill. The
> natural evils of State Communism are thus increased tenfold under the excuse
> that all misfortunes of our life are due to the intervention of
> foreigners."_ [ **Direct Struggle Against Capital** , p. 488]

So the stressing of "objective factors" is hardly accidental for it shifts
perspectives away from Bolshevik ideology and its flaws. It ensures that any
Leninist defence of Bolshevism based purely on stressing "objective factors"
results in the conclusion that Bolshevik ideology played **no role** in the
decisions made by the party leaders, that they simply operated on autopilot
from October 1917 onwards. As Samuel Farber puts it _"determinism's
characteristic and systemic failure is to understand that what the masses of
people do and think politically is as much part of the process determining the
outcome of history as are the objective obstacles that most definitely limit
peoples' choices."_ [ **Before Stalinism** , p. 198] This is particularly the
case when, as in Bolshevik Russia, "the masses of people" have had their
revolution expropriated from them and placed into the hands of a few leaders
at the top of a centralised, hierarchical social structure which combines
political and economic decision making and power.

For anarchists, "objective factors" and "ideology" are interwoven -- ideas
reflect the social conditions in which they develop but how people react to
events are influenced by the ideas in their heads and these are also
influenced by "ideologically correct" sources from the past. The decisions
made by those in power impact on the objective circumstances -- making them
better or worse depending on their suitability to address the issues. Social
structures create specific social relations, and so an ideological prejudice
in favour of, say, centralisation results in the building of specific forms of
social organisation which, in turn, quickly become objective factors.
Similarly, concentrating power into a few hands automatically limits the
options and knowledge available to solve the problems, as Malatesta noted long
before 1918:

> _"Social action [...] is the resultant of initiatives, thoughts and actions
> of all individuals who make up society; a resultant which, all other things
> being equal, is greater or smaller depending on whether individual forces
> are directed to a common objective or are divided or antagonistic. And if
> instead, as do the authoritarians, one means government action when one
> talks of social action, then this is still the resultant of individual
> forces, but only of those individuals who form the government or who by
> reason of their position can influence the policy of the government. [...]
> Even if we pursue our hypothesis of the ideal government of the
> authoritarian socialists, it follows from what we have said that far from
> resulting in an increase in the productive, organising and protective forces
> in society, it would greatly reduce them, limiting initiative to a few, and
> giving them the right to do everything without, of course, being able to
> provide them with the gift of being all-knowing."_ [ **Anarchy** , pp. 38-9]

In short, when a few hold political, economic and social power and are ruling
in the name of the working class then the impact of ideology becomes
correspondingly concentrated. Unsurprisingly, rather than just select policies
at random the Bolshevik leadership pursued consistently before, during and
after the civil war policies which reflected their ideology. There was a
preference for policies which centralised power in the hands of a few
(politically **and** economically), that saw socialism as being defined by
nationalisation rather than self-management, that considered bigger as
inherently better, that stressed that role and power of the vanguard above
that of the working class, that saw class consciousness as being determined by
how much a worker agreed with the party leadership rather than whether it
expressed the actual needs and interests of the class as a whole.

By stressing just one aspect of the matter, the "objective," Leninists ensure
that the other, the "subjective," is ignored and so ensure a flawed analysis
of the revolution and lessons to be learned from it. Indeed, what could be
learned? Only that any future revolution should occur in an advanced
capitalist nation, avoid isolation, civil war and so on. Thus Bolshevik
ideology can be uncritically embraced for, ultimately, it has never been
applied!

Yet Bolshevism itself undermined the socialist potential of the revolution,
irrespective of the actual circumstances involved (which, to some degree, will
affect **any** revolution). For example, the Bolshevik preference for
centralisation and nationalisation would negatively affect a revolution
conducted in even the best circumstances, as would the seizure of state power
rather than its destruction. Only the elimination of what makes Bolshevism
Bolshevik would ensure that a revolution would be successful. So anarchists
stress that rather than being forced upon them by "objective factors" many of
these policies were, in fact, in line with pre-civil war Bolshevik ideas. The
Bolshevik vision of socialism, in other words, ensured that they smothered the
(libertarian) socialist tendencies and institutions that existed at the time.
As Chomsky summarises, _"Lenin and Trotsky, shortly after seizing state power
in 1917, moved to dismantle organs of popular control, including factory
committees and Soviets, thus proceeding to deter and overcome socialist
tendencies."_ [ **Deterring Democracy** , p. 361] That they **thought** their
system of state capitalism was a form of "socialism" is irrelevant -- they
systematically combated (real) socialist tendencies in favour of state
capitalist ones and did so knowingly and deliberately (see sections
[H.3.1](secH3.md#sech31) and [H.3.13](secH3.md#sech313) on the differences
between real socialism and Marxism in its Bolshevik mode and [section
H.6](secH6.md) on Bolshevik practice itself).

So it is important to stress that even **if** the Russian Revolution had
occurred in better circumstances, it is unlikely that Bolshevism would have
resulted in socialism rather than state capitalism. Bolshevik principles
ensure that any revolution lead by a vanguard party would not have succeeded.
This can be seen from the experience of Bolshevism immediately after it seized
power, before the start of the civil war and major economic collapse, so their
application in even the best of situations would have undermined socialist
tendencies in the revolution. Simply put, a statist revolution will have
statist, not libertarian, ends.

The focusing on "objective factors" (particularly the civil war) has become
the traditional excuse for people with a romantic attachment to Leninism but
who are unwilling to critically analyse what the Bolsheviks actually did in
power and how it so often reflected their pre-October policies and promises.
This excuse is not viable if you seek to build a revolutionary movement today:
you need to choose between the real path of Lenin and the real, anarchist,
alternative. As Lenin constantly stressed, a revolution will be difficult --
fooling ourselves about what will happen now just undermines our chances of
success in the future and ensure that history will repeat itself. For the
"objective factors" argument is not a defence of Leninism, but rather one that
seeks to evade having to make such a defence. Revolutionary politics would be
much better served by confronting this history and the politics behind it head
on. Perhaps, if Leninists did do this, they would remain Leninists, but at
least then their party members and those who read their publications would
have an understanding of what this meant. And they would have to dump Lenin's
**State and Revolution** into the same place Lenin himself did when in power
-- into the rubbish bin -- and admit that democracy and Bolshevik revolution
do not go together.

Looking at the "subjective factor" and the ideology which drove it means to
recognise that it was **not** a case of the Bolshevik regime wanting to
introduce communism but, being isolated, ended up imposing state capitalism
instead. Rather, these policies were explicitly advocated **from the start** ,
before the seizure of power in October 1917. So the idea that "objective
factors" caused the degeneration of the revolution is valid if and only if the
Bolsheviks were implementing socialist policies during the period immediately
after the October revolution: that was not the case, Lenin and other leading
Bolsheviks explicitly argued for these policies as essential for building
socialism (or, at best, the preconditions of socialism) in Russia and
Bolshevik practice flowed from this analysis. Unsurprisingly, then, the
Bolsheviks happily introduced authoritarian and state capitalist policies
**from the start.** Many of the policies denounced as "Stalinist" by Leninists
were being advocated and implemented by Lenin in the spring of 1918, i.e.
**before** the start of the civil war and the deepening of economic chaos that
it produced.

In other words, the usual excuses for Bolshevik tyranny do not hold much
water, both factually and logically.

## 8 Do Leninists usually deny the importance of ideology?

In a word, no. Usually Leninists stress the importance of ideology in both
social change and revolution -- after all, why join their party if ideology is
unimportant as decisions are driven by "objective factors"? Yet, ironically,
other aspects of their analysis of the Russian Revolution recognises that
ideology **does** play an important role.

Indeed, the framework which Leninists use in this discussion shows the
importance of Bolshevik ideology and the key role it played in the outcome of
the revolution. After all, pro-Bolsheviks argue that the "objective factors"
forced the **Bolsheviks** to act as they did. However, the proletariat is
meant to be the _"ruling class"_ in the _"dictatorship of the proletariat."_
As such, to argue that the Bolsheviks were forced to act as they did due to
circumstances means to implicitly acknowledge that the party held power in
Russia, **not** the working class. That a ruling party could become a party
dictatorship is not that unsurprising, nor that **its** vision of what
"socialism" was would be given preference over the desires of the working
class in whose name it ruled. So these apologetics show the validity of
Bakunin's critique of Marxism:

> _"Nor can we comprehend talk of freedom of the proletariat or true
> deliverance of the masses within the State and by the State. State signifies
> domination, and all domination implies subjection of the masses, and as a
> result, their exploitation to the advantage of some governing minority._

> _"Not even as revolutionary transition will we countenance national
> Conventions, nor Constituent Assemblies, nor provisional governments, nor so
> called revolutionary dictatorships: because we are persuaded that revolution
> is sincere, honest and real only among the masses and that, whenever it is
> concentrated in the hands of a few governing individuals, it inevitably and
> immediately turns into reaction."_ [ **No Gods, No Masters** , vol. 1, p.
> 160]

This is not the only way in which Leninist defences of Bolshevism undermines
itself. In their own way, Leninists admit the key role of ideas indirectly
when they cannot avoid mentioning the collective resistance to Bolshevism
indicated in [section 5](append43.md#app5) above. In the few cases when the
class struggle under the Bolsheviks is not ignored, Leninists often argue that
while the working class was capable of collective decision making and action,
the nature of such action was suspect. This arguments rests on the premise
that the "advanced" workers (i.e. party members) left the workplace for the
front or for government posts, leaving the "backward" workers behind. This
argument is often used, particularly in regard to the garrison of Kronstadt at
the time of their revolt in early 1921 (see [section 8](append42.md#app8) of
the appendix on ["What was the Kronstadt Rebellion?"](append42.md)).

Yet this argument raises more problems that its solves. In **any** revolution
the most advanced, the most politically consciousness tend to volunteer to go
to the front first and, of course, tend to be elected as delegates to
committees of various kinds (local, regional and national; economic, political
and social). There is little that can be done about it but if soviet -- or
socialist -- democracy depends on the "advanced" workers being there in order
for it to work, then it suggests two things. First, and most obvious, that
ideas matter -- if not, then the question of advanced and backward workers
would be irrelevant. Second, that the commitment to democracy is lacking in
those who argue along these lines, for what happens if the "backward" masses
reject the "advanced" elements? Given the key role played by the latter then
do they have the right, even the duty, to impose their will on the former? And
it also begs the question of **who** determines what constitutes "backward" --
if it means "does not support the party" then it becomes little more than a
rationale for party dictatorship (as it did under Lenin and Trotsky).

Writing in 1938 while he defended the repression of the 1921 Kronstadt revolt,
Trotsky argued that a _"revolution is 'made' directly by a **minority** ,"_ he
argued that the _"success"_ of a revolution is _"possible"_ when _"this
minority finds more or less support, or at least friendly neutrality, on the
part of the majority."_ So what happens if the majority expresses opposition
to the party? Unfortunately Trotsky does not raise this question, but he does
answer it indirectly by arguing that _"to free the soviets from the leadership
[sic!] of the Bolsheviks would have meant within a short time to demolish the
soviets themselves. The experience of the Russian soviets during the period of
Menshevik and SR domination and, even more clearly, the experience of the
German and Austrian soviets under the domination of the Social Democrats,
proved this. Social Revolutionary-anarchist soviets could only serve as a
bridge from the proletarian dictatorship. They could play no other role,
regardless of the 'ideas' of their participants."_ [Lenin and Trotsky,
**Kronstadt** , p. 85 and p. 90]

Thus to let the working masses (the _"majority"_ ) have free soviet elections
and so reject the vanguard (the _"minority"_ ) would mean the end of soviet
power, allowing the proletariat a say in the progress of the revolution means
the end of the _"proletarian dictatorship"_! Which, of course, is interesting
logic. The authoritarian core of the Bolshevik vision of revolution is thus
exposed -- along with the key role of ideology in the outcome of the
revolution!

Victor Serge likewise presented an insight into the Bolshevik perspective on
the role of ideology in a revolution when he noted that in 1918 _"[a]gitation
conducted by the SRs and Mensheviks called demonstrations in the streets and
prepared for a general strike. The demands were: free trade, wage increases,
payment of wages one, two or three months in advance and 'democracy.' The
intention was to incite the working class itself against the revolution."_
Which only makes sense once you realise that by _"the revolution"_ Serge
simply meant _"the Bolsheviks"_ and the obvious truth that the working class
was **not** managing the revolution at all, was **not,** in any sense, in
power. _"The best elements among the workers,"_ explains Serge, _"were away
fighting; those in the factories were precisely the less energetic, less
revolutionary sections, along with the petty folk, yesterday's small
shopkeepers and artisans, who had come there to find refuge. This proletariat
of the reserve often allowed itself to fall under the sway of Menshevik
propaganda."_ [ **Year One of the Russian Revolution** , p. 229] Given that
Serge is discussing the period **before** the revolt of Czechoslovak Legion
(and so the start of the civil war), a greater indictment of Bolshevism cannot
be found. After all, what does "workers' democracy" mean unless the
proletariat can vote for its own delegates? Little wonder Daniel Guerin
described Serge's book as _"largely a justification of the liquidation of the
soviets by Bolshevism."_ [ **Anarchism** , p. 97] What point is there having
genuine soviet elections if the _"less revolutionary sections"_ (i.e.
Trotsky's _"majority"_ ) will not vote for the vanguard? And can socialism
exist without democracy? Can we expect an unaccountable vanguard to govern in
the interests of anyone but its own? Of course not!

Thus we find Serge arguing that the _"party of the proletariat must know, at
hours of decision, how to break the resistance of the backward elements among
the masses; it must know how to stand firm sometimes against the masses . . .
it must know how to go against the current, and cause proletarian
consciousness to prevail against lack of consciousness and against alien class
influences."_ [ **Op. Cit.** , p. 218] Ideas apparently **do** matter after
all. Trotsky comments on this theme allows us to draw the obvious conclusions:

> _"The very same masses are at different times inspired by different moods
> and objectives. It is just for this reason that a centralised organisation
> of the vanguard is indispensable. Only a party, wielding the authority it
> has won, is capable of overcoming the vacillation of the masses themselves .
> . . if the dictatorship of the proletariat means anything at all, then it
> means that the vanguard of the proletariat is armed with the resources of
> the state in order to repel dangers, including those emanating from the
> backward layers of the proletariat itself."_ [ _"The Moralists and
> Sycophants against Marxism"_ , pp. 53-66, **Their Morals and Ours** , p. 59]

Of course, by definition, **every** group is _"backward"_ compared to the
vanguard and so Trotsky's and Serge's argument amounts to little more than a
justification for party dictatorship **over** the proletariat. Thus the
validity of Bakunin's prediction that Marxism's _"sham people's government
would be no other than the completely despotic rule of the masses by a new and
very small aristocracy of actual or alleged 'scholars.' The people are no
'scholars,' and therefore they are as a whole to be freed from the toils of
government, and as a whole they are to make up the herd that is governed. What
a splendid freedom!"_ { **Micheal Bakunin: Selected Writings** , p. 269] Is it
then that surprising that Bolsheviks revised the Marxist theory of the state
to justify elite rule? As discussed in [section H.3.8](secH3.md#sech38),
once in power Lenin and Trotsky saw that the "workers' state" had to be
independent of the working class in order to overcome the _"wavering"_ and
_"vacillation of the masses themselves."_

The reason why such a system would not result in socialism does not take long
to discover. For anarchists, freedom is not just a goal, a noble end to be
achieved sometime in the distant future, but rather a necessary part of the
process of creating socialism. Eliminate freedom (and, as a necessary result,
workplace and community self-management, initiative, self-activity) and the
end result will be anything **but** socialism. Ultimately, as Malatesta
argued, _"the only way that the masses can raise themselves"_ is by freedom
_"for it is only through freedom that one educates oneself to be free."_ [
**Op. Cit.** , p. 53] Ironically, by using state repression to combat
_"backward"_ elements, the Bolsheviks ensured that they stayed that way and,
more importantly, disempowered the **whole** working class so ensuring that
Bolshevik dictatorship came into constant conflict with it and its continuing
struggle for autonomy. Rather than base itself on the creative powers of the
masses, Bolshevism crushed it as a threat to its power and so ensured that the
economic and social problems affecting Russia increased.

And need it be pointed out that "low" culture or "backwardness" have been used
by numerous imperialist and authoritarian regimes to justify their rule over a
given population? It matters little whether the population are of the same
nationality as the rulers or from a subjugated people, the arguments and the
logic are the same. Whether dressed up in racist or classist clothing, the
same elitist pedigree lies behind the pro-Bolshevik argument that democracy
would have brought _"chaos"_ or _"capitalist restoration."_ The implicit
assumption that working class people are not fit for self-government is clear
from these rationales. Equally obvious is the idea that the party knows better
than working class people what is best for them.

Sounding like Bolshevik Henry Kissingers, Leninists argue that Lenin and
Trotsky had to enforce their dictatorship **over** the proletariat to stop a
_"capitalist restoration"_ (Kissinger was the US state's liaison with the
Chilean military when it helped their coup in 1973 and infamously stated that
the country should not be allowed to turn communist due to the stupidity of
its own people). Needless to say, anarchists argue that even if the Bolshevik
regime had not already been capitalist (specifically, **state** capitalist)
this logic simply represents an elitist position based on _"socialism from
above"_ (see [section H.3.3](secH3.md#sech33)). Yes, soviet democracy
**may** have resulted in the return of (private) capitalism but by maintaining
party dictatorship the possibility of socialism was automatically nullified.
Simply put, the pro-Leninist argument implies that socialism can be
implemented from above as long as the right people with the right ideas are in
power. Thus the crudest determinism flips into the most vacuous idealism, with
the flipping driven by the overwhelming necessity of defend the Bolshevik
regime. And while we can understand Trotsky seeking to absolve his conscious
on the role **his** decisions, policies and politicis played in creating the
regime Stalin so adroitly utilised in his rise to power, it becomes less clear
why modern-day socialists would seek to encase themselves in such
contradictions.

Such reasoning by Trotsky and Serge show the role of ideology in the outcome
of the revolution, so underming their invocation of "objective factors" to
explain all. Yet, at the same time, they stress the importance of Leninist
ideology in ensuring the "victory" of the revolution. They seek to have it
both ways -- the application of the crudest form of deterministic materialism
on the one side, the glorification of the will of a few leaders on the other.
It also exposes the authoritarian core of Leninism which justified the
repression of working class revolt. Given this, it is incredulous for
Leninists like Chris Harman to suggest that it was the _"decimation of the
working class"_ which caused (by _"necessity"_ ) the _"Soviet institutions"_
to take _"on a life independently of the class they had arisen from. Those
workers and peasants who fought the Civil War could not govern themselves
collectively from their places in the factories."_ [ _"How the revolution was
lost"_ , pp. 13-36, P. Binns, T. Cliff, C. Harman, **Russia: From Workers'
State to State Capitalism** , p. 18] Given that this _"independent"_ life is
required to allow the party (requoting Serge) to _"go against the current,"_
Harman simply fails to understand the dynamics of the revolution, the actual
social position of the vanguard and the resistance of the working class
subject to it. Moreover, the reason **why** the _"workers and peasants"_ could
not govern themselves collectively was because the party had seized power for
itself and systematically destroyed soviet, workplace and military democracy
to remain there (see [section H.6](secH6.md)). Then there is the way the
Bolsheviks reacted to such collective unrest: they sought to break the workers
as a collective force. The use of violence, lockouts and re-registration was
typical, as was the arresting of "ringleaders" (see [section 5](append43#app5)
above for details) It seems ironic, therefore, to blame "objective factors"
for the "atomisation" of the working class when, in fact, this was a key aim
of Bolshevik repression of labour protest -- repression which was easily
justified by its ideology.

Ultimately, the degeneration of the Russian Revolution can be traced from when
the Bolsheviks seized power **on behalf of** the Russian working class and
peasantry and has its roots in Marxist ideology. Most obviously, state implies
the delegation of power and initiative into the hands of a few leaders who
form the "revolutionary government." Yet the power of any revolution, as
Bakunin recognised, derives from the decentralisation of power, from the
active participation of the masses in the collective social movement and the
direct action it generates. As soon as this power passes out of the hands of
the working class, the revolution is doomed: the counter-revolution has begun
and it matters little that it is draped in a red flag. Hence anarchist
opposition to the state.

Sadly, many socialists have failed to recognise this. Hopefully we have shown
that the standard explanations of the failure of the Russian revolution are,
at their base, superficial and will only ensure that history will repeat
itself. For the idea that Bolshevik policies did not impact on the outcome of
the revolution is a false assertion, as the Makhnovists show (see the appendix
["Why does the Makhnovist movement show there is an alternative to
Bolshevism?"](append46.md)) and Leninists themselves implicitly admit.
Beliefs are utopian if subjective ideas are not grounded in objective reality.
Anarchists hold that part of the subjective conditions required before
socialism can exist is the existence of free exchange of ideas and working
class democracy (i.e. self-management). To believe that revolution is possible
without freedom, to believe those in power can, through their good intentions,
impose socialism from above, as the Bolsheviks did, is indeed utopian.

[‹ What was the Kronstadt Rebellion?](append42.md "Go to previous page")
[up](append4.md "Go to parent page") [How did Bolshevik ideology contribute
to the failure of the Revolution? ›](append44.md "Go to next page")

