#include <string>
#include <iostream>
#include <unistd.h>

class DBPooledConnection {

public:

  DBPooledConnection();
  virtual ~DBPooledConnection();
  string getId();
  void setId(string id);

  // Gestiona una conexin de usuario.
  virtual bool handleConnection(int socket) = 0;

  // Checks if the connection is alright (socket test).
  virtual bool checkConnection() = 0;

  // Checks if the connection is being used.
  virtual bool isFree() = 0;

 // Checks if the connection is valid (internal attribute).
  virtual bool isValid() = 0;

  // Checks if the connection is available for use, returning
  // "true" in that case, "false" in the other.

  virtual DBPooledConnection *usable() = 0;

  // Checks if the connection is available for test, returning
  // "true" in that case.

  virtual DBPooledConnection *testable() = 0;

  // Closes the connection, freeing it for another client.
  virtual void closeConnection() = 0;

private:

  string _id;

};

