;; Enable a outline minor mode with Python code
;; 
;; Copy this document inside your ".emacs".

;; arch-tag: 3726247d-4c34-4247-a9aa-c9bc43ee2346

(add-hook 'python-mode-hook 'my-python-hook)

; this gets called by outline to deteremine the level
; just use the length of the whitespace
(defun py-outline-level ()
  (let (buffer-invisibility-spec)
    (save-excursion
      (skip-chars-forward "\t ")
      (current-column))))

; this get called after python mode is enabled
(defun my-python-hook ()
  ; outline uses this regexp to find headers. I match lines with no
  ; indent and indented "class" and "def" lines.
  (setq outline-regexp "[^ \t\n]\\|[ \t]*\\(def\\|class\\) ")
  ; enable our level computation
  (setq outline-level 'py-outline-level)
  ; do not use their \C-c@ prefix, too hard to type. Note this
  ; overides some python mode bindings
  (setq outline-minor-mode-prefix "\C-c")
  ; turn on outline mode
  (outline-minor-mode t)
  ; initially hide all but the headers
  (hide-body))


