#ifndef _MPPLAY_H
#define _MPPLAY_H

struct mpeginfo
{
	uint32_t pos;
	uint32_t len;
	uint32_t timelen;
	uint32_t rate;
	int	 stereo;
	int      bit16;
};

extern int mpeg_Bitrate; /* bitrate of the last decoded frame */
extern unsigned char mpegOpenPlayer(FILE *, size_t offset, size_t fsize);
extern void mpegClosePlayer(void);
extern void mpegIdle(void);
extern void mpegSetLoop(uint8_t s);
extern char mpegIsLooped(void);
extern void mpegPause(uint8_t p);
extern void mpegSetAmplify(uint32_t amp);
extern void mpegSetSpeed(uint16_t sp);
extern void mpegSetVolume(uint8_t vol, int8_t bal, int8_t pan, uint8_t opt);
extern void mpegGetInfo(struct mpeginfo *);
extern int32_t mpegGetPos(void);
extern void mpegSetPos(int32_t pos);

#endif
