#ifndef __PFILESEL_H
#define __PFILESEL_H

#include <stdio.h> /* FILE * */

struct moduleinfostruct;
extern int fsGetNextFile(char *path, struct moduleinfostruct *info, FILE **); /* info comes from external buffer */
extern int fsFilesLeft(void);
extern signed int fsFileSelect(void);
/* extern char fsAddFiles(const char *);      use the playlist instead..*/
extern char fsInit(void);
extern void fsClose(void);

extern int fsListScramble;
extern int fsListRemove;
extern int fsLoopMods;
extern int fsScanNames;
extern int fsScanArcs;
extern int fsScanInArc;
extern int fsScanMIF;
extern int fsScrType;
extern int fsEditWin;
extern int fsColorTypes;
extern int fsInfoMode;
extern int fsPutArcs;
extern int fsWriteModInfo;
extern const char *(fsTypeNames[256]); /* type description */

extern void fsRegisterExt(const char *ext);
extern int fsIsModule(const char *ext);

struct preprocregstruct
{
	void (*Preprocess)(const char *path, struct moduleinfostruct *info, FILE **f);
	struct preprocregstruct *next;
};

struct filehandlerstruct
{
	int (*Process)(const char *path, struct moduleinfostruct *m, FILE **f);
};

struct interfacestruct
{
	int (*Init)(const char *path, struct moduleinfostruct *info, FILE **f);
	int (*Run)(void);
	void (*Close)(void);
};

#define RD_PUTSUBS 1
#define RD_ARCSCAN 2
#define RD_DIRRECURSE 4
#define RD_PUTRSUBS 16

#if 0
struct modlist;

extern char *dmGetPath(char *path, unsigned short ref);
extern unsigned short dmGetPathReference(const char *p);
extern unsigned short dmGetDriveDir(int drv);
#endif

#if 0
extern char mifMemRead(const char *name, unsigned short size, char *ptr);

struct fsgetfileregstruct
{
	void (*GetFile)(char *path, FILE **f);
	struct fsgetfileregstruct *next;
};

#endif
struct dmDrive
{
	char drivename[13];
	/*char currentpath[PATH_MAX+1];*/
	uint32_t basepath;
	uint32_t currentpath;
	struct dmDrive *next;
};
extern struct dmDrive *dmDrives;
extern struct dmDrive *RegisterDrive(const char *dmDrive);
extern struct dmDrive *dmFindDrive(const char *dmDrive); /* to get the correct drive from a given string */

void fsConvFileName12(char *c, const char *f, const char *e);
void convfilename12wc(char *c, const char *f, const char *e);
int fsMatchFileName12(const char *a, const char *b);

extern void fsSetup(void);
extern void fsRescanDir(void);

struct modlistentry;
extern int dosfile_Read(struct modlistentry *entry, char **mem, size_t *size); /* used by medialib */
extern int dosfile_ReadHeader(struct modlistentry *entry, char *mem, size_t *size); /* used by medialib */
extern FILE *dosfile_ReadHandle(struct modlistentry *entry);

#endif
