/***************************************************************************
                          settingsdialog.h  -  description
                             -------------------
    begin                : Sat Jan 11 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>

// Forward declarations
class Account;
class AccountsWidget;
class AlertsWidget;
class ChattingWidget;
class ChatLoggingWidget;
class EmailWidget;
class KConfig;
class ProxyWidget;
class ImageWidget;

/**
  *@author Mike K. Bennett
  */

class SettingsDialog : public KDialogBase
{
  Q_OBJECT

  public:
    // The constructor
  	                   SettingsDialog(QWidget *parent=0, const char *name=0);
    // The destructor
  	                  ~SettingsDialog();
    // Show the settings dialog for the given account
    void               changeAccountSettings(Account *account, bool isCurrentAccount);

  private: // Private methods
    // Get a font and cleaned-up font family from a dialog
    bool               getFont(QFont &font, QString &fontFamily) const;
    // Insert the given placeholder into the format box
    void               insertPlaceholder(const QString& placeholder);
    // Load account information into the account widget
    void               loadAccountsSettings(Account *account, bool isCurrentAccount);
    // Load account information into the alerts widget
    void               loadAlertsSettings(Account *account);
    // Load account information into the chatting widget
    void               loadChattingSettings(Account *account);
    // Load account information into the chat logging widget
    void               loadChatLoggingSettings(Account *account);
    // Load account information into the email widget
    void               loadEmailSettings(Account *account);
    //Load account info for proxy
    void               loadProxySettings(Account *account);
    // Load account info for display picture
    void               loadImageSettings(Account *account);
    // Do some effects characters (ie, bold, underline and italic specials) - taken wholly from chat view
    void               parseEffects(QString &text) const;
    // Parse a message, using simple rules, to show a preview of the chat
    QString            parseMessage( QString name, QString message, const QString& format, bool isUser );
    // Read options from the configuration file.
    void               readOptions();
    // Save account information from the account widget
    void               saveAccountsSettings(Account *account);
    // Save account information from the alerts widget
    void               saveAlertsSettings(Account *account);
    // Save account information from the chatting widget
    void               saveChattingSettings(Account *account);
    // Save account information from the chat logging widget
    void               saveChatLoggingSettings(Account *account);
    // Save account information from the email widget
    void               saveEmailSettings(Account *account);
    // Save account information from the proxy widget
    void               saveProxySettings(Account *account);
    // Save account information from the image widget
    void               saveImageSettings(Account *account);
    // Save the options.
    void               saveOptions();
    // Save all widget settings
    void               saveAccountSettings();

  private slots: // Private slots
    // Get a directory from the user.
    void               chooseDirectory();
    // Save the window options before closing.
    void               closeEvent(QCloseEvent *event);
    // The contact font button was pressed.  Show a font dialog to get a new font.
    void               contactFontClicked();
    // The font button was pressed.  Show a font dialog to get a new font.
    void               fontClicked();
    // Insert the {message} placeholder into the format box
    void               insertMessage();
    // Insert the {name} placeholder into the format box
    void               insertName();
    // Insert the {time} placeholder into the format box
    void               insertTime();
    // The "preview" button was pressed.  Preview the chat format.
    void               previewClicked();
    // Reset the message format to the default
    void               resetFormat();
    // The apply button was clicked.  Apply the changes.
    void               slotApply();
    // The cancel button was clicked.  Close the dialog.
    void               slotCancel();
    // The OK button was pressed.  Apply the changes and close.
    void               slotOk();
    // The delete button was pressed.
    void               slotUser1();
    // Enable or disable the contact font and color selectors.
    void               useContactFontToggled(bool checked);
    // Enable or disable the sub-notification depending on the overall notification.
    void               useNotificationsToggled(bool checked);

  private: // Private attributes
    // The account being edited
    Account           *account_;
    // The configuration file from which window size is loaded from and saved to
    KConfig           *config_;
    // The widget for entering profile data (handle, name, password).
    AccountsWidget    *accountsWidget_;
    // The widget for selecting idle timer and notification timer durations.
    AlertsWidget      *alertsWidget_;
    // The widget for selecting the user's font.
    ChattingWidget    *chattingWidget_;
    // A widget for chat logging settings
    ChatLoggingWidget *chatLoggingWidget_;
    // The widget for selecting information about email notifications
    EmailWidget       *emailWidget_;
    // The widget for changing proxy settings
    ProxyWidget       *proxyWidget_;
    // The widget for changing image settings
    ImageWidget       *imageWidget_;
  signals:
    // Request that the given account be deleted
    void               deleteAccount(Account *account);
};

#endif
