/***************************************************************************
                          emailnotification.h  -  description
                             -------------------
    begin                : Fri Jan 31 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EMAILNOTIFICATION_H
#define EMAILNOTIFICATION_H

#include <qwidget.h>
#include "popupnotification.h"

// Forward declarations
class CurrentAccount;
class BalloonWidget;
class NotificationWidget;
class QStringList;

/**This notifies the user when a new email is received.
  *@author Mike K. Bennett
  */

class EmailNotification : public QObject
{
  Q_OBJECT

  public:
    // The constructor
  	           EmailNotification( BalloonWidget *balloonWidget );
    // The destructor
  	          ~EmailNotification();

  public slots:
    // Called when a new email is received
    void       newEmail(QString sender, QString subject, bool inInbox, QString command, QString folder, QString url);

  private slots: // Private slots
    // The balloon was clicked
    void       clicked( QStringList stringList, QObject *object );

  private: // Private attributes
     // Balloon Widget
    BalloonWidget            *balloonWidget_;
    // Not. Widget
    NotificationWidget       *notificationWidget_;
    // Current Account
    const CurrentAccount     *currentAccount_;
    // The email command, folder, and url, used to access the email directly in Hotmail
    QString    command_, folder_, url_;

};

#endif
