/***************************************************************************
                          contactofflinenotification.cpp  -  description
                             -------------------
    begin                : Fri Jan 31 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contactofflinenotification.h"

#include <qpixmap.h>

#include <kdebug.h>
#include <kiconloader.h>
#include <klocale.h>
#include <knotifyclient.h>

#include "../contact/contact.h"
#include "../currentaccount.h"
#include "../systemtraywidget.h"

#include "balloonwidget.h"
#include "notificationwidget.h"
#include "notificationitem.h"

// The constructor
ContactOfflineNotification::ContactOfflineNotification( BalloonWidget *balloonWidget )
 : balloonWidget_( balloonWidget )
{
  currentAccount_ = CurrentAccount::instance();

  notificationWidget_ = new NotificationWidget( balloonWidget );
  notificationWidget_->setCaption( i18n( "The following people are offline" ) );

  notificationWidget_->setPaletteBackgroundColor( "#FFC0CD" );
}



// The destructor
ContactOfflineNotification::~ContactOfflineNotification()
{
#ifdef KMESSDEBUG_CONTACTOFFLINENOTIFICATION
  kdDebug() << "DESTROYED ContactOfflineNotification" << endl;
#endif
}



// The balloon was clicked
void ContactOfflineNotification::balloonClicked()
{
  // Do nothing.
}



// Called when a contact goes offline
void ContactOfflineNotification::contactOffline(Contact *contact, bool showBaloon)
{
#ifdef KMESSTEST
  ASSERT( contact != 0 );
  ASSERT( currentAccount_ != 0 );
#endif
  if ( contact == 0 )
  {
    kdDebug() << "ContactOfflineNotification::contactOffline() - WARNING - Contact is null!" << endl;
    return;
  }
  if ( currentAccount_->getShowOfflineNotification() )
  {
    if ( contact->getExtension()->getNotifyOnline() && showBaloon )
    {
      QPixmap      pixmap;
      QString      text;
      KIconLoader *loader = KGlobal::iconLoader();

      // Try to get the contact's picture
      pixmap.load( contact->getContactPicturePath() );
      // If the pixmap couldn't be loaded, use the generic "offline" icon
      if ( pixmap.isNull() )
      {
        pixmap = loader->loadIcon("offline", KIcon::User);
      }
      // Make the message
      text = i18n("%1 is offline").arg( contact->getFriendlyName() );
      // Show the popup balloon
      //showBalloon( text, pixmap, "#FFC0CD" );
      new NotificationItem( notificationWidget_, 0, contact->getFriendlyName(), contact->getContactPicturePath() );

      // Send a system notification.
      KNotifyClient::event( "contact offline", text );
    }
  }
}

#include "contactofflinenotification.moc"
