/***************************************************************************
                          transferentry.h  -  description
                             -------------------
    begin                : Wed Nov 3 2004
    copyright            : (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSFERENTRY_H
#define TRANSFERENTRY_H

#ifndef TRANSFERENTRYINTERFACE_H
// Weird but it's required, g++ can't find this file
// if it's included from applications/transferfile.cpp
#include "transferentryinterface.h"
#endif

class TransferEntry : public TransferEntryInterface
{
  Q_OBJECT

public:
    // Constructor
    TransferEntry(QWidget *parent, const char *name, const QString &filename, const uint filesize, bool incoming = false);
    // Constructor
    TransferEntry(const QString &filename, const uint filesize, bool incoming = false);
    // Destructor
    virtual ~TransferEntry();

    // Returns true is the transfer is either cancelled or completed
    bool isDone() const;
    // Returns the file name
    QString getFileName() const;

    // Nice formatting of the bytes
    static QString toReadableBytes(uint bytes);

  private:
    // Initialize the widgets
    void initializeWidgets();

public slots:
    // The cancel link was pressed
    virtual void cancelClicked();
    // Mark the transfer as failed
    void failTransfer(const QString &message = 0);
    // Mark the transfer as complete
    void finishTransfer();
    // The open link was pressed
    virtual void openClicked();
    // Set a status message
    void setStatusMessage(const QString &message);
    // Update the progress bar
    void updateProgress(uint bytesTransferred);

signals:
    // Emit a request to cancel the transfer
    void cancelTransfer();

private:
    // Indicate the transfer is done (cancelled or complete)
    bool    isDone_;
    // Indicate this is an incoming transfer (shows the open label)
    bool    incoming_;
    // The file name
    QString filename_;
    // The file size
    uint    filesize_;
};

#endif
