/***************************************************************************
                          emoticonchooser.h  -  description
                             -------------------
    begin                : Mon May 6 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EMOTICONCHOOSER_H
#define EMOTICONCHOOSER_H

#include <qdialog.h>
#include <qwidget.h>

// forward declarations
class Emoticon;
class EmoticonButton;
class QEvent;
class QMouseEvent;

/**This is the popup window from which emoticons are selected.
  *@author Mike K. Bennett
  */

class EmoticonChooser : public QDialog
{
   Q_OBJECT

  public:
  	                   EmoticonChooser(QWidget *parent=0, const char *name=0);
  	                  ~EmoticonChooser();
    // Create an emoticon button on this dialog.
    void               createEmoticonButton(const Emoticon *emoticon);
    // Show the dialog at the given position
    void               popup ( const QPoint & pos, int indexAtPoint = 0 );

  private slots: // Private slots
    // Hide the dialog when the user has moved his or her mouse off it.
    void               leaveEvent ( QEvent * );
    // Signal (presumably to the chat view) to insert the emoticon.
    void               requestInsertEmoticon(QString html);

  private: // Private attributes
    // The number of buttons on the form.
    unsigned int       buttonCount_;
    // The height of an emoticon button.
    const unsigned int buttonHeight_;
    // The number of emoticon buttons in a row.
    const unsigned int buttonsPerRow_;
    // The width of an emoticon button.
    const unsigned int buttonWidth_;
    // The number of columns of emoticon buttons.
    unsigned int       nCols_;
    // The number of rows of emoticon buttons.
    unsigned int       nRows_;

  signals: // Signals
    // Request that the emoticon's html code be inserted in the message.
    void               insertEmoticon(QString html);
};

#endif
