/*
 * download.h
 *
 * Copyright (C) 2003 Bastian Blank <waldi@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $LastChangedBy: bastian $
 * $LastChangedDate: 2005-07-01 20:21:31 +0200 (Fr, 01 Jul 2005) $
 * $LastChangedRevision: 1007 $
 */

#ifndef DOWNLOAD_H
#define DOWNLOAD_H

#include <debian-installer.h>

#include <stdio.h>

#include "install.h"
#include "packages.h"
#include "suite.h"

static inline int build_target_deb_root (char *buf, size_t size, const char *file)
{
  snprintf (buf, size, "/var/cache/bootstrap/%s", file);
  return 0;
}

static inline int build_target_deb (char *buf, size_t size, const char *file)
{
  snprintf (buf, size, "%s/var/cache/bootstrap/%s", install_root, file);
  return 0;
}

static inline int build_source_indices_packages (char *buf, size_t size)
{
  snprintf (buf, size, "dists/%s/main/binary-%s/Packages", suite_name, arch);
  return 0;
}

static inline int build_target_indices_packages (char *buf, size_t size)
{
  snprintf (buf, size, "%s/var/cache/bootstrap/Packages", install_root);
  return 0;
}

static inline int build_source_indices_release (const char *ext, char *buf, size_t size)
{
  snprintf (buf, size, "dists/%s/Release%s", suite_name, ext);
  return 0;
}

static inline int build_target_indices_release (const char *ext, char *buf, size_t size)
{
  snprintf (buf, size, "%s/var/cache/bootstrap/Release%s", install_root, ext);
  return 0;
}

int download (di_packages **packages, di_packages_allocator *allocator, di_slist **install);

int download_init (void);

#endif
