from bzrlib.tests.blackbox import ExternalBase
from unittest import makeSuite
import os.path
class TestBzrTools(ExternalBase):
    @staticmethod
    def touch(filename):
        file(filename, 'wb').write('')

    def test_clean_tree(self):
        self.runbzr('init')
        self.touch('name')
        self.touch('name~')
        assert os.path.lexists('name~')
        self.touch('name.pyc')
        self.runbzr('clean-tree')
        assert os.path.lexists('name~')
        assert not os.path.lexists('name')
        self.runbzr('clean-tree --detritus')
        assert not os.path.lexists('name~')
        assert os.path.lexists('name.pyc')
        self.runbzr('clean-tree --ignored')
        assert not os.path.lexists('name.pyc')

    def test_shelve(self):
        self.runbzr('init')
        self.runbzr('commit -m uc --unchanged')
        self.runbzr('shelve -r 1 -m foo --all', retcode=3)
        file('foo', 'wb').write('foo')
        self.runbzr('add foo')
        self.runbzr('commit -m foo')
        self.runbzr('shelve -r 1 -m foo --all', retcode=0)

    def test_fetch_ghosts(self):
        self.runbzr('init')
        self.runbzr('fetch-ghosts .')

    def test_patch(self):
        self.runbzr('init')
        file('myfile', 'wb').write('hello')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        file('myfile', 'wb').write('goodbye')
        file('mypatch', 'wb').write(self.runbzr('diff', retcode=1, backtick=1))
        self.runbzr('revert')
        assert file('myfile', 'rb').read() == 'hello'
        self.runbzr('patch mypatch')
        assert file('myfile', 'rb').read() == 'goodbye'

    def test_branch_history(self):
        self.runbzr('init')
        file('myfile', 'wb').write('hello')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        self.runbzr('branch-history')

    def test_branch_history(self):
        self.runbzr('init')
        file('myfile', 'wb').write('hello')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        self.runbzr('graph-ancestry . graph.dot')
        self.runbzr('branch . my_branch')
        self.runbzr('graph-ancestry . graph.dot --merge-branch my_branch')

    def test_fetch_ghosts(self):
        self.runbzr('init')
        file('myfile', 'wb').write('hello')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        self.runbzr('branch . my_branch')
        self.runbzr('fetch-ghosts my_branch')

    def test_zap(self):
        self.runbzr('init source')
        self.runbzr('checkout --lightweight source checkout')
        self.runbzr('zap checkout')
        self.assertIs(False, os.path.exists('checkout'))
        self.assertIs(True, os.path.exists('source'))

    def test_zap_branch(self):
        self.runbzr('init source')
        self.runbzr('checkout --lightweight source checkout')
        self.runbzr('zap --branch checkout')
        self.assertIs(False, os.path.exists('checkout'))
        self.assertIs(False, os.path.exists('source'))

    def test_branches(self):
        self.runbzr('init source')
        self.runbzr('init source/subsource')
        self.runbzr('checkout --lightweight source checkout')
        self.runbzr('init checkout/subcheckout')
        self.runbzr('init checkout/.bzr/subcheckout')
        out = self.capture('branches')
        lines = out.split('\n')
        self.assertIs(True, 'source' in lines)
        self.assertIs(True, 'source/subsource' in lines)
        self.assertIs(True, 'checkout/subcheckout' in lines)
        self.assertIs(True, 'checkout' not in lines)
        self.assertIs(True, 'checkout/.bzr/subcheckout' not in lines)

def test_suite():
    return makeSuite(TestBzrTools)
