/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.rbp;

import ca.odell.glazedlists.impl.ctp.CTPConnectionManager;
import ca.odell.glazedlists.impl.ctp.CTPHandler;
import ca.odell.glazedlists.impl.ctp.CTPHandlerFactory;
import ca.odell.glazedlists.impl.rbp.PeerConnection;
import ca.odell.glazedlists.impl.rbp.PeerResource;
import ca.odell.glazedlists.impl.rbp.Resource;
import ca.odell.glazedlists.impl.rbp.ResourceStatus;
import ca.odell.glazedlists.impl.rbp.ResourceUri;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class Peer
implements CTPHandlerFactory {
    private static Logger logger = Logger.getLogger(Peer.class.toString());
    Map subscribed = new TreeMap();
    Map published = new TreeMap();
    List connections = new ArrayList();
    private CTPConnectionManager connectionManager;

    public Peer(int listenPort) {
        this.connectionManager = new CTPConnectionManager(this, listenPort);
    }

    public CTPHandler constructHandler() {
        PeerConnection incoming = new PeerConnection(this);
        this.connections.add(incoming);
        return incoming;
    }

    public void start() throws IOException {
        this.connectionManager.start();
    }

    public void stop() {
        this.connectionManager.getNIODaemon().invokeAndWait(new StopRunnable());
    }

    public void print() {
        PeerResource resource;
        System.out.println(" --------  --------  --------  --------  --------  --------  --------  -------- ");
        System.out.println("Subscribed Resources:");
        Iterator<Object> s = this.subscribed.values().iterator();
        while (s.hasNext()) {
            resource = (PeerResource)s.next();
            resource.print();
        }
        System.out.println("");
        System.out.println("Published Resources:");
        s = this.published.values().iterator();
        while (s.hasNext()) {
            resource = (PeerResource)s.next();
            resource.print();
        }
        System.out.println("");
        System.out.println("Connections:");
        s = this.connections.iterator();
        while (s.hasNext()) {
            PeerConnection connection = (PeerConnection)s.next();
            connection.print();
        }
        System.out.println("");
    }

    public ResourceStatus subscribe(Resource resource, String host, int port, String path) {
        PeerResource peerResource = new PeerResource(this, resource, ResourceUri.remote(host, port, path));
        return peerResource.status();
    }

    public ResourceStatus publish(Resource resource, String path) {
        PeerResource peerResource = new PeerResource(this, resource, ResourceUri.local(path));
        return peerResource.status();
    }

    PeerResource getPublishedResource(ResourceUri resourceUri) {
        return (PeerResource)this.published.get(resourceUri);
    }

    PeerConnection getConnection(String host, int port) {
        PeerConnection peerConnection = new PeerConnection(this);
        this.connectionManager.connect(peerConnection, host, port);
        this.connections.add(peerConnection);
        return peerConnection;
    }

    void invokeLater(Runnable runnable) {
        this.connectionManager.getNIODaemon().invokeLater(runnable);
    }

    private class StopRunnable
    implements Runnable {
        private StopRunnable() {
        }

        public void run() {
            Iterator s = Peer.this.subscribed.values().iterator();
            while (s.hasNext()) {
                PeerResource resource = (PeerResource)s.next();
                resource.status().disconnect();
            }
            Peer.this.subscribed.clear();
            logger.warning("Closing with published entries");
            ArrayList connectionsToClose = new ArrayList();
            connectionsToClose.addAll(Peer.this.connections);
            Iterator c = connectionsToClose.iterator();
            while (c.hasNext()) {
                PeerConnection connection = (PeerConnection)c.next();
                connection.close();
            }
            Peer.this.connectionManager.stop();
        }
    }
}

