/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.gradienteditor;

import com.michaelbaranov.microba.Microba;
import com.michaelbaranov.microba.gradient.GradientBar;
import com.michaelbaranov.microba.gradienteditor.DefaultGradientEditorModel;
import com.michaelbaranov.microba.marker.MarkerMutationModel;
import javax.swing.ListSelectionModel;

public class GradientEditor
extends GradientBar {
    public static final String PROPERTY_COLOR_SELECTION_MODEL = "colorSelectionModel";
    public static final String PROPERTY_ALPHA_SELECTION_MODEL = "alphaSelectionModel";
    public static final String PROPERTY_COLOR_MUTATION_MODEL = "colorMutationModel";
    public static final String PROPERTY_ALPHA_MUTATION_MODEL = "alphaMutationModel";
    private static final String uiClassID = "microba.GradientEditorUI";
    private ListSelectionModel colorSelectionModel = null;
    private ListSelectionModel alphaSelectionModel = null;
    private MarkerMutationModel colorMutationModel = null;
    private MarkerMutationModel alphaMutationModel = null;

    public GradientEditor() {
        DefaultGradientEditorModel defaultGradientEditorModel = new DefaultGradientEditorModel();
        this.dataModel = defaultGradientEditorModel;
        this.colorSelectionModel = defaultGradientEditorModel;
        this.colorMutationModel = defaultGradientEditorModel;
        this.setFocusable(true);
        this.updateUI();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public MarkerMutationModel getColorMutationModel() {
        return this.colorMutationModel;
    }

    public void setColorMutationModel(MarkerMutationModel mutationModel) {
        MarkerMutationModel oldMutationModel = this.colorMutationModel;
        this.colorMutationModel = mutationModel;
        this.firePropertyChange(PROPERTY_COLOR_MUTATION_MODEL, oldMutationModel, mutationModel);
    }

    public ListSelectionModel getColorSelectionModel() {
        return this.colorSelectionModel;
    }

    public void setColorSelectionModel(ListSelectionModel selectionModel) {
        ListSelectionModel oldSelectionModel = this.colorSelectionModel;
        this.colorSelectionModel = selectionModel;
        this.firePropertyChange(PROPERTY_COLOR_SELECTION_MODEL, oldSelectionModel, selectionModel);
    }

    public ListSelectionModel getAlphaSelectionModel() {
        return this.alphaSelectionModel;
    }

    public void setAlphaSelectionModel(ListSelectionModel selectionModel) {
        this.alphaSelectionModel = selectionModel;
    }

    public MarkerMutationModel getAlphaMutationModel() {
        return this.alphaMutationModel;
    }

    public void setAlphaMutationModel(MarkerMutationModel mutationModel) {
        this.alphaMutationModel = mutationModel;
    }

    static {
        Microba.init();
    }
}

