/* $Id: icmp_echo.c,v 1.9 2001/10/20 15:23:55 fygrave Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"

rpack_t *send_icmpecho_req(struct sockaddr_in to) {
    
    return(send_icmpecho_var_req( to, IP_DF));
}

rpack_t *send_icmpecho_var_req(struct sockaddr_in to, int bits) {

    int sndsock;
    int res;
    struct ip *ip;
    struct icmp *icmp;
    unsigned char *pack, *recv_pack;
    int on = 1;
    int packlen;
    rpack_t *retval = NULL;

    if ((sndsock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0) { 
        perror("Can not open raw socket:");
        exit(1);
    }
    
    if (setsockopt(sndsock, IPPROTO_IP, IP_HDRINCL, (char *)&on,
                   sizeof(on)) < 0) {
        perror("IP_HDRINCL");
        exit(1);
    }

    packlen = sizeof(struct ip) + sizeof(struct icmp) + DATA_SIZE;

    if((pack = (unsigned char *)calloc( packlen, 1)) == NULL) {
        perror("calloc");
        exit(1);
    }

    ip = (struct ip *)pack;
    icmp = (struct icmp *)(pack + sizeof(struct ip));
    make_ippkt(ip, IPPROTO_ICMP, interf.addr, to.sin_addr,
                packlen, bits, 6);
    
    icmp->icmp_type = ICMP_ECHO;
    icmp->icmp_code = 123; /* ! */
    icmp->icmp_seq = rand();
    icmp->icmp_id = rand();
    icmp->icmp_cksum = in_cksum((unsigned short *)icmp,
                                DATA_SIZE + sizeof(struct icmp));
    if (icmp->icmp_cksum == 0)
        icmp->icmp_cksum = 0xffff;
    
    log_message("[send]-> ICMP echo request to %s ",
                                            inet_ntoa(to.sin_addr));
    
   res = sendto(sndsock, (void *)pack, packlen,
                0, (struct sockaddr *)&to, sizeof(struct sockaddr));

   if (res <0) {
       perror("sendto:");
       close(sndsock);
       free(pack);
       return NULL;
   }
   log_message("[%d bytes] sent, waiting for response.", res);

   recv_pack = read_icmp(&res, ICMP_ECHOREPLY, -1);

   if (recv_pack == NULL || res < sizeof(ip) + 8) {
       fprintf(stderr,"Receive timeout. Quitting..\n");
       close(sndsock);
       free(pack);
       return NULL;
   }


  if ((retval=calloc(sizeof(rpack_t), 1)) == NULL) {
       perror("calloc");
       exit(1);
   }

   retval->packsize = res;

   if((retval->pkt = calloc(res, 1)) == NULL) {
       perror("calloc");
       exit(1);
   }
   memcpy((void *)retval->pkt, (void *)recv_pack, res);

   
#ifdef DEBUG
   fprintf(stderr,"Received %d bytes packet.\n", res);
   hexdump(recv_pack, res);
   fprintf(stderr,"\n----\n");
   hexdump(retval->pkt, res);
#endif    
 
   retval->ip = (struct ip *)retval->pkt;
 /* sanity checks */

#ifdef DEBUG
    fprintf(stderr, "hlen: %d\nlen: %d\n", retval->ip->ip_hl<<2, htons(retval->ip->ip_len));
#endif    
    
   if (res < sizeof(struct ip)      ||
       (retval->ip->ip_hl << 2) > res ||
       ntohs(retval->ip->ip_len) > res ) {
       fprintf(stderr,"Received maliformed packet!\n");
       close(sndsock);
       free(pack);
       free(retval->pkt);
       free(retval);
       return NULL;
   }

   retval->icmp = (struct icmp *)((VOIDPTR_T)retval->pkt + (VOIDPTR_T)(retval->ip->ip_hl<<2));

#ifdef DEBUG
   fprintf(stderr,"type: %d code: %d\n", retval->icmp->icmp_type, retval->icmp->icmp_code);
#endif   
          
/*    if (rcv_icmp->icmp_type != ICMP_ECHOREPLY) { 
       fprintf(stderr, "Received datagram is not ICMP echo reply\n");
       close(sndsock);
       close(rcvsock);
       free(pack);
       free(recv_pack);
       return NULL;
   }
*/

    retval->orig_pkt = NULL;
   close(sndsock);
   free(pack);
   return retval;

}

int wait_icmp(int sock, struct sockaddr_in *from, unsigned char *pack,
int packlen) {

    struct timeval wait;
    fd_set fds;
    int fromlen = sizeof(*from);
    ssize_t cc=0;

    wait.tv_sec=receive_timeout;
    wait.tv_usec=0;

    FD_ZERO(&fds);
    FD_SET(sock, &fds);


   if (select(sock+1, &fds, (fd_set *)0, (fd_set *)0, &wait) > 0)
            cc=recvfrom(sock, (char *)pack, packlen, 0,
                        (struct sockaddr *)from, &fromlen);

#ifdef DEBUG   
   if(cc>0) 
       hexdump((void *)pack, cc);
#endif       
   return((int)cc);
}

