/*
 * Copyright 2021 Zebediah Figura
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_OPENCL_PRIVATE_H
#define __WINE_OPENCL_PRIVATE_H

#include <stdarg.h>
#include <stdint.h>
#include <stdlib.h>

#include "ntstatus.h"
#define WIN32_NO_STATUS
#include "windef.h"
#include "winbase.h"
#include "winternl.h"
#include "wine/unixlib.h"
#include "wine/debug.h"

BOOL extension_is_supported( const char *name, size_t len ) DECLSPEC_HIDDEN;

extern unixlib_handle_t opencl_handle DECLSPEC_HIDDEN;

#define OPENCL_CALL( func, params ) __wine_unix_call( opencl_handle, unix_ ## func, params )

#endif
