/* Page block renderer.

   Copyright (C) 2000 Daiki Ueno <ueno@unixuser.org>

   Author: Daiki Ueno <ueno@unixuser.org>
   Created: 2000-05-16

   This file is part of UltraPoint.

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)  
   any later version.                                                   

   This program is distributed in the hope that it will be useful,      
   but WITHOUT ANY WARRANTY; without even the implied warranty of       
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the        
   GNU General Public License for more details.                         

   You should have received a copy of the GNU General Public License    
   along with GNU Emacs; see the file COPYING.  If not, write to the    
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
   Boston, MA 02111-1307, USA.                                          

*/

#ifndef __UPT_PAGE_H_
#define __UPT_PAGE_H_

typedef struct _UptPage UptPage;

#include "glyph.h"
#include "canvas.h"

struct _UptPage {
  glong base_width, base_height;
  gdouble base_lineskip;
  UptGlue *base_glue;
  UptFont *base_font;

  gboolean antialias;
  glong width, height;
  guint8 *pbuf;

  gint font_pixel_size;

  GSList *glyphs;

  gint ref_count;
  GFreeFunc free;
};

UptPage *upt_page_new (glong base_width, glong base_height,
		       UptGlue *base_glue, gdouble base_lineskip,
		       UptFont *base_font, gboolean aa);

void upt_page_add_glyph (UptPage *page, UptGlyph *glyph);

void upt_page_add_text (UptPage *page, guchar *utf);

void upt_page_instantiate (UptCanvas *canvas, UptPage *page);
void upt_page_get_metric (UptPage *page, glong *bbx_width, glong *bbx_height);

#endif
