/* This file is part of the Spring engine (GPL v2 or later), see LICENSE.html */

#include <SDL.h>

#include "SplashScreen.hpp"
#include "Rendering/GlobalRendering.h"
#include "Rendering/GL/myGL.h"
#include "Rendering/GL/RenderDataBuffer.hpp"
#include "Rendering/Fonts/glFont.h"
#include "Rendering/Textures/Bitmap.h"
#include "System/float4.h"
#include "System/Matrix44f.h"
#include "System/FileSystem/ArchiveScanner.h"

#ifndef HEADLESS
// identity projection
#if 0
static constexpr VA_TYPE_T QUAD_ELEMS[] = {
#else
static VA_TYPE_T QUAD_ELEMS[] = {
#endif
	{{-1.0f,  1.0f, 0.0f},   0.0f, 0.0f},
	{{-1.0f, -1.0f, 0.0f},   0.0f, 1.0f},
	{{ 1.0f, -1.0f, 0.0f},   1.0f, 1.0f},
	{{ 1.0f,  1.0f, 0.0f},   1.0f, 0.0f},
};

static constexpr uint32_t QUAD_INDCS[] = {0, 1, 2,   2, 3, 0};


static constexpr uint32_t LOGO_SIZE_X = 119;
static constexpr uint32_t LOGO_SIZE_Y = 119;
static constexpr uint8_t LOGO_PIXELS[] = {
	216, 220, 226, 102, 119, 143, 82, 102, 129, 82, 102, 129, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 103, 129, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 104, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 129, 82, 102, 129, 82, 102, 129, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 127, 81, 101, 127, 81, 101, 127, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 81, 101, 126, 79, 100, 125, 27, 59, 99, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 56, 97, 23, 55, 96, 22, 55, 95, 22, 54, 94, 22, 54, 92, 22, 52, 91, 21, 51, 88, 21, 50, 87, 21, 50, 86, 21, 50, 86, 21, 50, 86, 49, 75, 107, 194, 202, 211,
	100, 118, 142, 82, 102, 129, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 103, 129, 82, 103, 130, 82, 103, 130, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 104, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 81, 102, 128, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 81, 102, 127, 84, 104, 128, 29, 64, 106, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 60, 104, 23, 59, 103, 23, 59, 102, 23, 58, 100, 23, 57, 99, 22, 56, 97, 22, 55, 95, 22, 53, 92, 21, 51, 89, 21, 50, 86, 21, 50, 86, 21, 50, 86, 56, 81, 111,
	82, 102, 129, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 103, 130, 82, 104, 130, 82, 104, 131, 82, 104, 132, 82, 104, 132, 82, 104, 132, 82, 104, 132, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 104, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 86, 105, 129, 35, 70, 113, 24, 63, 110, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 111, 25, 63, 110, 25, 63, 109, 24, 62, 108, 24, 62, 107, 24, 60, 105, 24, 59, 103, 23, 58, 101, 23, 56, 97, 22, 54, 94, 22, 51, 90, 21, 51, 86, 21, 50, 86, 21, 50, 86,
	82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 103, 130, 82, 103, 130, 82, 104, 131, 82, 104, 132, 82, 104, 132, 82, 104, 132, 82, 104, 132, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 85, 104, 129, 40, 75, 119, 24, 66, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 67, 116, 25, 66, 115, 25, 66, 114, 25, 64, 113, 24, 63, 111, 24, 62, 109, 24, 61, 105, 23, 58, 102, 23, 57, 99, 22, 54, 94, 22, 52, 90, 21, 50, 86, 21, 50, 86,
	82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 104, 131, 82, 104, 131, 82, 104, 132, 82, 104, 132, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 85, 104, 128, 43, 79, 123, 26, 69, 121, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 122, 26, 69, 121, 26, 69, 122, 26, 68, 121, 26, 68, 119, 25, 67, 118, 25, 66, 116, 25, 64, 114, 24, 63, 110, 24, 60, 106, 23, 59, 102, 23, 57, 99, 22, 54, 94, 22, 51, 89, 21, 50, 86,
	82, 102, 128, 82, 102, 128, 82, 103, 129, 82, 103, 130, 82, 104, 130, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 104, 131, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 85, 104, 129, 45, 82, 127, 26, 71, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 27, 72, 127, 26, 72, 126, 26, 71, 125, 26, 71, 124, 26, 69, 122, 26, 68, 120, 25, 67, 117, 25, 65, 114, 24, 63, 110, 24, 60, 106, 23, 59, 102, 22, 56, 97, 22, 53, 91, 21, 50, 87,
	82, 102, 128, 82, 102, 128, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 130, 85, 104, 130, 45, 83, 130, 26, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 131, 27, 74, 130, 27, 73, 129, 27, 72, 128, 27, 72, 126, 26, 70, 124, 26, 69, 121, 26, 67, 117, 25, 65, 114, 24, 63, 110, 24, 60, 105, 23, 57, 100, 22, 55, 94, 21, 51, 88,
	81, 102, 127, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 103, 130, 82, 102, 130, 82, 103, 130, 82, 103, 130, 81, 103, 130, 78, 101, 131, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 75, 101, 132, 76, 101, 132, 76, 101, 132, 76, 101, 132, 76, 101, 132, 76, 101, 132, 76, 101, 132, 76, 101, 132, 76, 101, 132, 79, 103, 132, 34, 81, 134, 19, 74, 137, 19, 74, 137, 19, 74, 137, 19, 74, 137, 19, 74, 137, 19, 74, 137, 19, 74, 137, 19, 74, 137, 19, 74, 137, 19, 74, 137, 20, 76, 139, 20, 77, 140, 20, 77, 140, 20, 77, 140, 20, 77, 140, 20, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 77, 140, 21, 78, 140, 21, 78, 140, 21, 78, 140, 22, 78, 140, 22, 78, 140, 22, 78, 140, 22, 78, 139, 22, 77, 138, 23, 76, 135, 27, 74, 130, 27, 72, 127, 26, 70, 124, 26, 69, 121, 26, 66, 118, 25, 65, 113, 24, 62, 108, 23, 59, 103, 23, 56, 97, 21, 52, 90,
	81, 102, 127, 82, 102, 128, 82, 102, 129, 82, 102, 129, 82, 102, 130, 82, 102, 130, 82, 102, 130, 82, 102, 129, 82, 103, 130, 82, 102, 130, 101, 105, 125, 184, 119, 105, 233, 128, 92, 241, 129, 91, 240, 129, 91, 240, 129, 91, 240, 129, 91, 240, 129, 91, 240, 129, 91, 240, 129, 91, 240, 129, 91, 239, 129, 91, 238, 129, 91, 238, 128, 91, 238, 128, 91, 238, 128, 91, 238, 127, 91, 238, 127, 91, 237, 127, 91, 237, 127, 91, 237, 127, 91, 236, 127, 91, 236, 127, 91, 235, 126, 91, 235, 126, 91, 234, 126, 91, 234, 125, 91, 234, 125, 91, 233, 124, 91, 233, 124, 91, 231, 124, 91, 231, 124, 91, 232, 124, 91, 231, 123, 90, 229, 123, 90, 229, 123, 90, 228, 122, 91, 228, 122, 90, 228, 122, 90, 227, 122, 90, 227, 121, 90, 226, 121, 90, 226, 121, 90, 225, 120, 90, 225, 120, 90, 223, 119, 90, 223, 119, 90, 223, 119, 90, 222, 119, 90, 222, 119, 90, 221, 118, 90, 221, 118, 89, 220, 118, 89, 219, 117, 90, 219, 117, 90, 219, 116, 89, 218, 116, 90, 217, 115, 90, 216, 115, 90, 215, 114, 89, 215, 114, 89, 214, 114, 89, 213, 114, 89, 213, 113, 88, 201, 72, 41, 195, 55, 21, 193, 54, 21, 193, 54, 21, 192, 53, 21, 191, 53, 21, 190, 52, 21, 190, 52, 20, 188, 51, 20, 187, 51, 21, 187, 50, 20, 186, 50, 20, 185, 50, 20, 184, 49, 20, 183, 49, 20, 182, 48, 20, 181, 47, 20, 181, 47, 20, 179, 45, 20, 179, 45, 20, 178, 45, 20, 177, 44, 20, 175, 44, 19, 174, 43, 19, 174, 43, 19, 172, 42, 19, 172, 41, 19, 171, 41, 19, 169, 41, 19, 169, 40, 19, 168, 40, 19, 167, 40, 19, 167, 39, 19, 160, 40, 23, 116, 51, 60, 44, 71, 118, 27, 74, 130, 27, 72, 127, 26, 70, 124, 26, 68, 120, 25, 66, 116, 24, 63, 111, 24, 60, 105, 23, 57, 98, 22, 53, 92,
	81, 102, 127, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 130, 82, 102, 130, 113, 107, 122, 218, 126, 96, 246, 130, 89, 242, 129, 90, 242, 129, 90, 243, 129, 90, 243, 129, 90, 243, 129, 90, 242, 129, 90, 242, 129, 90, 242, 129, 91, 241, 129, 90, 241, 129, 90, 241, 129, 90, 240, 129, 90, 240, 128, 90, 240, 128, 90, 240, 128, 90, 240, 128, 90, 239, 127, 90, 238, 127, 90, 238, 127, 90, 238, 127, 90, 238, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 235, 125, 90, 235, 125, 90, 235, 125, 90, 234, 124, 90, 232, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 232, 123, 90, 231, 123, 90, 230, 122, 90, 230, 122, 90, 230, 122, 90, 229, 122, 90, 228, 122, 89, 228, 121, 90, 228, 121, 90, 227, 121, 89, 226, 120, 89, 225, 119, 89, 225, 119, 89, 225, 119, 90, 224, 119, 90, 223, 118, 89, 223, 118, 89, 222, 118, 89, 222, 117, 89, 221, 117, 89, 221, 117, 89, 220, 117, 89, 220, 116, 89, 219, 116, 88, 218, 115, 89, 218, 115, 88, 217, 114, 89, 216, 114, 88, 216, 113, 88, 216, 115, 90, 203, 74, 42, 197, 54, 19, 196, 54, 19, 194, 53, 20, 194, 53, 20, 193, 52, 19, 192, 52, 19, 191, 51, 19, 190, 51, 19, 190, 50, 18, 189, 49, 18, 188, 49, 19, 187, 49, 19, 186, 48, 18, 185, 48, 18, 184, 47, 18, 183, 47, 18, 182, 46, 18, 181, 46, 18, 180, 45, 18, 179, 45, 19, 178, 44, 18, 178, 44, 18, 176, 43, 19, 175, 42, 18, 175, 42, 18, 173, 42, 18, 172, 41, 17, 172, 40, 17, 171, 40, 17, 169, 40, 17, 169, 39, 17, 168, 38, 18, 167, 38, 17, 169, 36, 15, 145, 43, 35, 53, 67, 110, 27, 74, 129, 27, 71, 126, 26, 69, 122, 25, 67, 118, 25, 64, 112, 24, 61, 107, 23, 57, 100, 22, 54, 93,
	81, 101, 127, 82, 102, 128, 82, 102, 128, 81, 102, 128, 82, 102, 129, 82, 102, 129, 82, 102, 129, 82, 102, 129, 86, 103, 129, 177, 118, 106, 245, 130, 89, 241, 129, 90, 242, 129, 90, 242, 129, 91, 242, 129, 91, 242, 129, 91, 242, 129, 90, 242, 129, 90, 242, 129, 90, 242, 129, 91, 241, 129, 90, 240, 129, 91, 240, 129, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 235, 125, 90, 234, 125, 90, 234, 125, 90, 233, 125, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 226, 120, 90, 225, 120, 90, 225, 120, 90, 224, 119, 89, 224, 119, 90, 224, 119, 89, 223, 118, 89, 222, 118, 89, 222, 118, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 117, 89, 219, 116, 89, 218, 115, 89, 217, 115, 89, 217, 115, 88, 216, 114, 89, 216, 114, 88, 215, 114, 88, 216, 116, 91, 203, 75, 43, 196, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 191, 51, 20, 189, 51, 20, 188, 50, 19, 188, 50, 19, 187, 49, 20, 186, 49, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 182, 46, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 178, 45, 19, 177, 44, 19, 177, 44, 18, 176, 43, 19, 175, 42, 18, 174, 42, 18, 173, 41, 19, 172, 41, 18, 171, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 169, 36, 14, 104, 53, 68, 30, 73, 129, 27, 72, 127, 26, 70, 124, 25, 68, 119, 25, 65, 114, 24, 62, 108, 23, 59, 102, 22, 55, 95,
	81, 101, 127, 82, 102, 127, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 129, 82, 102, 129, 90, 103, 128, 212, 124, 98, 243, 129, 90, 242, 129, 91, 242, 129, 90, 242, 129, 90, 242, 130, 90, 242, 130, 90, 242, 130, 91, 242, 129, 90, 242, 129, 90, 242, 129, 90, 241, 129, 91, 241, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 231, 123, 90, 231, 123, 90, 229, 123, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 89, 227, 121, 89, 225, 119, 90, 225, 120, 90, 224, 119, 90, 224, 119, 89, 223, 119, 89, 223, 119, 89, 222, 118, 89, 222, 117, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 116, 89, 218, 116, 88, 218, 116, 89, 217, 115, 89, 217, 115, 89, 216, 114, 89, 216, 114, 88, 215, 114, 88, 215, 115, 91, 203, 75, 44, 196, 55, 20, 195, 54, 20, 194, 54, 20, 193, 53, 20, 193, 52, 20, 192, 52, 20, 191, 52, 20, 189, 51, 20, 189, 50, 20, 188, 49, 20, 187, 50, 19, 186, 49, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 182, 47, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 178, 45, 19, 177, 44, 18, 177, 43, 19, 176, 43, 19, 175, 42, 19, 174, 42, 19, 173, 42, 19, 172, 41, 18, 171, 40, 18, 170, 40, 18, 169, 39, 18, 168, 39, 18, 167, 39, 18, 166, 39, 18, 165, 38, 18, 168, 36, 15, 123, 49, 53, 32, 74, 129, 27, 73, 128, 27, 71, 125, 26, 69, 121, 25, 65, 115, 24, 63, 109, 24, 59, 102, 22, 55, 95,
	81, 101, 126, 82, 102, 127, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 129, 82, 102, 129, 91, 104, 128, 217, 125, 96, 243, 129, 89, 241, 129, 91, 242, 129, 91, 242, 129, 90, 242, 130, 91, 242, 130, 91, 242, 130, 91, 242, 130, 91, 242, 129, 90, 242, 129, 90, 241, 129, 90, 241, 129, 90, 240, 129, 90, 240, 129, 90, 239, 129, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 231, 123, 90, 231, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 227, 122, 90, 227, 122, 90, 227, 121, 89, 226, 120, 90, 225, 120, 90, 225, 119, 89, 224, 119, 89, 224, 119, 89, 223, 119, 89, 223, 118, 89, 222, 118, 89, 222, 118, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 117, 89, 219, 116, 89, 218, 116, 89, 217, 115, 88, 217, 115, 89, 216, 114, 88, 216, 114, 88, 215, 114, 89, 215, 116, 90, 203, 75, 43, 196, 54, 20, 195, 54, 20, 194, 54, 20, 193, 52, 20, 192, 52, 20, 191, 52, 20, 191, 52, 20, 190, 50, 20, 189, 50, 19, 188, 50, 20, 187, 49, 19, 186, 48, 19, 185, 48, 19, 184, 47, 19, 184, 47, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 178, 44, 19, 178, 44, 19, 177, 43, 19, 176, 43, 19, 174, 43, 18, 174, 42, 19, 173, 42, 18, 172, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 167, 36, 15, 125, 49, 52, 33, 74, 129, 27, 74, 130, 27, 71, 126, 26, 69, 121, 25, 66, 116, 24, 63, 109, 24, 59, 103, 22, 55, 96,
	81, 101, 126, 81, 102, 127, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 129, 91, 104, 128, 217, 125, 96, 243, 129, 90, 241, 129, 90, 242, 129, 91, 242, 129, 91, 242, 129, 90, 242, 130, 90, 242, 130, 90, 242, 129, 90, 242, 129, 90, 242, 129, 90, 241, 129, 90, 241, 129, 90, 240, 129, 90, 240, 129, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 125, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 123, 90, 230, 123, 90, 230, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 227, 122, 90, 227, 121, 90, 227, 121, 90, 227, 120, 90, 226, 120, 89, 225, 119, 89, 224, 119, 89, 224, 119, 89, 223, 119, 89, 223, 118, 89, 222, 118, 89, 222, 118, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 117, 89, 219, 116, 89, 218, 116, 89, 217, 115, 89, 217, 115, 88, 216, 114, 89, 215, 114, 88, 215, 114, 88, 215, 115, 90, 202, 73, 41, 196, 55, 20, 195, 54, 20, 195, 53, 20, 193, 53, 20, 193, 52, 20, 192, 52, 20, 191, 51, 20, 189, 51, 20, 189, 50, 20, 188, 50, 20, 187, 49, 20, 186, 49, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 180, 45, 18, 178, 45, 19, 178, 44, 19, 177, 43, 19, 176, 43, 18, 175, 43, 18, 174, 42, 18, 173, 42, 19, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 168, 37, 15, 124, 49, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 121, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 127, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 130, 91, 103, 128, 217, 125, 97, 243, 129, 89, 241, 129, 90, 242, 129, 90, 242, 129, 91, 242, 129, 91, 242, 129, 91, 242, 130, 90, 242, 129, 90, 242, 129, 90, 241, 129, 90, 241, 129, 90, 241, 129, 90, 240, 129, 90, 239, 129, 90, 239, 129, 90, 239, 128, 90, 239, 127, 90, 239, 128, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 126, 90, 236, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 233, 125, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 231, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 227, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 89, 226, 120, 90, 225, 119, 89, 224, 119, 89, 224, 119, 90, 223, 119, 89, 223, 118, 89, 222, 118, 89, 222, 118, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 117, 89, 219, 116, 89, 218, 116, 88, 217, 115, 89, 217, 114, 88, 216, 114, 88, 216, 114, 88, 215, 114, 88, 215, 113, 87, 202, 72, 40, 196, 54, 20, 195, 54, 20, 195, 53, 20, 193, 53, 20, 192, 52, 19, 192, 52, 20, 191, 51, 20, 190, 51, 20, 189, 50, 19, 188, 50, 19, 187, 49, 19, 186, 49, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 177, 44, 19, 177, 44, 19, 176, 43, 19, 174, 42, 18, 174, 42, 19, 173, 42, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 167, 39, 18, 166, 38, 18, 166, 38, 18, 168, 36, 15, 124, 48, 53, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 130, 91, 104, 128, 217, 125, 97, 243, 129, 89, 241, 129, 90, 241, 129, 91, 242, 129, 90, 242, 129, 90, 242, 129, 90, 242, 129, 90, 242, 129, 91, 241, 129, 90, 241, 129, 90, 241, 129, 90, 240, 129, 90, 239, 129, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 235, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 124, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 123, 90, 231, 123, 90, 231, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 122, 90, 227, 122, 90, 227, 121, 89, 227, 121, 90, 225, 120, 89, 225, 119, 89, 224, 119, 89, 224, 119, 89, 223, 119, 89, 222, 118, 89, 222, 118, 89, 222, 118, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 117, 89, 219, 116, 89, 218, 115, 88, 217, 115, 89, 217, 115, 88, 216, 114, 88, 216, 114, 89, 215, 114, 88, 214, 110, 84, 201, 69, 37, 196, 54, 20, 195, 54, 20, 194, 54, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 191, 51, 20, 189, 51, 20, 189, 50, 20, 188, 50, 19, 187, 50, 19, 186, 49, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 182, 47, 19, 181, 46, 19, 180, 46, 19, 179, 46, 19, 178, 45, 18, 177, 44, 19, 177, 43, 18, 176, 43, 18, 174, 42, 18, 174, 42, 19, 173, 42, 19, 172, 41, 18, 171, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 168, 36, 15, 124, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 130, 82, 102, 130, 91, 105, 128, 217, 125, 97, 243, 129, 89, 241, 129, 90, 241, 129, 90, 241, 129, 91, 242, 129, 90, 241, 129, 90, 242, 129, 90, 241, 129, 90, 241, 129, 91, 241, 129, 91, 240, 129, 90, 240, 129, 90, 240, 129, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 235, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 231, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 122, 90, 227, 121, 90, 227, 121, 90, 227, 120, 89, 225, 120, 89, 225, 119, 90, 224, 119, 89, 224, 119, 89, 223, 119, 89, 223, 119, 89, 222, 118, 89, 222, 117, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 117, 89, 219, 116, 89, 218, 116, 89, 217, 115, 88, 217, 114, 89, 216, 114, 88, 215, 114, 88, 215, 114, 89, 213, 107, 80, 200, 66, 33, 196, 55, 20, 195, 54, 20, 194, 53, 20, 193, 52, 20, 192, 52, 20, 192, 52, 20, 191, 52, 20, 189, 51, 20, 189, 50, 20, 188, 50, 20, 187, 49, 19, 186, 49, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 19, 174, 42, 19, 174, 42, 19, 173, 42, 18, 172, 41, 18, 171, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 168, 36, 15, 124, 49, 51, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 130, 82, 103, 130, 91, 104, 129, 216, 125, 96, 242, 129, 89, 241, 129, 90, 241, 129, 91, 241, 129, 90, 241, 129, 90, 241, 129, 91, 241, 129, 90, 241, 129, 90, 241, 129, 90, 241, 129, 90, 240, 129, 90, 240, 129, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 127, 90, 235, 126, 90, 235, 126, 90, 234, 125, 90, 234, 125, 90, 234, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 230, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 226, 120, 90, 225, 120, 89, 225, 119, 89, 224, 119, 90, 224, 119, 89, 223, 119, 89, 222, 118, 89, 222, 118, 89, 222, 118, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 116, 89, 219, 116, 89, 218, 115, 89, 217, 115, 89, 217, 114, 89, 216, 114, 89, 215, 114, 89, 215, 114, 89, 212, 104, 76, 199, 63, 29, 196, 55, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 191, 52, 20, 191, 51, 20, 189, 50, 20, 188, 50, 20, 188, 49, 20, 187, 49, 19, 185, 49, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 182, 47, 19, 182, 46, 19, 180, 46, 19, 180, 45, 19, 178, 45, 19, 177, 44, 19, 177, 44, 18, 176, 43, 19, 174, 43, 19, 173, 42, 19, 173, 41, 19, 172, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 168, 36, 15, 124, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 103, 130, 91, 105, 129, 216, 126, 96, 242, 129, 89, 240, 129, 90, 240, 129, 91, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 241, 129, 90, 241, 129, 90, 240, 129, 90, 240, 129, 90, 239, 129, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 127, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 230, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 226, 120, 90, 225, 120, 89, 225, 119, 90, 224, 119, 89, 224, 119, 89, 223, 119, 89, 222, 118, 89, 222, 118, 89, 222, 118, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 116, 89, 219, 116, 89, 218, 116, 88, 217, 115, 88, 217, 114, 89, 216, 114, 89, 215, 114, 88, 215, 114, 89, 210, 99, 71, 197, 58, 24, 196, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 190, 51, 20, 189, 51, 20, 189, 50, 19, 188, 50, 20, 187, 49, 19, 186, 48, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 182, 47, 19, 182, 46, 19, 180, 46, 19, 180, 45, 19, 179, 44, 19, 177, 44, 18, 177, 44, 19, 176, 43, 19, 174, 43, 19, 174, 42, 19, 173, 42, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 167, 37, 15, 124, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 103, 131, 91, 105, 130, 216, 125, 96, 242, 129, 89, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 123, 90, 231, 124, 90, 230, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 89, 226, 120, 89, 225, 120, 90, 224, 119, 89, 224, 119, 89, 224, 119, 89, 223, 119, 89, 222, 118, 89, 222, 118, 89, 222, 117, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 220, 117, 89, 218, 116, 89, 218, 115, 89, 217, 115, 89, 217, 114, 89, 216, 114, 88, 215, 114, 88, 215, 114, 88, 209, 94, 65, 197, 54, 19, 196, 54, 20, 195, 54, 20, 194, 54, 20, 193, 53, 20, 192, 52, 20, 191, 52, 20, 191, 51, 20, 189, 51, 20, 188, 50, 20, 187, 50, 20, 187, 49, 20, 186, 48, 19, 185, 48, 19, 184, 47, 19, 183, 47, 19, 182, 47, 18, 181, 46, 19, 180, 45, 19, 179, 45, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 18, 174, 42, 19, 174, 42, 19, 173, 41, 18, 172, 41, 18, 170, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 168, 37, 15, 124, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 104, 131, 91, 105, 130, 216, 125, 97, 241, 129, 89, 239, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 240, 129, 90, 239, 129, 90, 239, 129, 90, 239, 128, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 235, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 230, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 226, 120, 90, 225, 119, 89, 224, 119, 90, 224, 119, 89, 224, 119, 89, 223, 118, 89, 222, 118, 89, 222, 118, 89, 222, 117, 89, 220, 117, 89, 220, 117, 89, 220, 117, 89, 220, 116, 89, 218, 116, 89, 218, 115, 89, 217, 115, 89, 217, 114, 89, 216, 114, 88, 215, 114, 88, 215, 113, 87, 206, 84, 54, 196, 52, 18, 195, 54, 20, 195, 54, 20, 194, 53, 20, 193, 52, 20, 192, 52, 20, 191, 51, 20, 191, 51, 20, 189, 50, 20, 188, 50, 20, 188, 50, 19, 187, 49, 20, 185, 49, 20, 185, 48, 19, 184, 47, 19, 183, 47, 19, 182, 46, 19, 181, 46, 19, 180, 45, 19, 180, 45, 19, 178, 44, 19, 177, 44, 18, 176, 44, 19, 176, 43, 19, 174, 42, 19, 173, 42, 19, 173, 41, 19, 172, 41, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 38, 18, 166, 38, 18, 165, 37, 18, 167, 36, 15, 124, 49, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 104, 131, 91, 106, 131, 216, 125, 97, 241, 128, 89, 239, 128, 90, 239, 128, 90, 239, 129, 90, 239, 128, 90, 239, 129, 90, 239, 129, 90, 239, 129, 90, 239, 128, 90, 239, 129, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 235, 127, 90, 235, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 123, 90, 231, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 89, 227, 120, 90, 226, 120, 90, 225, 119, 89, 224, 119, 89, 224, 119, 89, 224, 119, 90, 223, 119, 89, 222, 118, 89, 222, 118, 89, 222, 117, 89, 221, 117, 89, 220, 117, 89, 220, 117, 89, 219, 116, 89, 218, 115, 89, 218, 115, 89, 217, 115, 89, 217, 114, 89, 215, 114, 89, 215, 114, 88, 214, 112, 85, 202, 72, 40, 196, 53, 19, 195, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 19, 192, 52, 20, 191, 52, 20, 190, 51, 20, 189, 51, 20, 188, 50, 19, 188, 50, 19, 186, 49, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 182, 46, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 178, 44, 19, 177, 44, 19, 176, 43, 19, 175, 43, 18, 174, 42, 18, 174, 42, 19, 173, 41, 18, 172, 41, 18, 171, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 167, 36, 15, 124, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 104, 132, 91, 106, 131, 216, 124, 97, 241, 128, 89, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 127, 90, 239, 128, 90, 238, 127, 90, 238, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 235, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 123, 90, 230, 123, 90, 230, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 122, 90, 227, 121, 90, 227, 120, 90, 226, 120, 90, 225, 120, 89, 225, 120, 89, 224, 120, 89, 224, 120, 89, 223, 120, 89, 223, 120, 89, 223, 119, 89, 223, 119, 89, 222, 118, 89, 221, 118, 89, 220, 118, 89, 220, 117, 89, 219, 116, 89, 218, 115, 89, 217, 115, 89, 217, 114, 89, 217, 114, 89, 216, 114, 88, 215, 114, 89, 214, 110, 84, 198, 59, 24, 196, 54, 19, 195, 54, 20, 195, 53, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 191, 51, 20, 190, 51, 20, 190, 51, 20, 188, 50, 20, 187, 50, 19, 186, 49, 20, 185, 48, 19, 185, 48, 19, 184, 47, 19, 183, 47, 19, 182, 46, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 178, 44, 19, 177, 44, 19, 176, 43, 19, 175, 43, 18, 174, 42, 18, 173, 41, 18, 173, 41, 18, 172, 41, 18, 171, 40, 18, 169, 40, 18, 169, 40, 18, 168, 39, 18, 167, 38, 18, 166, 38, 18, 165, 37, 18, 167, 36, 15, 124, 49, 52, 33, 75, 130, 27, 74, 132, 27, 71, 127, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 104, 130, 82, 105, 132, 91, 106, 132, 215, 124, 97, 241, 128, 89, 239, 128, 90, 239, 127, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 238, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 126, 90, 236, 126, 90, 235, 126, 90, 235, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 123, 90, 230, 123, 90, 230, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 228, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 226, 120, 90, 225, 120, 90, 224, 120, 90, 225, 121, 89, 225, 121, 89, 224, 121, 89, 223, 121, 90, 223, 121, 90, 223, 120, 90, 222, 120, 89, 221, 119, 89, 221, 119, 88, 221, 118, 89, 218, 117, 89, 217, 116, 89, 217, 115, 88, 217, 115, 88, 217, 114, 88, 215, 114, 88, 215, 114, 89, 211, 99, 72, 196, 52, 16, 196, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 191, 51, 20, 190, 51, 20, 188, 50, 20, 188, 50, 19, 187, 50, 19, 186, 49, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 183, 47, 19, 182, 46, 19, 180, 46, 19, 180, 45, 19, 179, 45, 19, 178, 44, 19, 177, 44, 19, 176, 43, 19, 175, 43, 18, 174, 42, 18, 173, 42, 19, 172, 41, 18, 172, 41, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 166, 38, 17, 165, 38, 18, 165, 37, 18, 167, 36, 15, 124, 49, 52, 33, 75, 130, 27, 75, 132, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 104, 131, 82, 105, 132, 91, 106, 132, 214, 124, 97, 240, 128, 89, 239, 127, 90, 239, 128, 90, 238, 127, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 239, 128, 90, 238, 128, 90, 238, 127, 90, 238, 128, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 236, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 234, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 230, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 226, 121, 90, 226, 121, 90, 225, 121, 90, 225, 121, 90, 225, 122, 90, 225, 122, 90, 224, 122, 90, 224, 122, 90, 224, 122, 90, 224, 122, 90, 223, 121, 90, 221, 121, 90, 221, 119, 90, 220, 119, 89, 220, 118, 89, 218, 116, 89, 217, 115, 88, 217, 114, 89, 216, 114, 89, 215, 114, 88, 215, 116, 90, 204, 79, 48, 196, 53, 18, 195, 55, 20, 195, 53, 20, 194, 53, 20, 194, 53, 20, 192, 52, 20, 191, 52, 20, 191, 51, 20, 190, 51, 20, 189, 50, 20, 188, 50, 20, 187, 49, 19, 186, 49, 20, 185, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 179, 45, 19, 178, 44, 19, 177, 43, 19, 176, 43, 18, 175, 43, 18, 174, 42, 18, 173, 42, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 167, 36, 15, 124, 49, 53, 33, 75, 131, 27, 75, 132, 27, 72, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 104, 131, 82, 105, 132, 91, 107, 132, 214, 124, 97, 239, 127, 89, 238, 127, 90, 238, 127, 90, 238, 128, 90, 239, 128, 90, 238, 127, 90, 238, 128, 90, 238, 127, 90, 238, 127, 90, 238, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 124, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 231, 123, 90, 230, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 89, 226, 121, 90, 225, 121, 90, 226, 122, 91, 225, 123, 91, 226, 125, 90, 225, 125, 90, 225, 126, 91, 226, 126, 91, 226, 126, 91, 225, 126, 90, 224, 125, 91, 223, 123, 90, 222, 122, 90, 221, 121, 89, 220, 119, 90, 218, 117, 89, 217, 116, 88, 217, 115, 89, 216, 114, 88, 215, 114, 88, 215, 114, 89, 199, 59, 25, 196, 55, 19, 196, 54, 20, 195, 53, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 191, 52, 20, 190, 51, 19, 190, 51, 20, 188, 50, 20, 188, 49, 20, 187, 49, 19, 186, 49, 19, 185, 48, 19, 184, 47, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 179, 45, 19, 177, 44, 18, 177, 44, 19, 176, 43, 19, 175, 43, 18, 174, 42, 19, 173, 42, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 166, 38, 18, 165, 38, 18, 164, 38, 18, 167, 36, 15, 124, 49, 52, 33, 75, 131, 28, 75, 132, 27, 72, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 129, 82, 104, 131, 82, 105, 133, 91, 107, 132, 214, 124, 97, 239, 127, 89, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 238, 127, 90, 237, 127, 90, 238, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 235, 126, 90, 236, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 123, 90, 231, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 89, 227, 122, 90, 226, 123, 91, 227, 123, 91, 227, 125, 91, 228, 128, 91, 227, 129, 92, 227, 130, 92, 227, 131, 92, 228, 131, 93, 226, 130, 91, 225, 129, 92, 225, 127, 92, 223, 125, 91, 222, 123, 91, 221, 120, 90, 218, 118, 89, 218, 116, 88, 217, 115, 88, 216, 114, 88, 215, 116, 90, 211, 96, 68, 196, 53, 18, 197, 55, 20, 196, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 191, 51, 20, 191, 51, 20, 189, 51, 20, 188, 50, 20, 187, 50, 20, 187, 49, 20, 186, 49, 19, 185, 48, 19, 184, 47, 19, 183, 47, 19, 182, 46, 19, 181, 46, 19, 180, 46, 19, 179, 45, 19, 179, 45, 19, 177, 44, 18, 177, 44, 19, 176, 43, 18, 175, 42, 18, 174, 42, 18, 173, 42, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 168, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 37, 18, 165, 37, 18, 166, 36, 15, 124, 49, 53, 33, 75, 131, 28, 75, 132, 27, 72, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 130, 82, 104, 131, 82, 105, 133, 91, 107, 133, 214, 124, 98, 239, 127, 89, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 231, 123, 90, 231, 123, 90, 230, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 122, 89, 227, 123, 90, 226, 124, 91, 226, 125, 90, 227, 129, 92, 229, 131, 92, 229, 134, 93, 229, 136, 93, 230, 137, 94, 230, 138, 92, 229, 137, 94, 228, 135, 93, 227, 133, 92, 225, 130, 92, 224, 126, 91, 221, 123, 91, 219, 120, 90, 218, 117, 89, 217, 116, 88, 216, 115, 88, 216, 117, 92, 202, 71, 37, 197, 54, 19, 196, 55, 20, 195, 54, 20, 194, 53, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 191, 51, 20, 190, 51, 20, 189, 51, 20, 188, 50, 20, 187, 49, 20, 186, 49, 19, 186, 49, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 178, 45, 19, 177, 43, 18, 176, 43, 19, 176, 43, 18, 175, 43, 18, 173, 42, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 169, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 166, 36, 15, 124, 49, 53, 33, 75, 131, 28, 75, 132, 27, 72, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 130, 82, 104, 131, 82, 105, 133, 91, 107, 134, 213, 124, 98, 239, 127, 89, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 126, 90, 236, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 125, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 231, 123, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 89, 227, 121, 90, 227, 122, 89, 226, 123, 90, 227, 125, 90, 227, 128, 92, 230, 132, 93, 230, 136, 93, 231, 140, 94, 232, 143, 95, 233, 145, 93, 236, 159, 115, 232, 146, 97, 231, 143, 95, 229, 139, 94, 226, 135, 92, 225, 130, 92, 222, 126, 91, 220, 122, 90, 219, 118, 89, 217, 117, 89, 216, 116, 89, 212, 105, 77, 199, 58, 23, 197, 55, 20, 196, 55, 20, 195, 54, 20, 194, 54, 20, 193, 53, 20, 193, 53, 20, 192, 52, 19, 191, 51, 20, 190, 51, 20, 189, 51, 19, 188, 50, 20, 187, 49, 19, 186, 49, 20, 186, 48, 19, 184, 48, 19, 184, 47, 19, 182, 47, 19, 182, 47, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 178, 44, 19, 177, 44, 19, 176, 44, 19, 176, 42, 19, 175, 43, 18, 173, 42, 18, 173, 41, 18, 171, 41, 18, 171, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 167, 36, 15, 124, 48, 53, 33, 75, 131, 28, 75, 132, 27, 72, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 130, 82, 104, 131, 82, 105, 134, 91, 107, 134, 213, 124, 98, 238, 127, 89, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 237, 127, 90, 236, 127, 90, 237, 127, 90, 236, 127, 90, 236, 127, 90, 236, 127, 90, 236, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 123, 90, 231, 123, 90, 230, 123, 90, 230, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 227, 122, 90, 227, 121, 90, 227, 121, 90, 227, 122, 90, 227, 123, 90, 227, 125, 91, 227, 128, 92, 229, 133, 93, 231, 138, 94, 233, 143, 95, 234, 148, 96, 235, 151, 96, 237, 157, 102, 253, 242, 234, 243, 195, 162, 234, 149, 90, 233, 148, 96, 230, 142, 94, 227, 137, 93, 224, 131, 92, 222, 126, 91, 220, 121, 91, 217, 118, 89, 216, 117, 90, 206, 82, 51, 198, 56, 21, 197, 55, 20, 196, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 191, 52, 20, 190, 51, 19, 190, 51, 19, 189, 50, 19, 188, 50, 20, 187, 49, 19, 186, 49, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 182, 46, 19, 180, 45, 19, 179, 45, 19, 179, 44, 19, 178, 44, 19, 177, 44, 19, 176, 43, 19, 175, 43, 18, 174, 42, 18, 173, 42, 19, 172, 41, 18, 172, 41, 18, 171, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 167, 39, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 165, 36, 15, 123, 48, 52, 33, 75, 131, 28, 75, 132, 27, 72, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 128, 82, 102, 130, 82, 104, 132, 82, 105, 134, 92, 107, 134, 213, 124, 98, 237, 127, 89, 236, 126, 90, 236, 127, 90, 236, 127, 90, 236, 127, 90, 236, 127, 90, 236, 127, 90, 236, 127, 90, 235, 126, 90, 236, 126, 90, 236, 126, 90, 236, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 124, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 123, 90, 230, 123, 90, 230, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 122, 90, 227, 122, 90, 227, 125, 90, 227, 128, 91, 229, 132, 93, 231, 138, 94, 233, 145, 95, 236, 151, 96, 238, 157, 98, 240, 161, 96, 248, 211, 180, 255, 255, 255, 254, 247, 241, 241, 173, 117, 236, 156, 95, 233, 150, 96, 229, 142, 94, 226, 135, 93, 223, 129, 92, 220, 124, 90, 218, 119, 89, 214, 110, 80, 201, 66, 31, 197, 55, 20, 196, 55, 20, 195, 54, 20, 194, 54, 20, 193, 53, 20, 193, 53, 20, 192, 52, 20, 191, 51, 20, 190, 51, 20, 189, 51, 20, 188, 50, 20, 187, 50, 20, 187, 49, 20, 186, 48, 19, 185, 48, 19, 184, 47, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 180, 46, 19, 179, 45, 19, 179, 45, 19, 178, 44, 19, 177, 44, 19, 176, 43, 19, 175, 43, 19, 174, 42, 18, 173, 42, 18, 172, 41, 19, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 167, 38, 18, 165, 38, 18, 165, 38, 18, 164, 37, 18, 166, 36, 15, 124, 48, 53, 33, 75, 131, 27, 75, 132, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 130, 82, 104, 132, 82, 105, 134, 92, 108, 134, 213, 123, 97, 237, 126, 89, 236, 126, 90, 235, 126, 90, 236, 126, 90, 236, 126, 90, 236, 126, 90, 236, 126, 90, 236, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 234, 126, 90, 234, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 124, 90, 233, 125, 90, 233, 124, 90, 233, 125, 90, 232, 125, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 230, 123, 90, 230, 122, 90, 230, 123, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 228, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 122, 90, 227, 124, 90, 227, 126, 91, 229, 130, 93, 231, 137, 93, 234, 144, 95, 236, 152, 96, 238, 160, 99, 242, 167, 99, 247, 190, 133, 254, 248, 242, 255, 255, 255, 255, 255, 255, 250, 223, 195, 241, 166, 98, 237, 159, 98, 233, 150, 97, 229, 142, 94, 225, 134, 93, 222, 127, 91, 219, 122, 90, 210, 95, 62, 198, 57, 20, 197, 56, 20, 196, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 193, 52, 20, 192, 52, 20, 191, 51, 20, 190, 51, 20, 189, 50, 19, 189, 50, 19, 187, 49, 19, 187, 49, 20, 186, 48, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 178, 45, 19, 177, 44, 19, 176, 44, 19, 175, 43, 18, 175, 43, 18, 174, 42, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 164, 37, 18, 165, 36, 15, 123, 48, 52, 33, 75, 130, 27, 74, 132, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 130, 82, 104, 132, 82, 105, 134, 92, 108, 135, 211, 123, 97, 237, 126, 89, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 126, 90, 235, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 125, 90, 234, 125, 90, 233, 126, 90, 233, 125, 90, 232, 125, 90, 232, 126, 90, 232, 126, 90, 232, 125, 90, 232, 125, 90, 231, 124, 90, 231, 124, 90, 230, 123, 90, 229, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 228, 122, 90, 227, 122, 90, 227, 122, 89, 227, 122, 89, 227, 123, 90, 227, 125, 91, 228, 129, 92, 230, 135, 93, 232, 142, 94, 235, 151, 96, 239, 160, 99, 242, 169, 100, 246, 181, 108, 253, 232, 207, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 244, 247, 196, 139, 241, 169, 100, 236, 159, 98, 232, 149, 96, 228, 139, 93, 224, 131, 92, 219, 121, 86, 204, 73, 32, 199, 59, 20, 198, 57, 20, 196, 55, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 190, 52, 19, 190, 51, 20, 189, 51, 20, 189, 51, 20, 188, 50, 20, 187, 50, 19, 186, 50, 20, 186, 50, 20, 184, 49, 19, 183, 48, 19, 183, 47, 19, 182, 47, 19, 180, 46, 18, 179, 45, 19, 178, 44, 19, 177, 44, 19, 176, 43, 18, 175, 43, 19, 175, 42, 18, 174, 42, 19, 172, 41, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 37, 18, 164, 37, 18, 163, 37, 18, 166, 36, 15, 123, 48, 52, 33, 75, 130, 27, 74, 132, 27, 71, 127, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 56, 96,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 129, 82, 102, 130, 82, 104, 132, 82, 105, 135, 92, 108, 135, 212, 123, 97, 236, 125, 89, 234, 126, 90, 235, 125, 90, 234, 126, 90, 234, 126, 90, 235, 126, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 126, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 126, 90, 233, 125, 90, 233, 126, 90, 233, 127, 90, 233, 127, 91, 233, 128, 91, 233, 128, 91, 233, 127, 91, 232, 127, 91, 231, 127, 91, 231, 125, 91, 230, 124, 90, 229, 124, 90, 229, 123, 90, 229, 123, 90, 228, 122, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 227, 122, 89, 227, 122, 90, 227, 124, 91, 228, 128, 92, 229, 132, 93, 231, 140, 94, 235, 148, 96, 238, 158, 98, 242, 169, 100, 247, 178, 98, 252, 214, 162, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 233, 207, 245, 181, 106, 241, 168, 100, 236, 156, 98, 230, 145, 95, 226, 138, 95, 215, 104, 60, 203, 64, 19, 200, 62, 22, 197, 58, 21, 196, 55, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 191, 53, 20, 191, 53, 20, 191, 54, 20, 190, 54, 20, 189, 54, 21, 189, 53, 20, 188, 53, 20, 187, 53, 20, 186, 52, 20, 184, 51, 20, 183, 50, 20, 182, 48, 19, 181, 47, 19, 180, 46, 19, 178, 45, 19, 176, 44, 19, 176, 43, 19, 175, 43, 18, 174, 42, 19, 174, 42, 19, 172, 41, 18, 171, 41, 18, 171, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 37, 18, 164, 37, 18, 163, 37, 18, 165, 35, 15, 123, 48, 52, 33, 75, 130, 27, 74, 132, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 22, 55, 95,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 105, 132, 82, 106, 135, 92, 109, 136, 212, 123, 97, 236, 125, 89, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 233, 125, 90, 233, 125, 90, 233, 125, 90, 233, 125, 90, 233, 125, 90, 233, 127, 91, 233, 128, 91, 233, 129, 91, 234, 129, 92, 234, 130, 92, 233, 131, 92, 233, 130, 92, 233, 129, 92, 232, 129, 92, 231, 128, 92, 230, 127, 92, 231, 126, 91, 230, 125, 91, 229, 124, 91, 228, 124, 90, 228, 123, 90, 228, 122, 90, 227, 122, 89, 227, 122, 90, 227, 123, 90, 228, 127, 91, 228, 131, 92, 231, 137, 93, 234, 145, 95, 238, 155, 98, 242, 166, 100, 246, 177, 100, 251, 199, 126, 255, 253, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 210, 152, 244, 176, 99, 239, 164, 99, 233, 153, 97, 226, 134, 85, 211, 83, 28, 205, 71, 23, 201, 65, 22, 198, 60, 21, 196, 56, 21, 195, 54, 20, 194, 54, 20, 194, 54, 21, 192, 54, 20, 193, 55, 21, 193, 56, 21, 192, 57, 21, 193, 57, 21, 193, 59, 22, 192, 59, 22, 192, 59, 22, 191, 59, 22, 190, 58, 22, 189, 57, 21, 186, 55, 21, 184, 53, 21, 183, 51, 20, 181, 49, 19, 180, 47, 19, 179, 45, 19, 177, 43, 18, 176, 43, 19, 175, 43, 18, 174, 42, 19, 173, 42, 19, 172, 41, 18, 171, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 167, 39, 18, 166, 38, 18, 165, 37, 18, 164, 37, 18, 163, 37, 18, 164, 35, 15, 122, 48, 52, 33, 75, 130, 27, 74, 132, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 20, 52, 90,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 105, 132, 82, 106, 135, 92, 109, 136, 211, 122, 98, 236, 125, 89, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 125, 90, 234, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 125, 90, 233, 125, 90, 233, 127, 91, 233, 128, 91, 233, 129, 91, 234, 130, 92, 234, 132, 92, 234, 134, 93, 235, 135, 93, 234, 135, 93, 234, 135, 93, 233, 134, 93, 233, 133, 93, 233, 132, 92, 232, 131, 92, 231, 128, 92, 230, 127, 91, 228, 125, 91, 228, 124, 91, 228, 123, 91, 228, 123, 91, 227, 123, 91, 227, 125, 91, 228, 129, 91, 229, 135, 93, 233, 142, 94, 236, 151, 97, 240, 162, 99, 245, 175, 101, 250, 187, 100, 255, 242, 225, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 247, 249, 187, 106, 243, 173, 100, 237, 161, 101, 222, 113, 45, 213, 88, 27, 207, 77, 25, 203, 68, 23, 200, 62, 22, 198, 59, 21, 196, 57, 21, 195, 57, 21, 195, 57, 21, 195, 58, 22, 195, 60, 21, 195, 62, 21, 196, 64, 22, 197, 65, 23, 197, 66, 23, 197, 67, 23, 196, 67, 24, 194, 66, 24, 193, 65, 23, 191, 62, 22, 189, 60, 22, 186, 56, 21, 184, 53, 21, 183, 51, 20, 180, 48, 20, 179, 46, 20, 177, 45, 18, 175, 43, 18, 174, 43, 18, 174, 42, 19, 173, 42, 18, 172, 41, 18, 171, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 167, 38, 18, 165, 38, 18, 164, 37, 17, 163, 37, 18, 163, 37, 17, 165, 35, 15, 122, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 24, 60, 104, 19, 49, 86,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 129, 82, 103, 130, 82, 105, 132, 82, 106, 136, 91, 109, 137, 210, 122, 98, 235, 124, 89, 233, 124, 90, 233, 125, 90, 233, 124, 90, 233, 125, 90, 234, 124, 90, 234, 124, 90, 234, 124, 90, 233, 125, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 125, 90, 233, 127, 91, 233, 128, 91, 233, 129, 91, 234, 132, 92, 234, 134, 92, 235, 136, 93, 235, 139, 94, 235, 140, 94, 236, 141, 94, 235, 142, 94, 235, 141, 94, 235, 139, 94, 235, 138, 94, 233, 137, 93, 232, 134, 93, 231, 132, 92, 230, 129, 91, 229, 128, 91, 228, 126, 90, 228, 126, 91, 228, 127, 91, 228, 129, 91, 229, 133, 92, 232, 140, 94, 235, 148, 96, 239, 159, 98, 243, 171, 101, 248, 183, 101, 254, 222, 174, 255, 254, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 231, 196, 247, 181, 99, 237, 152, 72, 225, 114, 34, 217, 97, 30, 210, 84, 26, 205, 75, 24, 202, 68, 23, 199, 63, 22, 198, 61, 22, 197, 62, 22, 197, 62, 22, 197, 65, 22, 199, 67, 24, 199, 70, 24, 200, 73, 24, 202, 74, 25, 202, 77, 25, 202, 77, 26, 201, 77, 26, 200, 76, 25, 198, 73, 25, 196, 70, 24, 193, 65, 23, 189, 61, 22, 186, 57, 22, 184, 53, 20, 181, 49, 20, 179, 47, 20, 177, 44, 18, 175, 43, 18, 174, 42, 18, 174, 42, 19, 173, 42, 19, 171, 41, 18, 171, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 166, 38, 18, 164, 37, 18, 163, 37, 18, 162, 36, 18, 165, 35, 15, 122, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 23, 59, 102, 17, 47, 83,
	81, 101, 126, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 129, 82, 104, 130, 82, 105, 133, 82, 106, 136, 91, 109, 137, 210, 122, 98, 234, 124, 89, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 233, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 125, 90, 233, 127, 91, 233, 129, 91, 234, 131, 92, 234, 134, 93, 235, 137, 93, 236, 141, 94, 236, 143, 94, 237, 147, 95, 239, 148, 96, 238, 149, 97, 238, 149, 96, 237, 149, 96, 237, 147, 96, 235, 144, 95, 235, 141, 95, 233, 139, 93, 232, 135, 93, 231, 133, 93, 230, 132, 92, 230, 131, 92, 230, 132, 92, 230, 134, 93, 232, 139, 94, 234, 147, 95, 238, 156, 98, 242, 167, 100, 247, 180, 102, 252, 202, 129, 255, 249, 237, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 251, 200, 130, 240, 147, 43, 231, 124, 35, 222, 108, 31, 215, 94, 29, 209, 83, 26, 206, 75, 25, 203, 71, 24, 201, 68, 23, 201, 69, 24, 201, 71, 24, 203, 74, 25, 204, 78, 25, 206, 82, 26, 207, 86, 28, 208, 89, 28, 209, 90, 28, 209, 91, 29, 208, 90, 29, 207, 88, 28, 204, 85, 27, 200, 77, 24, 196, 73, 24, 193, 67, 23, 189, 61, 22, 185, 56, 21, 182, 51, 20, 179, 47, 20, 177, 45, 19, 175, 43, 19, 174, 42, 18, 173, 42, 19, 172, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 167, 39, 18, 167, 38, 18, 166, 38, 18, 164, 38, 17, 164, 37, 18, 163, 37, 18, 163, 36, 18, 164, 35, 15, 122, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 111, 22, 57, 99, 17, 45, 80,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 102, 129, 82, 104, 131, 82, 105, 133, 82, 107, 137, 91, 110, 137, 210, 122, 98, 234, 124, 89, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 126, 90, 233, 127, 91, 233, 130, 92, 234, 132, 92, 235, 137, 93, 235, 141, 94, 237, 147, 97, 240, 162, 113, 239, 149, 87, 241, 156, 95, 241, 159, 99, 241, 160, 98, 241, 159, 98, 240, 157, 98, 239, 155, 97, 238, 151, 97, 236, 147, 96, 235, 143, 95, 233, 140, 94, 232, 138, 94, 232, 137, 94, 232, 138, 94, 233, 142, 94, 234, 147, 96, 237, 155, 97, 241, 164, 100, 245, 176, 102, 250, 189, 106, 255, 234, 201, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 231, 197, 246, 161, 52, 236, 138, 38, 228, 120, 34, 220, 106, 32, 214, 94, 29, 211, 86, 27, 208, 81, 26, 206, 80, 26, 206, 80, 26, 207, 83, 26, 209, 87, 27, 210, 92, 28, 214, 97, 30, 216, 102, 31, 216, 105, 31, 217, 107, 32, 217, 107, 32, 216, 105, 32, 214, 99, 27, 209, 89, 17, 211, 104, 47, 202, 83, 29, 196, 73, 25, 192, 65, 23, 187, 59, 22, 183, 53, 21, 180, 48, 20, 177, 45, 19, 175, 43, 19, 174, 42, 19, 173, 42, 19, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 164, 37, 18, 163, 37, 18, 162, 36, 17, 164, 35, 15, 122, 48, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 63, 110, 20, 54, 94, 16, 44, 79,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 103, 129, 82, 104, 131, 82, 106, 134, 82, 108, 138, 91, 110, 138, 210, 122, 98, 234, 124, 89, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 126, 90, 233, 128, 91, 233, 131, 92, 234, 135, 93, 235, 140, 94, 237, 146, 95, 238, 148, 90, 255, 249, 245, 250, 226, 206, 246, 186, 133, 244, 169, 96, 244, 171, 99, 245, 171, 101, 244, 169, 101, 243, 167, 100, 241, 163, 99, 240, 158, 98, 238, 153, 97, 237, 150, 96, 236, 148, 96, 235, 146, 96, 235, 148, 96, 236, 151, 97, 238, 156, 98, 241, 164, 99, 244, 173, 101, 249, 183, 102, 254, 212, 150, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 251, 195, 115, 241, 150, 41, 234, 133, 37, 226, 118, 34, 221, 107, 31, 217, 99, 30, 214, 94, 30, 213, 93, 29, 213, 94, 29, 215, 98, 29, 217, 103, 31, 220, 109, 33, 223, 116, 33, 226, 121, 34, 227, 124, 36, 228, 126, 36, 227, 124, 32, 225, 118, 25, 230, 147, 82, 243, 208, 183, 247, 228, 217, 209, 99, 41, 200, 80, 26, 194, 70, 24, 188, 62, 22, 184, 55, 21, 180, 49, 20, 177, 45, 19, 175, 43, 19, 173, 42, 19, 172, 41, 19, 172, 41, 19, 171, 40, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 167, 38, 18, 167, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 163, 36, 18, 162, 36, 18, 163, 34, 15, 122, 47, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 25, 62, 109, 19, 50, 88, 16, 44, 79,
	81, 101, 125, 81, 101, 126, 81, 102, 128, 82, 102, 128, 82, 103, 130, 82, 104, 132, 82, 106, 134, 82, 108, 138, 91, 111, 139, 209, 121, 99, 233, 124, 89, 232, 123, 90, 232, 124, 90, 232, 124, 90, 231, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 232, 124, 90, 231, 123, 90, 231, 123, 90, 231, 124, 90, 232, 125, 90, 232, 128, 92, 233, 133, 92, 234, 137, 93, 236, 143, 95, 238, 150, 97, 240, 154, 92, 253, 242, 231, 255, 255, 255, 255, 255, 255, 254, 244, 233, 251, 213, 168, 250, 190, 117, 249, 186, 108, 248, 180, 103, 246, 176, 102, 245, 171, 101, 242, 166, 100, 241, 162, 99, 239, 158, 98, 238, 157, 98, 239, 158, 98, 240, 161, 99, 241, 166, 99, 243, 172, 101, 247, 181, 102, 252, 195, 112, 255, 253, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 241, 219, 247, 167, 58, 239, 144, 40, 233, 131, 37, 227, 121, 35, 224, 114, 33, 222, 110, 32, 221, 109, 33, 221, 111, 33, 224, 116, 33, 226, 123, 36, 230, 129, 37, 234, 136, 37, 237, 142, 39, 239, 149, 48, 240, 157, 63, 245, 191, 133, 253, 242, 230, 255, 255, 255, 255, 255, 255, 245, 217, 197, 213, 105, 40, 204, 86, 28, 196, 75, 25, 190, 65, 23, 185, 57, 21, 181, 50, 20, 177, 46, 20, 174, 43, 18, 173, 42, 18, 172, 42, 18, 172, 41, 18, 170, 40, 18, 170, 40, 18, 168, 39, 18, 168, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 163, 37, 18, 162, 36, 18, 161, 36, 18, 163, 35, 15, 122, 47, 52, 33, 74, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 66, 116, 23, 60, 106, 16, 46, 83, 16, 45, 79,
	83, 102, 126, 81, 101, 126, 81, 102, 128, 82, 102, 129, 82, 103, 130, 82, 104, 132, 82, 106, 135, 82, 108, 140, 91, 111, 141, 209, 122, 98, 233, 123, 89, 231, 123, 90, 231, 123, 90, 231, 123, 90, 231, 123, 90, 231, 124, 90, 231, 124, 90, 231, 124, 90, 231, 124, 90, 231, 124, 90, 231, 123, 90, 231, 123, 90, 231, 123, 90, 230, 123, 90, 231, 123, 90, 230, 125, 90, 231, 129, 92, 233, 132, 93, 235, 138, 93, 237, 145, 96, 240, 153, 97, 242, 161, 95, 251, 228, 205, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 252, 254, 233, 203, 253, 213, 156, 252, 199, 127, 250, 185, 102, 247, 178, 100, 246, 174, 101, 244, 171, 102, 243, 170, 101, 243, 169, 101, 244, 171, 101, 245, 175, 102, 247, 180, 102, 251, 188, 102, 254, 236, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 210, 147, 244, 152, 35, 238, 144, 40, 234, 135, 38, 231, 129, 36, 229, 126, 36, 230, 127, 36, 232, 131, 37, 234, 136, 37, 238, 141, 34, 242, 153, 42, 247, 174, 78, 250, 195, 120, 253, 225, 187, 255, 254, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 242, 198, 163, 217, 110, 37, 206, 92, 29, 198, 78, 26, 191, 67, 24, 185, 58, 22, 181, 50, 21, 177, 45, 19, 174, 42, 18, 173, 41, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 164, 37, 18, 162, 37, 18, 162, 36, 18, 161, 36, 18, 163, 34, 15, 122, 47, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 67, 116, 20, 55, 96, 17, 47, 83, 16, 45, 79,
	59, 83, 112, 82, 102, 127, 84, 104, 129, 82, 103, 130, 82, 104, 131, 82, 105, 134, 82, 107, 137, 83, 109, 141, 92, 112, 142, 208, 121, 99, 232, 123, 89, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 230, 123, 90, 229, 123, 90, 229, 123, 90, 230, 125, 90, 232, 128, 92, 233, 133, 92, 235, 139, 94, 238, 147, 96, 240, 157, 98, 243, 166, 97, 251, 216, 179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 232, 254, 233, 202, 253, 212, 155, 251, 189, 105, 249, 182, 97, 248, 181, 102, 248, 180, 103, 247, 181, 103, 248, 183, 104, 250, 186, 100, 253, 217, 163, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 249, 178, 80, 244, 152, 38, 241, 148, 41, 239, 144, 40, 238, 144, 40, 240, 145, 37, 242, 146, 28, 246, 164, 56, 251, 198, 125, 253, 226, 188, 255, 244, 228, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 181, 128, 220, 114, 34, 209, 95, 29, 200, 81, 26, 192, 69, 24, 185, 59, 22, 180, 50, 20, 176, 45, 19, 174, 43, 18, 172, 41, 18, 172, 41, 18, 171, 40, 18, 170, 40, 18, 168, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 164, 37, 17, 164, 37, 18, 163, 37, 18, 162, 36, 18, 161, 35, 18, 163, 34, 15, 122, 47, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 122, 25, 65, 114, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	24, 54, 90, 33, 64, 102, 61, 87, 119, 83, 104, 130, 83, 106, 133, 82, 106, 136, 83, 107, 139, 83, 110, 143, 92, 113, 144, 208, 121, 99, 231, 122, 89, 229, 122, 90, 229, 122, 90, 229, 123, 90, 230, 123, 90, 230, 123, 90, 229, 123, 90, 230, 122, 90, 229, 123, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 123, 90, 230, 125, 90, 231, 128, 92, 232, 133, 93, 235, 141, 94, 238, 149, 96, 241, 159, 99, 244, 170, 99, 251, 206, 154, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 250, 255, 250, 242, 254, 228, 188, 252, 200, 122, 251, 189, 99, 251, 190, 104, 251, 190, 105, 253, 201, 126, 255, 245, 230, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 237, 213, 248, 160, 37, 246, 159, 43, 246, 157, 40, 246, 157, 37, 249, 181, 84, 253, 224, 183, 255, 248, 239, 255, 253, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 171, 104, 221, 116, 33, 211, 98, 31, 201, 83, 27, 192, 70, 24, 185, 58, 22, 179, 50, 20, 175, 45, 19, 173, 42, 18, 172, 41, 18, 171, 41, 19, 171, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 163, 37, 18, 162, 36, 18, 161, 36, 18, 161, 36, 18, 163, 34, 15, 121, 47, 52, 33, 75, 130, 27, 74, 131, 27, 71, 126, 26, 69, 123, 22, 59, 104, 18, 48, 87, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 21, 58, 103, 30, 67, 112, 56, 87, 125, 77, 103, 136, 81, 108, 140, 84, 111, 145, 93, 114, 146, 208, 121, 100, 231, 122, 89, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 123, 90, 230, 125, 90, 230, 128, 92, 233, 133, 93, 234, 141, 94, 237, 149, 96, 241, 160, 99, 245, 173, 101, 250, 196, 129, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 218, 254, 213, 149, 253, 199, 117, 254, 227, 186, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 250, 252, 204, 131, 250, 172, 57, 252, 205, 133, 255, 243, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 247, 237, 239, 164, 86, 223, 119, 34, 211, 100, 31, 201, 83, 27, 192, 70, 24, 185, 58, 22, 179, 49, 20, 175, 44, 19, 173, 42, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 37, 18, 164, 37, 18, 163, 37, 18, 162, 36, 18, 161, 36, 18, 160, 35, 18, 163, 34, 15, 121, 47, 52, 33, 74, 130, 27, 74, 131, 27, 71, 126, 26, 69, 121, 19, 52, 94, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 24, 63, 110, 23, 65, 116, 26, 69, 121, 43, 83, 131, 60, 96, 139, 79, 106, 144, 206, 120, 99, 231, 122, 89, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 229, 122, 90, 228, 122, 90, 229, 122, 90, 228, 122, 90, 229, 124, 90, 229, 127, 91, 232, 133, 92, 234, 140, 95, 237, 149, 96, 241, 161, 99, 246, 174, 102, 251, 191, 115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 243, 255, 253, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 249, 255, 247, 236, 255, 243, 226, 255, 241, 219, 254, 234, 203, 254, 232, 198, 254, 233, 199, 254, 235, 206, 254, 239, 216, 254, 245, 230, 255, 253, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 246, 255, 252, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 238, 219, 239, 157, 68, 223, 120, 34, 212, 100, 31, 201, 84, 27, 191, 69, 24, 184, 58, 21, 178, 49, 20, 175, 44, 19, 172, 42, 18, 172, 41, 18, 171, 40, 18, 170, 40, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 166, 38, 18, 165, 37, 18, 165, 37, 18, 164, 37, 17, 163, 36, 18, 162, 36, 18, 161, 36, 18, 160, 35, 18, 162, 34, 15, 121, 46, 52, 33, 74, 130, 27, 74, 131, 27, 72, 127, 24, 63, 112, 18, 52, 92, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 121, 25, 72, 126, 25, 73, 130, 42, 80, 133, 200, 116, 97, 231, 123, 89, 228, 122, 90, 228, 122, 90, 228, 122, 90, 228, 122, 89, 229, 122, 90, 228, 122, 90, 228, 122, 90, 228, 122, 90, 228, 122, 90, 228, 122, 90, 228, 122, 90, 228, 122, 90, 227, 122, 90, 227, 121, 90, 228, 123, 90, 229, 126, 91, 231, 132, 93, 234, 139, 94, 236, 148, 96, 241, 160, 98, 246, 173, 102, 251, 192, 114, 255, 248, 236, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 247, 237, 253, 228, 195, 250, 212, 162, 250, 202, 143, 249, 197, 131, 249, 194, 122, 248, 177, 86, 246, 162, 53, 247, 160, 49, 247, 161, 50, 247, 164, 57, 246, 168, 67, 246, 173, 82, 247, 181, 100, 248, 194, 128, 251, 218, 178, 255, 248, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 230, 202, 238, 148, 50, 223, 119, 35, 210, 100, 31, 200, 82, 27, 191, 68, 24, 183, 56, 21, 178, 48, 20, 174, 43, 19, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 163, 37, 18, 162, 36, 18, 161, 36, 18, 160, 36, 17, 160, 35, 17, 162, 34, 14, 120, 46, 51, 33, 74, 130, 27, 74, 131, 27, 71, 125, 21, 57, 103, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 79, 132, 198, 115, 97, 230, 122, 89, 228, 121, 89, 227, 122, 90, 228, 122, 90, 227, 122, 90, 228, 122, 90, 228, 121, 90, 228, 122, 90, 227, 121, 90, 227, 121, 90, 228, 121, 90, 228, 121, 90, 227, 121, 90, 227, 122, 90, 227, 121, 90, 227, 123, 90, 229, 126, 91, 231, 131, 92, 232, 138, 93, 236, 147, 96, 240, 158, 98, 245, 173, 102, 251, 190, 112, 255, 240, 216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 236, 216, 248, 199, 140, 246, 183, 113, 245, 178, 106, 243, 175, 101, 243, 173, 101, 242, 172, 102, 238, 148, 61, 236, 135, 37, 235, 134, 37, 235, 134, 37, 235, 134, 37, 235, 134, 37, 234, 135, 38, 235, 136, 38, 235, 137, 37, 236, 139, 39, 237, 144, 45, 239, 150, 52, 244, 177, 101, 252, 231, 206, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 221, 182, 237, 139, 33, 222, 117, 35, 209, 97, 30, 198, 80, 26, 190, 66, 24, 182, 55, 21, 177, 47, 20, 174, 42, 19, 172, 41, 18, 171, 40, 18, 170, 40, 18, 169, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 162, 36, 18, 161, 35, 18, 160, 35, 18, 159, 35, 17, 161, 34, 14, 120, 46, 51, 33, 74, 130, 27, 74, 131, 25, 67, 119, 20, 53, 96, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 79, 132, 197, 115, 97, 230, 122, 89, 227, 121, 90, 227, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 122, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 122, 90, 229, 125, 90, 230, 129, 92, 232, 137, 94, 235, 146, 96, 239, 157, 98, 244, 170, 102, 249, 187, 108, 255, 233, 197, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 252, 254, 238, 217, 248, 195, 130, 245, 173, 95, 242, 171, 100, 241, 167, 101, 239, 165, 100, 238, 162, 99, 236, 154, 90, 229, 125, 46, 227, 115, 33, 227, 115, 34, 226, 114, 34, 225, 113, 34, 225, 113, 34, 225, 114, 34, 225, 115, 34, 225, 116, 33, 226, 117, 35, 226, 120, 35, 228, 123, 35, 230, 129, 37, 233, 132, 36, 236, 137, 32, 244, 171, 87, 253, 234, 211, 255, 253, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 250, 207, 152, 234, 135, 31, 220, 114, 33, 208, 94, 30, 197, 77, 26, 187, 63, 23, 181, 53, 21, 176, 45, 19, 173, 42, 19, 171, 41, 18, 170, 40, 18, 170, 40, 18, 169, 39, 18, 168, 39, 18, 166, 39, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 163, 37, 18, 163, 36, 18, 162, 36, 18, 161, 36, 18, 160, 35, 17, 159, 35, 17, 161, 33, 15, 120, 46, 52, 33, 74, 130, 27, 73, 130, 22, 62, 110, 19, 52, 94, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 79, 132, 197, 114, 97, 229, 122, 89, 227, 121, 89, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 120, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 227, 121, 90, 226, 121, 90, 227, 124, 90, 229, 128, 92, 231, 134, 93, 234, 144, 95, 238, 155, 98, 243, 168, 101, 248, 184, 105, 254, 224, 178, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 242, 222, 251, 208, 151, 246, 178, 96, 242, 171, 99, 240, 166, 100, 238, 161, 99, 236, 157, 99, 234, 151, 95, 229, 132, 70, 223, 107, 36, 220, 100, 29, 220, 98, 30, 218, 98, 30, 218, 96, 30, 217, 96, 30, 217, 96, 30, 217, 96, 30, 217, 97, 30, 217, 99, 29, 218, 101, 31, 219, 103, 31, 220, 107, 32, 222, 112, 33, 225, 118, 34, 229, 126, 36, 234, 133, 34, 239, 143, 30, 249, 192, 118, 254, 239, 215, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 249, 248, 190, 118, 232, 131, 32, 218, 111, 32, 205, 91, 29, 195, 75, 26, 186, 61, 23, 180, 51, 21, 175, 45, 19, 172, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 163, 37, 18, 162, 36, 18, 161, 36, 18, 160, 35, 18, 160, 35, 18, 159, 34, 17, 160, 33, 14, 119, 46, 51, 33, 75, 130, 26, 72, 127, 19, 55, 98, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 79, 132, 197, 114, 97, 229, 121, 89, 226, 120, 90, 226, 120, 90, 226, 120, 90, 226, 120, 90, 226, 121, 90, 226, 120, 90, 226, 120, 89, 226, 120, 89, 226, 120, 90, 226, 120, 90, 226, 120, 90, 226, 120, 90, 226, 120, 90, 225, 120, 90, 226, 120, 89, 226, 123, 90, 228, 127, 91, 230, 134, 93, 233, 143, 95, 237, 154, 97, 243, 167, 101, 248, 181, 103, 253, 216, 159, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 225, 180, 250, 193, 117, 245, 177, 98, 242, 170, 101, 238, 162, 99, 236, 156, 98, 234, 153, 100, 228, 134, 80, 221, 108, 47, 217, 92, 29, 215, 88, 27, 213, 86, 27, 213, 84, 27, 211, 83, 27, 211, 82, 27, 210, 82, 26, 210, 82, 26, 209, 82, 26, 209, 83, 26, 210, 84, 27, 210, 86, 28, 211, 89, 28, 213, 93, 29, 215, 97, 30, 218, 103, 31, 221, 111, 33, 226, 121, 35, 232, 132, 37, 238, 142, 35, 246, 166, 61, 253, 216, 160, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 244, 245, 173, 84, 229, 128, 33, 216, 108, 32, 204, 89, 28, 194, 73, 25, 185, 60, 23, 179, 50, 20, 174, 45, 20, 171, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 162, 36, 18, 162, 36, 18, 161, 36, 17, 160, 35, 18, 159, 35, 17, 158, 34, 18, 160, 33, 15, 119, 46, 51, 33, 75, 131, 22, 63, 111, 19, 54, 96, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 79, 132, 196, 113, 97, 228, 121, 89, 225, 120, 90, 225, 120, 89, 225, 120, 90, 225, 120, 90, 226, 120, 89, 226, 120, 90, 226, 120, 90, 226, 120, 90, 225, 120, 90, 225, 120, 89, 225, 120, 90, 225, 120, 89, 224, 119, 90, 225, 119, 89, 224, 121, 90, 226, 123, 90, 228, 127, 91, 230, 134, 93, 233, 143, 95, 238, 153, 97, 242, 166, 100, 248, 180, 103, 253, 210, 148, 255, 254, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 252, 253, 211, 146, 249, 188, 105, 244, 177, 101, 241, 167, 100, 237, 159, 98, 234, 152, 97, 230, 143, 92, 222, 111, 54, 216, 90, 31, 213, 83, 26, 211, 79, 25, 210, 77, 25, 208, 74, 24, 207, 73, 24, 206, 71, 24, 205, 70, 24, 205, 70, 24, 203, 70, 23, 204, 70, 23, 204, 71, 24, 204, 72, 24, 204, 74, 24, 205, 76, 25, 206, 80, 25, 208, 84, 27, 210, 89, 28, 214, 97, 29, 218, 105, 32, 223, 115, 33, 230, 127, 37, 237, 141, 39, 245, 157, 43, 252, 196, 111, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 248, 241, 242, 155, 49, 228, 127, 35, 215, 106, 32, 203, 88, 28, 193, 73, 25, 184, 60, 23, 178, 51, 20, 174, 44, 19, 172, 41, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 166, 38, 18, 166, 38, 18, 165, 37, 18, 164, 37, 18, 163, 36, 18, 162, 36, 18, 161, 36, 17, 161, 36, 18, 159, 35, 17, 159, 34, 17, 158, 34, 18, 159, 33, 15, 119, 46, 52, 32, 71, 125, 19, 56, 99, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 79, 132, 195, 113, 97, 227, 120, 89, 225, 119, 89, 225, 119, 90, 225, 119, 89, 225, 119, 90, 225, 120, 90, 225, 120, 89, 225, 119, 90, 225, 120, 90, 225, 119, 89, 225, 119, 89, 224, 119, 89, 224, 120, 89, 224, 120, 89, 224, 120, 90, 225, 121, 89, 226, 124, 90, 228, 129, 91, 230, 135, 93, 234, 144, 95, 237, 155, 97, 242, 167, 101, 247, 180, 103, 253, 206, 138, 255, 250, 241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 242, 253, 210, 142, 248, 185, 103, 243, 175, 102, 239, 165, 100, 236, 156, 97, 231, 146, 93, 226, 123, 69, 216, 91, 32, 212, 80, 25, 211, 76, 25, 208, 73, 24, 206, 70, 24, 205, 67, 23, 204, 65, 23, 202, 64, 22, 201, 62, 22, 201, 62, 22, 200, 61, 22, 200, 61, 22, 199, 61, 22, 199, 62, 22, 199, 63, 22, 199, 64, 23, 199, 66, 23, 200, 69, 23, 201, 73, 24, 204, 76, 25, 206, 82, 26, 210, 90, 28, 215, 99, 30, 220, 109, 32, 227, 123, 35, 235, 138, 39, 243, 153, 37, 252, 186, 90, 255, 251, 246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 242, 224, 241, 143, 26, 228, 127, 36, 215, 108, 31, 204, 90, 29, 194, 75, 25, 185, 62, 23, 180, 52, 20, 175, 46, 19, 172, 43, 19, 170, 41, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 163, 36, 18, 162, 36, 17, 161, 36, 18, 160, 35, 18, 159, 35, 17, 158, 35, 17, 158, 34, 17, 159, 33, 14, 119, 47, 53, 27, 60, 107, 19, 56, 99, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 79, 132, 195, 113, 97, 227, 120, 89, 224, 119, 89, 224, 119, 90, 224, 119, 89, 224, 119, 89, 224, 119, 90, 224, 119, 90, 224, 119, 89, 224, 119, 89, 224, 119, 89, 224, 119, 89, 224, 120, 89, 225, 121, 90, 225, 122, 89, 225, 123, 90, 226, 124, 90, 227, 127, 91, 228, 131, 92, 231, 138, 93, 234, 147, 96, 238, 158, 98, 243, 169, 101, 248, 181, 103, 253, 202, 127, 255, 246, 231, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 245, 252, 211, 148, 248, 183, 99, 243, 174, 103, 238, 163, 100, 233, 146, 86, 226, 125, 66, 218, 97, 37, 212, 80, 22, 210, 76, 24, 207, 72, 24, 205, 68, 23, 205, 65, 23, 202, 62, 22, 201, 61, 22, 200, 60, 21, 199, 59, 21, 198, 58, 21, 198, 57, 21, 197, 56, 21, 196, 56, 21, 196, 56, 21, 196, 57, 21, 195, 57, 21, 195, 57, 21, 196, 59, 22, 196, 60, 22, 197, 63, 21, 197, 67, 23, 200, 71, 24, 203, 76, 25, 206, 85, 27, 211, 94, 29, 217, 106, 32, 225, 120, 34, 233, 136, 38, 242, 151, 38, 251, 188, 99, 255, 248, 238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 223, 181, 241, 145, 30, 229, 130, 36, 217, 112, 33, 207, 94, 29, 197, 79, 26, 188, 67, 23, 181, 57, 21, 177, 51, 20, 174, 47, 19, 172, 44, 19, 170, 42, 19, 169, 42, 18, 168, 40, 18, 166, 39, 18, 165, 38, 18, 164, 37, 18, 163, 37, 18, 163, 36, 18, 161, 36, 18, 161, 35, 17, 160, 35, 17, 159, 35, 17, 158, 34, 18, 157, 34, 17, 159, 33, 15, 117, 42, 44, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 79, 132, 195, 113, 97, 226, 120, 88, 224, 119, 89, 224, 119, 89, 224, 119, 90, 224, 119, 90, 224, 119, 89, 224, 119, 89, 224, 120, 90, 224, 120, 89, 225, 121, 89, 225, 121, 90, 225, 122, 90, 226, 123, 90, 226, 125, 91, 226, 127, 91, 227, 128, 91, 228, 131, 92, 230, 136, 93, 232, 144, 95, 235, 153, 96, 240, 162, 99, 244, 173, 101, 248, 184, 104, 253, 199, 116, 255, 242, 221, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 212, 151, 247, 184, 102, 243, 172, 101, 236, 149, 79, 228, 123, 55, 221, 102, 37, 215, 86, 26, 212, 78, 24, 209, 73, 24, 206, 68, 23, 204, 65, 22, 203, 62, 21, 201, 60, 21, 200, 58, 21, 199, 57, 20, 198, 56, 20, 197, 56, 20, 197, 55, 20, 196, 55, 20, 195, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 193, 54, 20, 193, 54, 20, 192, 54, 20, 193, 55, 21, 193, 56, 21, 194, 59, 21, 194, 62, 22, 197, 66, 23, 199, 72, 25, 204, 80, 26, 209, 90, 28, 215, 103, 31, 223, 117, 34, 232, 133, 37, 241, 148, 37, 250, 191, 112, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 204, 136, 242, 148, 33, 232, 134, 38, 221, 117, 34, 211, 102, 30, 201, 88, 28, 193, 75, 25, 187, 65, 23, 182, 58, 22, 178, 53, 21, 175, 50, 20, 173, 48, 19, 171, 45, 20, 169, 43, 19, 167, 42, 19, 166, 40, 19, 164, 38, 18, 163, 37, 18, 162, 37, 18, 161, 36, 18, 160, 35, 17, 159, 35, 18, 158, 35, 17, 157, 34, 17, 157, 34, 17, 159, 32, 16, 116, 40, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 39, 78, 131, 192, 105, 88, 226, 121, 90, 223, 120, 91, 223, 119, 90, 224, 119, 89, 224, 120, 89, 223, 120, 89, 223, 120, 89, 224, 120, 89, 225, 121, 90, 225, 122, 90, 225, 124, 90, 225, 125, 90, 226, 127, 91, 227, 128, 92, 228, 131, 92, 229, 134, 93, 230, 138, 93, 232, 144, 95, 235, 151, 96, 239, 159, 98, 243, 168, 100, 246, 177, 103, 250, 187, 105, 253, 196, 106, 255, 238, 211, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 218, 168, 247, 178, 92, 240, 153, 66, 232, 128, 42, 226, 109, 34, 219, 95, 29, 214, 85, 26, 211, 77, 25, 207, 71, 23, 205, 66, 22, 203, 63, 21, 202, 60, 22, 201, 58, 20, 200, 57, 20, 199, 56, 20, 197, 55, 20, 197, 55, 20, 197, 55, 20, 196, 55, 20, 195, 54, 20, 195, 54, 20, 194, 53, 20, 194, 53, 20, 193, 52, 20, 192, 52, 20, 191, 52, 20, 191, 52, 20, 191, 52, 19, 190, 53, 20, 191, 54, 20, 192, 56, 20, 192, 59, 22, 194, 63, 23, 197, 69, 23, 201, 78, 26, 207, 89, 27, 214, 102, 31, 223, 117, 34, 231, 132, 37, 239, 144, 35, 250, 205, 146, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 186, 92, 243, 153, 38, 236, 141, 39, 227, 126, 36, 217, 113, 32, 209, 99, 30, 200, 87, 27, 194, 77, 26, 189, 69, 25, 184, 63, 23, 181, 58, 22, 178, 54, 21, 175, 51, 21, 173, 49, 20, 170, 46, 20, 168, 43, 19, 166, 41, 19, 165, 39, 19, 163, 38, 18, 162, 37, 17, 160, 36, 17, 159, 35, 18, 157, 34, 18, 157, 34, 18, 157, 34, 17, 159, 32, 15, 115, 40, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 182, 63, 36, 213, 68, 27, 215, 87, 51, 219, 105, 73, 222, 115, 84, 222, 117, 86, 224, 119, 87, 224, 121, 90, 224, 123, 90, 225, 124, 90, 225, 125, 91, 226, 128, 91, 227, 129, 92, 228, 132, 92, 229, 136, 93, 230, 138, 93, 232, 142, 95, 234, 147, 96, 236, 152, 97, 239, 160, 99, 242, 168, 101, 245, 176, 102, 249, 185, 104, 251, 192, 105, 253, 195, 101, 255, 233, 199, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 227, 190, 245, 159, 53, 239, 138, 37, 232, 124, 34, 225, 109, 32, 219, 96, 29, 214, 84, 26, 210, 76, 24, 207, 70, 23, 204, 65, 22, 202, 61, 21, 202, 59, 21, 200, 57, 20, 199, 57, 20, 199, 56, 20, 198, 56, 20, 197, 55, 20, 197, 55, 20, 196, 55, 20, 195, 54, 20, 194, 53, 20, 194, 53, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 191, 51, 20, 190, 51, 20, 189, 51, 20, 189, 51, 20, 189, 51, 20, 189, 52, 21, 189, 54, 21, 191, 57, 21, 193, 62, 22, 195, 68, 23, 200, 77, 25, 206, 88, 27, 214, 102, 31, 222, 117, 34, 231, 132, 37, 238, 141, 30, 252, 230, 201, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 172, 55, 248, 160, 40, 241, 149, 39, 234, 138, 37, 226, 126, 36, 218, 115, 34, 210, 102, 31, 204, 92, 29, 197, 83, 27, 193, 77, 26, 188, 71, 25, 185, 66, 23, 181, 61, 22, 178, 57, 21, 175, 52, 21, 172, 49, 20, 169, 45, 20, 167, 43, 19, 164, 41, 18, 162, 38, 19, 161, 37, 18, 160, 36, 18, 158, 35, 17, 157, 34, 17, 156, 34, 17, 159, 32, 16, 115, 40, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 181, 64, 38, 211, 61, 19, 209, 60, 18, 208, 60, 17, 210, 65, 23, 213, 77, 37, 216, 89, 49, 219, 99, 61, 221, 108, 69, 223, 114, 74, 224, 120, 79, 226, 125, 83, 228, 131, 85, 230, 135, 88, 232, 141, 90, 234, 146, 92, 235, 149, 93, 237, 155, 94, 240, 161, 94, 243, 168, 94, 246, 175, 93, 249, 180, 87, 252, 187, 90, 253, 204, 126, 254, 221, 164, 255, 245, 229, 255, 255, 255, 255, 255, 255, 254, 247, 237, 247, 173, 82, 239, 141, 37, 233, 127, 36, 226, 112, 33, 220, 98, 29, 214, 86, 27, 209, 76, 24, 206, 69, 23, 204, 64, 22, 202, 61, 21, 201, 59, 21, 200, 57, 20, 199, 56, 20, 198, 56, 20, 198, 55, 20, 197, 55, 20, 196, 55, 20, 196, 54, 20, 195, 54, 20, 195, 54, 20, 194, 53, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 191, 52, 20, 190, 51, 20, 189, 51, 19, 189, 50, 20, 188, 50, 20, 188, 50, 20, 188, 50, 19, 187, 51, 20, 188, 53, 20, 189, 56, 21, 191, 61, 22, 195, 68, 24, 200, 78, 25, 207, 90, 29, 214, 104, 31, 222, 118, 34, 231, 132, 36, 241, 157, 62, 254, 248, 241, 255, 255, 255, 255, 255, 255, 254, 218, 166, 252, 192, 107, 248, 171, 67, 243, 150, 35, 237, 141, 34, 229, 132, 37, 222, 121, 35, 215, 110, 32, 209, 101, 31, 204, 93, 30, 199, 86, 28, 194, 80, 27, 189, 73, 25, 185, 68, 24, 180, 62, 23, 177, 57, 22, 173, 52, 21, 170, 48, 20, 167, 45, 20, 164, 41, 19, 162, 38, 18, 160, 37, 18, 158, 36, 17, 157, 34, 17, 156, 33, 17, 158, 32, 15, 115, 40, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 181, 64, 38, 210, 61, 19, 208, 62, 21, 209, 63, 21, 208, 64, 21, 209, 65, 21, 210, 67, 21, 212, 70, 21, 214, 75, 23, 216, 84, 28, 219, 92, 34, 222, 100, 39, 225, 108, 42, 228, 115, 45, 230, 123, 48, 233, 131, 50, 236, 138, 53, 239, 146, 53, 243, 154, 52, 247, 159, 46, 250, 171, 56, 253, 203, 125, 254, 230, 191, 255, 245, 229, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 251, 212, 161, 241, 145, 37, 234, 130, 37, 228, 115, 33, 221, 101, 30, 216, 88, 27, 211, 78, 26, 206, 70, 23, 204, 64, 22, 202, 60, 21, 200, 59, 21, 199, 57, 20, 199, 56, 20, 198, 56, 20, 197, 55, 20, 197, 55, 20, 196, 55, 20, 196, 54, 20, 196, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 193, 52, 20, 192, 52, 20, 192, 52, 20, 191, 51, 20, 190, 51, 20, 190, 51, 20, 189, 50, 19, 188, 50, 20, 188, 49, 20, 187, 49, 19, 186, 48, 19, 186, 49, 19, 186, 50, 19, 186, 52, 20, 188, 56, 21, 190, 61, 22, 194, 68, 24, 200, 80, 26, 207, 92, 29, 215, 106, 32, 224, 121, 35, 233, 136, 39, 246, 195, 136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 254, 239, 217, 253, 219, 172, 249, 185, 102, 242, 153, 39, 236, 139, 30, 229, 132, 36, 223, 123, 35, 217, 114, 33, 211, 105, 31, 206, 97, 30, 200, 89, 28, 194, 81, 27, 189, 74, 25, 184, 67, 24, 179, 61, 22, 174, 55, 21, 170, 49, 20, 166, 45, 20, 163, 41, 19, 161, 38, 18, 159, 36, 18, 157, 35, 17, 155, 34, 17, 157, 32, 15, 115, 40, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 180, 64, 38, 209, 61, 19, 208, 62, 21, 208, 63, 22, 208, 65, 22, 210, 68, 23, 212, 71, 23, 213, 76, 24, 216, 81, 26, 218, 88, 27, 221, 95, 28, 225, 103, 31, 227, 112, 32, 231, 121, 34, 235, 129, 36, 239, 139, 38, 242, 148, 40, 246, 155, 36, 251, 172, 57, 254, 215, 155, 255, 246, 233, 255, 253, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 244, 245, 162, 63, 237, 135, 36, 229, 120, 36, 223, 105, 31, 217, 91, 28, 212, 81, 26, 207, 71, 23, 204, 66, 22, 202, 61, 21, 200, 58, 21, 199, 56, 20, 198, 56, 20, 198, 56, 20, 198, 55, 20, 196, 55, 20, 197, 54, 20, 196, 54, 20, 195, 54, 20, 194, 53, 20, 194, 53, 20, 194, 53, 20, 192, 52, 20, 192, 52, 20, 191, 52, 20, 191, 52, 20, 190, 51, 20, 190, 50, 20, 189, 50, 20, 189, 50, 19, 187, 49, 19, 187, 49, 19, 186, 49, 19, 185, 49, 19, 185, 48, 19, 184, 49, 19, 185, 49, 20, 186, 51, 20, 187, 56, 21, 190, 62, 22, 196, 72, 24, 201, 82, 27, 209, 96, 29, 218, 110, 32, 228, 126, 36, 239, 156, 66, 252, 237, 218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 247, 254, 243, 227, 251, 208, 149, 245, 162, 54, 238, 144, 32, 232, 136, 36, 225, 127, 36, 218, 117, 34, 211, 107, 32, 205, 97, 30, 198, 88, 27, 191, 79, 26, 185, 70, 25, 179, 62, 23, 174, 54, 21, 169, 49, 20, 165, 44, 20, 162, 40, 19, 159, 37, 19, 157, 35, 17, 155, 34, 17, 157, 32, 15, 115, 40, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 180, 63, 38, 209, 61, 19, 207, 62, 21, 207, 63, 22, 208, 66, 22, 210, 69, 23, 212, 74, 24, 214, 79, 25, 217, 88, 27, 221, 96, 29, 225, 105, 31, 229, 116, 34, 233, 127, 36, 238, 137, 38, 242, 149, 42, 247, 163, 54, 251, 184, 86, 254, 228, 184, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 215, 166, 240, 140, 28, 233, 127, 36, 225, 111, 33, 219, 97, 29, 213, 84, 27, 208, 74, 25, 204, 67, 22, 202, 61, 21, 201, 58, 22, 199, 57, 20, 198, 56, 20, 198, 55, 20, 197, 55, 20, 196, 54, 20, 196, 55, 20, 195, 55, 20, 195, 54, 20, 194, 53, 20, 194, 53, 20, 193, 53, 20, 193, 53, 20, 192, 52, 19, 191, 52, 20, 191, 52, 20, 190, 51, 20, 190, 51, 20, 189, 50, 20, 188, 50, 19, 188, 50, 20, 187, 49, 20, 186, 49, 19, 185, 49, 20, 185, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 49, 20, 184, 52, 21, 187, 57, 21, 191, 64, 23, 196, 74, 24, 204, 87, 28, 212, 102, 31, 222, 118, 34, 232, 132, 30, 248, 206, 156, 255, 254, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 228, 192, 248, 184, 98, 241, 155, 52, 233, 140, 42, 225, 125, 34, 217, 114, 32, 208, 103, 31, 200, 91, 29, 192, 80, 26, 184, 70, 25, 177, 61, 23, 172, 52, 21, 166, 47, 20, 163, 41, 19, 160, 38, 18, 157, 35, 18, 156, 34, 17, 156, 32, 15, 114, 40, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 179, 62, 38, 208, 60, 19, 207, 62, 21, 207, 63, 22, 208, 66, 22, 210, 71, 24, 212, 76, 25, 216, 84, 27, 219, 94, 28, 224, 104, 31, 228, 115, 32, 234, 126, 30, 239, 142, 41, 246, 172, 81, 251, 202, 134, 254, 237, 210, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 165, 62, 237, 137, 36, 229, 119, 35, 222, 104, 31, 216, 89, 28, 210, 78, 25, 206, 69, 23, 202, 63, 22, 200, 59, 22, 199, 57, 20, 198, 56, 20, 197, 55, 20, 197, 55, 20, 197, 54, 20, 196, 54, 20, 196, 54, 20, 195, 54, 20, 194, 54, 20, 194, 53, 20, 194, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 191, 51, 20, 190, 51, 20, 190, 51, 20, 189, 50, 20, 188, 50, 20, 188, 50, 20, 187, 49, 19, 186, 49, 19, 186, 49, 19, 185, 49, 19, 184, 48, 19, 184, 47, 19, 183, 47, 19, 183, 47, 19, 183, 48, 19, 183, 49, 20, 184, 53, 21, 187, 59, 22, 193, 67, 23, 199, 79, 26, 208, 93, 29, 218, 110, 33, 228, 128, 34, 242, 163, 72, 254, 250, 244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 243, 228, 249, 207, 154, 241, 173, 96, 230, 142, 54, 218, 115, 28, 208, 102, 27, 199, 90, 28, 190, 78, 26, 181, 67, 24, 174, 56, 22, 168, 48, 20, 163, 43, 19, 160, 38, 18, 157, 36, 18, 155, 34, 17, 156, 32, 15, 114, 39, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 178, 62, 38, 207, 59, 19, 205, 61, 21, 206, 64, 22, 208, 67, 22, 210, 73, 24, 213, 79, 25, 217, 88, 27, 221, 97, 27, 225, 104, 21, 233, 128, 41, 244, 181, 119, 251, 223, 189, 254, 245, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 229, 194, 243, 147, 32, 234, 131, 37, 225, 113, 33, 219, 97, 30, 213, 84, 26, 208, 73, 24, 204, 66, 22, 201, 60, 21, 199, 58, 20, 198, 56, 20, 197, 55, 20, 196, 55, 20, 196, 55, 20, 196, 54, 20, 195, 54, 20, 195, 54, 20, 194, 53, 20, 193, 53, 20, 193, 53, 20, 193, 52, 20, 192, 52, 20, 191, 52, 20, 191, 51, 20, 190, 51, 19, 189, 51, 19, 189, 51, 19, 188, 50, 19, 188, 49, 20, 187, 49, 20, 186, 49, 19, 186, 49, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 182, 46, 19, 181, 46, 19, 182, 47, 19, 181, 47, 19, 182, 50, 20, 185, 55, 21, 189, 63, 22, 195, 73, 25, 203, 87, 28, 213, 104, 31, 224, 123, 35, 236, 139, 28, 253, 229, 199, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 248, 251, 231, 208, 242, 198, 156, 224, 145, 81, 204, 93, 19, 193, 79, 19, 185, 71, 24, 176, 61, 23, 170, 51, 21, 164, 45, 20, 160, 40, 18, 157, 36, 18, 155, 34, 17, 156, 32, 15, 114, 39, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 177, 61, 38, 206, 59, 19, 205, 61, 21, 206, 64, 22, 208, 67, 22, 210, 73, 24, 214, 81, 26, 217, 91, 28, 226, 120, 57, 243, 193, 157, 253, 244, 236, 255, 252, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 190, 105, 241, 145, 38, 232, 125, 36, 223, 107, 32, 216, 92, 28, 210, 79, 26, 205, 70, 23, 201, 63, 22, 199, 58, 21, 198, 56, 20, 197, 55, 20, 196, 55, 20, 196, 54, 20, 196, 54, 20, 195, 54, 20, 194, 53, 20, 194, 53, 20, 193, 53, 20, 193, 52, 20, 192, 52, 20, 192, 52, 20, 191, 52, 20, 191, 52, 20, 190, 51, 20, 189, 51, 19, 189, 51, 20, 188, 50, 20, 187, 50, 20, 187, 49, 19, 186, 49, 19, 186, 49, 20, 185, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 182, 47, 19, 182, 46, 19, 181, 46, 19, 180, 46, 19, 181, 46, 19, 180, 48, 20, 182, 52, 20, 186, 59, 21, 191, 68, 24, 199, 81, 27, 209, 97, 30, 221, 117, 34, 233, 136, 32, 249, 190, 112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 253, 249, 245, 248, 231, 220, 222, 158, 123, 192, 87, 39, 179, 64, 23, 171, 54, 22, 165, 46, 20, 160, 40, 18, 156, 36, 18, 155, 34, 17, 155, 32, 15, 113, 39, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 176, 61, 38, 205, 58, 19, 204, 61, 21, 205, 63, 22, 207, 68, 22, 210, 74, 24, 214, 81, 26, 218, 94, 30, 236, 166, 123, 255, 253, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 248, 249, 168, 57, 238, 140, 39, 229, 120, 35, 220, 102, 31, 213, 87, 27, 207, 75, 25, 202, 66, 23, 199, 60, 21, 198, 57, 20, 197, 55, 20, 196, 54, 20, 195, 54, 20, 195, 54, 20, 195, 53, 20, 195, 54, 20, 193, 53, 20, 193, 52, 20, 193, 52, 20, 192, 53, 20, 191, 52, 20, 191, 52, 20, 191, 51, 20, 190, 51, 19, 189, 50, 19, 189, 51, 19, 188, 50, 20, 188, 50, 19, 187, 49, 19, 187, 49, 19, 186, 48, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 184, 47, 19, 183, 47, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 180, 46, 19, 181, 49, 20, 184, 55, 22, 189, 64, 24, 196, 76, 26, 206, 92, 28, 217, 111, 33, 230, 132, 37, 245, 157, 41, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 240, 234, 206, 124, 86, 180, 65, 24, 171, 55, 22, 165, 47, 20, 160, 40, 18, 156, 36, 18, 154, 34, 17, 155, 31, 15, 113, 38, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 176, 61, 38, 205, 58, 20, 203, 59, 21, 204, 63, 21, 206, 67, 23, 209, 72, 24, 212, 80, 27, 217, 91, 28, 222, 100, 25, 238, 164, 109, 253, 244, 235, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 197, 246, 161, 51, 236, 135, 38, 225, 115, 33, 217, 97, 30, 211, 83, 27, 205, 72, 24, 200, 63, 22, 198, 58, 21, 197, 56, 20, 196, 54, 20, 196, 54, 20, 195, 54, 20, 194, 54, 20, 194, 53, 19, 194, 53, 20, 193, 53, 20, 193, 52, 20, 192, 52, 20, 191, 52, 20, 191, 52, 19, 191, 51, 20, 190, 51, 20, 190, 51, 20, 188, 50, 20, 188, 50, 20, 187, 50, 20, 187, 49, 19, 186, 49, 19, 186, 48, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 179, 45, 19, 179, 45, 19, 178, 44, 19, 179, 46, 19, 179, 47, 20, 182, 52, 20, 187, 61, 22, 193, 72, 25, 202, 88, 28, 213, 106, 32, 226, 128, 36, 241, 149, 33, 254, 233, 201, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 217, 198, 208, 119, 65, 187, 72, 18, 178, 65, 24, 171, 54, 21, 165, 45, 20, 160, 40, 18, 155, 35, 18, 154, 34, 17, 154, 31, 15, 112, 38, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 175, 60, 38, 204, 58, 19, 202, 59, 21, 204, 62, 22, 205, 65, 22, 207, 71, 23, 211, 78, 25, 215, 88, 28, 220, 101, 30, 227, 112, 27, 239, 158, 83, 253, 239, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 213, 152, 243, 154, 45, 233, 130, 37, 223, 110, 32, 215, 93, 29, 208, 79, 26, 203, 68, 23, 199, 61, 22, 197, 57, 21, 195, 54, 20, 195, 54, 20, 194, 53, 20, 194, 53, 20, 194, 53, 20, 193, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 191, 52, 20, 190, 51, 20, 190, 51, 20, 190, 51, 19, 189, 50, 19, 188, 50, 20, 188, 50, 19, 188, 49, 20, 186, 49, 19, 186, 48, 20, 185, 48, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 182, 47, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 179, 45, 19, 179, 45, 19, 178, 44, 19, 178, 44, 19, 177, 44, 18, 177, 46, 19, 179, 50, 20, 184, 58, 22, 190, 69, 24, 199, 83, 27, 210, 101, 31, 223, 122, 35, 238, 145, 36, 253, 207, 142, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 194, 153, 213, 116, 46, 196, 86, 23, 186, 74, 26, 176, 62, 23, 169, 52, 21, 163, 44, 20, 158, 39, 18, 155, 35, 18, 152, 33, 17, 154, 31, 15, 112, 39, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 174, 60, 38, 202, 57, 19, 201, 58, 21, 202, 60, 21, 203, 64, 22, 205, 69, 23, 209, 75, 25, 213, 84, 26, 219, 96, 30, 224, 110, 32, 232, 126, 35, 241, 154, 61, 253, 233, 206, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 197, 117, 240, 147, 40, 230, 125, 36, 220, 105, 32, 213, 90, 28, 207, 76, 24, 201, 65, 23, 198, 60, 22, 196, 56, 20, 194, 53, 20, 194, 53, 20, 194, 53, 20, 193, 53, 20, 192, 53, 20, 193, 52, 20, 192, 52, 20, 191, 52, 20, 191, 52, 19, 190, 51, 20, 190, 51, 20, 189, 51, 20, 189, 50, 19, 189, 50, 20, 188, 50, 19, 187, 49, 19, 186, 49, 19, 186, 49, 19, 186, 48, 19, 185, 48, 19, 184, 48, 19, 183, 48, 19, 183, 47, 19, 183, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 179, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 19, 177, 44, 19, 176, 43, 19, 176, 44, 19, 179, 49, 20, 182, 55, 21, 188, 65, 24, 196, 80, 26, 207, 96, 30, 220, 117, 35, 235, 140, 38, 250, 183, 91, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 250, 240, 181, 122, 220, 121, 39, 205, 100, 30, 193, 84, 27, 183, 70, 25, 173, 58, 22, 167, 49, 21, 161, 43, 19, 157, 37, 18, 154, 34, 18, 152, 33, 17, 153, 30, 15, 112, 39, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 174, 60, 38, 202, 57, 19, 200, 58, 20, 200, 59, 21, 202, 62, 21, 204, 66, 23, 206, 72, 24, 210, 79, 25, 215, 90, 28, 221, 103, 31, 228, 118, 34, 235, 133, 36, 243, 158, 56, 253, 229, 197, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 246, 249, 186, 99, 238, 141, 38, 228, 120, 34, 218, 102, 31, 211, 86, 28, 204, 74, 24, 199, 64, 22, 196, 57, 22, 194, 54, 20, 194, 53, 20, 194, 53, 20, 192, 53, 20, 192, 52, 20, 192, 52, 20, 192, 52, 20, 191, 52, 20, 191, 51, 20, 190, 51, 20, 190, 51, 20, 189, 50, 20, 189, 50, 20, 188, 50, 20, 187, 50, 20, 188, 49, 20, 186, 49, 19, 186, 48, 19, 186, 48, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 183, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 180, 46, 19, 180, 46, 19, 179, 45, 19, 179, 45, 19, 178, 44, 19, 178, 44, 19, 176, 44, 19, 176, 43, 19, 176, 43, 18, 177, 47, 20, 181, 53, 20, 186, 63, 24, 194, 76, 25, 204, 93, 29, 216, 112, 33, 231, 134, 38, 247, 166, 58, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 246, 237, 242, 176, 104, 224, 123, 29, 211, 108, 32, 198, 92, 29, 187, 77, 26, 178, 65, 24, 170, 54, 21, 164, 46, 20, 160, 40, 19, 156, 36, 18, 153, 34, 18, 152, 32, 17, 153, 30, 15, 112, 39, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 172, 59, 38, 201, 56, 18, 199, 57, 20, 200, 58, 21, 201, 61, 21, 202, 64, 22, 204, 68, 23, 208, 75, 25, 211, 84, 26, 217, 94, 29, 223, 108, 32, 230, 122, 35, 236, 136, 35, 245, 158, 50, 253, 221, 177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 232, 246, 175, 84, 235, 135, 37, 225, 116, 33, 216, 98, 30, 209, 82, 26, 203, 71, 24, 198, 62, 22, 195, 57, 20, 194, 53, 20, 193, 53, 20, 193, 53, 20, 192, 52, 20, 192, 52, 20, 192, 52, 20, 191, 51, 20, 191, 51, 20, 190, 51, 20, 189, 51, 20, 189, 50, 20, 189, 50, 19, 188, 50, 19, 188, 50, 20, 187, 50, 19, 187, 49, 19, 186, 48, 19, 185, 48, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 179, 45, 19, 178, 44, 19, 178, 44, 19, 177, 44, 18, 176, 43, 18, 176, 43, 19, 175, 43, 19, 175, 43, 18, 176, 46, 19, 179, 51, 21, 184, 60, 22, 192, 73, 25, 201, 88, 28, 213, 107, 32, 226, 128, 37, 242, 158, 54, 255, 248, 235, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 233, 207, 241, 165, 76, 226, 125, 26, 214, 112, 33, 202, 96, 30, 191, 81, 27, 182, 68, 25, 174, 58, 22, 167, 50, 20, 162, 43, 20, 157, 38, 18, 155, 35, 18, 153, 33, 17, 150, 32, 17, 152, 30, 15, 111, 38, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 173, 59, 38, 200, 55, 18, 198, 55, 20, 198, 58, 20, 200, 58, 21, 200, 61, 21, 201, 65, 22, 205, 70, 23, 208, 77, 25, 212, 85, 27, 217, 97, 29, 222, 108, 32, 229, 123, 35, 236, 137, 36, 244, 156, 44, 252, 206, 139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 240, 221, 243, 164, 72, 232, 130, 36, 222, 111, 33, 214, 93, 29, 207, 79, 26, 202, 69, 24, 197, 61, 21, 195, 55, 21, 193, 53, 20, 192, 52, 20, 192, 52, 19, 191, 52, 20, 191, 51, 20, 190, 51, 20, 190, 51, 19, 190, 51, 19, 189, 51, 19, 189, 50, 19, 188, 50, 20, 188, 50, 20, 187, 49, 19, 186, 49, 19, 186, 49, 19, 186, 48, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 19, 177, 44, 19, 176, 44, 18, 176, 43, 19, 175, 43, 19, 174, 42, 18, 174, 42, 18, 175, 44, 19, 178, 49, 21, 182, 58, 22, 190, 69, 25, 199, 84, 27, 210, 102, 31, 222, 122, 35, 237, 149, 51, 254, 237, 215, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 215, 169, 239, 154, 56, 226, 127, 32, 214, 112, 33, 202, 97, 30, 192, 82, 27, 183, 70, 24, 175, 60, 22, 168, 51, 21, 163, 45, 19, 159, 40, 19, 155, 36, 18, 154, 34, 18, 152, 32, 17, 149, 31, 17, 152, 30, 15, 111, 38, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 172, 59, 38, 199, 55, 18, 197, 55, 20, 197, 55, 20, 198, 57, 20, 199, 59, 21, 199, 61, 21, 202, 65, 22, 204, 70, 23, 207, 76, 25, 211, 85, 27, 216, 95, 29, 221, 107, 32, 228, 121, 35, 235, 137, 38, 243, 152, 44, 251, 197, 119, 255, 253, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 235, 213, 240, 153, 62, 228, 122, 34, 219, 106, 31, 211, 90, 27, 206, 77, 25, 200, 67, 23, 196, 58, 22, 193, 54, 21, 191, 52, 19, 191, 51, 19, 191, 51, 20, 190, 51, 20, 190, 51, 20, 190, 51, 20, 189, 51, 20, 189, 50, 20, 188, 50, 20, 188, 50, 19, 187, 49, 19, 187, 49, 19, 186, 49, 20, 186, 49, 20, 185, 48, 19, 185, 48, 19, 184, 47, 19, 183, 48, 19, 183, 47, 19, 183, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 18, 175, 43, 19, 174, 42, 18, 173, 42, 19, 173, 41, 19, 174, 44, 18, 176, 48, 20, 181, 56, 22, 187, 66, 23, 196, 80, 26, 206, 96, 30, 217, 115, 33, 232, 139, 47, 251, 228, 199, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 201, 141, 236, 144, 41, 224, 126, 35, 212, 109, 33, 201, 95, 30, 192, 81, 27, 183, 69, 25, 175, 60, 22, 169, 51, 21, 164, 45, 19, 159, 41, 19, 156, 37, 18, 154, 34, 18, 152, 32, 17, 150, 32, 17, 149, 30, 17, 151, 29, 15, 111, 38, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 38, 75, 128, 171, 57, 38, 198, 54, 18, 196, 55, 20, 196, 55, 20, 196, 55, 20, 197, 56, 21, 198, 58, 21, 199, 60, 21, 200, 64, 22, 203, 68, 23, 206, 75, 24, 210, 83, 27, 215, 94, 28, 220, 106, 32, 226, 119, 34, 234, 134, 37, 241, 146, 34, 249, 191, 114, 254, 248, 240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 230, 206, 235, 142, 53, 224, 116, 33, 217, 100, 31, 209, 86, 27, 203, 74, 25, 198, 65, 22, 195, 58, 21, 192, 54, 21, 191, 51, 20, 191, 51, 20, 190, 51, 20, 190, 51, 20, 189, 51, 20, 189, 50, 20, 189, 50, 20, 188, 50, 19, 187, 49, 20, 187, 50, 19, 187, 49, 19, 186, 49, 20, 186, 48, 19, 185, 48, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 181, 45, 19, 180, 46, 19, 180, 45, 19, 179, 44, 19, 178, 45, 19, 178, 44, 19, 177, 44, 19, 176, 43, 19, 175, 43, 18, 175, 43, 18, 175, 42, 19, 174, 42, 18, 173, 42, 18, 173, 42, 19, 173, 43, 18, 175, 47, 20, 179, 54, 21, 185, 64, 23, 192, 75, 26, 201, 90, 29, 212, 107, 33, 225, 130, 43, 248, 220, 190, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 247, 245, 184, 109, 233, 133, 28, 221, 122, 35, 210, 107, 32, 200, 92, 28, 190, 79, 26, 181, 68, 25, 174, 59, 22, 168, 50, 21, 163, 45, 19, 159, 40, 18, 156, 37, 18, 154, 34, 18, 153, 32, 17, 151, 31, 17, 149, 31, 17, 149, 30, 17, 151, 29, 15, 111, 37, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 170, 58, 38, 197, 54, 18, 195, 54, 20, 195, 54, 20, 195, 54, 20, 195, 54, 20, 196, 55, 21, 197, 57, 21, 198, 59, 21, 199, 63, 22, 202, 67, 23, 205, 74, 24, 208, 82, 26, 213, 92, 28, 218, 103, 31, 225, 116, 34, 232, 130, 37, 238, 138, 28, 245, 176, 94, 253, 239, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 249, 225, 203, 230, 131, 49, 221, 108, 32, 213, 94, 28, 207, 81, 26, 201, 71, 24, 197, 62, 22, 193, 56, 22, 191, 52, 20, 189, 51, 20, 190, 51, 20, 189, 50, 20, 189, 51, 20, 189, 50, 20, 188, 50, 20, 188, 50, 19, 187, 50, 20, 187, 49, 19, 186, 49, 19, 186, 49, 19, 185, 49, 19, 185, 48, 19, 185, 48, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 182, 47, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 180, 45, 19, 179, 45, 18, 178, 44, 18, 178, 44, 19, 177, 44, 19, 176, 43, 19, 175, 43, 19, 175, 43, 19, 174, 42, 19, 174, 42, 19, 173, 41, 18, 172, 41, 19, 172, 41, 18, 172, 43, 18, 174, 46, 20, 177, 52, 21, 183, 60, 23, 189, 71, 25, 198, 85, 27, 207, 99, 30, 218, 119, 41, 245, 211, 181, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 233, 212, 238, 160, 75, 228, 128, 29, 218, 118, 35, 207, 103, 31, 197, 88, 28, 188, 77, 26, 180, 66, 23, 173, 56, 21, 167, 50, 21, 163, 43, 19, 159, 39, 18, 156, 36, 18, 154, 34, 18, 153, 32, 17, 151, 31, 17, 150, 31, 17, 149, 31, 17, 148, 30, 17, 150, 29, 15, 110, 37, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 169, 57, 37, 197, 53, 18, 194, 53, 20, 194, 53, 20, 194, 54, 20, 194, 54, 20, 194, 54, 20, 195, 55, 20, 196, 56, 21, 197, 58, 21, 199, 62, 22, 200, 66, 22, 203, 72, 24, 207, 80, 25, 212, 90, 28, 217, 100, 30, 223, 112, 33, 228, 124, 36, 233, 131, 32, 239, 156, 71, 251, 225, 199, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 222, 201, 225, 121, 45, 216, 99, 30, 210, 88, 27, 204, 77, 26, 199, 68, 23, 195, 60, 22, 192, 55, 21, 190, 51, 20, 189, 50, 20, 188, 50, 20, 188, 50, 19, 188, 49, 20, 188, 49, 20, 187, 49, 19, 187, 49, 20, 186, 49, 20, 186, 49, 19, 185, 48, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 179, 44, 19, 178, 44, 18, 178, 44, 18, 176, 44, 19, 176, 43, 18, 176, 43, 19, 175, 43, 19, 174, 42, 19, 173, 42, 18, 173, 41, 18, 172, 41, 19, 172, 41, 18, 171, 41, 18, 171, 42, 18, 173, 45, 19, 175, 50, 20, 180, 57, 22, 186, 67, 24, 193, 78, 26, 200, 90, 29, 211, 108, 38, 242, 207, 179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 245, 211, 179, 228, 140, 57, 220, 119, 32, 214, 111, 33, 204, 99, 30, 195, 85, 28, 186, 74, 25, 178, 64, 23, 171, 55, 21, 166, 48, 20, 162, 43, 19, 158, 39, 18, 155, 36, 18, 154, 34, 17, 152, 32, 17, 151, 31, 17, 150, 31, 17, 149, 30, 17, 148, 30, 17, 148, 30, 17, 150, 29, 15, 110, 37, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 169, 56, 38, 195, 52, 18, 193, 53, 20, 193, 53, 20, 193, 53, 20, 193, 53, 20, 194, 53, 20, 193, 53, 20, 193, 53, 20, 195, 55, 21, 196, 58, 21, 196, 61, 22, 199, 65, 22, 202, 71, 24, 206, 78, 26, 210, 87, 27, 215, 97, 29, 220, 106, 32, 224, 114, 33, 227, 121, 34, 231, 135, 52, 247, 218, 193, 255, 255, 255, 255, 255, 255, 249, 228, 213, 219, 114, 49, 211, 91, 28, 206, 81, 26, 201, 72, 24, 196, 64, 22, 193, 59, 22, 191, 54, 21, 189, 51, 20, 188, 50, 20, 188, 50, 20, 188, 50, 19, 187, 49, 19, 187, 49, 20, 186, 49, 20, 186, 48, 20, 186, 48, 19, 186, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 182, 46, 19, 182, 46, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 19, 178, 44, 19, 177, 43, 19, 176, 43, 19, 175, 43, 18, 175, 43, 18, 174, 42, 19, 174, 42, 19, 173, 42, 18, 173, 42, 18, 172, 41, 18, 171, 41, 18, 171, 40, 18, 170, 41, 18, 172, 43, 19, 174, 48, 20, 178, 54, 21, 183, 62, 22, 188, 71, 24, 194, 81, 26, 202, 97, 37, 242, 214, 196, 255, 255, 255, 255, 255, 255, 235, 182, 143, 215, 113, 33, 212, 108, 31, 206, 101, 30, 200, 92, 29, 192, 82, 27, 184, 71, 25, 176, 61, 22, 171, 53, 21, 166, 47, 20, 161, 42, 19, 159, 38, 18, 156, 36, 18, 154, 34, 17, 153, 32, 17, 151, 31, 17, 150, 31, 17, 150, 31, 17, 149, 30, 17, 148, 30, 17, 147, 30, 17, 149, 29, 15, 110, 37, 42, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 168, 56, 37, 194, 52, 18, 192, 52, 20, 193, 52, 20, 192, 52, 20, 193, 52, 20, 192, 52, 20, 192, 53, 20, 193, 53, 20, 193, 53, 20, 194, 55, 21, 194, 57, 21, 196, 60, 21, 198, 64, 22, 200, 70, 24, 204, 76, 25, 207, 84, 27, 211, 91, 28, 215, 98, 30, 217, 104, 32, 220, 107, 32, 219, 105, 26, 219, 102, 21, 216, 98, 21, 213, 93, 22, 210, 90, 27, 206, 82, 26, 202, 74, 25, 197, 67, 23, 194, 61, 22, 192, 56, 21, 190, 53, 20, 189, 50, 19, 187, 50, 20, 187, 50, 19, 187, 49, 19, 187, 49, 20, 186, 48, 19, 186, 49, 19, 186, 49, 19, 184, 48, 19, 184, 47, 19, 184, 47, 19, 184, 47, 19, 183, 47, 19, 183, 46, 19, 182, 46, 19, 182, 46, 19, 181, 46, 19, 180, 46, 18, 180, 45, 19, 180, 45, 19, 179, 45, 18, 178, 45, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 19, 176, 43, 19, 175, 43, 18, 175, 42, 18, 173, 42, 19, 173, 41, 18, 172, 41, 18, 172, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 170, 42, 19, 173, 45, 20, 175, 50, 20, 179, 56, 21, 183, 63, 22, 187, 71, 25, 193, 78, 26, 196, 82, 21, 200, 86, 18, 202, 89, 19, 203, 93, 25, 202, 94, 30, 198, 89, 28, 193, 83, 27, 187, 76, 26, 182, 67, 24, 175, 59, 22, 169, 52, 21, 165, 46, 20, 161, 41, 18, 158, 38, 18, 156, 35, 18, 154, 34, 17, 153, 32, 17, 151, 31, 17, 151, 31, 17, 150, 31, 17, 149, 30, 17, 148, 30, 17, 147, 30, 17, 147, 30, 17, 149, 28, 15, 106, 37, 43, 25, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 167, 55, 38, 193, 52, 18, 192, 52, 20, 192, 52, 20, 192, 52, 20, 192, 52, 20, 192, 52, 20, 192, 52, 20, 192, 52, 20, 192, 52, 20, 192, 53, 20, 193, 54, 20, 194, 56, 21, 195, 59, 21, 197, 63, 22, 199, 67, 23, 202, 73, 25, 205, 79, 26, 208, 84, 27, 209, 88, 28, 211, 92, 28, 212, 94, 29, 212, 93, 29, 210, 91, 29, 208, 86, 27, 205, 80, 26, 201, 74, 24, 198, 68, 24, 195, 63, 22, 192, 58, 21, 190, 54, 20, 188, 51, 20, 187, 50, 19, 187, 49, 19, 186, 49, 19, 186, 49, 19, 186, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 182, 46, 19, 182, 46, 19, 181, 46, 19, 180, 46, 18, 179, 45, 19, 179, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 18, 175, 43, 18, 175, 43, 18, 174, 42, 18, 174, 42, 19, 173, 42, 18, 173, 41, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 169, 41, 19, 170, 44, 19, 172, 48, 20, 175, 52, 20, 178, 57, 21, 181, 62, 22, 185, 69, 24, 189, 74, 25, 191, 78, 26, 192, 80, 27, 191, 80, 27, 190, 77, 26, 187, 73, 25, 183, 69, 24, 178, 63, 23, 174, 56, 22, 169, 50, 21, 164, 44, 20, 160, 40, 18, 157, 37, 18, 155, 35, 18, 154, 34, 17, 152, 33, 17, 151, 32, 17, 150, 31, 17, 150, 31, 17, 149, 31, 17, 148, 30, 17, 148, 30, 17, 147, 30, 17, 146, 29, 17, 143, 28, 17, 92, 37, 46, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 166, 55, 37, 193, 51, 18, 190, 51, 20, 190, 51, 20, 190, 51, 20, 190, 51, 20, 190, 51, 19, 191, 51, 20, 191, 51, 19, 191, 51, 20, 190, 51, 20, 191, 52, 20, 191, 53, 21, 192, 55, 21, 194, 58, 21, 195, 61, 21, 197, 64, 23, 200, 69, 24, 202, 73, 24, 203, 76, 25, 204, 79, 26, 205, 80, 26, 205, 80, 26, 204, 79, 26, 202, 76, 25, 200, 71, 24, 197, 67, 23, 194, 63, 22, 193, 59, 22, 190, 55, 21, 188, 53, 20, 187, 51, 19, 186, 49, 19, 186, 49, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 184, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 179, 45, 19, 178, 44, 19, 178, 44, 19, 177, 43, 19, 177, 43, 19, 176, 43, 19, 175, 43, 18, 175, 43, 19, 174, 42, 18, 173, 42, 19, 173, 42, 19, 173, 42, 18, 172, 41, 18, 171, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 168, 40, 18, 168, 39, 18, 168, 39, 18, 168, 40, 18, 169, 42, 19, 170, 45, 19, 171, 48, 20, 174, 51, 21, 176, 55, 21, 179, 59, 22, 181, 63, 23, 182, 66, 24, 183, 66, 24, 181, 65, 24, 180, 64, 23, 177, 60, 23, 174, 57, 22, 171, 52, 21, 167, 48, 20, 163, 43, 20, 159, 39, 18, 157, 36, 18, 155, 34, 17, 154, 33, 17, 152, 32, 17, 152, 31, 17, 151, 31, 17, 150, 31, 17, 149, 30, 17, 149, 30, 17, 148, 30, 17, 147, 30, 17, 147, 29, 17, 143, 29, 17, 124, 28, 21, 87, 37, 48, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 165, 54, 37, 191, 51, 17, 190, 51, 19, 190, 51, 20, 190, 51, 20, 189, 51, 20, 190, 51, 20, 190, 51, 20, 190, 51, 20, 189, 51, 20, 190, 51, 19, 190, 51, 19, 190, 51, 19, 190, 52, 20, 191, 54, 21, 192, 57, 21, 193, 59, 21, 195, 62, 22, 196, 64, 22, 198, 67, 23, 199, 68, 23, 199, 70, 24, 199, 70, 24, 198, 69, 23, 197, 66, 23, 195, 64, 22, 194, 61, 22, 191, 58, 21, 190, 56, 21, 189, 53, 21, 187, 51, 20, 187, 50, 19, 185, 49, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 45, 19, 180, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 178, 44, 19, 178, 44, 19, 177, 44, 19, 176, 44, 19, 176, 43, 18, 175, 43, 19, 175, 43, 19, 174, 43, 19, 173, 42, 19, 173, 42, 19, 172, 42, 19, 172, 41, 18, 171, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 40, 18, 167, 41, 18, 167, 42, 19, 169, 45, 19, 170, 47, 20, 171, 49, 20, 173, 52, 21, 174, 54, 22, 175, 55, 22, 175, 56, 22, 174, 55, 21, 172, 53, 21, 169, 51, 21, 167, 48, 20, 165, 44, 19, 162, 42, 19, 159, 39, 18, 157, 36, 18, 155, 34, 17, 154, 33, 17, 152, 32, 17, 151, 32, 17, 151, 31, 17, 150, 31, 17, 150, 30, 17, 149, 30, 17, 148, 30, 17, 148, 30, 17, 146, 29, 17, 146, 29, 17, 122, 29, 23, 117, 28, 22, 87, 37, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 165, 54, 37, 191, 50, 18, 189, 50, 20, 189, 50, 19, 189, 50, 19, 189, 50, 20, 189, 51, 20, 189, 50, 20, 189, 50, 20, 189, 50, 19, 189, 50, 20, 189, 50, 19, 189, 50, 20, 190, 50, 19, 190, 52, 20, 190, 53, 20, 191, 54, 20, 191, 56, 21, 192, 57, 21, 193, 59, 21, 193, 60, 22, 194, 61, 22, 194, 61, 23, 193, 61, 22, 193, 60, 22, 191, 58, 21, 190, 57, 21, 189, 54, 21, 188, 52, 20, 187, 51, 20, 186, 49, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 184, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 46, 19, 182, 47, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 180, 46, 19, 180, 45, 19, 179, 45, 19, 179, 44, 19, 178, 44, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 19, 176, 43, 19, 175, 43, 18, 175, 42, 18, 174, 42, 18, 174, 42, 18, 172, 42, 19, 172, 41, 18, 172, 41, 18, 172, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 38, 18, 167, 38, 18, 166, 39, 18, 166, 39, 18, 166, 41, 19, 166, 41, 19, 167, 42, 19, 168, 43, 20, 168, 46, 20, 169, 47, 20, 168, 47, 20, 168, 47, 20, 167, 46, 20, 166, 45, 20, 164, 43, 19, 163, 42, 19, 160, 39, 18, 159, 38, 18, 157, 36, 18, 155, 35, 17, 154, 33, 17, 153, 32, 17, 152, 32, 17, 151, 31, 17, 150, 31, 17, 150, 31, 17, 149, 30, 17, 148, 30, 17, 147, 30, 17, 147, 29, 17, 146, 29, 17, 123, 29, 22, 115, 28, 24, 117, 27, 22, 87, 37, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 164, 54, 37, 190, 49, 18, 188, 50, 20, 188, 50, 19, 188, 50, 20, 188, 50, 19, 188, 50, 19, 188, 50, 19, 188, 50, 20, 188, 50, 19, 188, 50, 19, 188, 50, 20, 188, 50, 19, 188, 50, 19, 188, 50, 19, 188, 51, 20, 189, 51, 20, 189, 52, 21, 189, 54, 20, 190, 54, 20, 190, 55, 21, 190, 55, 21, 190, 55, 21, 189, 55, 21, 189, 54, 21, 189, 53, 20, 187, 52, 21, 187, 51, 20, 186, 50, 20, 186, 49, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 182, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 19, 177, 44, 19, 176, 43, 18, 176, 43, 19, 176, 43, 19, 175, 43, 18, 175, 43, 18, 174, 42, 18, 174, 42, 18, 173, 42, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 165, 38, 18, 165, 39, 18, 164, 40, 18, 164, 40, 19, 164, 40, 19, 165, 41, 19, 165, 42, 19, 164, 41, 19, 164, 41, 19, 163, 41, 19, 161, 40, 19, 160, 38, 18, 159, 37, 18, 157, 36, 18, 156, 35, 17, 155, 34, 17, 154, 33, 17, 153, 32, 17, 153, 31, 17, 151, 31, 17, 151, 31, 17, 150, 31, 17, 149, 30, 17, 148, 30, 17, 147, 30, 17, 147, 30, 17, 145, 29, 17, 126, 29, 22, 115, 29, 24, 116, 28, 24, 116, 27, 22, 87, 37, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 163, 54, 37, 188, 49, 17, 186, 49, 19, 186, 49, 19, 187, 49, 19, 187, 49, 19, 187, 49, 19, 187, 49, 19, 187, 49, 20, 186, 49, 19, 187, 49, 19, 187, 49, 19, 186, 49, 19, 186, 49, 19, 186, 49, 19, 186, 49, 19, 187, 49, 19, 187, 50, 19, 187, 50, 19, 187, 51, 19, 187, 51, 20, 187, 51, 20, 187, 51, 20, 187, 51, 20, 187, 51, 20, 186, 50, 19, 185, 50, 19, 185, 49, 19, 185, 49, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 45, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 178, 45, 19, 178, 45, 19, 178, 44, 19, 178, 44, 19, 177, 43, 18, 176, 44, 18, 176, 43, 19, 176, 43, 19, 175, 43, 19, 174, 43, 18, 174, 42, 19, 174, 42, 19, 173, 42, 18, 173, 41, 18, 172, 41, 18, 171, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 164, 37, 18, 163, 37, 18, 164, 37, 18, 163, 37, 18, 163, 38, 18, 162, 38, 17, 162, 38, 18, 161, 38, 18, 161, 38, 18, 160, 38, 18, 160, 38, 18, 158, 36, 18, 158, 36, 17, 157, 35, 17, 156, 34, 17, 154, 33, 17, 153, 32, 17, 153, 32, 17, 152, 32, 17, 151, 31, 17, 151, 31, 17, 150, 31, 17, 149, 30, 17, 148, 30, 17, 148, 30, 17, 147, 29, 17, 146, 29, 17, 126, 29, 22, 115, 29, 24, 115, 28, 24, 114, 28, 24, 116, 27, 22, 87, 36, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 162, 53, 37, 188, 49, 18, 186, 49, 19, 186, 49, 19, 186, 48, 19, 186, 49, 19, 186, 49, 19, 186, 48, 19, 186, 48, 19, 186, 48, 19, 186, 49, 19, 186, 49, 19, 185, 49, 20, 185, 49, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 49, 19, 185, 49, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 184, 48, 19, 184, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 46, 19, 182, 47, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 180, 46, 19, 181, 45, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 179, 44, 19, 178, 45, 19, 178, 44, 19, 178, 44, 19, 178, 44, 19, 177, 44, 18, 176, 43, 18, 176, 43, 18, 175, 43, 19, 175, 42, 19, 174, 42, 19, 174, 42, 18, 174, 42, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 163, 37, 18, 163, 36, 18, 162, 37, 18, 162, 36, 17, 161, 36, 18, 160, 36, 17, 160, 36, 17, 159, 35, 17, 159, 36, 18, 158, 35, 17, 157, 35, 17, 156, 34, 17, 155, 33, 17, 155, 33, 17, 154, 33, 17, 154, 32, 17, 153, 31, 17, 152, 32, 17, 151, 31, 17, 151, 31, 17, 151, 31, 17, 149, 30, 17, 149, 30, 17, 148, 30, 17, 148, 29, 17, 146, 29, 17, 124, 29, 22, 116, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 115, 27, 22, 86, 36, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 161, 52, 37, 187, 48, 17, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 49, 19, 185, 49, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 185, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 47, 19, 184, 47, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 182, 47, 19, 182, 47, 19, 181, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 18, 180, 46, 19, 180, 46, 19, 180, 45, 18, 179, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 18, 176, 43, 19, 175, 43, 19, 175, 43, 19, 174, 43, 19, 174, 42, 19, 173, 42, 18, 173, 41, 19, 173, 42, 19, 172, 41, 18, 172, 41, 18, 171, 41, 18, 171, 41, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 169, 39, 18, 167, 39, 18, 167, 39, 18, 167, 39, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 162, 36, 18, 162, 36, 18, 161, 36, 18, 160, 35, 18, 160, 35, 17, 159, 35, 18, 159, 35, 17, 158, 34, 17, 157, 34, 17, 156, 33, 18, 156, 33, 17, 155, 33, 17, 154, 33, 17, 154, 33, 17, 153, 32, 17, 152, 31, 17, 151, 31, 17, 151, 31, 17, 150, 31, 17, 149, 30, 17, 149, 30, 17, 148, 30, 17, 148, 30, 17, 145, 29, 17, 123, 29, 23, 115, 28, 24, 116, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 115, 26, 22, 86, 36, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 160, 52, 37, 186, 47, 17, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 48, 19, 184, 47, 19, 184, 47, 19, 184, 48, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 182, 47, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 179, 45, 19, 178, 45, 19, 178, 45, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 19, 176, 43, 18, 175, 43, 18, 175, 42, 19, 175, 43, 19, 174, 42, 18, 173, 42, 19, 173, 42, 18, 173, 42, 18, 172, 41, 18, 171, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 169, 39, 18, 167, 39, 18, 167, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 163, 37, 18, 162, 36, 17, 161, 36, 18, 161, 36, 17, 160, 35, 18, 159, 35, 18, 159, 35, 17, 159, 35, 17, 158, 34, 18, 157, 34, 18, 157, 33, 17, 156, 33, 17, 155, 33, 17, 155, 33, 17, 154, 32, 17, 152, 32, 17, 152, 32, 17, 152, 31, 17, 151, 31, 17, 151, 31, 17, 150, 31, 17, 149, 30, 17, 148, 30, 17, 148, 30, 17, 142, 30, 18, 123, 29, 23, 116, 29, 24, 116, 29, 24, 115, 28, 24, 114, 28, 24, 113, 28, 24, 113, 28, 24, 115, 26, 22, 85, 36, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 75, 128, 160, 52, 37, 185, 47, 17, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 18, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 183, 47, 19, 182, 47, 19, 182, 47, 19, 182, 47, 19, 182, 47, 19, 182, 46, 19, 182, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 178, 44, 18, 178, 44, 19, 178, 44, 18, 177, 44, 19, 177, 44, 19, 176, 44, 18, 176, 43, 19, 176, 43, 18, 175, 43, 19, 175, 43, 18, 175, 43, 19, 174, 42, 18, 174, 42, 18, 173, 42, 18, 173, 42, 18, 173, 41, 18, 172, 41, 18, 171, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 164, 37, 18, 163, 37, 17, 163, 36, 18, 162, 36, 18, 161, 36, 18, 161, 35, 18, 160, 35, 18, 160, 35, 18, 159, 35, 17, 158, 34, 17, 158, 34, 17, 157, 34, 17, 156, 33, 17, 155, 33, 17, 155, 33, 17, 155, 33, 17, 154, 32, 17, 153, 32, 17, 152, 32, 17, 152, 31, 17, 151, 31, 17, 150, 31, 17, 150, 31, 17, 149, 31, 17, 148, 30, 16, 150, 30, 17, 139, 30, 19, 121, 29, 23, 116, 29, 24, 115, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 115, 26, 22, 85, 36, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 74, 128, 159, 51, 37, 184, 46, 17, 182, 46, 19, 182, 47, 19, 182, 47, 19, 182, 47, 19, 183, 46, 19, 182, 47, 19, 182, 47, 19, 182, 47, 19, 182, 46, 19, 182, 47, 19, 182, 47, 19, 182, 47, 19, 182, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 180, 46, 19, 180, 45, 19, 179, 45, 18, 179, 45, 19, 179, 45, 18, 178, 44, 18, 179, 44, 19, 177, 44, 19, 177, 44, 18, 177, 43, 19, 177, 43, 18, 176, 43, 19, 176, 43, 18, 176, 43, 19, 175, 43, 18, 175, 43, 19, 175, 42, 19, 174, 42, 19, 174, 42, 18, 173, 42, 19, 173, 41, 18, 172, 41, 18, 172, 41, 19, 171, 41, 18, 171, 41, 18, 171, 41, 18, 170, 40, 18, 169, 39, 18, 169, 40, 18, 169, 40, 18, 168, 39, 18, 167, 39, 18, 167, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 163, 37, 17, 162, 36, 18, 161, 36, 18, 161, 35, 18, 160, 35, 18, 159, 35, 18, 159, 34, 18, 157, 34, 17, 157, 34, 18, 157, 34, 17, 156, 34, 17, 155, 33, 17, 155, 33, 17, 154, 33, 17, 154, 32, 17, 153, 32, 17, 152, 32, 17, 152, 32, 17, 151, 31, 17, 150, 31, 17, 149, 31, 17, 149, 30, 17, 149, 30, 17, 149, 30, 16, 133, 29, 20, 118, 29, 24, 117, 29, 24, 116, 29, 24, 115, 28, 24, 115, 28, 24, 114, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 114, 26, 22, 85, 36, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 74, 128, 158, 51, 37, 184, 46, 17, 181, 46, 19, 182, 46, 19, 182, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 182, 46, 19, 181, 46, 19, 182, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 46, 19, 180, 46, 19, 180, 46, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 18, 178, 45, 19, 178, 44, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 19, 176, 43, 19, 176, 43, 19, 175, 43, 19, 175, 42, 18, 174, 42, 18, 174, 42, 18, 174, 42, 19, 173, 42, 18, 173, 41, 18, 172, 41, 18, 171, 41, 18, 172, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 162, 36, 18, 162, 36, 18, 161, 36, 18, 160, 35, 18, 160, 35, 17, 159, 35, 18, 159, 34, 17, 158, 34, 18, 157, 34, 18, 157, 34, 17, 156, 34, 17, 156, 33, 17, 155, 33, 17, 155, 33, 17, 154, 32, 17, 153, 32, 17, 152, 32, 17, 151, 32, 17, 151, 31, 17, 151, 31, 17, 150, 31, 17, 149, 30, 17, 149, 30, 17, 146, 30, 17, 129, 29, 22, 117, 29, 24, 117, 29, 24, 116, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 114, 26, 22, 84, 36, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 74, 128, 157, 50, 37, 182, 45, 17, 181, 46, 19, 180, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 181, 46, 19, 180, 46, 19, 180, 45, 19, 181, 46, 19, 180, 45, 19, 181, 46, 19, 180, 45, 19, 180, 45, 19, 180, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 178, 45, 19, 178, 44, 19, 178, 44, 19, 178, 44, 19, 178, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 176, 43, 19, 176, 43, 19, 176, 43, 19, 175, 43, 18, 175, 42, 18, 175, 42, 19, 174, 42, 18, 174, 42, 19, 174, 42, 18, 173, 42, 18, 173, 41, 18, 172, 41, 19, 172, 41, 18, 171, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 166, 38, 18, 166, 38, 18, 165, 37, 18, 165, 37, 18, 164, 37, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 162, 36, 17, 162, 36, 18, 161, 36, 18, 161, 35, 18, 160, 35, 18, 159, 35, 18, 159, 35, 18, 158, 34, 18, 157, 34, 17, 157, 34, 18, 156, 33, 17, 156, 33, 17, 155, 33, 17, 154, 33, 17, 154, 32, 17, 153, 32, 17, 152, 32, 17, 152, 32, 17, 151, 31, 17, 151, 31, 17, 150, 31, 17, 149, 31, 17, 149, 30, 17, 141, 30, 19, 124, 29, 22, 116, 29, 24, 117, 29, 24, 116, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 112, 27, 24, 112, 27, 24, 113, 26, 22, 84, 35, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 37, 74, 128, 157, 50, 37, 181, 44, 17, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 179, 45, 19, 178, 44, 19, 178, 44, 18, 178, 45, 19, 178, 44, 19, 178, 44, 18, 178, 44, 19, 178, 44, 18, 177, 44, 18, 177, 44, 19, 177, 44, 19, 176, 44, 19, 176, 43, 19, 176, 43, 18, 175, 43, 18, 175, 43, 19, 175, 43, 18, 175, 42, 18, 174, 42, 19, 174, 42, 19, 174, 42, 18, 173, 42, 18, 173, 41, 18, 173, 42, 18, 172, 41, 18, 172, 41, 18, 172, 41, 19, 171, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 39, 18, 166, 39, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 163, 37, 18, 162, 37, 17, 162, 36, 18, 161, 35, 18, 161, 35, 17, 160, 35, 18, 159, 35, 17, 159, 35, 18, 159, 34, 18, 158, 34, 17, 157, 34, 17, 156, 34, 17, 156, 33, 17, 155, 33, 17, 155, 33, 17, 154, 33, 17, 154, 32, 17, 153, 32, 17, 152, 32, 17, 152, 32, 17, 151, 31, 17, 150, 31, 17, 149, 31, 17, 150, 31, 17, 148, 30, 17, 132, 29, 20, 119, 29, 23, 116, 29, 24, 117, 29, 24, 116, 29, 24, 116, 28, 24, 115, 28, 24, 114, 28, 24, 113, 28, 24, 113, 28, 24, 113, 28, 24, 112, 27, 24, 111, 27, 24, 111, 27, 24, 112, 26, 22, 84, 35, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 36, 74, 128, 156, 50, 37, 180, 45, 17, 179, 45, 19, 179, 44, 18, 179, 44, 19, 178, 44, 19, 179, 44, 18, 179, 45, 18, 179, 44, 19, 179, 45, 19, 179, 44, 19, 179, 44, 19, 179, 44, 19, 178, 44, 19, 178, 44, 19, 178, 44, 19, 178, 44, 19, 178, 44, 19, 178, 44, 18, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 18, 177, 44, 19, 176, 43, 19, 176, 43, 18, 176, 43, 18, 176, 43, 19, 175, 43, 19, 175, 43, 19, 175, 42, 19, 175, 43, 18, 174, 42, 19, 174, 42, 18, 173, 42, 19, 173, 42, 19, 173, 41, 18, 172, 41, 19, 172, 41, 19, 172, 41, 18, 171, 41, 18, 171, 41, 18, 170, 41, 18, 170, 41, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 38, 18, 167, 39, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 164, 37, 18, 164, 37, 18, 163, 36, 18, 162, 36, 18, 162, 36, 17, 161, 36, 17, 161, 36, 18, 160, 35, 17, 159, 35, 17, 159, 35, 17, 158, 34, 18, 158, 34, 17, 157, 34, 18, 156, 33, 17, 156, 34, 17, 155, 33, 17, 155, 33, 17, 154, 33, 17, 154, 32, 17, 152, 32, 17, 152, 32, 17, 151, 32, 17, 151, 31, 17, 150, 31, 17, 149, 31, 17, 149, 30, 17, 144, 30, 19, 124, 29, 23, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 115, 29, 24, 115, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 111, 27, 24, 111, 27, 24, 110, 27, 24, 112, 25, 22, 83, 35, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 36, 74, 128, 155, 49, 37, 180, 44, 17, 178, 44, 19, 178, 44, 19, 178, 44, 19, 178, 44, 19, 177, 44, 19, 178, 44, 18, 178, 44, 19, 178, 44, 19, 177, 44, 18, 178, 44, 19, 177, 44, 19, 177, 44, 18, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 18, 176, 44, 19, 177, 44, 19, 177, 44, 18, 177, 44, 18, 176, 43, 19, 176, 43, 19, 176, 43, 19, 176, 43, 18, 175, 43, 18, 175, 43, 19, 175, 43, 19, 175, 42, 18, 174, 42, 18, 174, 42, 19, 174, 42, 19, 174, 42, 18, 173, 42, 18, 173, 41, 19, 173, 41, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 171, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 167, 38, 18, 167, 39, 18, 167, 38, 18, 166, 38, 18, 165, 38, 17, 165, 38, 18, 165, 38, 17, 164, 37, 18, 163, 37, 18, 163, 36, 17, 163, 36, 18, 162, 36, 18, 161, 36, 18, 161, 36, 18, 160, 35, 18, 160, 35, 18, 159, 35, 18, 159, 35, 18, 159, 35, 17, 158, 34, 18, 157, 34, 17, 157, 34, 17, 156, 33, 17, 155, 33, 17, 155, 33, 17, 154, 32, 17, 153, 32, 17, 153, 32, 17, 152, 32, 17, 151, 31, 17, 151, 31, 17, 150, 31, 17, 150, 31, 17, 148, 30, 17, 136, 30, 20, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 115, 28, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 28, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 26, 24, 110, 26, 24, 111, 25, 22, 84, 35, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 36, 74, 128, 154, 49, 37, 179, 43, 17, 177, 43, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 43, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 44, 19, 177, 43, 19, 176, 43, 18, 176, 43, 18, 176, 43, 19, 176, 43, 18, 176, 43, 18, 176, 43, 19, 176, 43, 19, 175, 42, 19, 175, 42, 19, 175, 42, 19, 175, 42, 19, 174, 42, 19, 174, 42, 18, 173, 42, 19, 174, 42, 18, 173, 42, 18, 173, 41, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 39, 18, 167, 38, 18, 167, 38, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 165, 38, 18, 164, 37, 18, 163, 37, 18, 163, 37, 18, 163, 36, 18, 162, 36, 17, 161, 36, 18, 161, 35, 18, 160, 35, 18, 160, 35, 17, 159, 35, 17, 159, 35, 17, 158, 34, 17, 158, 34, 17, 157, 34, 17, 156, 34, 17, 156, 33, 17, 155, 33, 17, 154, 33, 17, 154, 33, 17, 154, 32, 17, 153, 32, 17, 152, 32, 17, 152, 31, 17, 151, 31, 17, 151, 31, 17, 149, 31, 17, 140, 30, 19, 124, 30, 23, 116, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 115, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 110, 26, 24, 110, 26, 24, 110, 26, 24, 111, 25, 22, 84, 35, 47, 24, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 35, 74, 128, 135, 46, 40, 171, 42, 18, 177, 43, 18, 176, 43, 18, 176, 43, 19, 175, 43, 19, 175, 43, 19, 176, 43, 18, 175, 43, 19, 175, 43, 19, 175, 43, 19, 176, 43, 18, 175, 43, 18, 175, 43, 19, 175, 43, 19, 175, 43, 19, 175, 43, 19, 175, 43, 18, 175, 42, 19, 175, 42, 19, 175, 42, 18, 175, 42, 19, 174, 42, 19, 174, 42, 19, 174, 42, 18, 173, 42, 18, 173, 41, 19, 173, 41, 18, 173, 42, 19, 173, 41, 18, 172, 41, 19, 172, 41, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 171, 41, 18, 171, 40, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 38, 18, 166, 39, 18, 166, 38, 18, 166, 37, 18, 165, 37, 18, 165, 38, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 163, 36, 18, 162, 36, 18, 162, 36, 18, 161, 36, 18, 161, 35, 18, 160, 35, 18, 160, 35, 18, 159, 35, 17, 159, 35, 18, 158, 35, 18, 158, 34, 17, 157, 34, 18, 157, 33, 17, 156, 33, 17, 156, 33, 17, 155, 33, 17, 154, 33, 17, 154, 32, 17, 153, 32, 17, 152, 31, 17, 152, 32, 17, 151, 31, 17, 151, 31, 17, 152, 31, 16, 141, 31, 19, 128, 30, 22, 119, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 28, 24, 115, 29, 24, 115, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 110, 27, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 111, 25, 22, 83, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 34, 74, 128, 123, 45, 42, 142, 39, 24, 154, 40, 22, 173, 42, 19, 175, 43, 18, 175, 43, 18, 174, 43, 18, 175, 43, 19, 174, 43, 19, 175, 43, 18, 175, 43, 19, 174, 43, 18, 174, 43, 18, 174, 42, 19, 174, 42, 19, 174, 42, 18, 174, 42, 18, 174, 42, 19, 174, 42, 18, 173, 42, 18, 174, 42, 19, 173, 42, 19, 173, 42, 19, 173, 42, 18, 173, 42, 18, 173, 42, 18, 173, 41, 18, 173, 42, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 171, 41, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 167, 38, 18, 167, 39, 18, 166, 39, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 17, 164, 38, 18, 164, 37, 18, 164, 37, 18, 162, 37, 18, 163, 36, 18, 162, 36, 18, 162, 36, 18, 161, 36, 18, 161, 35, 18, 160, 35, 18, 160, 35, 17, 159, 35, 17, 159, 35, 18, 158, 34, 17, 158, 34, 17, 157, 33, 17, 156, 33, 17, 156, 33, 17, 155, 33, 17, 155, 33, 17, 154, 32, 17, 154, 32, 17, 153, 32, 17, 152, 32, 17, 152, 31, 17, 151, 32, 17, 152, 31, 17, 146, 30, 18, 128, 30, 22, 120, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 115, 29, 24, 115, 28, 24, 115, 28, 24, 114, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 111, 24, 22, 82, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 34, 74, 128, 122, 45, 42, 140, 38, 23, 138, 39, 26, 139, 39, 25, 157, 41, 22, 171, 42, 19, 173, 42, 19, 174, 42, 19, 174, 42, 18, 174, 42, 19, 174, 42, 19, 174, 42, 18, 174, 42, 19, 174, 42, 18, 174, 42, 19, 174, 42, 18, 173, 42, 19, 173, 42, 18, 173, 42, 18, 173, 41, 18, 173, 42, 19, 173, 42, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 172, 41, 18, 171, 41, 19, 171, 41, 18, 171, 40, 18, 170, 40, 18, 170, 41, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 169, 40, 18, 169, 39, 18, 168, 40, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 38, 18, 167, 39, 18, 166, 38, 18, 166, 38, 17, 165, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 163, 37, 18, 162, 37, 18, 162, 36, 18, 161, 36, 18, 161, 36, 17, 160, 35, 18, 160, 35, 17, 160, 35, 17, 159, 35, 17, 158, 34, 18, 157, 34, 18, 157, 34, 17, 157, 34, 17, 156, 34, 18, 156, 33, 18, 155, 33, 17, 155, 33, 17, 154, 33, 17, 154, 32, 17, 153, 32, 17, 153, 32, 17, 152, 32, 17, 150, 31, 17, 147, 31, 18, 132, 31, 22, 119, 29, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 115, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 26, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 109, 24, 22, 82, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 34, 74, 128, 121, 44, 42, 139, 38, 25, 138, 39, 26, 137, 39, 26, 136, 38, 25, 141, 39, 25, 155, 40, 22, 165, 40, 20, 172, 42, 18, 174, 42, 18, 173, 42, 19, 173, 42, 18, 173, 41, 18, 173, 42, 18, 173, 41, 18, 173, 41, 18, 173, 41, 18, 172, 41, 18, 172, 41, 18, 172, 42, 18, 172, 41, 18, 172, 41, 19, 172, 41, 18, 172, 41, 18, 171, 41, 18, 171, 41, 18, 171, 41, 18, 171, 41, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 169, 40, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 38, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 164, 37, 18, 164, 37, 18, 164, 37, 18, 164, 37, 18, 163, 36, 18, 163, 36, 18, 162, 36, 18, 161, 36, 18, 161, 36, 18, 161, 35, 18, 160, 35, 18, 160, 35, 17, 159, 35, 18, 159, 35, 17, 158, 34, 17, 158, 34, 18, 157, 34, 18, 157, 34, 17, 156, 34, 17, 155, 33, 17, 155, 33, 17, 154, 33, 17, 154, 32, 17, 153, 32, 17, 153, 32, 17, 153, 32, 17, 150, 31, 17, 143, 31, 19, 131, 31, 21, 120, 30, 24, 118, 29, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 115, 29, 24, 115, 28, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 27, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 25, 24, 108, 25, 24, 109, 24, 22, 82, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 34, 74, 128, 120, 44, 42, 138, 37, 24, 136, 38, 25, 137, 38, 26, 137, 38, 25, 137, 38, 25, 135, 38, 26, 140, 38, 25, 147, 39, 23, 157, 39, 21, 170, 40, 19, 174, 41, 18, 172, 41, 18, 172, 41, 18, 171, 41, 18, 171, 41, 18, 171, 41, 18, 171, 41, 18, 171, 41, 18, 171, 40, 18, 171, 40, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 39, 18, 167, 39, 18, 167, 39, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 165, 37, 18, 165, 37, 18, 164, 37, 17, 164, 37, 18, 163, 37, 18, 163, 37, 18, 163, 36, 18, 162, 36, 18, 162, 36, 18, 161, 36, 18, 161, 36, 18, 160, 36, 18, 160, 35, 18, 159, 35, 18, 159, 35, 18, 159, 34, 17, 158, 34, 17, 157, 34, 17, 157, 34, 18, 157, 34, 17, 156, 33, 17, 156, 33, 17, 155, 33, 17, 155, 33, 17, 154, 33, 17, 153, 32, 17, 154, 32, 17, 154, 32, 16, 148, 31, 18, 137, 31, 20, 128, 30, 22, 121, 30, 24, 119, 29, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 115, 29, 24, 115, 29, 24, 115, 28, 24, 114, 28, 24, 113, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 27, 24, 110, 27, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 108, 25, 24, 107, 25, 24, 109, 24, 22, 81, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 34, 74, 128, 120, 44, 42, 137, 37, 23, 136, 38, 25, 136, 38, 25, 136, 38, 25, 136, 37, 25, 136, 38, 25, 136, 38, 25, 136, 38, 25, 137, 37, 25, 138, 37, 25, 149, 38, 22, 165, 40, 20, 172, 40, 18, 171, 40, 18, 170, 40, 18, 171, 40, 18, 171, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 170, 40, 18, 169, 40, 18, 169, 39, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 168, 39, 18, 167, 38, 18, 167, 38, 18, 167, 38, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 164, 38, 18, 164, 37, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 163, 36, 18, 162, 36, 18, 162, 36, 18, 161, 36, 18, 161, 36, 18, 161, 36, 17, 160, 35, 18, 160, 35, 18, 159, 35, 18, 159, 35, 17, 159, 34, 17, 158, 34, 17, 157, 34, 17, 157, 34, 17, 157, 33, 18, 156, 33, 17, 155, 33, 17, 155, 33, 17, 154, 32, 17, 154, 32, 17, 154, 32, 17, 154, 32, 17, 145, 32, 19, 130, 31, 23, 123, 30, 24, 121, 30, 24, 120, 29, 24, 119, 29, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 115, 29, 24, 115, 28, 24, 114, 28, 24, 113, 28, 24, 113, 28, 24, 113, 28, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 108, 25, 24, 107, 25, 24, 107, 25, 24, 109, 24, 22, 81, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 89, 22, 56, 97, 24, 60, 104, 25, 64, 110, 25, 66, 117, 26, 70, 122, 27, 72, 127, 27, 74, 131, 34, 74, 128, 120, 43, 42, 136, 36, 24, 135, 37, 25, 135, 37, 25, 135, 37, 25, 135, 37, 25, 135, 37, 25, 135, 37, 25, 135, 37, 25, 135, 37, 25, 135, 37, 25, 134, 37, 25, 134, 37, 25, 140, 37, 24, 154, 39, 21, 166, 40, 18, 168, 40, 18, 169, 40, 18, 169, 40, 18, 170, 40, 18, 169, 40, 18, 169, 40, 18, 169, 39, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 39, 17, 167, 39, 18, 166, 39, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 18, 164, 37, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 163, 37, 18, 162, 36, 18, 162, 36, 17, 162, 36, 17, 161, 36, 18, 161, 36, 17, 160, 35, 17, 160, 35, 17, 160, 35, 18, 159, 35, 17, 159, 34, 17, 158, 34, 17, 158, 34, 17, 157, 34, 17, 156, 34, 17, 157, 34, 17, 156, 33, 17, 155, 33, 17, 155, 33, 17, 153, 33, 17, 152, 32, 17, 147, 32, 19, 136, 32, 21, 123, 31, 24, 120, 31, 24, 120, 30, 24, 120, 30, 24, 120, 30, 24, 120, 29, 24, 118, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 116, 29, 24, 115, 28, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 111, 26, 24, 111, 27, 24, 110, 26, 24, 110, 26, 24, 109, 25, 24, 109, 26, 24, 109, 26, 24, 108, 25, 24, 107, 25, 24, 107, 25, 24, 107, 25, 24, 108, 24, 22, 81, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	22, 52, 90, 23, 56, 98, 24, 60, 105, 25, 64, 111, 25, 66, 117, 26, 70, 121, 27, 72, 127, 27, 74, 131, 34, 74, 128, 119, 43, 42, 136, 35, 24, 135, 37, 25, 135, 37, 25, 135, 36, 25, 135, 36, 25, 135, 37, 25, 135, 37, 25, 135, 36, 25, 135, 36, 25, 135, 37, 25, 135, 37, 25, 135, 37, 25, 134, 36, 25, 133, 36, 25, 133, 37, 25, 142, 37, 24, 151, 38, 22, 158, 38, 20, 162, 38, 19, 167, 39, 18, 169, 39, 18, 169, 39, 18, 168, 39, 18, 168, 39, 18, 168, 39, 18, 167, 39, 18, 167, 39, 18, 167, 38, 18, 167, 38, 18, 167, 38, 18, 166, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 165, 37, 18, 164, 37, 17, 164, 37, 18, 163, 37, 18, 164, 37, 18, 163, 37, 18, 163, 36, 18, 162, 36, 18, 162, 36, 18, 161, 36, 18, 161, 36, 18, 161, 35, 18, 160, 35, 17, 160, 35, 18, 160, 35, 18, 159, 35, 17, 159, 34, 17, 158, 34, 17, 158, 34, 18, 157, 34, 18, 157, 34, 17, 157, 33, 17, 157, 33, 17, 156, 33, 17, 153, 33, 18, 148, 33, 18, 144, 32, 19, 136, 32, 21, 127, 31, 23, 120, 31, 24, 120, 31, 24, 121, 30, 24, 121, 30, 24, 121, 30, 24, 120, 30, 24, 119, 29, 24, 119, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 116, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 27, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 108, 26, 24, 108, 25, 24, 107, 25, 24, 107, 25, 24, 106, 25, 24, 108, 24, 22, 81, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	18, 46, 81, 19, 51, 89, 22, 57, 99, 24, 62, 108, 26, 67, 117, 26, 71, 123, 27, 73, 128, 27, 74, 132, 34, 74, 129, 119, 43, 42, 135, 35, 23, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 134, 36, 25, 133, 36, 25, 133, 36, 25, 132, 36, 25, 134, 36, 25, 138, 36, 24, 141, 37, 23, 147, 38, 22, 153, 38, 21, 159, 38, 20, 165, 38, 18, 168, 38, 17, 168, 38, 18, 167, 38, 18, 166, 38, 18, 166, 38, 18, 165, 38, 18, 165, 38, 18, 164, 38, 18, 164, 37, 18, 164, 37, 18, 164, 37, 18, 163, 37, 18, 163, 36, 18, 162, 37, 18, 162, 37, 18, 162, 36, 18, 162, 36, 18, 161, 36, 17, 161, 36, 17, 161, 36, 17, 160, 36, 18, 160, 35, 17, 160, 35, 18, 159, 35, 17, 159, 35, 18, 158, 34, 17, 159, 34, 18, 158, 34, 17, 159, 34, 18, 158, 34, 17, 158, 33, 17, 154, 33, 18, 148, 33, 19, 141, 32, 21, 135, 32, 22, 130, 32, 23, 126, 31, 23, 122, 31, 24, 121, 31, 24, 121, 31, 24, 121, 30, 24, 121, 30, 24, 120, 29, 24, 120, 30, 24, 119, 30, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 115, 28, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 112, 27, 24, 111, 27, 24, 111, 27, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 108, 25, 24, 107, 25, 24, 107, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 108, 24, 22, 81, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	16, 42, 75, 16, 46, 80, 17, 48, 85, 18, 51, 89, 19, 52, 94, 21, 57, 101, 22, 62, 109, 24, 67, 118, 32, 69, 121, 117, 42, 41, 135, 36, 24, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 133, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 133, 36, 25, 132, 36, 25, 133, 36, 25, 134, 36, 25, 135, 36, 25, 138, 36, 24, 145, 36, 23, 151, 36, 20, 156, 37, 20, 161, 37, 18, 165, 37, 17, 165, 37, 18, 165, 37, 18, 164, 37, 17, 164, 37, 17, 164, 37, 18, 164, 36, 18, 163, 36, 18, 162, 36, 18, 162, 36, 18, 161, 36, 17, 162, 36, 18, 162, 36, 18, 161, 36, 18, 160, 35, 18, 160, 35, 18, 160, 35, 17, 160, 34, 17, 159, 35, 18, 160, 34, 17, 158, 34, 17, 153, 34, 19, 147, 34, 19, 141, 33, 20, 135, 33, 22, 128, 32, 23, 126, 32, 24, 125, 32, 24, 124, 32, 24, 123, 32, 24, 122, 31, 24, 122, 31, 24, 121, 31, 24, 121, 30, 24, 121, 30, 24, 120, 30, 24, 120, 30, 24, 120, 30, 24, 120, 30, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 116, 29, 24, 115, 28, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 28, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 27, 24, 111, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 109, 25, 24, 108, 25, 24, 107, 25, 24, 107, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 108, 24, 22, 81, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	16, 42, 75, 16, 45, 79, 17, 47, 84, 18, 50, 88, 18, 51, 92, 19, 53, 95, 19, 54, 97, 19, 55, 100, 26, 55, 98, 115, 39, 37, 133, 36, 24, 132, 36, 25, 133, 36, 25, 132, 36, 25, 133, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 24, 131, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 25, 129, 34, 25, 130, 35, 25, 134, 35, 24, 137, 35, 23, 141, 35, 23, 144, 36, 22, 146, 35, 21, 148, 35, 21, 149, 36, 20, 149, 35, 21, 150, 35, 20, 149, 35, 20, 150, 35, 19, 149, 35, 20, 146, 34, 20, 145, 34, 20, 143, 34, 21, 139, 34, 21, 136, 34, 23, 132, 34, 23, 128, 33, 24, 124, 33, 24, 124, 33, 24, 123, 32, 25, 123, 32, 24, 124, 32, 24, 124, 32, 24, 124, 32, 24, 123, 31, 24, 122, 31, 24, 122, 31, 24, 122, 31, 24, 121, 30, 24, 121, 31, 24, 121, 30, 24, 121, 30, 24, 120, 30, 24, 119, 30, 24, 119, 29, 24, 119, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 116, 28, 24, 116, 28, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 112, 27, 24, 111, 27, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 109, 25, 24, 108, 26, 24, 108, 25, 24, 107, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 108, 24, 22, 81, 34, 47, 23, 56, 99, 19, 56, 100, 19, 54, 97, 19, 52, 95, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	16, 42, 75, 16, 45, 80, 17, 47, 84, 18, 49, 88, 18, 51, 91, 19, 53, 95, 19, 55, 97, 19, 56, 100, 26, 56, 98, 116, 39, 37, 133, 35, 24, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 36, 25, 132, 35, 25, 132, 35, 25, 132, 35, 25, 132, 36, 25, 131, 36, 25, 131, 36, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 25, 130, 34, 24, 129, 34, 25, 128, 34, 25, 128, 34, 25, 127, 34, 25, 126, 34, 25, 126, 34, 25, 126, 34, 24, 126, 33, 25, 126, 33, 25, 126, 33, 25, 126, 33, 25, 125, 33, 25, 125, 33, 24, 125, 33, 25, 124, 33, 25, 125, 33, 24, 124, 33, 25, 124, 33, 25, 124, 33, 25, 124, 33, 24, 124, 32, 24, 124, 32, 24, 124, 32, 24, 123, 32, 24, 123, 31, 24, 122, 31, 24, 122, 31, 24, 122, 31, 24, 121, 31, 24, 121, 30, 24, 121, 30, 24, 121, 30, 24, 120, 30, 24, 120, 30, 24, 119, 29, 24, 119, 29, 24, 119, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 116, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 112, 27, 24, 111, 27, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 108, 25, 24, 108, 25, 24, 107, 25, 24, 107, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 108, 24, 22, 81, 34, 47, 23, 55, 99, 19, 56, 100, 19, 54, 97, 19, 52, 94, 18, 51, 91, 18, 49, 88, 17, 47, 84, 16, 45, 79,
	16, 42, 74, 16, 45, 79, 17, 47, 84, 17, 49, 88, 18, 51, 91, 19, 52, 94, 19, 54, 97, 19, 55, 99, 25, 55, 98, 112, 39, 39, 133, 35, 24, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 24, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 131, 35, 25, 130, 35, 25, 131, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 24, 130, 34, 25, 130, 34, 25, 130, 35, 25, 129, 34, 24, 129, 34, 25, 129, 34, 25, 129, 34, 24, 129, 34, 25, 128, 34, 25, 128, 34, 25, 128, 34, 24, 128, 33, 24, 128, 33, 24, 128, 33, 25, 128, 33, 25, 127, 33, 24, 127, 33, 25, 127, 33, 25, 127, 33, 25, 126, 33, 25, 126, 33, 25, 125, 33, 25, 125, 33, 24, 125, 33, 24, 124, 33, 24, 124, 33, 24, 124, 32, 24, 124, 32, 24, 124, 31, 24, 124, 31, 24, 123, 32, 24, 123, 31, 24, 122, 31, 24, 122, 31, 24, 122, 31, 24, 121, 31, 24, 121, 30, 24, 121, 30, 24, 121, 30, 24, 121, 30, 24, 120, 30, 24, 119, 30, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 116, 29, 24, 116, 29, 24, 115, 29, 24, 115, 28, 24, 114, 28, 24, 114, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 110, 27, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 109, 26, 24, 108, 25, 24, 108, 25, 24, 107, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 108, 24, 22, 81, 35, 48, 22, 55, 99, 19, 55, 99, 19, 54, 97, 19, 52, 94, 18, 51, 90, 17, 49, 87, 17, 47, 83, 16, 44, 78,
	16, 42, 74, 16, 44, 79, 17, 46, 83, 17, 49, 87, 18, 50, 90, 18, 52, 93, 19, 54, 96, 19, 55, 98, 22, 56, 98, 86, 44, 56, 133, 34, 23, 131, 35, 25, 130, 35, 25, 130, 34, 25, 130, 35, 24, 130, 35, 25, 130, 35, 24, 131, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 25, 130, 35, 24, 130, 35, 24, 130, 34, 25, 129, 35, 25, 129, 34, 25, 129, 34, 25, 129, 34, 24, 129, 34, 25, 129, 34, 25, 128, 34, 25, 129, 34, 24, 128, 34, 25, 128, 34, 25, 128, 33, 25, 128, 33, 24, 128, 33, 25, 128, 33, 25, 128, 33, 25, 128, 33, 25, 128, 33, 25, 127, 33, 24, 127, 33, 24, 126, 33, 24, 126, 33, 24, 126, 33, 25, 125, 33, 24, 125, 33, 24, 125, 32, 24, 125, 32, 24, 124, 32, 24, 124, 32, 24, 124, 32, 24, 124, 32, 24, 123, 32, 24, 123, 31, 24, 123, 31, 24, 123, 31, 24, 122, 31, 24, 122, 31, 24, 122, 31, 24, 121, 30, 24, 121, 30, 24, 121, 30, 24, 120, 30, 24, 120, 30, 24, 119, 29, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 116, 28, 24, 115, 29, 24, 114, 28, 24, 114, 28, 24, 114, 28, 24, 113, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 26, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 26, 24, 109, 25, 24, 109, 25, 24, 108, 25, 24, 107, 25, 24, 107, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 109, 24, 22, 70, 38, 58, 21, 55, 99, 19, 55, 98, 19, 54, 96, 18, 52, 93, 18, 50, 89, 17, 48, 87, 17, 46, 83, 16, 44, 78,
	16, 42, 74, 16, 44, 78, 17, 46, 82, 17, 48, 85, 18, 50, 89, 18, 51, 93, 19, 53, 95, 19, 55, 98, 19, 55, 99, 42, 51, 85, 115, 37, 35, 129, 34, 25, 129, 34, 24, 130, 34, 24, 130, 34, 24, 129, 35, 25, 130, 35, 25, 129, 34, 25, 129, 35, 24, 129, 34, 25, 130, 34, 25, 130, 34, 24, 129, 34, 25, 129, 34, 25, 129, 34, 25, 129, 34, 25, 129, 34, 25, 129, 34, 25, 129, 34, 25, 129, 34, 25, 129, 34, 25, 128, 34, 25, 128, 34, 25, 128, 34, 25, 128, 34, 25, 128, 34, 25, 128, 33, 24, 128, 33, 25, 128, 33, 24, 128, 33, 25, 127, 33, 25, 128, 33, 25, 127, 33, 24, 127, 33, 25, 127, 33, 25, 126, 33, 24, 126, 33, 24, 126, 33, 25, 126, 33, 24, 125, 33, 24, 125, 33, 24, 125, 32, 25, 124, 33, 24, 124, 32, 24, 124, 32, 24, 124, 32, 24, 124, 32, 24, 124, 31, 24, 123, 31, 24, 122, 31, 24, 122, 31, 24, 122, 31, 24, 121, 31, 24, 121, 31, 24, 121, 30, 24, 121, 30, 24, 121, 30, 24, 120, 30, 24, 120, 30, 24, 120, 30, 24, 119, 29, 24, 118, 29, 24, 118, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 117, 29, 24, 116, 29, 24, 115, 29, 24, 115, 28, 24, 115, 28, 24, 114, 28, 24, 113, 28, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 113, 27, 24, 112, 27, 24, 111, 27, 24, 111, 26, 24, 110, 26, 24, 110, 26, 24, 109, 26, 24, 109, 25, 24, 109, 26, 24, 108, 26, 24, 108, 25, 24, 108, 25, 24, 107, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 106, 25, 24, 95, 29, 34, 37, 50, 85, 19, 55, 99, 19, 55, 97, 19, 52, 95, 18, 51, 92, 18, 50, 88, 17, 48, 86, 17, 46, 82, 16, 44, 77,
	16, 41, 73, 16, 43, 77, 17, 45, 81, 17, 47, 84, 17, 49, 88, 18, 51, 91, 19, 52, 94, 19, 54, 96, 19, 55, 98, 17, 56, 101, 41, 52, 86, 92, 42, 51, 108, 38, 40, 110, 38, 38, 110, 38, 39, 110, 38, 38, 110, 38, 39, 110, 38, 38, 110, 38, 38, 110, 38, 38, 110, 38, 38, 110, 38, 38, 110, 38, 39, 110, 38, 38, 110, 38, 39, 109, 38, 38, 109, 38, 38, 109, 38, 38, 109, 38, 38, 109, 38, 38, 109, 38, 39, 109, 37, 38, 109, 38, 38, 109, 37, 39, 109, 37, 38, 109, 37, 39, 109, 37, 38, 109, 37, 38, 108, 37, 38, 108, 37, 38, 108, 37, 38, 108, 37, 38, 108, 37, 38, 108, 37, 38, 108, 37, 38, 108, 37, 38, 107, 37, 38, 107, 37, 38, 106, 37, 38, 106, 37, 39, 106, 37, 38, 106, 37, 38, 106, 37, 38, 106, 36, 38, 106, 37, 38, 105, 36, 38, 105, 36, 38, 105, 35, 38, 104, 36, 38, 104, 35, 38, 104, 35, 38, 104, 35, 38, 104, 35, 38, 104, 35, 38, 103, 35, 38, 102, 35, 38, 103, 35, 38, 103, 34, 38, 102, 34, 38, 101, 34, 38, 101, 34, 38, 101, 34, 38, 101, 34, 38, 100, 34, 38, 100, 34, 38, 100, 34, 38, 100, 34, 38, 99, 34, 38, 99, 34, 38, 99, 33, 38, 98, 33, 38, 98, 33, 38, 97, 33, 38, 97, 33, 38, 97, 33, 38, 97, 32, 38, 96, 32, 38, 96, 32, 38, 95, 32, 38, 95, 32, 38, 94, 32, 38, 95, 32, 38, 94, 32, 38, 94, 32, 38, 94, 32, 38, 93, 31, 38, 93, 31, 38, 92, 31, 38, 91, 31, 38, 91, 31, 38, 91, 31, 38, 91, 31, 38, 91, 31, 38, 91, 31, 38, 91, 31, 38, 91, 31, 38, 91, 31, 38, 90, 31, 39, 77, 36, 51, 37, 50, 86, 18, 56, 101, 19, 55, 98, 19, 54, 95, 19, 52, 93, 18, 50, 90, 17, 49, 88, 17, 47, 84, 17, 45, 80, 16, 43, 77,
	16, 41, 73, 16, 43, 76, 17, 45, 80, 17, 47, 83, 17, 48, 87, 18, 50, 89, 18, 51, 92, 19, 52, 94, 19, 54, 96, 19, 55, 98, 17, 56, 101, 21, 56, 99, 32, 54, 93, 34, 53, 92, 34, 53, 93, 34, 53, 92, 34, 53, 93, 34, 53, 92, 34, 53, 93, 34, 53, 93, 34, 53, 92, 34, 53, 93, 34, 53, 92, 34, 53, 92, 34, 53, 93, 34, 53, 93, 34, 53, 92, 34, 53, 92, 34, 53, 92, 34, 53, 92, 34, 53, 93, 34, 54, 92, 34, 53, 92, 34, 54, 93, 34, 54, 93, 34, 54, 93, 34, 54, 92, 34, 54, 92, 34, 54, 92, 34, 54, 92, 34, 54, 92, 34, 54, 92, 34, 53, 92, 34, 53, 92, 34, 53, 92, 34, 53, 92, 33, 54, 92, 33, 54, 93, 33, 54, 93, 33, 54, 93, 33, 54, 93, 33, 54, 93, 33, 54, 93, 33, 54, 93, 33, 54, 93, 33, 54, 93, 33, 54, 93, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 33, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 92, 32, 53, 93, 32, 53, 93, 31, 54, 94, 31, 54, 94, 31, 54, 94, 31, 54, 94, 31, 54, 94, 31, 53, 93, 31, 53, 93, 31, 53, 93, 31, 53, 92, 31, 52, 92, 31, 52, 92, 31, 52, 92, 30, 52, 92, 29, 53, 93, 21, 56, 99, 17, 56, 101, 19, 55, 98, 19, 54, 96, 19, 52, 94, 18, 51, 92, 18, 50, 89, 17, 48, 86, 17, 47, 83, 17, 44, 79, 16, 42, 75,
	16, 41, 73, 16, 42, 74, 16, 44, 78, 17, 46, 82, 17, 47, 85, 17, 49, 88, 18, 50, 90, 18, 51, 92, 19, 52, 94, 19, 54, 96, 19, 55, 97, 19, 55, 98, 19, 55, 100, 19, 55, 100, 19, 56, 101, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 20, 56, 101, 20, 56, 101, 20, 56, 101, 20, 56, 101, 20, 56, 102, 20, 56, 102, 20, 56, 102, 20, 56, 101, 20, 56, 101, 20, 56, 102, 19, 56, 101, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 100, 20, 56, 100, 20, 56, 102, 20, 56, 101, 20, 56, 102, 20, 56, 103, 20, 56, 103, 20, 56, 103, 20, 56, 103, 20, 56, 102, 20, 56, 102, 19, 56, 101, 19, 56, 100, 19, 56, 100, 19, 56, 100, 19, 56, 101, 19, 56, 100, 19, 55, 100, 19, 55, 98, 19, 54, 97, 19, 53, 96, 19, 52, 94, 18, 51, 92, 18, 50, 90, 17, 48, 87, 17, 47, 84, 17, 46, 81, 16, 44, 78, 16, 42, 74,
	16, 41, 73, 16, 41, 74, 16, 43, 77, 17, 45, 80, 17, 46, 83, 17, 47, 85, 18, 49, 88, 18, 50, 90, 18, 51, 92, 19, 52, 94, 19, 53, 95, 19, 54, 96, 19, 54, 97, 19, 55, 97, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 20, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 99, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 98, 19, 55, 97, 19, 54, 97, 19, 53, 96, 19, 53, 94, 19, 52, 93, 18, 51, 92, 18, 50, 89, 17, 48, 87, 17, 47, 85, 17, 46, 82, 17, 45, 79, 16, 43, 76, 16, 41, 73,
	16, 41, 73, 16, 41, 73, 16, 42, 74, 16, 43, 78, 17, 45, 80, 17, 47, 83, 17, 47, 86, 18, 49, 87, 18, 50, 89, 18, 51, 91, 18, 51, 92, 19, 52, 93, 19, 52, 94, 19, 53, 94, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 54, 96, 19, 54, 96, 19, 54, 96, 20, 54, 97, 20, 54, 97, 19, 54, 97, 19, 54, 96, 19, 54, 96, 19, 54, 96, 19, 53, 96, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 54, 96, 19, 54, 96, 19, 54, 96, 19, 54, 96, 19, 53, 96, 19, 53, 96, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 95, 19, 53, 94, 19, 52, 94, 19, 52, 93, 18, 51, 92, 18, 51, 90, 18, 50, 89, 17, 48, 87, 17, 47, 85, 17, 46, 83, 17, 45, 81, 16, 43, 77, 16, 41, 74, 16, 41, 73,
	16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 42, 75, 16, 43, 78, 17, 45, 81, 17, 46, 83, 17, 47, 85, 17, 49, 86, 17, 49, 88, 18, 50, 89, 18, 50, 90, 18, 50, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 19, 51, 91, 19, 51, 92, 19, 51, 92, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 51, 93, 19, 51, 92, 18, 51, 92, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 19, 51, 92, 19, 51, 92, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 52, 93, 19, 52, 92, 19, 51, 92, 19, 51, 92, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 51, 91, 18, 50, 90, 18, 50, 90, 18, 50, 89, 17, 49, 87, 17, 49, 86, 17, 47, 85, 17, 46, 82, 17, 45, 80, 16, 44, 77, 16, 42, 74, 16, 41, 73, 16, 41, 73,
	16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 42, 75, 16, 43, 77, 17, 45, 80, 17, 45, 81, 17, 46, 83, 17, 47, 85, 17, 48, 85, 17, 48, 86, 17, 48, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 88, 17, 49, 88, 17, 49, 88, 18, 49, 88, 18, 49, 88, 18, 50, 88, 18, 50, 88, 18, 50, 88, 18, 50, 88, 18, 50, 89, 18, 50, 89, 18, 50, 89, 18, 50, 88, 18, 50, 88, 18, 50, 88, 18, 49, 88, 18, 49, 88, 17, 49, 88, 17, 49, 88, 17, 49, 88, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 88, 17, 49, 88, 18, 49, 88, 18, 49, 88, 18, 49, 88, 18, 50, 88, 18, 50, 88, 18, 50, 88, 18, 49, 88, 18, 49, 88, 18, 49, 88, 18, 49, 88, 17, 49, 88, 17, 49, 88, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 49, 87, 17, 48, 87, 17, 48, 86, 17, 48, 85, 17, 47, 84, 17, 46, 83, 17, 45, 81, 17, 45, 80, 16, 44, 77, 16, 42, 74, 16, 41, 73, 16, 41, 73, 16, 41, 73,
	16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 42, 74, 16, 43, 76, 16, 44, 78, 17, 45, 80, 17, 45, 81, 17, 46, 82, 17, 47, 83, 17, 47, 83, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 48, 84, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 48, 84, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 85, 17, 48, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 84, 17, 47, 83, 17, 47, 83, 17, 46, 81, 17, 45, 81, 17, 45, 79, 16, 44, 77, 16, 42, 76, 16, 42, 74, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73,
	43, 65, 94, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 42, 74, 16, 43, 76, 16, 43, 76, 16, 44, 77, 17, 44, 78, 17, 44, 79, 17, 44, 79, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 45, 79, 17, 44, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 45, 80, 17, 44, 79, 17, 44, 79, 17, 44, 78, 16, 44, 77, 16, 43, 76, 16, 43, 75, 16, 41, 74, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 51, 72, 99,
	192, 199, 207, 54, 75, 102, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 74, 16, 42, 74, 16, 42, 74, 16, 42, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 43, 75, 16, 42, 75, 16, 42, 74, 16, 42, 74, 16, 41, 74, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 16, 41, 73, 52, 73, 100, 191, 198, 206,
};


static constexpr float4 TEXT_COLOR = {1.0f, 1.0f, 1.0f, 1.0f};
static constexpr float4 TEXT_COORS = {0.5f, 0.175f, 0.8f, 0.04f}; // x, y, scale, space

// not constexpr to circumvent a VS bug
// https://developercommunity.visualstudio.com/content/problem/10720/constexpr-function-accessing-character-array-leads.html
static const char* FMT_STRS[5] = {
	"[Initializing Virtual File System]",
	"* archives scanned: %u",
	"* scantime elapsed: %.1fms",
	"Spring %s",
	"This program is distributed under the GNU General Public License, see doc/LICENSE for more information.",
};



void ShowSplashScreen(
	const std::string& splashScreenFile,
	const std::string& springVersionStr,
	const std::function<bool()>& testDoneFunc
) {
	CBitmap bmp;

	// passing an empty name would cause bmp FileHandler to also
	// search inside the VFS since its default mode is RAW_FIRST
	if (splashScreenFile.empty() || !bmp.Load(splashScreenFile)) {
		#if 0
		bmp.AllocDummy({0, 0, 0, 0});
		#else
		bmp.Alloc(LOGO_SIZE_X, LOGO_SIZE_Y, 4);

		static_assert(sizeof(LOGO_PIXELS) == (LOGO_SIZE_X * LOGO_SIZE_Y * 3), "");
		for (size_t i = 0, j = 0, n = sizeof(LOGO_PIXELS); i < n; i += 3, j += 4) {
			const size_t x = (i / 3) % LOGO_SIZE_X;
			const size_t y = (i / 3) / LOGO_SIZE_X;

			bmp.GetRawMem()[j + 0] = LOGO_PIXELS[i + 0];
			bmp.GetRawMem()[j + 1] = LOGO_PIXELS[i + 1];
			bmp.GetRawMem()[j + 2] = LOGO_PIXELS[i + 2];
			bmp.GetRawMem()[j + 3] = 255 * (x > 0 && x < (LOGO_SIZE_X - 1) && y > 0 && y < (LOGO_SIZE_Y - 2));
		}

		QUAD_ELEMS[0].p = {-0.125f,  0.125f * globalRendering->aspectRatio, 0.0f};
		QUAD_ELEMS[1].p = {-0.125f, -0.125f * globalRendering->aspectRatio, 0.0f};
		QUAD_ELEMS[2].p = { 0.125f, -0.125f * globalRendering->aspectRatio, 0.0f};
		QUAD_ELEMS[3].p = { 0.125f,  0.125f * globalRendering->aspectRatio, 0.0f};
		#endif
	}

	const unsigned int splashTex = bmp.CreateTexture();
	const unsigned int fontFlags = FONT_NORM | FONT_SCALE | FONT_BUFFERED;


	const float textWidth[3] = {
		font->GetTextWidth(FMT_STRS[0]),
		font->GetTextWidth(FMT_STRS[4]),
		font->GetTextWidth("Spring " + springVersionStr),
	};
	const float normWidth[3] = {
		textWidth[0] * globalRendering->pixelX * font->GetSize() * TEXT_COORS.z,
		textWidth[1] * globalRendering->pixelX * font->GetSize() * TEXT_COORS.z,
		textWidth[2] * globalRendering->pixelX * font->GetSize() * TEXT_COORS.z,
	};


	GL::RenderDataBufferT* buffer = GL::GetRenderBufferT();
	Shader::IProgramObject* shader = buffer->GetShader();

	// slower than location-based SetUniform, but works without pre-initializing uniforms via CreateShader
	// template expects a TV but argument is const TV*, tell compiler it needs to invoke matrix::operator()
	shader->Enable();
	shader->SetUniformMatrix4x4<float>("u_movi_mat", false, CMatrix44f::Identity());
	shader->SetUniformMatrix4x4<float>("u_proj_mat", false, CMatrix44f::Identity());
	shader->SetUniform("u_tex0", 0);
	shader->Disable();


	glActiveTexture(GL_TEXTURE0);

	for (spring_time t0 = spring_now(), t1 = t0; !testDoneFunc(); t1 = spring_now()) {
		glAttribStatePtr->Clear(GL_COLOR_BUFFER_BIT);
		glBindTexture(GL_TEXTURE_2D, splashTex);

		shader->Enable();
		buffer->SafeAppend(QUAD_ELEMS, sizeof(QUAD_ELEMS) / sizeof(QUAD_ELEMS[0]));
		buffer->SafeAppend(QUAD_INDCS, sizeof(QUAD_INDCS) / sizeof(QUAD_INDCS[0]));
		buffer->SubmitIndexed(GL_TRIANGLES);
		shader->Disable(); // font uses its own

		font->SetTextColor(TEXT_COLOR.x, TEXT_COLOR.y, TEXT_COLOR.z, TEXT_COLOR.w);
		font->glFormat(TEXT_COORS.x - (normWidth[0] * 0.500f), TEXT_COORS.y                                       , TEXT_COORS.z, fontFlags, FMT_STRS[0]);
		font->glFormat(TEXT_COORS.x - (normWidth[0] * 0.475f), TEXT_COORS.y - (TEXT_COORS.w * TEXT_COORS.z * 1.0f), TEXT_COORS.z, fontFlags, FMT_STRS[1], CArchiveScanner::GetNumScannedArchives());
		font->glFormat(TEXT_COORS.x - (normWidth[0] * 0.475f), TEXT_COORS.y - (TEXT_COORS.w * TEXT_COORS.z * 2.0f), TEXT_COORS.z, fontFlags, FMT_STRS[2], (t1 - t0).toMilliSecsf());

		// always render Spring's license notice (even on a white background)
		font->SetOutlineColor(0.0f, 0.0f, 0.0f, 0.65f);
		font->SetTextColor(TEXT_COLOR.x, TEXT_COLOR.y, TEXT_COLOR.z, TEXT_COLOR.w);
		font->glFormat(TEXT_COORS.x - (normWidth[2] * 0.5f), TEXT_COORS.y * 0.5f - (TEXT_COORS.w * TEXT_COORS.z * 1.0f), TEXT_COORS.z, fontFlags | FONT_OUTLINE, FMT_STRS[3], springVersionStr.c_str());
		font->glFormat(TEXT_COORS.x - (normWidth[1] * 0.5f), TEXT_COORS.y * 0.5f - (TEXT_COORS.w * TEXT_COORS.z * 2.0f), TEXT_COORS.z, fontFlags | FONT_OUTLINE, FMT_STRS[4]);
		font->DrawBufferedGL4();

		// also swaps <buffer>
		globalRendering->SwapBuffers(true, true);

		SDL_PollEvent(nullptr);
	}

	glDeleteTextures(1, &splashTex);
}
#endif

