// Copyright (c) 2016 The SigViewer Development Team
// Licensed under the GNU General Public License (GPL)
// https://www.gnu.org/licenses/gpl


#ifndef APPLICATION_CONTEXT_IMPL_H
#define APPLICATION_CONTEXT_IMPL_H

#include "base/application_states.h"
#include "gui/application_context.h"

#include <QObject>
#include <QSharedPointer>


namespace sigviewer
{

//-----------------------------------------------------------------------------
/// ApplicationContext
///
/// exists once in an application
class ApplicationContextImpl : public QObject, public ApplicationContext
{
    Q_OBJECT
public:
    //-------------------------------------------------------------------------
    static QSharedPointer<ApplicationContextImpl> getInstance (bool cleanup = false);

    //-------------------------------------------------------------------------
    static void init (std::set<ApplicationMode> activated_modes);

    //-------------------------------------------------------------------------
    static void cleanup ();

    //-------------------------------------------------------------------------
    ApplicationContextImpl () {}
    virtual ~ApplicationContextImpl ();

    //-------------------------------------------------------------------------
    virtual bool modeActivated (ApplicationMode mode) const;

    //-------------------------------------------------------------------------
    virtual QSharedPointer<FileContext> getCurrentFileContext ();

    //-------------------------------------------------------------------------
    virtual void setCurrentTabContext (QSharedPointer<TabContext> tab_context);

    //-------------------------------------------------------------------------
    virtual QSharedPointer<CommandExecuter> getCurrentCommandExecuter ();

    //-------------------------------------------------------------------------
    /// NO MULTI-FILE SUPPORT IMPLEMENTED YET!!!
    /// THIS CALL WILL REPLACE ACTUAL FILE CONTEXT
    virtual void addFileContext (QSharedPointer<FileContext> file_context);

    //-------------------------------------------------------------------------
    virtual void removeCurrentFileContext ();

    //-------------------------------------------------------------------------
    virtual QSharedPointer<MainWindowModel> getMainWindowModel ();

    //-------------------------------------------------------------------------
    virtual QSharedPointer<ColorManager> getEventColorManager ();

    QSharedPointer<ColorManager> color_manager_;

signals:
    void stateChanged (ApplicationState state);
    void currentFileStateChanged (FileState state);
    void currentTabSelectionStateChanged (TabSelectionState state);
    void currentTabEditStateChanged (TabEditState state);

private:
    void setState (ApplicationState state);
    std::set<ApplicationMode> activated_modes_;
    QSharedPointer<MainWindowModel> main_window_model_;
    QSharedPointer<FileContext> current_file_context_;
    QSharedPointer<TabContext> current_tab_context_;
    ApplicationState state_;
};

}

#endif // APPLICATION_CONTEXT_IMPL_H
