// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

extern crate pango_sys;
extern crate shell_words;
extern crate tempdir;
use std::env;
use std::error::Error;
use std::path::Path;
use std::mem::{align_of, size_of};
use std::process::Command;
use std::str;
use pango_sys::*;

static PACKAGES: &[&str] = &["pango"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Compiler, Box<Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Compiler { args })
    }

    pub fn define<'a, V: Into<Option<&'a str>>>(&mut self, var: &str, val: V) {
        let arg = match val.into() {
            None => format!("-D{}", var),
            Some(val) => format!("-D{}={}", var, val),
        };
        self.args.push(arg);
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}",
                               &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let mut cmd = Command::new("pkg-config");
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}",
                           &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}


#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
    /// Number of tests that failed to compile.
    failed_to_compile: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn record_failed_to_compile(&mut self) {
        self.failed += 1;
        self.failed_to_compile += 1;
    }
    fn summary(&self) -> String {
        format!(
            "{} passed; {} failed (compilation errors: {})",
            self.passed,
            self.failed,
            self.failed_to_compile)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let tmpdir = tempdir::TempDir::new("abi").expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!("1",
               get_c_value(tmpdir.path(), &cc, "1").expect("C constant"),
               "failed to obtain correct constant value for 1");

    let mut results : Results = Default::default();
    for (i, &(name, rust_value)) in RUST_CONSTANTS.iter().enumerate() {
        match get_c_value(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(ref c_value) => {
                if rust_value == c_value {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_value, c_value);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("constants ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let tmpdir = tempdir::TempDir::new("abi").expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!(Layout {size: 1, alignment: 1},
               get_c_layout(tmpdir.path(), &cc, "char").expect("C layout"),
               "failed to obtain correct layout for char type");

    let mut results : Results = Default::default();
    for (i, &(name, rust_layout)) in RUST_LAYOUTS.iter().enumerate() {
        match get_c_layout(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(c_layout) => {
                if rust_layout == c_layout {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_layout, &c_layout);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("layout    ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

fn get_c_layout(dir: &Path, cc: &Compiler, name: &str) -> Result<Layout, Box<Error>> {
    let exe = dir.join("layout");
    let mut cc = cc.clone();
    cc.define("ABI_TYPE_NAME", name);
    cc.compile(Path::new("tests/layout.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    let stdout = str::from_utf8(&output.stdout)?;
    let mut words = stdout.trim().split_whitespace();
    let size = words.next().unwrap().parse().unwrap();
    let alignment = words.next().unwrap().parse().unwrap();
    Ok(Layout {size, alignment})
}

fn get_c_value(dir: &Path, cc: &Compiler, name: &str) -> Result<String, Box<Error>> {
    let exe = dir.join("constant");
    let mut cc = cc.clone();
    cc.define("ABI_CONSTANT_NAME", name);
    cc.compile(Path::new("tests/constant.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    Ok(str::from_utf8(&output.stdout)?.trim().to_owned())
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    ("PangoAlignment", Layout {size: size_of::<PangoAlignment>(), alignment: align_of::<PangoAlignment>()}),
    ("PangoAnalysis", Layout {size: size_of::<PangoAnalysis>(), alignment: align_of::<PangoAnalysis>()}),
    ("PangoAttrClass", Layout {size: size_of::<PangoAttrClass>(), alignment: align_of::<PangoAttrClass>()}),
    ("PangoAttrColor", Layout {size: size_of::<PangoAttrColor>(), alignment: align_of::<PangoAttrColor>()}),
    ("PangoAttrFloat", Layout {size: size_of::<PangoAttrFloat>(), alignment: align_of::<PangoAttrFloat>()}),
    ("PangoAttrFontDesc", Layout {size: size_of::<PangoAttrFontDesc>(), alignment: align_of::<PangoAttrFontDesc>()}),
    ("PangoAttrFontFeatures", Layout {size: size_of::<PangoAttrFontFeatures>(), alignment: align_of::<PangoAttrFontFeatures>()}),
    ("PangoAttrInt", Layout {size: size_of::<PangoAttrInt>(), alignment: align_of::<PangoAttrInt>()}),
    ("PangoAttrLanguage", Layout {size: size_of::<PangoAttrLanguage>(), alignment: align_of::<PangoAttrLanguage>()}),
    ("PangoAttrShape", Layout {size: size_of::<PangoAttrShape>(), alignment: align_of::<PangoAttrShape>()}),
    ("PangoAttrString", Layout {size: size_of::<PangoAttrString>(), alignment: align_of::<PangoAttrString>()}),
    ("PangoAttrType", Layout {size: size_of::<PangoAttrType>(), alignment: align_of::<PangoAttrType>()}),
    ("PangoAttribute", Layout {size: size_of::<PangoAttribute>(), alignment: align_of::<PangoAttribute>()}),
    ("PangoBidiType", Layout {size: size_of::<PangoBidiType>(), alignment: align_of::<PangoBidiType>()}),
    ("PangoColor", Layout {size: size_of::<PangoColor>(), alignment: align_of::<PangoColor>()}),
    ("PangoCoverageLevel", Layout {size: size_of::<PangoCoverageLevel>(), alignment: align_of::<PangoCoverageLevel>()}),
    ("PangoDirection", Layout {size: size_of::<PangoDirection>(), alignment: align_of::<PangoDirection>()}),
    ("PangoEllipsizeMode", Layout {size: size_of::<PangoEllipsizeMode>(), alignment: align_of::<PangoEllipsizeMode>()}),
    ("PangoEngine", Layout {size: size_of::<PangoEngine>(), alignment: align_of::<PangoEngine>()}),
    ("PangoEngineClass", Layout {size: size_of::<PangoEngineClass>(), alignment: align_of::<PangoEngineClass>()}),
    ("PangoEngineInfo", Layout {size: size_of::<PangoEngineInfo>(), alignment: align_of::<PangoEngineInfo>()}),
    ("PangoEngineLang", Layout {size: size_of::<PangoEngineLang>(), alignment: align_of::<PangoEngineLang>()}),
    ("PangoEngineLangClass", Layout {size: size_of::<PangoEngineLangClass>(), alignment: align_of::<PangoEngineLangClass>()}),
    ("PangoEngineScriptInfo", Layout {size: size_of::<PangoEngineScriptInfo>(), alignment: align_of::<PangoEngineScriptInfo>()}),
    ("PangoEngineShape", Layout {size: size_of::<PangoEngineShape>(), alignment: align_of::<PangoEngineShape>()}),
    ("PangoEngineShapeClass", Layout {size: size_of::<PangoEngineShapeClass>(), alignment: align_of::<PangoEngineShapeClass>()}),
    ("PangoFont", Layout {size: size_of::<PangoFont>(), alignment: align_of::<PangoFont>()}),
    ("PangoFontClass", Layout {size: size_of::<PangoFontClass>(), alignment: align_of::<PangoFontClass>()}),
    ("PangoFontFace", Layout {size: size_of::<PangoFontFace>(), alignment: align_of::<PangoFontFace>()}),
    ("PangoFontFaceClass", Layout {size: size_of::<PangoFontFaceClass>(), alignment: align_of::<PangoFontFaceClass>()}),
    ("PangoFontFamily", Layout {size: size_of::<PangoFontFamily>(), alignment: align_of::<PangoFontFamily>()}),
    ("PangoFontFamilyClass", Layout {size: size_of::<PangoFontFamilyClass>(), alignment: align_of::<PangoFontFamilyClass>()}),
    ("PangoFontMap", Layout {size: size_of::<PangoFontMap>(), alignment: align_of::<PangoFontMap>()}),
    ("PangoFontMapClass", Layout {size: size_of::<PangoFontMapClass>(), alignment: align_of::<PangoFontMapClass>()}),
    ("PangoFontMask", Layout {size: size_of::<PangoFontMask>(), alignment: align_of::<PangoFontMask>()}),
    ("PangoFontMetrics", Layout {size: size_of::<PangoFontMetrics>(), alignment: align_of::<PangoFontMetrics>()}),
    ("PangoFontset", Layout {size: size_of::<PangoFontset>(), alignment: align_of::<PangoFontset>()}),
    ("PangoFontsetClass", Layout {size: size_of::<PangoFontsetClass>(), alignment: align_of::<PangoFontsetClass>()}),
    ("PangoGlyph", Layout {size: size_of::<PangoGlyph>(), alignment: align_of::<PangoGlyph>()}),
    ("PangoGlyphGeometry", Layout {size: size_of::<PangoGlyphGeometry>(), alignment: align_of::<PangoGlyphGeometry>()}),
    ("PangoGlyphItem", Layout {size: size_of::<PangoGlyphItem>(), alignment: align_of::<PangoGlyphItem>()}),
    ("PangoGlyphItemIter", Layout {size: size_of::<PangoGlyphItemIter>(), alignment: align_of::<PangoGlyphItemIter>()}),
    ("PangoGlyphString", Layout {size: size_of::<PangoGlyphString>(), alignment: align_of::<PangoGlyphString>()}),
    ("PangoGlyphUnit", Layout {size: size_of::<PangoGlyphUnit>(), alignment: align_of::<PangoGlyphUnit>()}),
    ("PangoGravity", Layout {size: size_of::<PangoGravity>(), alignment: align_of::<PangoGravity>()}),
    ("PangoGravityHint", Layout {size: size_of::<PangoGravityHint>(), alignment: align_of::<PangoGravityHint>()}),
    ("PangoIncludedModule", Layout {size: size_of::<PangoIncludedModule>(), alignment: align_of::<PangoIncludedModule>()}),
    ("PangoItem", Layout {size: size_of::<PangoItem>(), alignment: align_of::<PangoItem>()}),
    ("PangoLayoutRun", Layout {size: size_of::<PangoLayoutRun>(), alignment: align_of::<PangoLayoutRun>()}),
    ("PangoMatrix", Layout {size: size_of::<PangoMatrix>(), alignment: align_of::<PangoMatrix>()}),
    ("PangoRectangle", Layout {size: size_of::<PangoRectangle>(), alignment: align_of::<PangoRectangle>()}),
    ("PangoRenderPart", Layout {size: size_of::<PangoRenderPart>(), alignment: align_of::<PangoRenderPart>()}),
    ("PangoRenderer", Layout {size: size_of::<PangoRenderer>(), alignment: align_of::<PangoRenderer>()}),
    ("PangoRendererClass", Layout {size: size_of::<PangoRendererClass>(), alignment: align_of::<PangoRendererClass>()}),
    ("PangoScript", Layout {size: size_of::<PangoScript>(), alignment: align_of::<PangoScript>()}),
    ("PangoScriptForLang", Layout {size: size_of::<PangoScriptForLang>(), alignment: align_of::<PangoScriptForLang>()}),
    ("PangoStretch", Layout {size: size_of::<PangoStretch>(), alignment: align_of::<PangoStretch>()}),
    ("PangoStyle", Layout {size: size_of::<PangoStyle>(), alignment: align_of::<PangoStyle>()}),
    ("PangoTabAlign", Layout {size: size_of::<PangoTabAlign>(), alignment: align_of::<PangoTabAlign>()}),
    ("PangoUnderline", Layout {size: size_of::<PangoUnderline>(), alignment: align_of::<PangoUnderline>()}),
    ("PangoVariant", Layout {size: size_of::<PangoVariant>(), alignment: align_of::<PangoVariant>()}),
    ("PangoWeight", Layout {size: size_of::<PangoWeight>(), alignment: align_of::<PangoWeight>()}),
    ("PangoWrapMode", Layout {size: size_of::<PangoWrapMode>(), alignment: align_of::<PangoWrapMode>()}),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("PANGO_ALIGN_CENTER", "1"),
    ("PANGO_ALIGN_LEFT", "0"),
    ("PANGO_ALIGN_RIGHT", "2"),
    ("PANGO_ANALYSIS_FLAG_CENTERED_BASELINE", "1"),
    ("PANGO_ANALYSIS_FLAG_IS_ELLIPSIS", "2"),
    ("PANGO_ATTR_ABSOLUTE_SIZE", "20"),
    ("PANGO_ATTR_BACKGROUND", "10"),
    ("PANGO_ATTR_BACKGROUND_ALPHA", "25"),
    ("PANGO_ATTR_FALLBACK", "16"),
    ("PANGO_ATTR_FAMILY", "2"),
    ("PANGO_ATTR_FONT_DESC", "8"),
    ("PANGO_ATTR_FONT_FEATURES", "23"),
    ("PANGO_ATTR_FOREGROUND", "9"),
    ("PANGO_ATTR_FOREGROUND_ALPHA", "24"),
    ("PANGO_ATTR_GRAVITY", "21"),
    ("PANGO_ATTR_GRAVITY_HINT", "22"),
    ("PANGO_ATTR_INDEX_FROM_TEXT_BEGINNING", "0"),
    ("PANGO_ATTR_INVALID", "0"),
    ("PANGO_ATTR_LANGUAGE", "1"),
    ("PANGO_ATTR_LETTER_SPACING", "17"),
    ("PANGO_ATTR_RISE", "13"),
    ("PANGO_ATTR_SCALE", "15"),
    ("PANGO_ATTR_SHAPE", "14"),
    ("PANGO_ATTR_SIZE", "7"),
    ("PANGO_ATTR_STRETCH", "6"),
    ("PANGO_ATTR_STRIKETHROUGH", "12"),
    ("PANGO_ATTR_STRIKETHROUGH_COLOR", "19"),
    ("PANGO_ATTR_STYLE", "3"),
    ("PANGO_ATTR_UNDERLINE", "11"),
    ("PANGO_ATTR_UNDERLINE_COLOR", "18"),
    ("PANGO_ATTR_VARIANT", "5"),
    ("PANGO_ATTR_WEIGHT", "4"),
    ("PANGO_BIDI_TYPE_AL", "4"),
    ("PANGO_BIDI_TYPE_AN", "11"),
    ("PANGO_BIDI_TYPE_B", "15"),
    ("PANGO_BIDI_TYPE_BN", "14"),
    ("PANGO_BIDI_TYPE_CS", "12"),
    ("PANGO_BIDI_TYPE_EN", "8"),
    ("PANGO_BIDI_TYPE_ES", "9"),
    ("PANGO_BIDI_TYPE_ET", "10"),
    ("PANGO_BIDI_TYPE_L", "0"),
    ("PANGO_BIDI_TYPE_LRE", "1"),
    ("PANGO_BIDI_TYPE_LRO", "2"),
    ("PANGO_BIDI_TYPE_NSM", "13"),
    ("PANGO_BIDI_TYPE_ON", "18"),
    ("PANGO_BIDI_TYPE_PDF", "7"),
    ("PANGO_BIDI_TYPE_R", "3"),
    ("PANGO_BIDI_TYPE_RLE", "5"),
    ("PANGO_BIDI_TYPE_RLO", "6"),
    ("PANGO_BIDI_TYPE_S", "16"),
    ("PANGO_BIDI_TYPE_WS", "17"),
    ("PANGO_COVERAGE_APPROXIMATE", "2"),
    ("PANGO_COVERAGE_EXACT", "3"),
    ("PANGO_COVERAGE_FALLBACK", "1"),
    ("PANGO_COVERAGE_NONE", "0"),
    ("PANGO_DIRECTION_LTR", "0"),
    ("PANGO_DIRECTION_NEUTRAL", "6"),
    ("PANGO_DIRECTION_RTL", "1"),
    ("PANGO_DIRECTION_TTB_LTR", "2"),
    ("PANGO_DIRECTION_TTB_RTL", "3"),
    ("PANGO_DIRECTION_WEAK_LTR", "4"),
    ("PANGO_DIRECTION_WEAK_RTL", "5"),
    ("PANGO_ELLIPSIZE_END", "3"),
    ("PANGO_ELLIPSIZE_MIDDLE", "2"),
    ("PANGO_ELLIPSIZE_NONE", "0"),
    ("PANGO_ELLIPSIZE_START", "1"),
    ("PANGO_ENGINE_TYPE_LANG", "PangoEngineLang"),
    ("PANGO_ENGINE_TYPE_SHAPE", "PangoEngineShape"),
    ("PANGO_FONT_MASK_FAMILY", "1"),
    ("PANGO_FONT_MASK_GRAVITY", "64"),
    ("PANGO_FONT_MASK_SIZE", "32"),
    ("PANGO_FONT_MASK_STRETCH", "16"),
    ("PANGO_FONT_MASK_STYLE", "2"),
    ("PANGO_FONT_MASK_VARIANT", "4"),
    ("PANGO_FONT_MASK_WEIGHT", "8"),
    ("PANGO_GLYPH_EMPTY", "268435455"),
    ("PANGO_GLYPH_INVALID_INPUT", "4294967295"),
    ("PANGO_GLYPH_UNKNOWN_FLAG", "268435456"),
    ("PANGO_GRAVITY_AUTO", "4"),
    ("PANGO_GRAVITY_EAST", "1"),
    ("PANGO_GRAVITY_HINT_LINE", "2"),
    ("PANGO_GRAVITY_HINT_NATURAL", "0"),
    ("PANGO_GRAVITY_HINT_STRONG", "1"),
    ("PANGO_GRAVITY_NORTH", "2"),
    ("PANGO_GRAVITY_SOUTH", "0"),
    ("PANGO_GRAVITY_WEST", "3"),
    ("PANGO_RENDER_PART_BACKGROUND", "1"),
    ("PANGO_RENDER_PART_FOREGROUND", "0"),
    ("PANGO_RENDER_PART_STRIKETHROUGH", "3"),
    ("PANGO_RENDER_PART_UNDERLINE", "2"),
    ("PANGO_RENDER_TYPE_NONE", "PangoRenderNone"),
    ("PANGO_SCALE", "1024"),
    ("PANGO_SCRIPT_AHOM", "111"),
    ("PANGO_SCRIPT_ANATOLIAN_HIEROGLYPHS", "112"),
    ("PANGO_SCRIPT_ARABIC", "2"),
    ("PANGO_SCRIPT_ARMENIAN", "3"),
    ("PANGO_SCRIPT_BALINESE", "62"),
    ("PANGO_SCRIPT_BASSA_VAH", "88"),
    ("PANGO_SCRIPT_BATAK", "78"),
    ("PANGO_SCRIPT_BENGALI", "4"),
    ("PANGO_SCRIPT_BOPOMOFO", "5"),
    ("PANGO_SCRIPT_BRAHMI", "79"),
    ("PANGO_SCRIPT_BRAILLE", "46"),
    ("PANGO_SCRIPT_BUGINESE", "55"),
    ("PANGO_SCRIPT_BUHID", "44"),
    ("PANGO_SCRIPT_CANADIAN_ABORIGINAL", "40"),
    ("PANGO_SCRIPT_CARIAN", "75"),
    ("PANGO_SCRIPT_CAUCASIAN_ALBANIAN", "89"),
    ("PANGO_SCRIPT_CHAKMA", "81"),
    ("PANGO_SCRIPT_CHAM", "72"),
    ("PANGO_SCRIPT_CHEROKEE", "6"),
    ("PANGO_SCRIPT_COMMON", "0"),
    ("PANGO_SCRIPT_COPTIC", "7"),
    ("PANGO_SCRIPT_CUNEIFORM", "63"),
    ("PANGO_SCRIPT_CYPRIOT", "47"),
    ("PANGO_SCRIPT_CYRILLIC", "8"),
    ("PANGO_SCRIPT_DESERET", "9"),
    ("PANGO_SCRIPT_DEVANAGARI", "10"),
    ("PANGO_SCRIPT_DUPLOYAN", "90"),
    ("PANGO_SCRIPT_ELBASAN", "91"),
    ("PANGO_SCRIPT_ETHIOPIC", "11"),
    ("PANGO_SCRIPT_GEORGIAN", "12"),
    ("PANGO_SCRIPT_GLAGOLITIC", "56"),
    ("PANGO_SCRIPT_GOTHIC", "13"),
    ("PANGO_SCRIPT_GRANTHA", "92"),
    ("PANGO_SCRIPT_GREEK", "14"),
    ("PANGO_SCRIPT_GUJARATI", "15"),
    ("PANGO_SCRIPT_GURMUKHI", "16"),
    ("PANGO_SCRIPT_HAN", "17"),
    ("PANGO_SCRIPT_HANGUL", "18"),
    ("PANGO_SCRIPT_HANUNOO", "43"),
    ("PANGO_SCRIPT_HATRAN", "113"),
    ("PANGO_SCRIPT_HEBREW", "19"),
    ("PANGO_SCRIPT_HIRAGANA", "20"),
    ("PANGO_SCRIPT_INHERITED", "1"),
    ("PANGO_SCRIPT_INVALID_CODE", "-1"),
    ("PANGO_SCRIPT_KANNADA", "21"),
    ("PANGO_SCRIPT_KATAKANA", "22"),
    ("PANGO_SCRIPT_KAYAH_LI", "67"),
    ("PANGO_SCRIPT_KHAROSHTHI", "60"),
    ("PANGO_SCRIPT_KHMER", "23"),
    ("PANGO_SCRIPT_KHOJKI", "93"),
    ("PANGO_SCRIPT_KHUDAWADI", "94"),
    ("PANGO_SCRIPT_LAO", "24"),
    ("PANGO_SCRIPT_LATIN", "25"),
    ("PANGO_SCRIPT_LEPCHA", "68"),
    ("PANGO_SCRIPT_LIMBU", "48"),
    ("PANGO_SCRIPT_LINEAR_A", "95"),
    ("PANGO_SCRIPT_LINEAR_B", "51"),
    ("PANGO_SCRIPT_LYCIAN", "76"),
    ("PANGO_SCRIPT_LYDIAN", "77"),
    ("PANGO_SCRIPT_MAHAJANI", "96"),
    ("PANGO_SCRIPT_MALAYALAM", "26"),
    ("PANGO_SCRIPT_MANDAIC", "80"),
    ("PANGO_SCRIPT_MANICHAEAN", "97"),
    ("PANGO_SCRIPT_MENDE_KIKAKUI", "98"),
    ("PANGO_SCRIPT_MEROITIC_CURSIVE", "82"),
    ("PANGO_SCRIPT_MEROITIC_HIEROGLYPHS", "83"),
    ("PANGO_SCRIPT_MIAO", "84"),
    ("PANGO_SCRIPT_MODI", "99"),
    ("PANGO_SCRIPT_MONGOLIAN", "27"),
    ("PANGO_SCRIPT_MRO", "100"),
    ("PANGO_SCRIPT_MULTANI", "114"),
    ("PANGO_SCRIPT_MYANMAR", "28"),
    ("PANGO_SCRIPT_NABATAEAN", "101"),
    ("PANGO_SCRIPT_NEW_TAI_LUE", "54"),
    ("PANGO_SCRIPT_NKO", "66"),
    ("PANGO_SCRIPT_OGHAM", "29"),
    ("PANGO_SCRIPT_OLD_HUNGARIAN", "115"),
    ("PANGO_SCRIPT_OLD_ITALIC", "30"),
    ("PANGO_SCRIPT_OLD_NORTH_ARABIAN", "102"),
    ("PANGO_SCRIPT_OLD_PERMIC", "103"),
    ("PANGO_SCRIPT_OLD_PERSIAN", "59"),
    ("PANGO_SCRIPT_OL_CHIKI", "73"),
    ("PANGO_SCRIPT_ORIYA", "31"),
    ("PANGO_SCRIPT_OSMANYA", "49"),
    ("PANGO_SCRIPT_PAHAWH_HMONG", "104"),
    ("PANGO_SCRIPT_PALMYRENE", "105"),
    ("PANGO_SCRIPT_PAU_CIN_HAU", "106"),
    ("PANGO_SCRIPT_PHAGS_PA", "65"),
    ("PANGO_SCRIPT_PHOENICIAN", "64"),
    ("PANGO_SCRIPT_PSALTER_PAHLAVI", "107"),
    ("PANGO_SCRIPT_REJANG", "69"),
    ("PANGO_SCRIPT_RUNIC", "32"),
    ("PANGO_SCRIPT_SAURASHTRA", "71"),
    ("PANGO_SCRIPT_SHARADA", "85"),
    ("PANGO_SCRIPT_SHAVIAN", "50"),
    ("PANGO_SCRIPT_SIDDHAM", "108"),
    ("PANGO_SCRIPT_SIGNWRITING", "116"),
    ("PANGO_SCRIPT_SINHALA", "33"),
    ("PANGO_SCRIPT_SORA_SOMPENG", "86"),
    ("PANGO_SCRIPT_SUNDANESE", "70"),
    ("PANGO_SCRIPT_SYLOTI_NAGRI", "58"),
    ("PANGO_SCRIPT_SYRIAC", "34"),
    ("PANGO_SCRIPT_TAGALOG", "42"),
    ("PANGO_SCRIPT_TAGBANWA", "45"),
    ("PANGO_SCRIPT_TAI_LE", "52"),
    ("PANGO_SCRIPT_TAKRI", "87"),
    ("PANGO_SCRIPT_TAMIL", "35"),
    ("PANGO_SCRIPT_TELUGU", "36"),
    ("PANGO_SCRIPT_THAANA", "37"),
    ("PANGO_SCRIPT_THAI", "38"),
    ("PANGO_SCRIPT_TIBETAN", "39"),
    ("PANGO_SCRIPT_TIFINAGH", "57"),
    ("PANGO_SCRIPT_TIRHUTA", "109"),
    ("PANGO_SCRIPT_UGARITIC", "53"),
    ("PANGO_SCRIPT_UNKNOWN", "61"),
    ("PANGO_SCRIPT_VAI", "74"),
    ("PANGO_SCRIPT_WARANG_CITI", "110"),
    ("PANGO_SCRIPT_YI", "41"),
    ("PANGO_STRETCH_CONDENSED", "2"),
    ("PANGO_STRETCH_EXPANDED", "6"),
    ("PANGO_STRETCH_EXTRA_CONDENSED", "1"),
    ("PANGO_STRETCH_EXTRA_EXPANDED", "7"),
    ("PANGO_STRETCH_NORMAL", "4"),
    ("PANGO_STRETCH_SEMI_CONDENSED", "3"),
    ("PANGO_STRETCH_SEMI_EXPANDED", "5"),
    ("PANGO_STRETCH_ULTRA_CONDENSED", "0"),
    ("PANGO_STRETCH_ULTRA_EXPANDED", "8"),
    ("PANGO_STYLE_ITALIC", "2"),
    ("PANGO_STYLE_NORMAL", "0"),
    ("PANGO_STYLE_OBLIQUE", "1"),
    ("PANGO_TAB_LEFT", "0"),
    ("PANGO_UNDERLINE_DOUBLE", "2"),
    ("PANGO_UNDERLINE_ERROR", "4"),
    ("PANGO_UNDERLINE_LOW", "3"),
    ("PANGO_UNDERLINE_NONE", "0"),
    ("PANGO_UNDERLINE_SINGLE", "1"),
    ("PANGO_UNKNOWN_GLYPH_HEIGHT", "14"),
    ("PANGO_UNKNOWN_GLYPH_WIDTH", "10"),
    ("PANGO_VARIANT_NORMAL", "0"),
    ("PANGO_VARIANT_SMALL_CAPS", "1"),
    ("PANGO_VERSION_MIN_REQUIRED", "2"),
    ("PANGO_WEIGHT_BOLD", "700"),
    ("PANGO_WEIGHT_BOOK", "380"),
    ("PANGO_WEIGHT_HEAVY", "900"),
    ("PANGO_WEIGHT_LIGHT", "300"),
    ("PANGO_WEIGHT_MEDIUM", "500"),
    ("PANGO_WEIGHT_NORMAL", "400"),
    ("PANGO_WEIGHT_SEMIBOLD", "600"),
    ("PANGO_WEIGHT_SEMILIGHT", "350"),
    ("PANGO_WEIGHT_THIN", "100"),
    ("PANGO_WEIGHT_ULTRABOLD", "800"),
    ("PANGO_WEIGHT_ULTRAHEAVY", "1000"),
    ("PANGO_WEIGHT_ULTRALIGHT", "200"),
    ("PANGO_WRAP_CHAR", "1"),
    ("PANGO_WRAP_WORD", "0"),
    ("PANGO_WRAP_WORD_CHAR", "2"),
];


