// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Buildable;
use SizeGroupMode;
use Widget;
use ffi;
use glib;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct SizeGroup(Object<ffi::GtkSizeGroup, ffi::GtkSizeGroupClass>): Buildable;

    match fn {
        get_type => || ffi::gtk_size_group_get_type(),
    }
}

impl SizeGroup {
    pub fn new(mode: SizeGroupMode) -> SizeGroup {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_size_group_new(mode.to_glib()))
        }
    }
}

pub trait SizeGroupExt {
    fn add_widget<P: IsA<Widget>>(&self, widget: &P);

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn get_ignore_hidden(&self) -> bool;

    fn get_mode(&self) -> SizeGroupMode;

    fn get_widgets(&self) -> Vec<Widget>;

    fn remove_widget<P: IsA<Widget>>(&self, widget: &P);

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn set_ignore_hidden(&self, ignore_hidden: bool);

    fn set_mode(&self, mode: SizeGroupMode);

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn connect_property_ignore_hidden_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<SizeGroup> + IsA<glib::object::Object>> SizeGroupExt for O {
    fn add_widget<P: IsA<Widget>>(&self, widget: &P) {
        unsafe {
            ffi::gtk_size_group_add_widget(self.to_glib_none().0, widget.to_glib_none().0);
        }
    }

    fn get_ignore_hidden(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_size_group_get_ignore_hidden(self.to_glib_none().0))
        }
    }

    fn get_mode(&self) -> SizeGroupMode {
        unsafe {
            from_glib(ffi::gtk_size_group_get_mode(self.to_glib_none().0))
        }
    }

    fn get_widgets(&self) -> Vec<Widget> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_size_group_get_widgets(self.to_glib_none().0))
        }
    }

    fn remove_widget<P: IsA<Widget>>(&self, widget: &P) {
        unsafe {
            ffi::gtk_size_group_remove_widget(self.to_glib_none().0, widget.to_glib_none().0);
        }
    }

    fn set_ignore_hidden(&self, ignore_hidden: bool) {
        unsafe {
            ffi::gtk_size_group_set_ignore_hidden(self.to_glib_none().0, ignore_hidden.to_glib());
        }
    }

    fn set_mode(&self, mode: SizeGroupMode) {
        unsafe {
            ffi::gtk_size_group_set_mode(self.to_glib_none().0, mode.to_glib());
        }
    }

    fn connect_property_ignore_hidden_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::ignore-hidden",
                transmute(notify_ignore_hidden_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::mode",
                transmute(notify_mode_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn notify_ignore_hidden_trampoline<P>(this: *mut ffi::GtkSizeGroup, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<SizeGroup> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&SizeGroup::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_mode_trampoline<P>(this: *mut ffi::GtkSizeGroup, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<SizeGroup> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&SizeGroup::from_glib_borrow(this).downcast_unchecked())
}
