#include "../matrixutils/mask.h"
#include <rumba/arghandler.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrixio.h>
#include <rumba/jacobi.h>

#include <vector>
#include <algorithm>
#include <time.h>
#include <stdlib.h>

#define RANDOM random
#define SRAND srandom

using namespace RUMBA;
using RUMBA::Argument;

void usage()
{
	std::cerr << "Usage: randompermute-matrix "
		"(-i|--infile) infile (-o|--outfile) outfile\n"
		"[--permute-rows|-p]" << std::endl;
}


Argument myArgs[] = 
{
	Argument("vectors",RUMBA::ALPHA,'e',"",false),
	Argument("permute-rows",RUMBA::FLAG,'p',0,false),
	Argument()
};

class RandomGenerator
{
public:
	RandomGenerator() { seed(time(NULL)); }
	RandomGenerator(int x) { seed(x); }
	void seed(int x) { SRAND(x); }
	
	int operator()(int x)
	{
		return RANDOM () % x;
	}
};

int main(int argc,char** argv)
{
	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setRequiredDefaultArg("outfile");
	int seed = 0;
	bool permute_rows;
	SRAND(time(NULL));

	std::string infile,outfile,evecfile;
	try {
		RUMBA::ArgHandler argh ( argc , argv, myArgs );

		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}

		argh.arg("infile",infile);
		argh.arg("outfile",outfile);
		permute_rows = (argh.arg("permute-rows"));


	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}


	RandomGenerator r;
	
	try 
	{
		RUMBA::ManifoldMatrix in = 
			RUMBA::manifoldMatrixReadHack(infile.c_str());

		if (permute_rows)
			in=in.transpose();

		std::vector<int> v;
		v.resize(in.rows());
		for ( int i = 0; i < v.size(); ++i )
			v[i]=i;
		std::random_shuffle(v.begin(),v.end(),r);


		std::vector<double> w(in.rows());
		for ( int i = 0; i < in.cols(); ++i )
		{
			for ( int j = 0; j < in.rows(); ++j )
				w[j]=in.element(v[j],i);
			for ( int j = 0; j < in.rows(); ++j )
				in.element(j,i)=w[j];
		}

		if (permute_rows)
			in=in.transpose();

		RUMBA::manifoldMatrixWriteHack(in,outfile.c_str());

		

	}
	catch (RUMBA::Exception& e)
	{
		std::cerr << "Fatal error: " << e.error() << std::endl;
		exit(2);
	}
	
	return 0;
}
