#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrix.hpp>
#include <rumba/matrixio.h>


using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: matrix-multiply -i infile1 infile2 -o outfile\n";
}

/********** If we had special args, here would be the place for them...
Argument myArgs [] = {
	Argument()
};
*********** But we don't...*******************************************/

int main(int argc,char** argv)
{
	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setMultiDefaultArg("infile");
	std::vector<Splodge> v;	
	std::string outfile , sortMethod;
	void ( *theSortFunction ) ( std::vector<string> & );

	try {
		ArgHandler argh ( argc , argv );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		v =  argh.multiarg( "infile" );
		try { argh.arg ( "outfile" , outfile ); } catch (...){}

		theSortFunction = doNothing;
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}

// main loop for matrix multiplication


	try 
	{
	ManifoldMatrix product = manifoldMatrixReadHack( v.front().asString() );

	for (std::vector<Splodge>::iterator it = v.begin()+1; it != v.end(); ++it ) 
	{
		product =  product * manifoldMatrixReadHack( it->asString() ) ;
	}
	std::cerr << "Writing Matrix" << std::endl;
	manifoldMatrixWriteHack( product , outfile.c_str() );
	}
	catch ( RUMBA::Exception& e )
	{
		std::cerr << "Fatal Exception: " << e.error() << std::endl;
	}
}
