#include "stats.h"	
#include <cmath>

namespace {
	double volume(const RUMBA::intPoint& e)
	{
		return e.x()*e.y()*e.z()*e.t();
	}
};

using RUMBA::StatFunctor;
double StatFunctor::mean() const
{
	int sz = volume(Extent);
	assert(sz);
	return sum / ( sz );
}


double StatFunctor::sumSquare() const
{
	return sumsq;
}

double StatFunctor::variance() const
{
	double tmp = mean();
	return (sumsq  - 2 * tmp * sum) / (volume(Extent)) + tmp * tmp;
}

double StatFunctor::sd() const
{
	return std::sqrt(variance());
}


void StatFunctor::setManifold(const BaseManifold* A)
{
	ptr = A;
	compute();
}



double StatFunctor::max() const { return Max; }
double StatFunctor::min() const { return Min; }



void StatFunctor::compute() 
{
	double tmp;	
	sum = sumsq = 0;
	Max = Min = ptr->getElementDouble(Origin);

	intPoint count (0,0,0,0);
	intPoint top = intPoint ( 
			Origin.x()+Extent.x(), 
			Origin.y()+Extent.y(), 
			Origin.z()+Extent.z(),
			Origin.t()+Extent.t()
			);

	for ( count.t() = Origin.t(); count.t() < top.t(); ++count.t() )
	   for ( count.z() = Origin.z(); count.z() < top.z(); ++count.z() )
		   for ( count.y() = Origin.y(); count.y() < top.y(); ++count.y() )
			   for ( count.x() = Origin.x(); count.x() < top.x(); ++count.x() )
				   sum += ptr->getElementDouble(count);

	for ( count.t() = Origin.t(); count.t() < top.t(); ++count.t() )
	   for ( count.z() = Origin.z(); count.z() < top.z(); ++count.z() )
		   for ( count.y() = Origin.y(); count.y() < top.y(); ++count.y() )
			   for ( count.x() = Origin.x(); count.x() < top.x(); ++count.x() )
			   {
				   tmp = ptr->getElementDouble(count);
				   sumsq += tmp*tmp;
			   }

	for ( count.t() = Origin.t(); count.t() < Extent.t(); ++count.t() )
	   for ( count.z() = Origin.z(); count.z() < Extent.z(); ++count.z() )
		   for ( count.y() = Origin.y(); count.y() < Extent.y(); ++count.y() )
			   for ( count.x() = Origin.x(); count.x() < Extent.x(); ++count.x() )
			   {
					tmp = ptr->getElementDouble(count);
					if ( tmp > Max ) 
						Max = tmp; 
					else if ( tmp < Min )
						Min = tmp;
			   }

}
