#include "../matrixutils/mask.h"
#include <rumba/arghandler.h>
#include <sstream>

using namespace RUMBA;

typedef void(*maskop_t)(Manifold<char>&, const Manifold<char>&);

void usage()
{
	std::cerr << "Usage: maskop (--union|-u|--intersection|-n|--complement|-c) -i infile1 infile2 ...  -o outfile \n"
		<< std::endl;
}

void maskop_intersect ( Manifold<char> & M, const Manifold<char>& N)
{
	if ( M.size() != N.size() )
	{
		std::ostringstream strout;
		strout << "Incompatible sizes: " << M.size() << " " << N.size();
		throw RUMBA::Exception(strout.str());
	}
	
	for ( int i = 0; i < M.size(); ++i )
		M[i] = ( M[i] && N[i] ) ? 1 : 0;
	
}

void maskop_complement( Manifold<char> & M)
{
	for ( int i = 0; i < M.size(); ++i )
		if (!M[i] ) 
			M[i] = 1; 
		else 
			M[i] = 0;
}

void maskop_union ( Manifold<char> & M, const Manifold<char>& N)
{
	if ( M.size() != N.size() )
	{
		std::ostringstream strout;
		strout << "Incompatible sizes: " << M.size() << " " << N.size();
		throw RUMBA::Exception(strout.str());
	}
	
	for ( int i = 0; i < M.size(); ++i )
		M[i] = ( M[i] || N[i] ) ? 1 : 0;
}

Argument myArgs[] = 
{
	Argument ( "union", RUMBA::FLAG, 'u' ),
	Argument ( "intersection", RUMBA::FLAG, 'n' ),
	Argument ( "complement", RUMBA::FLAG, 'c' ),
	Argument ()
};


int main(int argc,char** argv)
{
	ArgHandler::setMultiDefaultArg("infile");
	ArgHandler::setRequiredDefaultArg("outfile");
	ArgHandler::setRequiredDefaultArg("infile");
	std::vector<RUMBA::Splodge> infile;
	std::vector<RUMBA::Splodge>::const_iterator it;
	std::string outfile;
	maskop_t op;
	try {
		RUMBA::ArgHandler argh ( argc , argv, myArgs  );

		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}

		infile = argh.multiarg("infile");
		argh.arg("outfile",outfile);

		if ( infile.empty() )
		{
			usage();
			return 0;
		}

		if ( argh.arg ( "union" )) 
			op = maskop_union;
		else if ( argh.arg ( "intersection" ))
			op = maskop_intersect;
		else 
			op = 0;
			
		it = infile.begin();
		Manifold<char> outmask ( it->asString().c_str() );
		++it;
		if (op)
		{
			for (; it!=infile.end(); ++it )
				(*op)( outmask, Manifold<char> ( it->asString().c_str() ));
		}
		else
		{
			maskop_complement ( outmask );
		}
	
		outmask.save(outfile);
		
		return 0;
	

	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}

	return 1;

}
