#include <rumba/manifoldFile.h>
#include <rumba/arghandler.h>
	
template<class TYPE>
void interpolate (std::vector<TYPE> & v, int start_index, int end_index )
{
	double ratio = (end_index - start_index) / (double) v.size();
	double tmp;
	for (int i = v.size()-1; i >= 0; --i )
	{
		tmp = ratio * i;
		v[i] = (tmp - (int)tmp) * (v[(int)(tmp+1)] - v[(int)tmp] )+v[(int)tmp];
	}
}

void usage()
{
	std::cerr << "Usage: interpolate -i infile -o outfile -l new_length\n";
}

using RUMBA::Argument;

Argument myArgs [] = {
	Argument( "length", RUMBA::NUMERIC, 'l', true ),
	Argument()
};

int main(int argc, char** argv)
{
	std::string infile , outfile;
	int length;
	int px;int tp;
	RUMBA::ManifoldFile* fin;
	RUMBA::ManifoldFile* fout;
	RUMBA::intPoint ext;
	std::vector<double> v;

	try {
		RUMBA::ArgHandler argh ( argc , argv, myArgs );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		argh.arg ( "infile" , infile );
		argh.arg ( "outfile" , outfile );
		argh.arg( "length", length );


		fin = RUMBA::ManifoldFile::construct ( infile.c_str ());
		if (!fin)
			throw RUMBA::Exception("Couldn't open input file");

		if (length < fin->extent().t() )
			throw RUMBA::Exception("Length too short");

		ext = fin->extent();
		ext.t() = length;
		fout = RUMBA::ManifoldFile::construct ( outfile.c_str(), "float64", ext);
		if (!fout) 
			throw RUMBA::Exception("Couldn't open output file");

		px = fin->pixels();
		tp = fin->timepoints();
		v.resize(length);

		fin->setCacheStrategy(RUMBA::CACHE_TIME);
		fout->setCacheStrategy(RUMBA::CACHE_TIME);


		for ( int i = 0; i < px; ++i )
		{
			std::fill(v.begin(),v.end(),0);
			for ( int j = 0; j < tp; ++j )
				v[j] = (*fin)[ i + j*px ];

			interpolate(v,0,tp);

			for ( int j = 0; j < fout->timepoints(); ++j )
				(*fout)[ i + j*px ] = v[j];
		}

		delete fin;
		delete fout;




	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (RUMBA::Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}



}
