require 'test-unit-ext'

class TestPending < Test::Unit::TestCase
  class TestCase < Test::Unit::TestCase
    class << self
      def suite
        Test::Unit::TestSuite.new(name)
      end
    end

    def test_pend
      pend("1st pend")
      pend("2nd pend. Not reached here.")
    end

    def test_pend_with_failure_in_block
      pend("Wait a minute") do
        raise "Not implemented yet"
      end
      assert(true, "Not reached here.")
    end

    def test_pend_with_no_failure_in_block
      pend("Wait a minute") do
        "Nothing raised"
      end
      assert(true, "Reached here.")
    end
  end

  def test_pend
    result = run_test("test_pend")
    assert_equal("1 tests, 0 assertions, 0 failures, 0 errors, 1 pendings, " \
                 "0 omissions, 0 notifications",
                 result.to_s)
    assert_equal(["1st pend"],
                 result.pendings.collect {|pending| pending.message})
  end

  def test_pend_with_failure_in_block
    result = run_test("test_pend_with_failure_in_block")
    assert_equal("1 tests, 0 assertions, 0 failures, 0 errors, 1 pendings, " \
                 "0 omissions, 0 notifications",
                 result.to_s)
    assert_equal(["Wait a minute"],
                 result.pendings.collect {|pending| pending.message})
  end

  def test_pend_with_no_failure_in_block
    result = run_test("test_pend_with_no_failure_in_block")
    assert_equal("1 tests, 1 assertions, 1 failures, 0 errors, 0 pendings, " \
                 "0 omissions, 0 notifications",
                 result.to_s)
    assert_equal(["Pending block should not be passed: Wait a minute."],
                 result.failures.collect {|failure| failure.message})
  end

  private
  def run_test(name)
    result = Test::Unit::TestResult.new
    TestCase.new(name).run(result) {}
    result
  end
end
