
#line 1 "ragel/i18n/fa.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/fa.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_fa/gherkin_lexer_fa.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 13, 18, 19, 20, 21, 22, 
	23, 24, 25, 26, 27, 29, 31, 43, 
	46, 47, 48, 49, 50, 51, 52, 53, 
	54, 55, 56, 57, 58, 59, 60, 61, 
	62, 69, 71, 73, 75, 77, 79, 81, 
	83, 85, 87, 89, 91, 93, 105, 106, 
	107, 109, 111, 116, 121, 126, 131, 135, 
	139, 141, 142, 143, 144, 145, 146, 147, 
	148, 149, 150, 151, 152, 153, 154, 155, 
	156, 161, 168, 173, 177, 183, 186, 188, 
	194, 206, 207, 208, 209, 210, 211, 212, 
	213, 214, 215, 216, 218, 219, 220, 221, 
	222, 223, 224, 225, 226, 227, 228, 229, 
	230, 239, 243, 245, 247, 249, 251, 253, 
	255, 257, 259, 261, 263, 265, 267, 269, 
	271, 273, 275, 277, 279, 281, 283, 285, 
	287, 289, 291, 293, 295, 297, 299, 301, 
	303, 306, 308, 310, 312, 314, 316, 318, 
	320, 322, 324, 326, 328, 330, 332, 334, 
	336, 338, 340, 342, 344, 346, 348, 350, 
	352, 354, 356, 358, 360, 362, 364, 366, 
	368, 370, 372, 374, 376, 378, 380, 381, 
	383, 384, 385, 386, 387, 388, 389, 390, 
	391, 392, 393, 394, 395, 396, 397, 398, 
	399, 400, 401, 402, 403, 404, 405, 415, 
	420, 422, 424, 426, 428, 430, 432, 434, 
	436, 438, 440, 442, 444, 446, 448, 450, 
	452, 454, 456, 458, 460, 462, 464, 466, 
	468, 470, 472, 474, 476, 478, 480, 482, 
	484, 486, 489, 491, 493, 495, 497, 499, 
	501, 503, 505, 507, 509, 512, 514, 516, 
	518, 520, 522, 524, 526, 528, 530, 532, 
	534, 536, 538, 540, 542, 544, 546, 548, 
	550, 552, 554, 556, 558, 559, 560, 561, 
	562, 563, 564, 565, 566, 567, 568, 569, 
	570, 571, 572, 573, 574, 575, 576, 577, 
	578, 579, 580, 590, 595, 597, 599, 601, 
	603, 605, 607, 609, 611, 613, 615, 618, 
	620, 622, 624, 626, 628, 630, 632, 634, 
	636, 638, 640, 642, 644, 646, 648, 650, 
	652, 654, 656, 658, 660, 662, 664, 666, 
	668, 670, 672, 674, 676, 678, 680, 683, 
	685, 687, 689, 691, 693, 695, 697, 699, 
	701, 703, 706, 708, 710, 712, 714, 716, 
	718, 720, 722, 724, 726, 728, 730, 732, 
	734, 736, 738, 740, 742, 744, 746, 748, 
	750, 752, 753, 754, 755, 756, 757, 758, 
	759, 760, 761, 762, 763, 764, 765, 775, 
	781, 783, 785, 787, 789, 791, 793, 795, 
	797, 799, 801, 804, 806, 808, 810, 812, 
	814, 816, 818, 820, 822, 824, 826, 828, 
	830, 832, 834, 836, 838, 840, 842, 844, 
	846, 848, 850, 852, 854, 856, 858, 860, 
	862, 864, 866, 868, 870, 872, 874, 876, 
	878, 880, 882, 885, 887, 889, 891, 893, 
	895, 897, 899, 901, 903, 905, 908, 910, 
	912, 914, 916, 918, 920, 922, 924, 926, 
	928, 930, 932, 934, 936, 938, 940, 942, 
	944, 946, 948, 950, 952, 954, 955, 956
};

static const char _lexer_trans_keys[] = {
	-40, -39, -17, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, -94, -89, -88, 
	-78, -77, -39, -122, -38, -81, -40, -89, 
	-39, -121, 32, 10, 13, 10, 13, -40, 
	-39, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -122, -121, -120, -39, -123, 
	-39, -120, -39, -122, -39, -121, 32, -39, 
	-121, -40, -89, 58, 10, 10, -39, 10, 
	32, 35, 124, 9, 13, -120, 10, -39, 
	10, -112, 10, -37, 10, -116, 10, -38, 
	10, -104, 10, -38, 10, -81, 10, -37, 
	10, -116, 10, 10, 58, -40, -39, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, 34, 34, 10, 13, 10, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 9, 13, 10, 
	32, 9, 13, 10, 13, 10, 95, 70, 
	69, 65, 84, 85, 82, 69, 95, 69, 
	78, 68, 95, 37, 13, 32, 64, 9, 
	10, 9, 10, 13, 32, 64, 11, 12, 
	10, 32, 64, 9, 13, 32, 124, 9, 
	13, 10, 32, 92, 124, 9, 13, 10, 
	92, 124, 10, 92, 10, 32, 92, 124, 
	9, 13, -40, -39, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, -39, -122, 
	-38, -81, -40, -89, -39, -123, -37, -116, 
	-39, 32, -112, -37, -116, -38, -104, -38, 
	-81, -37, -116, 58, 10, 10, -40, -39, 
	10, 32, 35, 37, 64, 9, 13, -89, 
	-78, -77, 10, -39, 10, -124, 10, -38, 
	10, -81, 10, -39, 10, -120, 10, -37, 
	10, -116, 10, 10, 32, -40, 10, -77, 
	10, -39, 10, -122, 10, -40, 10, -89, 
	10, -40, 10, -79, 10, -37, 10, -116, 
	10, -39, 10, -120, 10, 10, 58, -39, 
	10, -123, 10, -37, 10, -116, 10, -39, 
	10, -122, 10, -39, 10, -121, 10, -122, 
	-120, 10, -39, 10, -123, 10, -39, 10, 
	-120, 10, -39, 10, -122, 10, -39, 10, 
	-121, 10, 10, 32, -39, 10, -121, 10, 
	-40, 10, -89, 10, -39, 10, -112, 10, 
	-37, 10, -116, 10, -38, 10, -104, 10, 
	-38, 10, -81, 10, -37, 10, -116, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -39, -124, -123, -38, 
	-81, -39, -120, -37, -116, 32, -40, -77, 
	-39, -122, -40, -89, -40, -79, -37, -116, 
	-39, -120, 58, 10, 10, -40, -39, 10, 
	32, 35, 37, 42, 64, 9, 13, -94, 
	-89, -88, -77, 10, -39, 10, -122, 10, 
	-38, 10, -81, 10, -40, 10, -89, 10, 
	-39, 10, -121, 10, 10, 32, -39, 10, 
	-123, 10, -40, 10, -89, 10, -40, 10, 
	-89, 10, 10, 32, -39, 10, -127, 10, 
	-40, 10, -79, 10, -40, 10, -74, 10, 
	-39, 10, -122, 10, -40, 10, -89, 10, 
	-40, 10, -79, 10, -37, 10, -116, 10, 
	-39, 10, -120, 10, 10, 58, -121, -120, 
	10, -39, 10, -122, 10, -38, 10, -81, 
	10, -40, 10, -89, 10, -39, 10, -123, 
	10, -37, 10, -116, 10, -39, 10, 32, 
	-112, 10, -37, 10, -116, 10, -38, 10, 
	-104, 10, -38, 10, -81, 10, -37, 10, 
	-116, 10, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, -40, -89, 
	-40, -89, 32, -39, -127, -40, -79, -40, 
	-74, -39, -123, -37, -116, -39, -122, -39, 
	-121, 58, 10, 10, -40, -39, 10, 32, 
	35, 37, 42, 64, 9, 13, -94, -89, 
	-88, -77, 10, -39, 10, -122, 10, -38, 
	10, -81, 10, -40, 10, -89, 10, -39, 
	10, -121, 10, 10, 32, -39, 10, -124, 
	-123, 10, -38, 10, -81, 10, -39, 10, 
	-120, 10, -37, 10, -116, 10, 10, 32, 
	-40, 10, -77, 10, -39, 10, -122, 10, 
	-40, 10, -89, 10, -40, 10, -79, 10, 
	-37, 10, -116, 10, -39, 10, -120, 10, 
	10, 58, -40, 10, -89, 10, -40, 10, 
	-89, 10, 10, 32, -39, 10, -127, 10, 
	-40, 10, -79, 10, -40, 10, -74, 10, 
	-121, -120, 10, -39, 10, -122, 10, -38, 
	10, -81, 10, -40, 10, -89, 10, -39, 
	10, -123, 10, -37, 10, -116, 10, -39, 
	10, 32, -112, 10, -37, 10, -116, 10, 
	-38, 10, -104, 10, -38, 10, -81, 10, 
	-37, 10, -116, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-39, -122, -40, -89, -40, -79, -37, -116, 
	-39, -120, 58, 10, 10, -40, -39, 10, 
	32, 35, 37, 42, 64, 9, 13, -94, 
	-89, -88, -78, -77, 10, -39, 10, -122, 
	10, -38, 10, -81, 10, -40, 10, -89, 
	10, -39, 10, -121, 10, 10, 32, -39, 
	10, -124, -123, 10, -38, 10, -81, 10, 
	-39, 10, -120, 10, -37, 10, -116, 10, 
	10, 32, -40, 10, -77, 10, -39, 10, 
	-122, 10, -40, 10, -89, 10, -40, 10, 
	-79, 10, -37, 10, -116, 10, -39, 10, 
	-120, 10, 10, 58, -40, 10, -89, 10, 
	-40, 10, -89, 10, 10, 32, -39, 10, 
	-127, 10, -40, 10, -79, 10, -40, 10, 
	-74, 10, -39, 10, -123, 10, -37, 10, 
	-116, 10, -39, 10, -122, 10, -39, 10, 
	-121, 10, -121, -120, 10, -39, 10, -122, 
	10, -38, 10, -81, 10, -40, 10, -89, 
	10, -39, 10, -123, 10, -37, 10, -116, 
	10, -39, 10, 32, -112, 10, -37, 10, 
	-116, 10, -38, 10, -104, 10, -38, 10, 
	-81, 10, -37, 10, -116, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 11, 5, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 2, 10, 3, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	5, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 10, 1, 1, 
	2, 2, 3, 3, 3, 3, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 5, 3, 2, 4, 3, 2, 4, 
	10, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	7, 4, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 8, 5, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 8, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 8, 6, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 1, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 13, 19, 21, 23, 25, 27, 
	29, 31, 33, 35, 37, 40, 43, 55, 
	59, 61, 63, 65, 67, 69, 71, 73, 
	75, 77, 79, 81, 83, 85, 87, 89, 
	91, 98, 101, 104, 107, 110, 113, 116, 
	119, 122, 125, 128, 131, 134, 146, 148, 
	150, 153, 156, 161, 166, 171, 176, 180, 
	184, 187, 189, 191, 193, 195, 197, 199, 
	201, 203, 205, 207, 209, 211, 213, 215, 
	217, 222, 229, 234, 238, 244, 248, 251, 
	257, 269, 271, 273, 275, 277, 279, 281, 
	283, 285, 287, 289, 292, 294, 296, 298, 
	300, 302, 304, 306, 308, 310, 312, 314, 
	316, 325, 330, 333, 336, 339, 342, 345, 
	348, 351, 354, 357, 360, 363, 366, 369, 
	372, 375, 378, 381, 384, 387, 390, 393, 
	396, 399, 402, 405, 408, 411, 414, 417, 
	420, 424, 427, 430, 433, 436, 439, 442, 
	445, 448, 451, 454, 457, 460, 463, 466, 
	469, 472, 475, 478, 481, 484, 487, 490, 
	493, 496, 499, 502, 505, 508, 511, 514, 
	517, 520, 523, 526, 529, 532, 535, 537, 
	540, 542, 544, 546, 548, 550, 552, 554, 
	556, 558, 560, 562, 564, 566, 568, 570, 
	572, 574, 576, 578, 580, 582, 584, 594, 
	600, 603, 606, 609, 612, 615, 618, 621, 
	624, 627, 630, 633, 636, 639, 642, 645, 
	648, 651, 654, 657, 660, 663, 666, 669, 
	672, 675, 678, 681, 684, 687, 690, 693, 
	696, 699, 703, 706, 709, 712, 715, 718, 
	721, 724, 727, 730, 733, 737, 740, 743, 
	746, 749, 752, 755, 758, 761, 764, 767, 
	770, 773, 776, 779, 782, 785, 788, 791, 
	794, 797, 800, 803, 806, 808, 810, 812, 
	814, 816, 818, 820, 822, 824, 826, 828, 
	830, 832, 834, 836, 838, 840, 842, 844, 
	846, 848, 850, 860, 866, 869, 872, 875, 
	878, 881, 884, 887, 890, 893, 896, 900, 
	903, 906, 909, 912, 915, 918, 921, 924, 
	927, 930, 933, 936, 939, 942, 945, 948, 
	951, 954, 957, 960, 963, 966, 969, 972, 
	975, 978, 981, 984, 987, 990, 993, 997, 
	1000, 1003, 1006, 1009, 1012, 1015, 1018, 1021, 
	1024, 1027, 1031, 1034, 1037, 1040, 1043, 1046, 
	1049, 1052, 1055, 1058, 1061, 1064, 1067, 1070, 
	1073, 1076, 1079, 1082, 1085, 1088, 1091, 1094, 
	1097, 1100, 1102, 1104, 1106, 1108, 1110, 1112, 
	1114, 1116, 1118, 1120, 1122, 1124, 1126, 1136, 
	1143, 1146, 1149, 1152, 1155, 1158, 1161, 1164, 
	1167, 1170, 1173, 1177, 1180, 1183, 1186, 1189, 
	1192, 1195, 1198, 1201, 1204, 1207, 1210, 1213, 
	1216, 1219, 1222, 1225, 1228, 1231, 1234, 1237, 
	1240, 1243, 1246, 1249, 1252, 1255, 1258, 1261, 
	1264, 1267, 1270, 1273, 1276, 1279, 1282, 1285, 
	1288, 1291, 1294, 1298, 1301, 1304, 1307, 1310, 
	1313, 1316, 1319, 1322, 1325, 1328, 1332, 1335, 
	1338, 1341, 1344, 1347, 1350, 1353, 1356, 1359, 
	1362, 1365, 1368, 1371, 1374, 1377, 1380, 1383, 
	1386, 1389, 1392, 1395, 1398, 1401, 1403, 1405
};

static const short _lexer_trans_targs[] = {
	2, 15, 469, 14, 14, 46, 56, 58, 
	11, 72, 75, 14, 0, 3, 174, 270, 
	279, 369, 0, 4, 0, 5, 0, 6, 
	0, 7, 0, 8, 0, 9, 0, 10, 
	0, 11, 0, 12, 0, 14, 57, 13, 
	14, 57, 13, 2, 15, 14, 14, 46, 
	56, 58, 11, 72, 75, 14, 0, 16, 
	81, 91, 0, 17, 0, 18, 0, 19, 
	0, 20, 0, 21, 0, 22, 0, 23, 
	0, 24, 0, 25, 0, 26, 0, 27, 
	0, 28, 0, 29, 0, 30, 0, 32, 
	31, 32, 31, 33, 32, 32, 14, 14, 
	32, 31, 34, 32, 31, 35, 32, 31, 
	36, 32, 31, 37, 32, 31, 38, 32, 
	31, 39, 32, 31, 40, 32, 31, 41, 
	32, 31, 42, 32, 31, 43, 32, 31, 
	44, 32, 31, 32, 45, 31, 2, 15, 
	14, 14, 46, 56, 58, 11, 72, 75, 
	14, 0, 47, 0, 48, 0, 50, 49, 
	49, 50, 49, 49, 51, 51, 52, 51, 
	51, 51, 51, 52, 51, 51, 51, 51, 
	53, 51, 51, 51, 51, 54, 51, 51, 
	14, 55, 55, 0, 14, 55, 55, 0, 
	14, 57, 56, 14, 0, 59, 0, 60, 
	0, 61, 0, 62, 0, 63, 0, 64, 
	0, 65, 0, 66, 0, 67, 0, 68, 
	0, 69, 0, 70, 0, 71, 0, 471, 
	0, 0, 0, 0, 0, 73, 74, 14, 
	74, 74, 72, 73, 73, 14, 74, 72, 
	74, 0, 75, 76, 75, 0, 80, 79, 
	78, 76, 79, 77, 0, 78, 76, 77, 
	0, 78, 77, 80, 79, 78, 76, 79, 
	77, 2, 15, 80, 80, 46, 56, 58, 
	11, 72, 75, 80, 0, 82, 0, 83, 
	0, 84, 0, 85, 0, 86, 0, 87, 
	0, 88, 0, 89, 0, 90, 0, 11, 
	0, 92, 12, 0, 93, 0, 94, 0, 
	95, 0, 96, 0, 97, 0, 98, 0, 
	99, 0, 100, 0, 101, 0, 102, 0, 
	104, 103, 104, 103, 105, 136, 104, 104, 
	14, 160, 14, 104, 103, 106, 128, 117, 
	104, 103, 107, 104, 103, 108, 104, 103, 
	109, 104, 103, 110, 104, 103, 111, 104, 
	103, 112, 104, 103, 113, 104, 103, 114, 
	104, 103, 104, 115, 103, 116, 104, 103, 
	117, 104, 103, 118, 104, 103, 119, 104, 
	103, 120, 104, 103, 121, 104, 103, 122, 
	104, 103, 123, 104, 103, 124, 104, 103, 
	125, 104, 103, 126, 104, 103, 127, 104, 
	103, 104, 45, 103, 129, 104, 103, 130, 
	104, 103, 131, 104, 103, 132, 104, 103, 
	133, 104, 103, 134, 104, 103, 135, 104, 
	103, 127, 104, 103, 137, 150, 104, 103, 
	138, 104, 103, 139, 104, 103, 140, 104, 
	103, 141, 104, 103, 142, 104, 103, 143, 
	104, 103, 144, 104, 103, 145, 104, 103, 
	104, 146, 103, 147, 104, 103, 148, 104, 
	103, 149, 104, 103, 127, 104, 103, 151, 
	104, 103, 152, 104, 103, 153, 104, 103, 
	154, 104, 103, 155, 104, 103, 156, 104, 
	103, 157, 104, 103, 158, 104, 103, 159, 
	104, 103, 127, 104, 103, 104, 161, 103, 
	104, 162, 103, 104, 163, 103, 104, 164, 
	103, 104, 165, 103, 104, 166, 103, 104, 
	167, 103, 104, 168, 103, 104, 169, 103, 
	104, 170, 103, 104, 171, 103, 104, 172, 
	103, 104, 173, 103, 104, 14, 103, 175, 
	0, 176, 268, 0, 177, 0, 178, 0, 
	179, 0, 180, 0, 181, 0, 182, 0, 
	183, 0, 184, 0, 185, 0, 186, 0, 
	187, 0, 188, 0, 189, 0, 190, 0, 
	191, 0, 192, 0, 193, 0, 194, 0, 
	195, 0, 196, 0, 198, 197, 198, 197, 
	199, 233, 198, 198, 14, 254, 208, 14, 
	198, 197, 200, 209, 213, 222, 198, 197, 
	201, 198, 197, 202, 198, 197, 203, 198, 
	197, 204, 198, 197, 205, 198, 197, 206, 
	198, 197, 207, 198, 197, 208, 198, 197, 
	198, 45, 197, 210, 198, 197, 211, 198, 
	197, 212, 198, 197, 208, 198, 197, 214, 
	198, 197, 215, 198, 197, 198, 216, 197, 
	217, 198, 197, 218, 198, 197, 219, 198, 
	197, 220, 198, 197, 221, 198, 197, 208, 
	198, 197, 223, 198, 197, 224, 198, 197, 
	225, 198, 197, 226, 198, 197, 227, 198, 
	197, 228, 198, 197, 229, 198, 197, 230, 
	198, 197, 231, 198, 197, 232, 198, 197, 
	198, 45, 197, 234, 244, 198, 197, 235, 
	198, 197, 236, 198, 197, 237, 198, 197, 
	238, 198, 197, 239, 198, 197, 240, 198, 
	197, 241, 198, 197, 242, 198, 197, 243, 
	198, 197, 208, 198, 197, 245, 198, 45, 
	197, 246, 198, 197, 247, 198, 197, 248, 
	198, 197, 249, 198, 197, 250, 198, 197, 
	251, 198, 197, 252, 198, 197, 253, 198, 
	197, 232, 198, 197, 198, 255, 197, 198, 
	256, 197, 198, 257, 197, 198, 258, 197, 
	198, 259, 197, 198, 260, 197, 198, 261, 
	197, 198, 262, 197, 198, 263, 197, 198, 
	264, 197, 198, 265, 197, 198, 266, 197, 
	198, 267, 197, 198, 14, 197, 269, 0, 
	11, 0, 271, 0, 272, 0, 273, 0, 
	274, 0, 275, 0, 276, 0, 277, 0, 
	278, 0, 11, 0, 280, 0, 281, 0, 
	282, 0, 283, 0, 284, 0, 285, 0, 
	286, 0, 287, 0, 288, 0, 290, 289, 
	290, 289, 291, 334, 290, 290, 14, 355, 
	300, 14, 290, 289, 292, 301, 325, 312, 
	290, 289, 293, 290, 289, 294, 290, 289, 
	295, 290, 289, 296, 290, 289, 297, 290, 
	289, 298, 290, 289, 299, 290, 289, 300, 
	290, 289, 290, 45, 289, 302, 290, 289, 
	303, 323, 290, 289, 304, 290, 289, 305, 
	290, 289, 306, 290, 289, 307, 290, 289, 
	308, 290, 289, 309, 290, 289, 290, 310, 
	289, 311, 290, 289, 312, 290, 289, 313, 
	290, 289, 314, 290, 289, 315, 290, 289, 
	316, 290, 289, 317, 290, 289, 318, 290, 
	289, 319, 290, 289, 320, 290, 289, 321, 
	290, 289, 322, 290, 289, 290, 45, 289, 
	324, 290, 289, 300, 290, 289, 326, 290, 
	289, 327, 290, 289, 290, 328, 289, 329, 
	290, 289, 330, 290, 289, 331, 290, 289, 
	332, 290, 289, 333, 290, 289, 300, 290, 
	289, 335, 345, 290, 289, 336, 290, 289, 
	337, 290, 289, 338, 290, 289, 339, 290, 
	289, 340, 290, 289, 341, 290, 289, 342, 
	290, 289, 343, 290, 289, 344, 290, 289, 
	300, 290, 289, 346, 290, 45, 289, 347, 
	290, 289, 348, 290, 289, 349, 290, 289, 
	350, 290, 289, 351, 290, 289, 352, 290, 
	289, 353, 290, 289, 354, 290, 289, 322, 
	290, 289, 290, 356, 289, 290, 357, 289, 
	290, 358, 289, 290, 359, 289, 290, 360, 
	289, 290, 361, 289, 290, 362, 289, 290, 
	363, 289, 290, 364, 289, 290, 365, 289, 
	290, 366, 289, 290, 367, 289, 290, 368, 
	289, 290, 14, 289, 370, 0, 371, 0, 
	372, 0, 373, 0, 374, 0, 375, 0, 
	376, 0, 377, 0, 378, 0, 379, 0, 
	380, 0, 382, 381, 382, 381, 383, 434, 
	382, 382, 14, 455, 392, 14, 382, 381, 
	384, 393, 417, 426, 404, 382, 381, 385, 
	382, 381, 386, 382, 381, 387, 382, 381, 
	388, 382, 381, 389, 382, 381, 390, 382, 
	381, 391, 382, 381, 392, 382, 381, 382, 
	45, 381, 394, 382, 381, 395, 415, 382, 
	381, 396, 382, 381, 397, 382, 381, 398, 
	382, 381, 399, 382, 381, 400, 382, 381, 
	401, 382, 381, 382, 402, 381, 403, 382, 
	381, 404, 382, 381, 405, 382, 381, 406, 
	382, 381, 407, 382, 381, 408, 382, 381, 
	409, 382, 381, 410, 382, 381, 411, 382, 
	381, 412, 382, 381, 413, 382, 381, 414, 
	382, 381, 382, 45, 381, 416, 382, 381, 
	392, 382, 381, 418, 382, 381, 419, 382, 
	381, 382, 420, 381, 421, 382, 381, 422, 
	382, 381, 423, 382, 381, 424, 382, 381, 
	425, 382, 381, 392, 382, 381, 427, 382, 
	381, 428, 382, 381, 429, 382, 381, 430, 
	382, 381, 431, 382, 381, 432, 382, 381, 
	433, 382, 381, 414, 382, 381, 435, 445, 
	382, 381, 436, 382, 381, 437, 382, 381, 
	438, 382, 381, 439, 382, 381, 440, 382, 
	381, 441, 382, 381, 442, 382, 381, 443, 
	382, 381, 444, 382, 381, 392, 382, 381, 
	446, 382, 45, 381, 447, 382, 381, 448, 
	382, 381, 449, 382, 381, 450, 382, 381, 
	451, 382, 381, 452, 382, 381, 453, 382, 
	381, 454, 382, 381, 414, 382, 381, 382, 
	456, 381, 382, 457, 381, 382, 458, 381, 
	382, 459, 381, 382, 460, 381, 382, 461, 
	381, 382, 462, 381, 382, 463, 381, 382, 
	464, 381, 382, 465, 381, 382, 466, 381, 
	382, 467, 381, 382, 468, 381, 382, 14, 
	381, 470, 0, 14, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 29, 0, 54, 0, 5, 1, 0, 
	29, 1, 35, 0, 43, 0, 0, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 149, 126, 57, 
	110, 23, 0, 29, 29, 54, 0, 5, 
	1, 0, 29, 1, 35, 0, 43, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 81, 81, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 21, 0, 63, 63, 
	130, 31, 60, 57, 31, 63, 57, 66, 
	31, 43, 0, 43, 0, 43, 139, 48, 
	9, 106, 11, 0, 134, 45, 45, 45, 
	3, 122, 33, 33, 33, 0, 122, 33, 
	33, 33, 0, 122, 33, 0, 33, 0, 
	102, 7, 7, 43, 54, 0, 0, 43, 
	114, 25, 0, 54, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 43, 43, 43, 43, 0, 27, 118, 
	27, 27, 51, 27, 0, 54, 0, 1, 
	0, 43, 0, 0, 0, 43, 54, 37, 
	37, 87, 37, 37, 43, 0, 39, 0, 
	43, 0, 0, 54, 0, 0, 39, 0, 
	0, 96, 96, 54, 0, 93, 90, 41, 
	96, 90, 99, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 84, 54, 0, 
	69, 33, 69, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 13, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 13, 0, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	84, 84, 54, 0, 78, 33, 84, 78, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 19, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 19, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 19, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 19, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 84, 84, 54, 0, 72, 33, 
	84, 72, 0, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 15, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 15, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 15, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 15, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 84, 
	54, 0, 75, 33, 84, 75, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	17, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 17, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 17, 
	0, 0, 43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 471;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/fa.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1079 "ext/gherkin_lexer_fa/gherkin_lexer_fa.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/fa.c.rl"
    
#line 1086 "ext/gherkin_lexer_fa/gherkin_lexer_fa.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/fa.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/fa.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/fa.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/fa.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/fa.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/fa.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/fa.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/fa.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/fa.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/fa.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/fa.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/fa.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/fa.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/fa.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/fa.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/fa.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/fa.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/fa.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/fa.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/fa.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/fa.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/fa.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/fa.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/fa.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1376 "ext/gherkin_lexer_fa/gherkin_lexer_fa.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/fa.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1439 "ext/gherkin_lexer_fa/gherkin_lexer_fa.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/fa.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_fa()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Fa", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

