
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 22, 23, 25, 27, 38, 
	39, 40, 42, 44, 49, 54, 59, 64, 
	68, 72, 74, 75, 76, 77, 78, 79, 
	80, 81, 82, 83, 84, 85, 86, 87, 
	88, 89, 94, 101, 106, 110, 116, 119, 
	121, 127, 138, 140, 141, 142, 143, 144, 
	145, 146, 147, 148, 149, 150, 151, 152, 
	153, 154, 155, 156, 157, 158, 159, 160, 
	161, 162, 163, 164, 165, 166, 167, 168, 
	169, 170, 171, 172, 173, 175, 176, 177, 
	178, 179, 180, 181, 182, 183, 184, 185, 
	186, 187, 188, 189, 190, 191, 192, 193, 
	194, 195, 204, 215, 217, 228, 231, 233, 
	235, 237, 239, 241, 243, 245, 247, 249, 
	251, 253, 255, 257, 259, 261, 263, 265, 
	267, 269, 271, 273, 275, 277, 279, 281, 
	283, 285, 287, 289, 291, 293, 295, 297, 
	299, 301, 303, 305, 307, 309, 311, 313, 
	315, 317, 319, 321, 323, 325, 327, 329, 
	331, 333, 336, 338, 340, 342, 344, 347, 
	349, 351, 353, 355, 357, 359, 361, 363, 
	365, 367, 369, 371, 373, 375, 377, 379, 
	381, 383, 385, 387, 389, 391, 393, 395, 
	397, 399, 401, 403, 405, 407, 409, 411, 
	413, 415, 417, 419, 421, 423, 425, 427, 
	429, 431, 433, 435, 437, 440, 443, 445, 
	447, 449, 451, 453, 455, 457, 459, 461, 
	463, 465, 467, 469, 471, 473, 475, 477, 
	479, 481, 483, 485, 487, 489, 491, 493, 
	495, 497, 499, 501, 503, 505, 507, 509, 
	511, 513, 515, 517, 518, 519, 520, 521, 
	523, 524, 525, 526, 527, 528, 529, 530, 
	531, 532, 533, 534, 541, 543, 545, 547, 
	549, 551, 553, 555, 557, 559, 561, 563, 
	565, 567, 569, 571, 573, 575, 577, 579, 
	581, 582, 583, 584, 585, 586, 587, 588, 
	589, 590, 591, 592, 593, 595, 596, 597, 
	598, 599, 601, 602, 603, 604, 605, 606, 
	607, 608, 609, 610, 611, 612, 613, 614, 
	615, 616, 617, 618, 619, 620, 621, 622, 
	623, 624, 625, 626, 627, 628, 629, 630, 
	631, 632, 633, 634, 635, 644, 655, 657, 
	660, 662, 664, 666, 668, 670, 672, 674, 
	676, 678, 680, 682, 684, 686, 688, 690, 
	692, 694, 696, 698, 700, 702, 704, 706, 
	708, 710, 712, 714, 716, 718, 720, 722, 
	724, 726, 728, 730, 732, 734, 736, 738, 
	740, 742, 744, 746, 748, 750, 752, 754, 
	756, 758, 760, 762, 765, 767, 769, 771, 
	773, 775, 777, 779, 781, 783, 785, 787, 
	789, 791, 793, 795, 797, 799, 801, 803, 
	806, 809, 811, 813, 815, 817, 819, 821, 
	823, 825, 827, 829, 831, 833, 835, 837, 
	839, 841, 843, 845, 847, 849, 851, 853, 
	855, 857, 859, 861, 863, 865, 867, 869, 
	871, 873, 875, 877, 879, 881, 883, 884, 
	885, 886, 887, 888, 889, 890, 891, 892, 
	893, 894, 895, 896, 897, 898, 907, 918, 
	920, 923, 925, 927, 929, 931, 933, 935, 
	937, 939, 941, 943, 945, 947, 949, 951, 
	953, 955, 957, 959, 961, 963, 965, 967, 
	969, 971, 973, 975, 977, 979, 981, 983, 
	985, 987, 989, 992, 994, 996, 998, 1000, 
	1002, 1004, 1006, 1008, 1010, 1012, 1014, 1016, 
	1018, 1020, 1022, 1024, 1026, 1028, 1030, 1032, 
	1034, 1036, 1038, 1040, 1042, 1044, 1046, 1048, 
	1050, 1052, 1054, 1056, 1058, 1060, 1062, 1065, 
	1067, 1069, 1071, 1073, 1076, 1078, 1080, 1082, 
	1084, 1086, 1088, 1090, 1092, 1094, 1096, 1098, 
	1100, 1102, 1104, 1106, 1108, 1110, 1112, 1114, 
	1116, 1118, 1120, 1122, 1124, 1126, 1128, 1130, 
	1132, 1134, 1136, 1138, 1140, 1142, 1144, 1146, 
	1148, 1150, 1152, 1154, 1156, 1158, 1160, 1162, 
	1164, 1167, 1170, 1172, 1174, 1176, 1178, 1180, 
	1182, 1184, 1186, 1188, 1190, 1192, 1194, 1196, 
	1198, 1200, 1202, 1204, 1206, 1208, 1210, 1212, 
	1214, 1216, 1218, 1220, 1222, 1224, 1226, 1228, 
	1230, 1232, 1234, 1236, 1238, 1240, 1242, 1244, 
	1245, 1247, 1249, 1250, 1251, 1252, 1253, 1254, 
	1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 
	1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 
	1271, 1272, 1273, 1281, 1285, 1288, 1290, 1292, 
	1294, 1296, 1298, 1300, 1302, 1304, 1306, 1308, 
	1310, 1312, 1314, 1316, 1318, 1320, 1322, 1324, 
	1326, 1328, 1330, 1332, 1334, 1336, 1338, 1340, 
	1342, 1344, 1346, 1348, 1350, 1352, 1355, 1357, 
	1359, 1361, 1363, 1365, 1367, 1369, 1371, 1373, 
	1375, 1377, 1379, 1381, 1383, 1385, 1387, 1389, 
	1391, 1393, 1395, 1397, 1399, 1401, 1403, 1405, 
	1407, 1409, 1411, 1413, 1415, 1417, 1419, 1421, 
	1423, 1425, 1427, 1429, 1431, 1433, 1435, 1437, 
	1439, 1441, 1443, 1445, 1447, 1449, 1451, 1453, 
	1455, 1457, 1459, 1461, 1463, 1465, 1467, 1469, 
	1471, 1473, 1475, 1477, 1479, 1481, 1483, 1485, 
	1487, 1489, 1491, 1493, 1495, 1497, 1499, 1501, 
	1503, 1505, 1506, 1507, 1508, 1509
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -122, -112, -108, -102, 
	-99, -97, -95, -94, -92, -81, 32, 10, 
	13, 10, 13, -48, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, 34, 34, 
	10, 13, 10, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 9, 13, 10, 32, 9, 13, 
	10, 13, 10, 95, 70, 69, 65, 84, 
	85, 82, 69, 95, 69, 78, 68, 95, 
	37, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 32, 124, 9, 13, 10, 32, 
	92, 124, 9, 13, 10, 92, 124, 10, 
	92, 10, 32, 92, 124, 9, 13, -48, 
	10, 32, 34, 35, 37, 42, 64, 124, 
	9, 13, -48, 32, -69, -48, -75, -47, 
	-126, -48, -80, -48, -70, -48, -66, -48, 
	-74, -48, -80, -48, -67, -48, -66, -48, 
	-66, -48, -69, -48, -72, -48, -75, -47, 
	-123, -48, -80, -48, -71, -48, -47, -75, 
	-47, -128, -48, -75, -48, -76, -47, -125, 
	-48, -68, -48, -66, -48, -78, -48, -80, 
	58, 10, 10, -48, 10, 32, 35, 37, 
	42, 64, 9, 13, -122, -112, -108, -102, 
	-99, -97, -95, -94, -92, -81, 10, 10, 
	32, -48, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -48, 10, 32, -69, 
	10, -48, 10, -75, 10, -47, 10, -126, 
	10, -48, 10, -80, 10, -48, 10, -70, 
	10, -48, 10, -66, 10, -48, 10, -74, 
	10, -48, 10, -80, 10, -48, 10, -67, 
	10, -48, 10, -66, 10, -48, 10, -66, 
	10, -48, 10, -69, 10, -48, 10, -72, 
	10, -48, 10, -75, 10, -47, 10, -123, 
	10, -48, 10, -80, 10, -48, 10, -71, 
	10, -47, 10, -128, 10, -48, 10, -72, 
	10, -48, 10, -65, 10, -47, 10, -125, 
	10, -47, 10, -127, 10, -47, 10, -126, 
	10, -48, 10, -72, 10, -48, 10, -68, 
	10, -48, 10, -66, 10, 10, 32, 44, 
	10, 32, -47, 10, -119, 10, -47, 10, 
	-126, -122, 10, -47, 10, -128, 10, -47, 
	10, -125, 10, -48, 10, -70, 10, -47, 
	10, -126, 10, -47, 10, -125, 10, -47, 
	10, -128, 10, -48, 10, -80, 10, 10, 
	32, -47, 10, -127, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -47, 10, -106, 10, -47, 10, -114, 
	10, 10, 58, -48, 10, -75, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -47, 
	10, -128, 10, -47, 10, -106, 10, -48, 
	10, -71, 10, -48, 10, -80, -66, 10, 
	-48, 10, 32, -76, 10, -47, 10, -106, 
	10, -47, 10, -125, 10, -48, 10, -67, 
	10, -48, 10, -70, 10, -47, 10, -122, 
	10, -47, 10, -106, 10, -48, 10, -66, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -48, 10, -69, 10, -48, 10, -70, 
	10, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, -128, -48, -72, 
	-48, -70, -65, -48, -69, -48, -80, -48, 
	-76, -48, -72, 58, 10, 10, -48, 10, 
	32, 35, 124, 9, 13, -92, 10, -47, 
	10, -125, 10, -48, 10, -67, 10, -48, 
	10, -70, 10, -47, 10, -122, 10, -47, 
	10, -106, 10, -48, 10, -66, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -48, 
	10, -69, 10, 10, 58, -47, -125, -47, 
	-127, -47, -126, -48, -72, -48, -68, -48, 
	-66, 32, 44, 32, -47, -119, -47, -126, 
	-122, -47, -128, -47, -125, -48, -70, -47, 
	-126, -47, -125, -47, -128, -48, -80, 32, 
	-47, -127, -47, -122, -48, -75, -48, -67, 
	-48, -80, -47, -128, -47, -106, -47, -114, 
	58, 10, 10, -48, 10, 32, 35, 37, 
	42, 64, 9, 13, -122, -112, -108, -102, 
	-99, -97, -95, -94, -92, -81, 10, 10, 
	32, -48, 10, 32, -69, 10, -48, 10, 
	-75, 10, -47, 10, -126, 10, -48, 10, 
	-80, 10, -48, 10, -70, 10, -48, 10, 
	-66, 10, -48, 10, -74, 10, -48, 10, 
	-80, 10, -48, 10, -67, 10, -48, 10, 
	-66, 10, -48, 10, -66, 10, -48, 10, 
	-69, 10, -48, 10, -72, 10, -48, 10, 
	-75, 10, -47, 10, -123, 10, -48, 10, 
	-80, 10, -48, 10, -71, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-65, 10, -47, 10, -125, 10, -47, 10, 
	-127, 10, -47, 10, -126, 10, -48, 10, 
	-72, 10, -48, 10, -68, 10, -48, 10, 
	-66, 10, 10, 32, 44, 10, 32, -47, 
	10, -119, 10, -47, 10, -122, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -47, 
	10, -106, 10, -48, 10, -71, 10, 10, 
	58, -48, 10, -80, -66, 10, -48, 10, 
	32, -76, 10, -47, 10, -106, 10, -47, 
	10, -125, 10, -48, 10, -67, 10, -48, 
	10, -70, 10, -47, 10, -122, 10, -47, 
	10, -106, 10, -48, 10, -66, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -48, 
	10, -69, 10, -48, 10, -70, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -48, -75, -48, -67, -48, 
	-80, -47, -128, -47, -106, -48, -71, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -122, -112, -108, -102, -99, 
	-97, -95, -94, -92, -81, 10, 10, 32, 
	-48, 10, 32, -69, 10, -48, 10, -75, 
	10, -47, 10, -126, 10, -48, 10, -80, 
	10, -48, 10, -70, 10, -48, 10, -66, 
	10, -48, 10, -74, 10, -48, 10, -80, 
	10, -48, 10, -67, 10, -48, 10, -66, 
	10, -48, 10, -66, 10, -48, 10, -69, 
	10, -48, 10, -72, 10, -48, 10, -75, 
	10, -47, 10, -123, 10, -48, 10, -80, 
	10, -48, 10, -71, 10, -48, -47, 10, 
	-75, 10, -47, 10, -128, 10, -48, 10, 
	-75, 10, -48, 10, -76, 10, -47, 10, 
	-125, 10, -48, 10, -68, 10, -48, 10, 
	-66, 10, -48, 10, -78, 10, -48, 10, 
	-80, 10, 10, 58, -128, 10, -48, 10, 
	-72, 10, -48, 10, -65, 10, -47, 10, 
	-125, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, -48, 10, -72, 10, -48, 10, 
	-68, 10, -48, 10, -66, 10, 10, 32, 
	44, 10, 32, -47, 10, -119, 10, -47, 
	10, -126, -122, 10, -47, 10, -128, 10, 
	-47, 10, -125, 10, -48, 10, -70, 10, 
	-47, 10, -126, 10, -47, 10, -125, 10, 
	-47, 10, -128, 10, -48, 10, -80, 10, 
	10, 32, -47, 10, -127, 10, -47, 10, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -47, 10, -106, 10, -47, 10, 
	-114, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -47, 10, -106, 10, -48, 10, 
	-71, 10, -48, 10, -80, -66, 10, -48, 
	10, 32, -76, 10, -47, 10, -106, 10, 
	-47, 10, -125, 10, -48, 10, -67, 10, 
	-48, 10, -70, 10, -47, 10, -122, 10, 
	-47, 10, -106, 10, -48, 10, -66, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-48, 10, -69, 10, -48, 10, -70, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -48, -80, -66, -48, 
	32, -76, -47, -106, -47, -125, -48, -67, 
	-48, -70, -47, -122, -47, -106, -48, -66, 
	-48, -67, -48, -80, -48, -69, 58, 10, 
	10, -48, 10, 32, 35, 37, 64, 9, 
	13, -97, -95, -92, 10, -48, -47, 10, 
	-75, 10, -47, 10, -128, 10, -48, 10, 
	-75, 10, -48, 10, -76, 10, -47, 10, 
	-125, 10, -48, 10, -68, 10, -48, 10, 
	-66, 10, -48, 10, -78, 10, -48, 10, 
	-80, 10, 10, 58, -128, 10, -48, 10, 
	-72, 10, -48, 10, -70, 10, -48, 10, 
	-69, 10, -48, 10, -80, 10, -48, 10, 
	-76, 10, -48, 10, -72, 10, -47, 10, 
	-126, -122, 10, -47, 10, -128, 10, -47, 
	10, -125, 10, -48, 10, -70, 10, -47, 
	10, -126, 10, -47, 10, -125, 10, -47, 
	10, -128, 10, -48, 10, -80, 10, 10, 
	32, -47, 10, -127, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -47, 10, -106, 10, -47, 10, -114, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -47, 10, -106, 10, -48, 10, -71, 
	10, -47, 10, -125, 10, -48, 10, -67, 
	10, -48, 10, -70, 10, -47, 10, -122, 
	10, -47, 10, -106, 10, -48, 10, -66, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -48, 10, -69, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, -48, -70, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 10, 1, 2, 2, 9, 1, 
	1, 2, 2, 3, 3, 3, 3, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 3, 5, 3, 2, 4, 3, 2, 
	4, 9, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 7, 11, 2, 9, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 7, 11, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 7, 11, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 6, 4, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 1, 1, 1, 1, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 0, 0, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 23, 25, 28, 31, 42, 
	44, 46, 49, 52, 57, 62, 67, 72, 
	76, 80, 83, 85, 87, 89, 91, 93, 
	95, 97, 99, 101, 103, 105, 107, 109, 
	111, 113, 118, 125, 130, 134, 140, 144, 
	147, 153, 164, 167, 169, 171, 173, 175, 
	177, 179, 181, 183, 185, 187, 189, 191, 
	193, 195, 197, 199, 201, 203, 205, 207, 
	209, 211, 213, 215, 217, 219, 221, 223, 
	225, 227, 229, 231, 233, 236, 238, 240, 
	242, 244, 246, 248, 250, 252, 254, 256, 
	258, 260, 262, 264, 266, 268, 270, 272, 
	274, 276, 285, 297, 300, 311, 315, 318, 
	321, 324, 327, 330, 333, 336, 339, 342, 
	345, 348, 351, 354, 357, 360, 363, 366, 
	369, 372, 375, 378, 381, 384, 387, 390, 
	393, 396, 399, 402, 405, 408, 411, 414, 
	417, 420, 423, 426, 429, 432, 435, 438, 
	441, 444, 447, 450, 453, 456, 459, 462, 
	465, 468, 472, 475, 478, 481, 484, 488, 
	491, 494, 497, 500, 503, 506, 509, 512, 
	515, 518, 521, 524, 527, 530, 533, 536, 
	539, 542, 545, 548, 551, 554, 557, 560, 
	563, 566, 569, 572, 575, 578, 581, 584, 
	587, 590, 593, 596, 599, 602, 605, 608, 
	611, 614, 617, 620, 623, 627, 631, 634, 
	637, 640, 643, 646, 649, 652, 655, 658, 
	661, 664, 667, 670, 673, 676, 679, 682, 
	685, 688, 691, 694, 697, 700, 703, 706, 
	709, 712, 715, 718, 721, 724, 727, 730, 
	733, 736, 739, 742, 744, 746, 748, 750, 
	753, 755, 757, 759, 761, 763, 765, 767, 
	769, 771, 773, 775, 782, 785, 788, 791, 
	794, 797, 800, 803, 806, 809, 812, 815, 
	818, 821, 824, 827, 830, 833, 836, 839, 
	842, 844, 846, 848, 850, 852, 854, 856, 
	858, 860, 862, 864, 866, 869, 871, 873, 
	875, 877, 880, 882, 884, 886, 888, 890, 
	892, 894, 896, 898, 900, 902, 904, 906, 
	908, 910, 912, 914, 916, 918, 920, 922, 
	924, 926, 928, 930, 932, 934, 936, 938, 
	940, 942, 944, 946, 948, 957, 969, 972, 
	976, 979, 982, 985, 988, 991, 994, 997, 
	1000, 1003, 1006, 1009, 1012, 1015, 1018, 1021, 
	1024, 1027, 1030, 1033, 1036, 1039, 1042, 1045, 
	1048, 1051, 1054, 1057, 1060, 1063, 1066, 1069, 
	1072, 1075, 1078, 1081, 1084, 1087, 1090, 1093, 
	1096, 1099, 1102, 1105, 1108, 1111, 1114, 1117, 
	1120, 1123, 1126, 1129, 1133, 1136, 1139, 1142, 
	1145, 1148, 1151, 1154, 1157, 1160, 1163, 1166, 
	1169, 1172, 1175, 1178, 1181, 1184, 1187, 1190, 
	1194, 1198, 1201, 1204, 1207, 1210, 1213, 1216, 
	1219, 1222, 1225, 1228, 1231, 1234, 1237, 1240, 
	1243, 1246, 1249, 1252, 1255, 1258, 1261, 1264, 
	1267, 1270, 1273, 1276, 1279, 1282, 1285, 1288, 
	1291, 1294, 1297, 1300, 1303, 1306, 1309, 1311, 
	1313, 1315, 1317, 1319, 1321, 1323, 1325, 1327, 
	1329, 1331, 1333, 1335, 1337, 1339, 1348, 1360, 
	1363, 1367, 1370, 1373, 1376, 1379, 1382, 1385, 
	1388, 1391, 1394, 1397, 1400, 1403, 1406, 1409, 
	1412, 1415, 1418, 1421, 1424, 1427, 1430, 1433, 
	1436, 1439, 1442, 1445, 1448, 1451, 1454, 1457, 
	1460, 1463, 1466, 1470, 1473, 1476, 1479, 1482, 
	1485, 1488, 1491, 1494, 1497, 1500, 1503, 1506, 
	1509, 1512, 1515, 1518, 1521, 1524, 1527, 1530, 
	1533, 1536, 1539, 1542, 1545, 1548, 1551, 1554, 
	1557, 1560, 1563, 1566, 1569, 1572, 1575, 1579, 
	1582, 1585, 1588, 1591, 1595, 1598, 1601, 1604, 
	1607, 1610, 1613, 1616, 1619, 1622, 1625, 1628, 
	1631, 1634, 1637, 1640, 1643, 1646, 1649, 1652, 
	1655, 1658, 1661, 1664, 1667, 1670, 1673, 1676, 
	1679, 1682, 1685, 1688, 1691, 1694, 1697, 1700, 
	1703, 1706, 1709, 1712, 1715, 1718, 1721, 1724, 
	1727, 1731, 1735, 1738, 1741, 1744, 1747, 1750, 
	1753, 1756, 1759, 1762, 1765, 1768, 1771, 1774, 
	1777, 1780, 1783, 1786, 1789, 1792, 1795, 1798, 
	1801, 1804, 1807, 1810, 1813, 1816, 1819, 1822, 
	1825, 1828, 1831, 1834, 1837, 1840, 1843, 1846, 
	1848, 1851, 1854, 1856, 1858, 1860, 1862, 1864, 
	1866, 1868, 1870, 1872, 1874, 1876, 1878, 1880, 
	1882, 1884, 1886, 1888, 1890, 1892, 1894, 1896, 
	1898, 1900, 1902, 1910, 1915, 1919, 1922, 1925, 
	1928, 1931, 1934, 1937, 1940, 1943, 1946, 1949, 
	1952, 1955, 1958, 1961, 1964, 1967, 1970, 1973, 
	1976, 1979, 1982, 1985, 1988, 1991, 1994, 1997, 
	2000, 2003, 2006, 2009, 2012, 2015, 2019, 2022, 
	2025, 2028, 2031, 2034, 2037, 2040, 2043, 2046, 
	2049, 2052, 2055, 2058, 2061, 2064, 2067, 2070, 
	2073, 2076, 2079, 2082, 2085, 2088, 2091, 2094, 
	2097, 2100, 2103, 2106, 2109, 2112, 2115, 2118, 
	2121, 2124, 2127, 2130, 2133, 2136, 2139, 2142, 
	2145, 2148, 2151, 2154, 2157, 2160, 2163, 2166, 
	2169, 2172, 2175, 2178, 2181, 2184, 2187, 2190, 
	2193, 2196, 2199, 2202, 2205, 2208, 2211, 2214, 
	2217, 2220, 2223, 2226, 2229, 2232, 2235, 2238, 
	2241, 2244, 2246, 2248, 2250, 2252
};

static const short _lexer_trans_targs[] = {
	2, 763, 6, 6, 7, 17, 19, 3, 
	33, 36, 6, 0, 3, 42, 56, 62, 
	68, 76, 296, 623, 629, 761, 0, 4, 
	0, 6, 18, 5, 6, 18, 5, 2, 
	6, 6, 7, 17, 19, 3, 33, 36, 
	6, 0, 8, 0, 9, 0, 11, 10, 
	10, 11, 10, 10, 12, 12, 13, 12, 
	12, 12, 12, 13, 12, 12, 12, 12, 
	14, 12, 12, 12, 12, 15, 12, 12, 
	6, 16, 16, 0, 6, 16, 16, 0, 
	6, 18, 17, 6, 0, 20, 0, 21, 
	0, 22, 0, 23, 0, 24, 0, 25, 
	0, 26, 0, 27, 0, 28, 0, 29, 
	0, 30, 0, 31, 0, 32, 0, 765, 
	0, 0, 0, 0, 0, 34, 35, 6, 
	35, 35, 33, 34, 34, 6, 35, 33, 
	35, 0, 36, 37, 36, 0, 41, 40, 
	39, 37, 40, 38, 0, 39, 37, 38, 
	0, 39, 38, 41, 40, 39, 37, 40, 
	38, 2, 41, 41, 7, 17, 19, 3, 
	33, 36, 41, 0, 43, 46, 0, 44, 
	0, 45, 0, 3, 0, 47, 0, 48, 
	0, 49, 0, 50, 0, 51, 0, 52, 
	0, 53, 0, 54, 0, 55, 0, 3, 
	0, 57, 0, 58, 0, 59, 0, 60, 
	0, 61, 0, 3, 0, 63, 0, 64, 
	0, 65, 0, 66, 0, 67, 0, 3, 
	0, 69, 0, 70, 0, 71, 0, 72, 
	0, 73, 0, 74, 0, 75, 0, 3, 
	0, 77, 243, 0, 78, 0, 79, 0, 
	80, 0, 81, 0, 82, 0, 83, 0, 
	84, 0, 85, 0, 86, 0, 87, 0, 
	88, 0, 89, 0, 90, 0, 91, 0, 
	92, 0, 93, 0, 94, 0, 95, 0, 
	97, 96, 97, 96, 98, 97, 97, 6, 
	229, 99, 6, 97, 96, 99, 101, 115, 
	121, 127, 135, 157, 203, 209, 227, 97, 
	96, 97, 100, 96, 2, 6, 6, 7, 
	17, 19, 3, 33, 36, 6, 0, 102, 
	97, 105, 96, 103, 97, 96, 104, 97, 
	96, 99, 97, 96, 106, 97, 96, 107, 
	97, 96, 108, 97, 96, 109, 97, 96, 
	110, 97, 96, 111, 97, 96, 112, 97, 
	96, 113, 97, 96, 114, 97, 96, 99, 
	97, 96, 116, 97, 96, 117, 97, 96, 
	118, 97, 96, 119, 97, 96, 120, 97, 
	96, 99, 97, 96, 122, 97, 96, 123, 
	97, 96, 124, 97, 96, 125, 97, 96, 
	126, 97, 96, 99, 97, 96, 128, 97, 
	96, 129, 97, 96, 130, 97, 96, 131, 
	97, 96, 132, 97, 96, 133, 97, 96, 
	134, 97, 96, 99, 97, 96, 136, 97, 
	96, 137, 97, 96, 138, 97, 96, 139, 
	97, 96, 140, 97, 96, 141, 97, 96, 
	142, 97, 96, 143, 97, 96, 144, 97, 
	96, 145, 97, 96, 146, 97, 96, 147, 
	97, 96, 148, 97, 96, 149, 97, 96, 
	150, 97, 96, 151, 97, 96, 152, 97, 
	96, 153, 97, 96, 97, 100, 154, 96, 
	97, 155, 96, 156, 97, 96, 119, 97, 
	96, 158, 97, 96, 159, 191, 97, 96, 
	160, 97, 96, 161, 97, 96, 162, 97, 
	96, 163, 97, 96, 164, 97, 96, 165, 
	97, 96, 166, 97, 96, 167, 97, 96, 
	168, 97, 96, 169, 97, 96, 170, 97, 
	96, 171, 97, 96, 172, 97, 96, 173, 
	97, 96, 97, 174, 96, 175, 97, 96, 
	176, 97, 96, 177, 97, 96, 178, 97, 
	96, 179, 97, 96, 180, 97, 96, 181, 
	97, 96, 182, 97, 96, 183, 97, 96, 
	184, 97, 96, 185, 97, 96, 186, 97, 
	96, 187, 97, 96, 188, 97, 96, 189, 
	97, 96, 190, 97, 96, 97, 100, 96, 
	192, 97, 96, 193, 97, 96, 194, 97, 
	96, 195, 97, 96, 196, 97, 96, 197, 
	97, 96, 198, 97, 96, 199, 97, 96, 
	200, 97, 96, 201, 97, 96, 202, 97, 
	96, 190, 97, 96, 204, 97, 96, 99, 
	205, 97, 96, 206, 97, 100, 96, 207, 
	97, 96, 208, 97, 96, 99, 97, 96, 
	210, 97, 96, 211, 97, 96, 212, 97, 
	96, 213, 97, 96, 214, 97, 96, 215, 
	97, 96, 216, 97, 96, 217, 97, 96, 
	218, 97, 96, 219, 97, 96, 220, 97, 
	96, 221, 97, 96, 222, 97, 96, 223, 
	97, 96, 224, 97, 96, 225, 97, 96, 
	226, 97, 96, 190, 97, 96, 228, 97, 
	96, 155, 97, 96, 97, 230, 96, 97, 
	231, 96, 97, 232, 96, 97, 233, 96, 
	97, 234, 96, 97, 235, 96, 97, 236, 
	96, 97, 237, 96, 97, 238, 96, 97, 
	239, 96, 97, 240, 96, 97, 241, 96, 
	97, 242, 96, 97, 6, 96, 244, 0, 
	245, 0, 246, 0, 247, 0, 248, 280, 
	0, 249, 0, 250, 0, 251, 0, 252, 
	0, 253, 0, 254, 0, 255, 0, 256, 
	0, 257, 0, 259, 258, 259, 258, 260, 
	259, 259, 6, 6, 259, 258, 261, 259, 
	258, 262, 259, 258, 263, 259, 258, 264, 
	259, 258, 265, 259, 258, 266, 259, 258, 
	267, 259, 258, 268, 259, 258, 269, 259, 
	258, 270, 259, 258, 271, 259, 258, 272, 
	259, 258, 273, 259, 258, 274, 259, 258, 
	275, 259, 258, 276, 259, 258, 277, 259, 
	258, 278, 259, 258, 279, 259, 258, 259, 
	100, 258, 281, 0, 282, 0, 283, 0, 
	284, 0, 285, 0, 286, 0, 287, 0, 
	288, 0, 289, 0, 290, 0, 291, 0, 
	292, 0, 4, 293, 0, 294, 0, 295, 
	0, 60, 0, 297, 0, 298, 446, 0, 
	299, 0, 300, 0, 301, 0, 302, 0, 
	303, 0, 304, 0, 305, 0, 306, 0, 
	307, 0, 308, 0, 309, 0, 310, 0, 
	311, 0, 312, 0, 313, 0, 314, 0, 
	315, 0, 316, 0, 317, 0, 318, 0, 
	319, 0, 320, 0, 321, 0, 322, 0, 
	323, 0, 324, 0, 325, 0, 326, 0, 
	327, 0, 328, 0, 329, 0, 330, 0, 
	332, 331, 332, 331, 333, 332, 332, 6, 
	432, 334, 6, 332, 331, 334, 335, 349, 
	355, 361, 369, 391, 406, 412, 430, 332, 
	331, 332, 100, 331, 336, 332, 339, 331, 
	337, 332, 331, 338, 332, 331, 334, 332, 
	331, 340, 332, 331, 341, 332, 331, 342, 
	332, 331, 343, 332, 331, 344, 332, 331, 
	345, 332, 331, 346, 332, 331, 347, 332, 
	331, 348, 332, 331, 334, 332, 331, 350, 
	332, 331, 351, 332, 331, 352, 332, 331, 
	353, 332, 331, 354, 332, 331, 334, 332, 
	331, 356, 332, 331, 357, 332, 331, 358, 
	332, 331, 359, 332, 331, 360, 332, 331, 
	334, 332, 331, 362, 332, 331, 363, 332, 
	331, 364, 332, 331, 365, 332, 331, 366, 
	332, 331, 367, 332, 331, 368, 332, 331, 
	334, 332, 331, 370, 332, 331, 371, 332, 
	331, 372, 332, 331, 373, 332, 331, 374, 
	332, 331, 375, 332, 331, 376, 332, 331, 
	377, 332, 331, 378, 332, 331, 379, 332, 
	331, 380, 332, 331, 381, 332, 331, 382, 
	332, 331, 383, 332, 331, 384, 332, 331, 
	385, 332, 331, 386, 332, 331, 387, 332, 
	331, 332, 100, 388, 331, 332, 389, 331, 
	390, 332, 331, 353, 332, 331, 392, 332, 
	331, 393, 332, 331, 394, 332, 331, 395, 
	332, 331, 396, 332, 331, 397, 332, 331, 
	398, 332, 331, 399, 332, 331, 400, 332, 
	331, 401, 332, 331, 402, 332, 331, 403, 
	332, 331, 404, 332, 331, 405, 332, 331, 
	332, 100, 331, 407, 332, 331, 334, 408, 
	332, 331, 409, 332, 100, 331, 410, 332, 
	331, 411, 332, 331, 334, 332, 331, 413, 
	332, 331, 414, 332, 331, 415, 332, 331, 
	416, 332, 331, 417, 332, 331, 418, 332, 
	331, 419, 332, 331, 420, 332, 331, 421, 
	332, 331, 422, 332, 331, 423, 332, 331, 
	424, 332, 331, 425, 332, 331, 426, 332, 
	331, 427, 332, 331, 428, 332, 331, 429, 
	332, 331, 405, 332, 331, 431, 332, 331, 
	389, 332, 331, 332, 433, 331, 332, 434, 
	331, 332, 435, 331, 332, 436, 331, 332, 
	437, 331, 332, 438, 331, 332, 439, 331, 
	332, 440, 331, 332, 441, 331, 332, 442, 
	331, 332, 443, 331, 332, 444, 331, 332, 
	445, 331, 332, 6, 331, 447, 0, 448, 
	0, 449, 0, 450, 0, 451, 0, 452, 
	0, 453, 0, 454, 0, 455, 0, 456, 
	0, 457, 0, 458, 0, 459, 0, 461, 
	460, 461, 460, 462, 461, 461, 6, 609, 
	463, 6, 461, 460, 463, 464, 478, 484, 
	490, 498, 538, 583, 589, 607, 461, 460, 
	461, 100, 460, 465, 461, 468, 460, 466, 
	461, 460, 467, 461, 460, 463, 461, 460, 
	469, 461, 460, 470, 461, 460, 471, 461, 
	460, 472, 461, 460, 473, 461, 460, 474, 
	461, 460, 475, 461, 460, 476, 461, 460, 
	477, 461, 460, 463, 461, 460, 479, 461, 
	460, 480, 461, 460, 481, 461, 460, 482, 
	461, 460, 483, 461, 460, 463, 461, 460, 
	485, 461, 460, 486, 461, 460, 487, 461, 
	460, 488, 461, 460, 489, 461, 460, 463, 
	461, 460, 491, 461, 460, 492, 461, 460, 
	493, 461, 460, 494, 461, 460, 495, 461, 
	460, 496, 461, 460, 497, 461, 460, 463, 
	461, 460, 499, 517, 461, 460, 500, 461, 
	460, 501, 461, 460, 502, 461, 460, 503, 
	461, 460, 504, 461, 460, 505, 461, 460, 
	506, 461, 460, 507, 461, 460, 508, 461, 
	460, 509, 461, 460, 510, 461, 460, 511, 
	461, 460, 512, 461, 460, 513, 461, 460, 
	514, 461, 460, 515, 461, 460, 516, 461, 
	460, 461, 100, 460, 518, 461, 460, 519, 
	461, 460, 520, 461, 460, 521, 461, 460, 
	522, 461, 460, 523, 461, 460, 524, 461, 
	460, 525, 461, 460, 526, 461, 460, 527, 
	461, 460, 528, 461, 460, 529, 461, 460, 
	530, 461, 460, 531, 461, 460, 532, 461, 
	460, 533, 461, 460, 534, 461, 460, 461, 
	100, 535, 460, 461, 536, 460, 537, 461, 
	460, 482, 461, 460, 539, 461, 460, 540, 
	571, 461, 460, 541, 461, 460, 542, 461, 
	460, 543, 461, 460, 544, 461, 460, 545, 
	461, 460, 546, 461, 460, 547, 461, 460, 
	548, 461, 460, 549, 461, 460, 550, 461, 
	460, 551, 461, 460, 552, 461, 460, 553, 
	461, 460, 554, 461, 460, 461, 555, 460, 
	556, 461, 460, 557, 461, 460, 558, 461, 
	460, 559, 461, 460, 560, 461, 460, 561, 
	461, 460, 562, 461, 460, 563, 461, 460, 
	564, 461, 460, 565, 461, 460, 566, 461, 
	460, 567, 461, 460, 568, 461, 460, 569, 
	461, 460, 570, 461, 460, 516, 461, 460, 
	572, 461, 460, 573, 461, 460, 574, 461, 
	460, 575, 461, 460, 576, 461, 460, 577, 
	461, 460, 578, 461, 460, 579, 461, 460, 
	580, 461, 460, 581, 461, 460, 582, 461, 
	460, 516, 461, 460, 584, 461, 460, 463, 
	585, 461, 460, 586, 461, 100, 460, 587, 
	461, 460, 588, 461, 460, 463, 461, 460, 
	590, 461, 460, 591, 461, 460, 592, 461, 
	460, 593, 461, 460, 594, 461, 460, 595, 
	461, 460, 596, 461, 460, 597, 461, 460, 
	598, 461, 460, 599, 461, 460, 600, 461, 
	460, 601, 461, 460, 602, 461, 460, 603, 
	461, 460, 604, 461, 460, 605, 461, 460, 
	606, 461, 460, 516, 461, 460, 608, 461, 
	460, 536, 461, 460, 461, 610, 460, 461, 
	611, 460, 461, 612, 460, 461, 613, 460, 
	461, 614, 460, 461, 615, 460, 461, 616, 
	460, 461, 617, 460, 461, 618, 460, 461, 
	619, 460, 461, 620, 460, 461, 621, 460, 
	461, 622, 460, 461, 6, 460, 624, 0, 
	3, 625, 0, 626, 4, 0, 627, 0, 
	628, 0, 3, 0, 630, 0, 631, 0, 
	632, 0, 633, 0, 634, 0, 635, 0, 
	636, 0, 637, 0, 638, 0, 639, 0, 
	640, 0, 641, 0, 642, 0, 643, 0, 
	644, 0, 645, 0, 646, 0, 647, 0, 
	648, 0, 650, 649, 650, 649, 651, 650, 
	650, 6, 747, 6, 650, 649, 652, 684, 
	729, 650, 649, 653, 671, 650, 649, 654, 
	650, 649, 655, 650, 649, 656, 650, 649, 
	657, 650, 649, 658, 650, 649, 659, 650, 
	649, 660, 650, 649, 661, 650, 649, 662, 
	650, 649, 663, 650, 649, 664, 650, 649, 
	665, 650, 649, 666, 650, 649, 667, 650, 
	649, 668, 650, 649, 669, 650, 649, 670, 
	650, 649, 650, 100, 649, 672, 650, 649, 
	673, 650, 649, 674, 650, 649, 675, 650, 
	649, 676, 650, 649, 677, 650, 649, 678, 
	650, 649, 679, 650, 649, 680, 650, 649, 
	681, 650, 649, 682, 650, 649, 683, 650, 
	649, 670, 650, 649, 685, 650, 649, 686, 
	717, 650, 649, 687, 650, 649, 688, 650, 
	649, 689, 650, 649, 690, 650, 649, 691, 
	650, 649, 692, 650, 649, 693, 650, 649, 
	694, 650, 649, 695, 650, 649, 696, 650, 
	649, 697, 650, 649, 698, 650, 649, 699, 
	650, 649, 700, 650, 649, 650, 701, 649, 
	702, 650, 649, 703, 650, 649, 704, 650, 
	649, 705, 650, 649, 706, 650, 649, 707, 
	650, 649, 708, 650, 649, 709, 650, 649, 
	710, 650, 649, 711, 650, 649, 712, 650, 
	649, 713, 650, 649, 714, 650, 649, 715, 
	650, 649, 716, 650, 649, 670, 650, 649, 
	718, 650, 649, 719, 650, 649, 720, 650, 
	649, 721, 650, 649, 722, 650, 649, 723, 
	650, 649, 724, 650, 649, 725, 650, 649, 
	726, 650, 649, 727, 650, 649, 728, 650, 
	649, 670, 650, 649, 730, 650, 649, 731, 
	650, 649, 732, 650, 649, 733, 650, 649, 
	734, 650, 649, 735, 650, 649, 736, 650, 
	649, 737, 650, 649, 738, 650, 649, 739, 
	650, 649, 740, 650, 649, 741, 650, 649, 
	742, 650, 649, 743, 650, 649, 744, 650, 
	649, 745, 650, 649, 746, 650, 649, 670, 
	650, 649, 650, 748, 649, 650, 749, 649, 
	650, 750, 649, 650, 751, 649, 650, 752, 
	649, 650, 753, 649, 650, 754, 649, 650, 
	755, 649, 650, 756, 649, 650, 757, 649, 
	650, 758, 649, 650, 759, 649, 650, 760, 
	649, 650, 6, 649, 762, 0, 294, 0, 
	764, 0, 6, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 43, 0, 
	43, 149, 126, 57, 110, 23, 0, 29, 
	54, 0, 5, 1, 0, 29, 1, 35, 
	0, 43, 0, 43, 0, 43, 139, 48, 
	9, 106, 11, 0, 134, 45, 45, 45, 
	3, 122, 33, 33, 33, 0, 122, 33, 
	33, 33, 0, 122, 33, 0, 33, 0, 
	102, 7, 7, 43, 54, 0, 0, 43, 
	114, 25, 0, 54, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 43, 43, 43, 43, 0, 27, 118, 
	27, 27, 51, 27, 0, 54, 0, 1, 
	0, 43, 0, 0, 0, 43, 54, 37, 
	37, 87, 37, 37, 43, 0, 39, 0, 
	43, 0, 0, 54, 0, 0, 39, 0, 
	0, 96, 54, 0, 93, 90, 41, 96, 
	90, 99, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 72, 
	33, 84, 72, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 54, 
	0, 54, 15, 0, 63, 130, 31, 60, 
	57, 31, 63, 57, 66, 31, 43, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 15, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 15, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 15, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 15, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 81, 81, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	21, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 78, 
	33, 84, 78, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 54, 
	0, 54, 19, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 19, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 19, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 19, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 19, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 75, 33, 
	84, 75, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	54, 17, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	17, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 17, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 17, 0, 0, 43, 
	0, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 69, 33, 69, 0, 0, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 13, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 13, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 765;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1545 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
    
#line 1552 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1842 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1905 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uk.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_uk()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Uk", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

