
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 16, 19, 23, 24, 25, 26, 
	28, 30, 45, 47, 48, 49, 50, 51, 
	52, 53, 54, 55, 63, 65, 67, 69, 
	71, 73, 75, 77, 79, 81, 83, 85, 
	87, 89, 91, 93, 108, 109, 110, 111, 
	112, 113, 114, 115, 116, 117, 118, 119, 
	120, 121, 132, 135, 138, 140, 142, 144, 
	146, 148, 150, 152, 154, 156, 158, 160, 
	162, 164, 166, 168, 170, 172, 174, 176, 
	179, 182, 184, 186, 188, 190, 192, 194, 
	196, 198, 200, 202, 204, 206, 208, 210, 
	212, 214, 216, 218, 220, 222, 224, 226, 
	228, 230, 232, 234, 237, 239, 241, 243, 
	245, 247, 250, 252, 254, 256, 258, 260, 
	262, 264, 266, 268, 270, 272, 274, 276, 
	278, 280, 282, 284, 286, 288, 290, 292, 
	294, 296, 298, 300, 302, 304, 306, 308, 
	310, 312, 314, 316, 318, 320, 322, 324, 
	326, 328, 330, 332, 334, 336, 338, 340, 
	342, 344, 345, 346, 347, 348, 349, 350, 
	351, 352, 364, 368, 373, 375, 377, 379, 
	381, 383, 385, 387, 389, 391, 393, 395, 
	397, 399, 401, 403, 405, 407, 409, 412, 
	414, 416, 418, 420, 422, 424, 426, 428, 
	430, 433, 436, 438, 440, 442, 444, 446, 
	448, 450, 452, 454, 456, 458, 460, 462, 
	464, 466, 468, 470, 472, 474, 476, 478, 
	480, 482, 484, 486, 488, 490, 493, 495, 
	497, 499, 501, 503, 506, 508, 510, 512, 
	514, 516, 518, 520, 522, 524, 526, 528, 
	530, 532, 534, 536, 538, 540, 542, 544, 
	546, 548, 550, 552, 554, 556, 558, 560, 
	562, 564, 566, 568, 570, 572, 574, 576, 
	578, 580, 582, 584, 586, 588, 590, 592, 
	594, 596, 598, 600, 602, 603, 604, 606, 
	608, 613, 618, 623, 628, 632, 636, 638, 
	639, 640, 641, 642, 643, 644, 645, 646, 
	647, 648, 649, 650, 651, 652, 653, 654, 
	659, 666, 671, 675, 681, 684, 686, 692, 
	707, 709, 711, 713, 715, 717, 718, 719, 
	720, 721, 722, 723, 724, 725, 726, 727, 
	728, 729, 732, 733, 734, 735, 736, 737, 
	738, 739, 740, 741, 742, 743, 744, 745, 
	746, 747, 748, 749, 750, 752, 754, 755, 
	756, 757, 758, 759, 760, 761, 762, 763, 
	764, 765, 766, 767, 768, 769, 770, 771, 
	772, 773, 785, 789, 794, 796, 798, 800, 
	802, 804, 806, 808, 810, 812, 814, 816, 
	818, 820, 822, 824, 826, 828, 830, 833, 
	835, 837, 839, 841, 843, 845, 847, 849, 
	851, 853, 855, 857, 859, 861, 863, 865, 
	867, 869, 871, 873, 875, 877, 879, 881, 
	883, 885, 887, 889, 891, 893, 895, 897, 
	899, 901, 903, 905, 907, 909, 911, 913, 
	915, 917, 919, 921, 923, 925, 927, 929, 
	931, 933, 934, 935, 936, 937, 938, 939, 
	940, 941, 942, 943, 945, 946, 947, 948, 
	949, 950, 951, 952, 965, 969, 974, 976, 
	978, 980, 982, 984, 986, 988, 990, 992, 
	994, 996, 998, 1000, 1002, 1004, 1006, 1008, 
	1010, 1013, 1015, 1017, 1019, 1021, 1023, 1025, 
	1027, 1029, 1031, 1034, 1037, 1039, 1041, 1043, 
	1045, 1047, 1049, 1051, 1053, 1055, 1057, 1059, 
	1061, 1063, 1065, 1067, 1069, 1071, 1073, 1075, 
	1077, 1079, 1081, 1083, 1085, 1087, 1089, 1091, 
	1094, 1096, 1098, 1100, 1102, 1104, 1107, 1109, 
	1111, 1113, 1115, 1117, 1119, 1121, 1123, 1125, 
	1127, 1129, 1131, 1133, 1135, 1137, 1139, 1141, 
	1143, 1145, 1147, 1149, 1151, 1153, 1155, 1157, 
	1159, 1161, 1163, 1165, 1167, 1169, 1171, 1173, 
	1175, 1177, 1179, 1181, 1183, 1185, 1187, 1189, 
	1191, 1193, 1195, 1197, 1199, 1201, 1203, 1205, 
	1207, 1209, 1211, 1213, 1215, 1216, 1217, 1218, 
	1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 
	1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 
	1235, 1236, 1237, 1238
};

static const char _lexer_trans_keys[] = {
	-29, -28, -27, -26, -24, -17, 10, 32, 
	34, 35, 37, 42, 64, 124, 9, 13, 
	-127, -126, -125, -117, -105, -97, -86, -29, 
	-127, -92, 10, 13, 10, 13, -29, -28, 
	-27, -26, -24, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, -67, -66, -122, 
	-29, -127, -105, -117, 58, 10, 10, -29, 
	-26, 10, 32, 35, 124, 9, 13, -125, 
	10, -107, 10, -29, 10, -126, 10, -93, 
	10, -29, 10, -125, 10, -68, 10, -29, 
	10, -125, 10, -127, 10, -29, 10, -125, 
	10, -93, 10, 10, 58, -29, -28, -27, 
	-26, -24, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -119, -115, -26, -113, 
	-112, -87, -97, -24, -125, -67, 58, 10, 
	10, -29, -28, -26, -24, 10, 32, 35, 
	37, 64, 9, 13, -126, -125, 10, -75, 
	-73, 10, -29, 10, -125, 10, -77, 10, 
	-29, 10, -125, 10, -105, 10, -29, 10, 
	-125, 10, -85, 10, 10, 58, -29, 10, 
	-125, 10, -118, 10, -29, 10, -125, 10, 
	-86, 10, -29, 10, -126, 10, -86, 10, 
	-29, 10, 58, -126, -125, 10, -94, 10, 
	-29, 10, -126, 10, -90, 10, -29, 10, 
	-125, 10, -120, 10, -29, 10, -125, 10, 
	-87, 10, -29, 10, -126, 10, -92, 10, 
	-29, 10, -125, 10, -77, 10, -122, 10, 
	-29, 10, -125, 10, -77, 10, -29, 10, 
	-125, 10, -105, 10, -29, 10, -125, 10, 
	-84, 10, -29, 10, 58, -125, 10, -68, 
	10, -29, 10, -125, 10, -120, 10, -122, 
	-107, 10, -29, 10, -125, 10, -77, 10, 
	-29, 10, -125, 10, -105, 10, -29, 10, 
	-125, 10, -84, 10, -29, 10, -126, 10, 
	-93, 10, -29, 10, -125, 10, -68, 10, 
	-29, 10, -125, 10, -127, 10, -29, 10, 
	-125, 10, -93, 10, -66, 10, -117, 10, 
	-87, 10, -97, 10, -24, 10, -125, 10, 
	-67, 10, -125, 10, -116, 10, -26, 10, 
	-103, 10, -81, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-125, -116, -26, -103, -81, 58, 10, 10, 
	-29, -28, -27, -26, 10, 32, 35, 37, 
	42, 64, 9, 13, -127, -126, -125, 10, 
	-117, -105, -97, -86, 10, -29, 10, -127, 
	10, -92, 10, -29, 10, -127, 10, -117, 
	10, -29, 10, -127, 10, -105, 10, -29, 
	10, -127, 10, -96, 10, -29, 10, -126, 
	10, -119, 10, -29, 10, -127, 10, -80, 
	10, -126, -73, 10, -29, 10, -125, 10, 
	-118, 10, -29, 10, -125, 10, -86, 10, 
	-29, 10, -126, 10, -86, 10, -29, 10, 
	58, -126, -125, 10, -94, 10, -29, 10, 
	-126, 10, -90, 10, -29, 10, -125, 10, 
	-120, 10, -29, 10, -125, 10, -87, 10, 
	-29, 10, -126, 10, -92, 10, -29, 10, 
	-125, 10, -77, 10, 10, 58, -122, 10, 
	-29, 10, -125, 10, -77, 10, -29, 10, 
	-125, 10, -105, 10, -29, 10, -125, 10, 
	-84, 10, -29, 10, 58, -125, 10, -68, 
	10, -29, 10, -125, 10, -120, 10, -122, 
	-107, 10, -29, 10, -125, 10, -77, 10, 
	-29, 10, -125, 10, -105, 10, -29, 10, 
	-125, 10, -84, 10, -29, 10, -126, 10, 
	-93, 10, -29, 10, -125, 10, -68, 10, 
	-29, 10, -125, 10, -127, 10, -29, 10, 
	-125, 10, -93, 10, -67, 10, -122, 10, 
	-119, 10, -115, 10, -26, 10, -113, 10, 
	-112, 10, -87, 10, -97, 10, -24, 10, 
	-125, 10, -67, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 32, 34, 34, 10, 13, 10, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 9, 13, 
	10, 32, 9, 13, 10, 13, 10, 95, 
	70, 69, 65, 84, 85, 82, 69, 95, 
	69, 78, 68, 95, 37, 32, 13, 32, 
	64, 9, 10, 9, 10, 13, 32, 64, 
	11, 12, 10, 32, 64, 9, 13, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, -29, -28, -27, -26, 
	-24, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -87, 10, -97, 10, -24, 
	10, -125, 10, -67, 10, -29, -127, -117, 
	-29, -127, -96, -29, -126, -119, -29, -127, 
	-80, -126, -75, -73, -29, -125, -77, -29, 
	-125, -105, -29, -125, -85, -29, -125, -118, 
	-29, -125, -86, -29, -126, -86, -29, 58, 
	-126, -125, -94, -29, -126, -90, -29, -125, 
	-120, -29, -125, -87, -29, -126, -92, -29, 
	-125, -77, 58, 10, 10, -29, -28, -27, 
	-26, 10, 32, 35, 37, 42, 64, 9, 
	13, -127, -126, -125, 10, -117, -105, -97, 
	-86, 10, -29, 10, -127, 10, -92, 10, 
	-29, 10, -127, 10, -117, 10, -29, 10, 
	-127, 10, -105, 10, -29, 10, -127, 10, 
	-96, 10, -29, 10, -126, 10, -119, 10, 
	-29, 10, -127, 10, -80, 10, -126, -73, 
	10, -29, 10, -125, 10, -118, 10, -29, 
	10, -125, 10, -86, 10, -29, 10, -126, 
	10, -86, 10, 10, 58, -107, 10, -29, 
	10, -126, 10, -93, 10, -29, 10, -125, 
	10, -68, 10, -29, 10, -125, 10, -127, 
	10, -29, 10, -125, 10, -93, 10, -67, 
	10, -122, 10, -119, 10, -115, 10, -26, 
	10, -113, 10, -112, 10, -87, 10, -97, 
	10, -24, 10, -125, 10, -67, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, -122, -29, -125, 
	-77, -29, -125, -105, -29, -125, -84, -29, 
	58, -125, -68, -29, -125, -120, 10, 10, 
	-29, -28, -27, -26, -24, 10, 32, 35, 
	37, 42, 64, 9, 13, -127, -126, -125, 
	10, -117, -105, -97, -86, 10, -29, 10, 
	-127, 10, -92, 10, -29, 10, -127, 10, 
	-117, 10, -29, 10, -127, 10, -105, 10, 
	-29, 10, -127, 10, -96, 10, -29, 10, 
	-126, 10, -119, 10, -29, 10, -127, 10, 
	-80, 10, -126, -73, 10, -29, 10, -125, 
	10, -118, 10, -29, 10, -125, 10, -86, 
	10, -29, 10, -126, 10, -86, 10, -29, 
	10, 58, -126, -125, 10, -94, 10, -29, 
	10, -126, 10, -90, 10, -29, 10, -125, 
	10, -120, 10, -29, 10, -125, 10, -87, 
	10, -29, 10, -126, 10, -92, 10, -29, 
	10, -125, 10, -77, 10, 10, 58, -122, 
	10, -29, 10, -125, 10, -77, 10, -29, 
	10, -125, 10, -105, 10, -29, 10, -125, 
	10, -84, 10, -29, 10, 58, -125, 10, 
	-68, 10, -29, 10, -125, 10, -120, 10, 
	-122, -107, 10, -29, 10, -125, 10, -77, 
	10, -29, 10, -125, 10, -105, 10, -29, 
	10, -125, 10, -84, 10, -29, 10, -126, 
	10, -93, 10, -29, 10, -125, 10, -68, 
	10, -29, 10, -125, 10, -127, 10, -29, 
	10, -125, 10, -93, 10, -67, 10, -122, 
	10, -119, 10, -115, 10, -26, 10, -113, 
	10, -112, 10, -87, 10, -97, 10, -24, 
	10, -125, 10, -67, 10, -125, 10, -116, 
	10, -26, 10, -103, 10, -81, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, -122, -107, -29, 
	-125, -77, -29, -125, -105, -29, -125, -84, 
	-29, -126, -93, -29, -125, -68, -29, -125, 
	-127, -29, -125, -93, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 14, 3, 4, 1, 1, 1, 2, 
	2, 13, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 6, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 13, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 9, 3, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 10, 4, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 2, 2, 
	3, 3, 3, 3, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	5, 3, 2, 4, 3, 2, 4, 13, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 3, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 10, 4, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 11, 4, 5, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 1, 0, 0, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 16, 20, 25, 27, 29, 31, 
	34, 37, 52, 55, 57, 59, 61, 63, 
	65, 67, 69, 71, 79, 82, 85, 88, 
	91, 94, 97, 100, 103, 106, 109, 112, 
	115, 118, 121, 124, 139, 141, 143, 145, 
	147, 149, 151, 153, 155, 157, 159, 161, 
	163, 165, 176, 180, 184, 187, 190, 193, 
	196, 199, 202, 205, 208, 211, 214, 217, 
	220, 223, 226, 229, 232, 235, 238, 241, 
	245, 249, 252, 255, 258, 261, 264, 267, 
	270, 273, 276, 279, 282, 285, 288, 291, 
	294, 297, 300, 303, 306, 309, 312, 315, 
	318, 321, 324, 327, 331, 334, 337, 340, 
	343, 346, 350, 353, 356, 359, 362, 365, 
	368, 371, 374, 377, 380, 383, 386, 389, 
	392, 395, 398, 401, 404, 407, 410, 413, 
	416, 419, 422, 425, 428, 431, 434, 437, 
	440, 443, 446, 449, 452, 455, 458, 461, 
	464, 467, 470, 473, 476, 479, 482, 485, 
	488, 491, 493, 495, 497, 499, 501, 503, 
	505, 507, 519, 524, 530, 533, 536, 539, 
	542, 545, 548, 551, 554, 557, 560, 563, 
	566, 569, 572, 575, 578, 581, 584, 588, 
	591, 594, 597, 600, 603, 606, 609, 612, 
	615, 619, 623, 626, 629, 632, 635, 638, 
	641, 644, 647, 650, 653, 656, 659, 662, 
	665, 668, 671, 674, 677, 680, 683, 686, 
	689, 692, 695, 698, 701, 704, 708, 711, 
	714, 717, 720, 723, 727, 730, 733, 736, 
	739, 742, 745, 748, 751, 754, 757, 760, 
	763, 766, 769, 772, 775, 778, 781, 784, 
	787, 790, 793, 796, 799, 802, 805, 808, 
	811, 814, 817, 820, 823, 826, 829, 832, 
	835, 838, 841, 844, 847, 850, 853, 856, 
	859, 862, 865, 868, 871, 873, 875, 878, 
	881, 886, 891, 896, 901, 905, 909, 912, 
	914, 916, 918, 920, 922, 924, 926, 928, 
	930, 932, 934, 936, 938, 940, 942, 944, 
	949, 956, 961, 965, 971, 975, 978, 984, 
	999, 1002, 1005, 1008, 1011, 1014, 1016, 1018, 
	1020, 1022, 1024, 1026, 1028, 1030, 1032, 1034, 
	1036, 1038, 1042, 1044, 1046, 1048, 1050, 1052, 
	1054, 1056, 1058, 1060, 1062, 1064, 1066, 1068, 
	1070, 1072, 1074, 1076, 1078, 1081, 1084, 1086, 
	1088, 1090, 1092, 1094, 1096, 1098, 1100, 1102, 
	1104, 1106, 1108, 1110, 1112, 1114, 1116, 1118, 
	1120, 1122, 1134, 1139, 1145, 1148, 1151, 1154, 
	1157, 1160, 1163, 1166, 1169, 1172, 1175, 1178, 
	1181, 1184, 1187, 1190, 1193, 1196, 1199, 1203, 
	1206, 1209, 1212, 1215, 1218, 1221, 1224, 1227, 
	1230, 1233, 1236, 1239, 1242, 1245, 1248, 1251, 
	1254, 1257, 1260, 1263, 1266, 1269, 1272, 1275, 
	1278, 1281, 1284, 1287, 1290, 1293, 1296, 1299, 
	1302, 1305, 1308, 1311, 1314, 1317, 1320, 1323, 
	1326, 1329, 1332, 1335, 1338, 1341, 1344, 1347, 
	1350, 1353, 1355, 1357, 1359, 1361, 1363, 1365, 
	1367, 1369, 1371, 1373, 1376, 1378, 1380, 1382, 
	1384, 1386, 1388, 1390, 1403, 1408, 1414, 1417, 
	1420, 1423, 1426, 1429, 1432, 1435, 1438, 1441, 
	1444, 1447, 1450, 1453, 1456, 1459, 1462, 1465, 
	1468, 1472, 1475, 1478, 1481, 1484, 1487, 1490, 
	1493, 1496, 1499, 1503, 1507, 1510, 1513, 1516, 
	1519, 1522, 1525, 1528, 1531, 1534, 1537, 1540, 
	1543, 1546, 1549, 1552, 1555, 1558, 1561, 1564, 
	1567, 1570, 1573, 1576, 1579, 1582, 1585, 1588, 
	1592, 1595, 1598, 1601, 1604, 1607, 1611, 1614, 
	1617, 1620, 1623, 1626, 1629, 1632, 1635, 1638, 
	1641, 1644, 1647, 1650, 1653, 1656, 1659, 1662, 
	1665, 1668, 1671, 1674, 1677, 1680, 1683, 1686, 
	1689, 1692, 1695, 1698, 1701, 1704, 1707, 1710, 
	1713, 1716, 1719, 1722, 1725, 1728, 1731, 1734, 
	1737, 1740, 1743, 1746, 1749, 1752, 1755, 1758, 
	1761, 1764, 1767, 1770, 1773, 1775, 1777, 1779, 
	1781, 1783, 1785, 1787, 1789, 1791, 1793, 1795, 
	1797, 1799, 1801, 1803, 1805, 1807, 1809, 1811, 
	1813, 1815, 1817, 1819
};

static const short _lexer_trans_targs[] = {
	2, 10, 36, 41, 153, 601, 9, 9, 
	276, 286, 288, 302, 303, 306, 9, 0, 
	3, 329, 579, 0, 4, 317, 320, 323, 
	0, 5, 0, 6, 0, 7, 0, 9, 
	287, 8, 9, 287, 8, 2, 10, 36, 
	41, 153, 9, 9, 276, 286, 288, 302, 
	303, 306, 9, 0, 11, 15, 0, 12, 
	0, 13, 0, 14, 0, 7, 0, 16, 
	0, 17, 0, 19, 18, 19, 18, 20, 
	312, 19, 19, 9, 9, 19, 18, 21, 
	19, 18, 22, 19, 18, 23, 19, 18, 
	24, 19, 18, 25, 19, 18, 26, 19, 
	18, 27, 19, 18, 28, 19, 18, 29, 
	19, 18, 30, 19, 18, 31, 19, 18, 
	32, 19, 18, 33, 19, 18, 34, 19, 
	18, 19, 35, 18, 2, 10, 36, 41, 
	153, 9, 9, 276, 286, 288, 302, 303, 
	306, 9, 0, 37, 0, 38, 0, 39, 
	0, 40, 0, 7, 0, 42, 0, 43, 
	0, 44, 0, 45, 0, 46, 0, 47, 
	0, 49, 48, 49, 48, 50, 127, 129, 
	134, 49, 49, 9, 139, 9, 49, 48, 
	51, 105, 49, 48, 52, 62, 49, 48, 
	53, 49, 48, 54, 49, 48, 55, 49, 
	48, 56, 49, 48, 57, 49, 48, 58, 
	49, 48, 59, 49, 48, 60, 49, 48, 
	61, 49, 48, 49, 35, 48, 63, 49, 
	48, 64, 49, 48, 65, 49, 48, 66, 
	49, 48, 67, 49, 48, 68, 49, 48, 
	69, 49, 48, 70, 49, 48, 71, 49, 
	48, 72, 49, 35, 48, 73, 89, 49, 
	48, 74, 49, 48, 75, 49, 48, 76, 
	49, 48, 77, 49, 48, 78, 49, 48, 
	79, 49, 48, 80, 49, 48, 81, 49, 
	48, 82, 49, 48, 83, 49, 48, 84, 
	49, 48, 85, 49, 48, 86, 49, 48, 
	87, 49, 48, 88, 49, 48, 61, 49, 
	48, 90, 49, 48, 91, 49, 48, 92, 
	49, 48, 93, 49, 48, 94, 49, 48, 
	95, 49, 48, 96, 49, 48, 97, 49, 
	48, 98, 49, 48, 99, 49, 48, 100, 
	49, 35, 48, 101, 49, 48, 102, 49, 
	48, 103, 49, 48, 104, 49, 48, 61, 
	49, 48, 106, 115, 49, 48, 107, 49, 
	48, 108, 49, 48, 109, 49, 48, 110, 
	49, 48, 111, 49, 48, 112, 49, 48, 
	113, 49, 48, 114, 49, 48, 61, 49, 
	48, 116, 49, 48, 117, 49, 48, 118, 
	49, 48, 119, 49, 48, 120, 49, 48, 
	121, 49, 48, 122, 49, 48, 123, 49, 
	48, 124, 49, 48, 125, 49, 48, 126, 
	49, 48, 61, 49, 48, 128, 49, 48, 
	61, 49, 48, 130, 49, 48, 131, 49, 
	48, 132, 49, 48, 133, 49, 48, 61, 
	49, 48, 135, 49, 48, 136, 49, 48, 
	137, 49, 48, 138, 49, 48, 61, 49, 
	48, 49, 140, 48, 49, 141, 48, 49, 
	142, 48, 49, 143, 48, 49, 144, 48, 
	49, 145, 48, 49, 146, 48, 49, 147, 
	48, 49, 148, 48, 49, 149, 48, 49, 
	150, 48, 49, 151, 48, 49, 152, 48, 
	49, 9, 48, 154, 0, 155, 0, 156, 
	0, 157, 0, 158, 0, 159, 0, 161, 
	160, 161, 160, 162, 249, 251, 256, 161, 
	161, 9, 261, 275, 9, 161, 160, 163, 
	182, 227, 161, 160, 164, 167, 173, 176, 
	161, 160, 165, 161, 160, 166, 161, 160, 
	35, 161, 160, 168, 161, 160, 169, 161, 
	160, 170, 161, 160, 171, 161, 160, 172, 
	161, 160, 35, 161, 160, 174, 161, 160, 
	175, 161, 160, 170, 161, 160, 177, 161, 
	160, 178, 161, 160, 179, 161, 160, 180, 
	161, 160, 181, 161, 160, 35, 161, 160, 
	170, 183, 161, 160, 184, 161, 160, 185, 
	161, 160, 186, 161, 160, 187, 161, 160, 
	188, 161, 160, 189, 161, 160, 190, 161, 
	160, 191, 161, 160, 192, 161, 160, 193, 
	161, 35, 160, 194, 211, 161, 160, 195, 
	161, 160, 196, 161, 160, 197, 161, 160, 
	198, 161, 160, 199, 161, 160, 200, 161, 
	160, 201, 161, 160, 202, 161, 160, 203, 
	161, 160, 204, 161, 160, 205, 161, 160, 
	206, 161, 160, 207, 161, 160, 208, 161, 
	160, 209, 161, 160, 210, 161, 160, 161, 
	35, 160, 212, 161, 160, 213, 161, 160, 
	214, 161, 160, 215, 161, 160, 216, 161, 
	160, 217, 161, 160, 218, 161, 160, 219, 
	161, 160, 220, 161, 160, 221, 161, 160, 
	222, 161, 35, 160, 223, 161, 160, 224, 
	161, 160, 225, 161, 160, 226, 161, 160, 
	210, 161, 160, 228, 237, 161, 160, 229, 
	161, 160, 230, 161, 160, 231, 161, 160, 
	232, 161, 160, 233, 161, 160, 234, 161, 
	160, 235, 161, 160, 236, 161, 160, 210, 
	161, 160, 238, 161, 160, 239, 161, 160, 
	240, 161, 160, 241, 161, 160, 242, 161, 
	160, 243, 161, 160, 244, 161, 160, 245, 
	161, 160, 246, 161, 160, 247, 161, 160, 
	248, 161, 160, 210, 161, 160, 250, 161, 
	160, 170, 161, 160, 252, 161, 160, 253, 
	161, 160, 254, 161, 160, 255, 161, 160, 
	35, 161, 160, 257, 161, 160, 258, 161, 
	160, 259, 161, 160, 260, 161, 160, 210, 
	161, 160, 161, 262, 160, 161, 263, 160, 
	161, 264, 160, 161, 265, 160, 161, 266, 
	160, 161, 267, 160, 161, 268, 160, 161, 
	269, 160, 161, 270, 160, 161, 271, 160, 
	161, 272, 160, 161, 273, 160, 161, 274, 
	160, 161, 9, 160, 161, 35, 160, 277, 
	0, 278, 0, 280, 279, 279, 280, 279, 
	279, 281, 281, 282, 281, 281, 281, 281, 
	282, 281, 281, 281, 281, 283, 281, 281, 
	281, 281, 284, 281, 281, 9, 285, 285, 
	0, 9, 285, 285, 0, 9, 287, 286, 
	9, 0, 289, 0, 290, 0, 291, 0, 
	292, 0, 293, 0, 294, 0, 295, 0, 
	296, 0, 297, 0, 298, 0, 299, 0, 
	300, 0, 301, 0, 603, 0, 7, 0, 
	0, 0, 0, 0, 304, 305, 9, 305, 
	305, 303, 304, 304, 9, 305, 303, 305, 
	0, 306, 307, 306, 0, 311, 310, 309, 
	307, 310, 308, 0, 309, 307, 308, 0, 
	309, 308, 311, 310, 309, 307, 310, 308, 
	2, 10, 36, 41, 153, 311, 311, 276, 
	286, 288, 302, 303, 306, 311, 0, 313, 
	19, 18, 314, 19, 18, 315, 19, 18, 
	316, 19, 18, 34, 19, 18, 318, 0, 
	319, 0, 12, 0, 321, 0, 322, 0, 
	12, 0, 324, 0, 325, 0, 326, 0, 
	327, 0, 328, 0, 7, 0, 12, 330, 
	339, 0, 331, 0, 332, 0, 333, 0, 
	334, 0, 335, 0, 336, 0, 337, 0, 
	338, 0, 16, 0, 340, 0, 341, 0, 
	342, 0, 343, 0, 344, 0, 345, 0, 
	346, 0, 347, 0, 348, 0, 349, 457, 
	0, 350, 441, 0, 351, 0, 352, 0, 
	353, 0, 354, 0, 355, 0, 356, 0, 
	357, 0, 358, 0, 359, 0, 360, 0, 
	361, 0, 362, 0, 363, 0, 364, 0, 
	365, 0, 366, 0, 367, 0, 369, 368, 
	369, 368, 370, 414, 416, 421, 369, 369, 
	9, 426, 440, 9, 369, 368, 371, 390, 
	401, 369, 368, 372, 375, 381, 384, 369, 
	368, 373, 369, 368, 374, 369, 368, 35, 
	369, 368, 376, 369, 368, 377, 369, 368, 
	378, 369, 368, 379, 369, 368, 380, 369, 
	368, 35, 369, 368, 382, 369, 368, 383, 
	369, 368, 378, 369, 368, 385, 369, 368, 
	386, 369, 368, 387, 369, 368, 388, 369, 
	368, 389, 369, 368, 35, 369, 368, 378, 
	391, 369, 368, 392, 369, 368, 393, 369, 
	368, 394, 369, 368, 395, 369, 368, 396, 
	369, 368, 397, 369, 368, 398, 369, 368, 
	399, 369, 368, 400, 369, 368, 369, 35, 
	368, 402, 369, 368, 403, 369, 368, 404, 
	369, 368, 405, 369, 368, 406, 369, 368, 
	407, 369, 368, 408, 369, 368, 409, 369, 
	368, 410, 369, 368, 411, 369, 368, 412, 
	369, 368, 413, 369, 368, 400, 369, 368, 
	415, 369, 368, 378, 369, 368, 417, 369, 
	368, 418, 369, 368, 419, 369, 368, 420, 
	369, 368, 35, 369, 368, 422, 369, 368, 
	423, 369, 368, 424, 369, 368, 425, 369, 
	368, 400, 369, 368, 369, 427, 368, 369, 
	428, 368, 369, 429, 368, 369, 430, 368, 
	369, 431, 368, 369, 432, 368, 369, 433, 
	368, 369, 434, 368, 369, 435, 368, 369, 
	436, 368, 369, 437, 368, 369, 438, 368, 
	369, 439, 368, 369, 9, 368, 369, 35, 
	368, 442, 0, 443, 0, 444, 0, 445, 
	0, 446, 0, 447, 0, 448, 0, 449, 
	0, 450, 0, 451, 0, 452, 367, 0, 
	453, 0, 454, 0, 455, 0, 456, 0, 
	366, 0, 459, 458, 459, 458, 460, 547, 
	549, 554, 559, 459, 459, 9, 564, 578, 
	9, 459, 458, 461, 480, 525, 459, 458, 
	462, 465, 471, 474, 459, 458, 463, 459, 
	458, 464, 459, 458, 35, 459, 458, 466, 
	459, 458, 467, 459, 458, 468, 459, 458, 
	469, 459, 458, 470, 459, 458, 35, 459, 
	458, 472, 459, 458, 473, 459, 458, 468, 
	459, 458, 475, 459, 458, 476, 459, 458, 
	477, 459, 458, 478, 459, 458, 479, 459, 
	458, 35, 459, 458, 468, 481, 459, 458, 
	482, 459, 458, 483, 459, 458, 484, 459, 
	458, 485, 459, 458, 486, 459, 458, 487, 
	459, 458, 488, 459, 458, 489, 459, 458, 
	490, 459, 458, 491, 459, 35, 458, 492, 
	509, 459, 458, 493, 459, 458, 494, 459, 
	458, 495, 459, 458, 496, 459, 458, 497, 
	459, 458, 498, 459, 458, 499, 459, 458, 
	500, 459, 458, 501, 459, 458, 502, 459, 
	458, 503, 459, 458, 504, 459, 458, 505, 
	459, 458, 506, 459, 458, 507, 459, 458, 
	508, 459, 458, 459, 35, 458, 510, 459, 
	458, 511, 459, 458, 512, 459, 458, 513, 
	459, 458, 514, 459, 458, 515, 459, 458, 
	516, 459, 458, 517, 459, 458, 518, 459, 
	458, 519, 459, 458, 520, 459, 35, 458, 
	521, 459, 458, 522, 459, 458, 523, 459, 
	458, 524, 459, 458, 508, 459, 458, 526, 
	535, 459, 458, 527, 459, 458, 528, 459, 
	458, 529, 459, 458, 530, 459, 458, 531, 
	459, 458, 532, 459, 458, 533, 459, 458, 
	534, 459, 458, 508, 459, 458, 536, 459, 
	458, 537, 459, 458, 538, 459, 458, 539, 
	459, 458, 540, 459, 458, 541, 459, 458, 
	542, 459, 458, 543, 459, 458, 544, 459, 
	458, 545, 459, 458, 546, 459, 458, 508, 
	459, 458, 548, 459, 458, 468, 459, 458, 
	550, 459, 458, 551, 459, 458, 552, 459, 
	458, 553, 459, 458, 35, 459, 458, 555, 
	459, 458, 556, 459, 458, 557, 459, 458, 
	558, 459, 458, 508, 459, 458, 560, 459, 
	458, 561, 459, 458, 562, 459, 458, 563, 
	459, 458, 508, 459, 458, 459, 565, 458, 
	459, 566, 458, 459, 567, 458, 459, 568, 
	458, 459, 569, 458, 459, 570, 458, 459, 
	571, 458, 459, 572, 458, 459, 573, 458, 
	459, 574, 458, 459, 575, 458, 459, 576, 
	458, 459, 577, 458, 459, 9, 458, 459, 
	35, 458, 580, 589, 0, 581, 0, 582, 
	0, 583, 0, 584, 0, 585, 0, 586, 
	0, 587, 0, 588, 0, 366, 0, 590, 
	0, 591, 0, 592, 0, 593, 0, 594, 
	0, 595, 0, 596, 0, 597, 0, 598, 
	0, 599, 0, 600, 0, 46, 0, 602, 
	0, 9, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 29, 29, 29, 29, 0, 54, 0, 
	5, 1, 0, 29, 1, 35, 0, 43, 
	0, 0, 0, 43, 0, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 149, 
	126, 57, 110, 23, 0, 29, 29, 29, 
	29, 29, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	84, 54, 0, 81, 81, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 21, 0, 63, 63, 63, 63, 
	63, 130, 31, 60, 57, 31, 63, 57, 
	66, 31, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 84, 84, 
	84, 54, 0, 69, 33, 69, 0, 0, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 13, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 13, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 13, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 13, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 84, 84, 84, 54, 
	0, 72, 33, 84, 72, 0, 0, 0, 
	0, 0, 54, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	15, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 15, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 15, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 15, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	15, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 15, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	15, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 15, 0, 54, 15, 0, 0, 
	43, 0, 43, 139, 48, 9, 106, 11, 
	0, 134, 45, 45, 45, 3, 122, 33, 
	33, 33, 0, 122, 33, 33, 33, 0, 
	122, 33, 0, 33, 0, 102, 7, 7, 
	43, 54, 0, 0, 43, 114, 25, 0, 
	54, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	43, 43, 43, 43, 0, 27, 118, 27, 
	27, 51, 27, 0, 54, 0, 1, 0, 
	43, 0, 0, 0, 43, 54, 37, 37, 
	87, 37, 37, 43, 0, 39, 0, 43, 
	0, 0, 54, 0, 0, 39, 0, 0, 
	96, 96, 96, 96, 96, 54, 0, 93, 
	90, 41, 96, 90, 99, 0, 43, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 84, 84, 84, 84, 54, 0, 
	78, 33, 84, 78, 0, 0, 0, 0, 
	0, 54, 0, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 19, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 19, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 19, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 19, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 19, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 19, 0, 54, 19, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 84, 
	84, 84, 84, 54, 0, 75, 33, 84, 
	75, 0, 0, 0, 0, 0, 54, 0, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 17, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 17, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 17, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 17, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 17, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 17, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 17, 0, 54, 
	17, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 603;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1303 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
    
#line 1310 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1600 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1663 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ja.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ja()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ja", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

