;(%use eval)

;;(define (read-file file)
;;    (with-input-from-file file read))
    
(define (xlate n)
  (show-xlation "xlating ~a => ~@#*50s\n" (car n) n)
  (let ((r (xlate* n)))
    (show-xlation "xlated ~a => ~@#*50s\n" (car n) r)
    r))

(define (xlate* n)
    (case (car n)
	((method)
			(let ((formals (cadr n))
			      (body (caddr n)))
			    `(lambda ,(xlate formals) ,@(map xlate body))))
	((signature)
			(let ((from (cadr n))
			      (to (caddr n)))
			    (if (null? from)
			        '()
				(xlate from))))
	((slot)
			(let ((name (cadr n))
			      (type (caddr n)))
			    (if type
				`(,name type: ,(xlate type))
				name)))
	;;
	;; kinds of arguments...
	;;
	((positional)
			(xlate (cadr n)))
	((keyword)
			(list (list 'quote (cadr n)) (xlate (caddr n))))
	((begin)
			(cons 'begin (map xlate (cadr n))))
	((parms)
			(let ((normal (cadr n))
			      (rest (caddr n)))
			    (append (map xlate normal)
			    	    (or rest '()))))
	((varlist)
			(let ((normal (cadr n))
			      (rest (caddr n)))
			    (append (map xlate normal)
			    	    (or rest '()))))
	((var)
			(let ((name (cadr n))
			      (type (caddr n)))
			    (if type
				(list name (xlate type))
				name)))
	((combo)
			(cons (if (symbol? (cadr n))
				  (cadr n)
				  (xlate (cadr n)))
			      (flatten-kwds (caddr n))))
	((op)
			(cons (re-op (cadr n))
			      (map xlate (cddr n))))
	((ref)
			(cadr n))
	((set!)
			(let* ((lvalue (cadr n))
			       (rvalue (caddr n))
			       (xlvalue (xlate lvalue)))
			    ;(format #t "set! lvalue => ~s\n" lvalue)
			    ;(format #t "     rvalue => ~s\n" rvalue)
			    ;(format #t "     xlvalue => ~s\n" xlvalue)
			    
			    ;; make sure the lvalue is an lvalue
			    (if (and (pair? xlvalue)
				     (not (symbol? (car xlvalue))))
				(abort 'xlate/set
					"Bad lvalue: ~s" xlvalue))
			    (if (pair? xlvalue)
				(append
				    (list 'do-set
				           (string->symbol
					    (string-append
					      "set-"
					      (symbol->string (car xlvalue))
					      "!"))
				          (xlate rvalue))
				      (cdr xlvalue))
				(list 'set! xlvalue (xlate rvalue)))))
	((special)
			(cons (cadr n) (map xlate (cddr n))))
	((decl)
			(let ((decl (cadr n))
			      (body (caddr n)))
			    (cons (car decl)
				  (cons (xlate decl)
				        (map xlate body)))))
	((bind)
			(let ((varlist (cadr n))
			      (expr (caddr n)))
			    (list (append (xlate varlist)
					  (xlate expr)))))
	((letrec)
			(map (lambda (f)
				(list (car f)
				      (xlate (cadr f))))
			    (cadr n)))
	((if)
			(let ((first-clause (cadr n))
			      (other-clauses (caddr n))
			      (else-body (cadddr n)))
		        (append (cons 'cond
					(map xlate
					    (cons first-clause other-clauses)))
				(if else-body
				    (list (cons #t (map xlate else-body)))
				    '()))))
	((clause)
		        (let ((condition (cadr n))
			      (body (caddr n)))
			    (cons (xlate condition)
			          (map xlate body))))
	((qvec quote qlist qstr)
			(list 'quote (xevalq n)))
	((aref)
			(let ((indices (caddr n))
			      (target (cadr n)))
			    (if (eq? (length indices) 1)
			        (list 'element 
					(xlate target)
					(xlate (car indices)))
				(cons 'aref 
				    (cons (xlate target) 
					  (map xlate indices))))))
	((sel)
			(let ((field (caddr n))
			      (target (cadr n)))
			    (list field (xlate target))))
	(else
			(format #t "can't xlate: ~s\n" n)
			n)))

(define (xevalq n)
    (case (car n)
	((quote)
		(cadr n))
	((qvec)
		(list->vector (map xevalq (cadr n))))
	((qstr)
		(apply string-append (cadr n)))
	((qlist)
		(append (map xevalq (cadr n)) 
			(if (null? (caddr n))
			    '()
			    (xevalq (caddr n)))))))

(define (re-op op)
    (case op
	((==) 'eq?)
	((=) 'equal?)
	((~=) 'ne?)
	((~) 'not)
	(else op)))

(define (flatten-kwds lst)
    (if (null? lst)
	lst
	(if (eq? (caar lst) 'keyword)
	    (cons (list 'quote (cadar lst))
		  (cons (xlate (caddar lst)) 
			(flatten-kwds (cdr lst))))
	    (cons (xlate (car lst)) (flatten-kwds (cdr lst))))))
