(define (thread-list envt)
  (for-each
   (lambda ((k <fixnum>))
     (let* ((t (table-lookup *thread-table* k))
	    (t (and t (thread t))))
       (if t
	   (let (((n <string>) (internal-thread-name t))
                 (s (thread-state t)))
	     (format #t " ~-5d [~a]~a ~6a ~10a"
		     (thread-number t)
		     n
		     (vector-ref '#("          "
				    "         "
				    "        "
				    "       "
				    "      "
				    "     "
				    "    "
				    "   "
				    "  "
				    " "
				    "")
				 (min 10 (string-length n)))
		   (gvec-ref $thread-state-names s)
		   (thread-time t))
	     (cond
              ((eq? s $thread-state-blocked)
               (format #t " ~s" (thread-blocked-on t)))
              ((eq? s $thread-state-complete)
               (let ((res (thread-stack t)))
                 (cond
                  ((instance? res <condition>)
                   (format #t " condition: ~s"
                           (class-name (object-class res))))
                  ((list? res)
                   (format #t " returned ~d values" (length res)))))))
             (newline)))))
   (sort (key-sequence *thread-table*) <)))

(%early-once-only
 (define-command-proc tl thread-list ((",tl" "show thread list"))))

;;;
