
;; debug message

(define *debug-messages-enabled* #t)
(define (enabled? x)
  *debug-messages-enabled*)

(define (debug-messages-disable)
  (set! *debug-messages-enabled* #f))

(define (debug-messages-enable)
  (set! *debug-messages-enabled* #t))

(define (debug-message (m <message>) argv . more)
  (display-message m (current-error-port) argv 
		   (if (null? more)
		       *message-prefix*
		       (car more))))

;;  (dm [at: PLACE] [type: TYPE] [NUM] FMT ARG ...)

(define-macro (dm . args)
  (bind ((msg args xtra (foo 'debug args))
	 (mn (gensym)))
    `(let ((,mn (alloc-message ,@msg)))
       (if (',enabled? ,mn)
	   (',debug-message ,mn (vector ,@args) ,@xtra)
	   (values)))))

(&module (export dm debug-messages-disable debug-messages-enable))
