(load "_keywords.scm")
(load "module.scm")

,(use gui.x)

(define d (open-display (with-module unixm (hostname))))

(define $colors '#(#xbbbbcc #xffffff #xcccccb #x808080))
(define $colors '#(32 1 3 8))

(define $steel-blue (make-color red: (/ 70 255)
				green: (/ 130 255)
				blue: (/ 180 255)))

(define s (car (display-roots d)))

(define (getcolor c dflt)
  (handler-case
    (alloc-color (screen-default-colormap s) c)
   ((<x-error>)
    (display "Could not allocate background color!\n")
    (dflt s))))

(define steelblue (getcolor "Steel Blue" screen-white-pixel))

(define w (create-window parent: (screen-root s)
			 x: 50
			 y: 50
			 width: 120
			 height: 300
			 background: steelblue #|(vector-ref $colors 0)|#))

(define w1 (create-window parent: w
			  x: 10 
			  y: 10
			  width: 100
			  height: 20
			  border: (vector-ref $colors 2)
			  border-width: 1
			  event-mask: '(enter-window leave-window)
			  background: (vector-ref $colors 1)))

(define w2 (create-window parent: w
			  x: 10 
			  y: 35
			  width: 100
			  height: 20
			  border: (vector-ref $colors 2)
			  border-width: 1
			  event-mask: '(enter-window leave-window)
			  background: (vector-ref $colors 3)))

(map-window w)
(map-window w1)
(map-window w2)

(display-force-output d)
