
(define (point+ (a <point>) (b <size>))
  (make-point (+ (x a) (dx b)) (+ (y a) (dy b))))

(define (point- (a <point>) (b <point>))
  (make-size (- (x a) (x b)) (- (y a) (y b))))

(define (size- (a <size>) (b <size>))
  (make-size (- (dx a) (dx b)) (- (dy a) (dy b))))

(define (size+ (a <size>) (b <size>))
  (make-size (+ (dx a) (dx b)) (+ (dy a) (dy b))))

(define (inner-product (a <size>) (b <size>))
  (+ (* (dx a) (dx b))
     (* (dy a) (dy b))))

(define (size* (v <size>) (n <real>))
  (make-size (* (dx v) n)
	     (* (dy v) n)))

(define (normalize (v <size>))
  (size* v (/ (sqrt (inner-product v v)))))

(define (inset-rect (r <rect>) dx dy)
  (make-rect (+ (origin-x r) dx)
   	     (+ (origin-y r) dy)
	     (- (size-width r) (* 2 dx))
	     (- (size-height r) (* 2 dy))))

(define (offset-point (p <point>) dx dy)
  (make <point>
	x: (+ (x p) dx)
	y: (+ (y p) dy)))

(define (offset-rect (r <rect>) dx dy)
  (make-rect (+ (origin-x r) dx)
   	     (+ (origin-y r) dy)
	     (size-width r)
	     (size-height r)))
