
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

static void *
do_test (void *data)
{
    long tid = (long) data;
    RBucket *bucket;
    int *num[1000];
    int i, a;

    for (a = 0; a < 10000; a++) {

        bucket = rbucket_new (sizeof (int));

        for (i = 0; i < 1000; i++) {
            num[i] = rbucket_alloc (bucket);
            *num[i] = i;
        }

        for (i = 0; i < 1000; i++) {
            if (*num[i] != i) {
                printf ("Bad Magic: found %d, expected %d\n", *num[i], i);
            }
        }

        for (i = 0; i < 1000; i++) {
            rbucket_free (bucket, num[i]);
        }

        for (i = 0; i < 10000; i++) {
            num[0] = rbucket_alloc (bucket);
        }

        rbucket_destroy (bucket);

    }

    printf ("thread %ld done.\n", tid);

    return (NULL);
}


int
main (void)
{
    RThread *thread1;
    RThread *thread2;

    rinit_threaded ();

    thread1 = rthread_create (do_test, (void *) 1L);
    thread2 = rthread_create (do_test, (void *) 2L);

    rthread_waitfor (thread1, NULL);
    rthread_free (thread1);

    rthread_waitfor (thread2, NULL);
    rthread_free (thread2);

    rcleanup ();

    return (0);
}

