# Code for the progress bar in RoutePlanner/RouteEdit
#
# Copyright (C) 1996-2001 Chris Lawrence
# This file may be freely distributed under the terms of the RoutePlanner
# license.  A copy should appear as 'LICENSE' in the archive that this
# file was included in.

import string
from gtk import *

def render():
    while events_pending():
        mainiteration(FALSE)

class ProgressWin:
    def __init__(self, title='', parent=None):
        self.current, self.max = 0, 1
        self.window = GtkWindow(type=WINDOW_DIALOG, title=title)
        self.bartitle = GtkFrame()
        self.bar = GtkProgressBar()
        self.bar.set_show_text(TRUE)
        self.bartitle.add(self.bar)
        self.window.set_title(title)
        self.window.connect("delete_event", self.close_clicked)
        self.window.add(self.bartitle)
        self.window.set_position(WIN_POS_CENTER)
        self.window.set_default_size(200, -1)
        if parent:
            self.window.set_transient_for(parent)
        self.window.set_modal(TRUE)
        self.bar.show()
        self.bartitle.show()

    def set_label(self, label):
        self.bartitle.set_label(label)
        render()

    def set_max(self, maxval):
        self.max = maxval
        self.bar.update(self.current/float(self.max))
        render()

    def set_current(self, current):
        self.current = current
        if self.max:
            self.bar.update(current/float(self.max))
        else:
            self.bar.update(0)
        render()

    def close_clicked(self, *args):
        self.hide()
        render()
        return TRUE

    def hide(self):
        render()
        self.window.hide()

    def destroy(self):
        self.window.destroy()

    def show(self):
        self.window.show()
        render()
