/*
 *  appointment-data.h   -
 *
 *  Created: 20020221
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: appointment-data.h,v 1.6 2002/03/09 20:59:18 tomek Exp $
 *
 */

#ifndef __APPOINTMENT_DATA
#define __APPOINTMENT_DATA

#include <gtk/gtk.h>

#define MAX_SUMMARY         200
#define MAX_LOCATION        200
#define MAX_DESCRIPTION    1024

/* Struktura suca do przechowywania danych terminu. */
typedef struct
{
    GtkWidget *appointment_window;
    
    /* Pole okrelajce czy zostay zmodyfikowane dane struktury danych kontaktu. */
    gboolean modified;
    
    gint id;
    gchar summary[MAX_SUMMARY];
    gchar location[MAX_LOCATION];
    
    guint start_month;
    guint start_day;
    guint start_year;
    guint start_hour;
    guint start_mins;
    
    guint end_month;
    guint end_day;
    guint end_year;
    guint end_hour;
    guint end_mins;
    
    gchar description[MAX_DESCRIPTION];
} appointment_data;

void create_days_list(appointment_data *data, gboolean start_entries);

#endif    /*  __APPOINTMENT_DATA  */
