/*
 *  Rexx/Tk
 *  Copyright (C) 1999  Roger O'Connor <ocon@metronet.com>
 *  Copyright (C) 2000  Mark Hessling  <M.Hessling@qut.edu.au>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define REXXTK_VERSION "1.0.1"
#define REXXTK_DATE "7 Sep 2000"

#include "rexxtk.h"

char *RxPackageName = "rexxtk";

RexxFunctionHandler TkActivate            ;
RexxFunctionHandler TkAdd                 ;
RexxFunctionHandler TkAfter               ;
RexxFunctionHandler TkBBox                ;
RexxFunctionHandler TkBind                ;
RexxFunctionHandler TkButton              ;
RexxFunctionHandler TkCanvas              ;
RexxFunctionHandler TkCanvasAddTag        ;
RexxFunctionHandler TkCanvasArc           ;
RexxFunctionHandler TkCanvasBind          ;
RexxFunctionHandler TkCanvasBitmap        ;
RexxFunctionHandler TkCanvasCanvasx       ;
RexxFunctionHandler TkCanvasCanvasy       ;
RexxFunctionHandler TkCanvasCoords        ;
RexxFunctionHandler TkCanvasDChars        ;
RexxFunctionHandler TkCanvasDTag          ;
RexxFunctionHandler TkCanvasDelete        ;
RexxFunctionHandler TkCanvasFind          ;
RexxFunctionHandler TkCanvasFocus         ;
RexxFunctionHandler TkCanvasImage         ;
RexxFunctionHandler TkCanvasLine          ;
RexxFunctionHandler TkCanvasOval          ;
RexxFunctionHandler TkCanvasPolygon       ;
RexxFunctionHandler TkCanvasPostscript    ;
RexxFunctionHandler TkCanvasRectangle     ;
RexxFunctionHandler TkCanvasText          ;
RexxFunctionHandler TkCanvasType          ;
RexxFunctionHandler TkCanvasWindow        ;
RexxFunctionHandler TkCget                ;
RexxFunctionHandler TkCheckButton         ;
RexxFunctionHandler TkChooseColor         ;
RexxFunctionHandler TkConfig              ;
RexxFunctionHandler TkCurSelection        ;
RexxFunctionHandler TkDelete              ;
RexxFunctionHandler TkDestroy             ;
RexxFunctionHandler TkDropFuncs           ;
RexxFunctionHandler TkEntry               ;
RexxFunctionHandler TkError               ;
RexxFunctionHandler TkFocus               ;
RexxFunctionHandler TkFontActual          ;
RexxFunctionHandler TkFontConfig          ;
RexxFunctionHandler TkFontCreate          ;
RexxFunctionHandler TkFontDelete          ;
RexxFunctionHandler TkFontFamilies        ;
RexxFunctionHandler TkFontMeasure         ;
RexxFunctionHandler TkFontMetrics         ;
RexxFunctionHandler TkFontNames           ;
RexxFunctionHandler TkFrame               ;
RexxFunctionHandler TkGet                 ;
RexxFunctionHandler TkGetBaseData         ;
RexxFunctionHandler TkGetOpenFile         ;
RexxFunctionHandler TkGrab                ;
RexxFunctionHandler TkGrid                ;
RexxFunctionHandler TkGridBbox            ;
RexxFunctionHandler TkGridColumnConfig    ;
RexxFunctionHandler TkGridConfig          ;
RexxFunctionHandler TkGridForget          ;
RexxFunctionHandler TkGridInfo            ;
RexxFunctionHandler TkGridLocation        ;
RexxFunctionHandler TkGridPropagate       ;
RexxFunctionHandler TkGridRemove          ;
RexxFunctionHandler TkGridRowConfig       ;
RexxFunctionHandler TkGridSize            ;
RexxFunctionHandler TkGridSlaves          ;
RexxFunctionHandler TkImageBitmap         ;
RexxFunctionHandler TkImagePhoto          ;
RexxFunctionHandler TkIndex               ;
RexxFunctionHandler TkInsert              ;
RexxFunctionHandler TkItemConfig          ;
RexxFunctionHandler TkLabel               ;
RexxFunctionHandler TkListBox             ;
RexxFunctionHandler TkLoadFuncs           ;
RexxFunctionHandler TkMenu                ;
RexxFunctionHandler TkMenuClone           ;
RexxFunctionHandler TkMenuEntryCget       ;
RexxFunctionHandler TkMenuEntryConfig     ;
RexxFunctionHandler TkMenuInvoke          ;
RexxFunctionHandler TkMenuPost            ;
RexxFunctionHandler TkMenuPostCascade     ;
RexxFunctionHandler TkMenuType            ;
RexxFunctionHandler TkMenuUnPost          ;
RexxFunctionHandler TkMenuYPosition       ;
RexxFunctionHandler TkMessageBox          ;
RexxFunctionHandler TkNearest             ;
RexxFunctionHandler TkPack                ;
RexxFunctionHandler TkRadioButton         ;
RexxFunctionHandler TkPopup               ;
RexxFunctionHandler TkScale               ;
RexxFunctionHandler TkScan                ;
RexxFunctionHandler TkScrollBar           ;
RexxFunctionHandler TkSee                 ;
RexxFunctionHandler TkSelection           ;
RexxFunctionHandler TkSet                 ;
RexxFunctionHandler TkSetFileType         ;
RexxFunctionHandler TkTcl                 ;
RexxFunctionHandler TkText                ;
RexxFunctionHandler TkTextTagBind         ;
RexxFunctionHandler TkTextTagConfig       ;
RexxFunctionHandler TkTopLevel            ;
RexxFunctionHandler TkVar                 ;
RexxFunctionHandler TkVariable            ;
RexxFunctionHandler TkWait                ;
RexxFunctionHandler TkWinfo               ;
RexxFunctionHandler TkWm                  ;
RexxFunctionHandler TkXView               ;
RexxFunctionHandler TkYView               ;

/*-----------------------------------------------------------------------------
 * Table of TK Functions. Used to install/de-install functions.
 * If you change this table, don't forget to change the table at the end
 * of this file.
 *----------------------------------------------------------------------------*/
RexxFunction RxPackageFunctions[] = {
   { "TKACTIVATE"            ,TkActivate            ,"TkActivate"            , 1 },
   { "TKADD"                 ,TkAdd                 ,"TkAdd"                 , 1 },
   { "TKAFTER"               ,TkAfter               ,"TkAfter"               , 1 },
   { "TKBBOX"                ,TkBBox                ,"TkBBox"                , 1 },
   { "TKBIND"                ,TkBind                ,"TkBind"                , 1 },
   { "TKBUTTON"              ,TkButton              ,"TkButton"              , 1 },
   { "TKCANVAS"              ,TkCanvas              ,"TkCanvas"              , 1 },
   { "TKCANVASADDTAG"        ,TkCanvasAddTag        ,"TkCanvasAddTag"        , 1 },
   { "TKCANVASARC"           ,TkCanvasArc           ,"TkCanvasArc"           , 1 },
   { "TKCANVASBIND"          ,TkCanvasBind          ,"TkCanvasBind"          , 1 },
   { "TKCANVASBITMAP"        ,TkCanvasBitmap        ,"TkCanvasBitmap"        , 1 },
   { "TKCANVASCANVASX"       ,TkCanvasCanvasx       ,"TkCanvasCanvasx"       , 1 },
   { "TKCANVASCANVASY"       ,TkCanvasCanvasy       ,"TkCanvasCanvasy"       , 1 },
   { "TKCANVASCOORDS"        ,TkCanvasCoords        ,"TkCanvasCoords"        , 1 },
   { "TKCANVASDCHARS"        ,TkCanvasDChars        ,"TkCanvasDChars"        , 1 },
   { "TKCANVASDTAG"          ,TkCanvasDTag          ,"TkCanvasDTag"          , 1 },
   { "TKCANVASDELETE"        ,TkCanvasDelete        ,"TkCanvasDelete"        , 1 },
   { "TKCANVASFIND"          ,TkCanvasFind          ,"TkCanvasFind"          , 1 },
   { "TKCANVASFOCUS"         ,TkCanvasFocus         ,"TkCanvasFocus"         , 1 },
   { "TKCANVASIMAGE"         ,TkCanvasImage         ,"TkCanvasImage"         , 1 },
   { "TKCANVASLINE"          ,TkCanvasLine          ,"TkCanvasLine"          , 1 },
   { "TKCANVASOVAL"          ,TkCanvasOval          ,"TkCanvasOval"          , 1 },
   { "TKCANVASPOLYGON"       ,TkCanvasPolygon       ,"TkCanvasPolygon"       , 1 },
   { "TKCANVASPOSTSCRIPT"    ,TkCanvasPostscript    ,"TkCanvasPostscript"    , 1 },
   { "TKCANVASRECTANGLE"     ,TkCanvasRectangle     ,"TkCanvasRectangle"     , 1 },
   { "TKCANVASTEXT"          ,TkCanvasText          ,"TkCanvasText"          , 1 },
   { "TKCANVASTYPE"          ,TkCanvasType          ,"TkCanvasType"          , 1 },
   { "TKCANVASWINDOW"        ,TkCanvasWindow        ,"TkCanvasWindow"        , 1 },
   { "TKCGET"                ,TkCget                ,"TkCget"                , 1 },
   { "TKCHECKBUTTON"         ,TkCheckButton         ,"TkCheckButton"         , 1 },
   { "TKCHOOSECOLOR"         ,TkChooseColor         ,"TkChooseColor"         , 1 },
   { "TKCONFIG"              ,TkConfig              ,"TkConfig"              , 1 },
   { "TKCURSELECTION"        ,TkCurSelection        ,"TkCurSelection"        , 1 },
   { "TKDELETE"              ,TkDelete              ,"TkDelete"              , 1 },
   { "TKDESTROY"             ,TkDestroy             ,"TkDestroy"             , 1 },
   { "TKDROPFUNCS"           ,TkDropFuncs           ,"TkDropFuncs"           , 1 },
   { "TKENTRY"               ,TkEntry               ,"TkEntry"               , 1 },
   { "TKERROR"               ,TkError               ,"TkError"               , 1 },
   { "TKFOCUS"               ,TkFocus               ,"TkFocus"               , 1 },
   { "TKFONTACTUAL"          ,TkFontActual          ,"TkFontActual"          , 1 },
   { "TKFONTCONFIG"          ,TkFontConfig          ,"TkFontConfig"          , 1 },
   { "TKFONTCREATE"          ,TkFontCreate          ,"TkFontCreate"          , 1 },
   { "TKFONTDELETE"          ,TkFontDelete          ,"TkFontDelete"          , 1 },
   { "TKFONTFAMILIES"        ,TkFontFamilies        ,"TkFontFamilies"        , 1 },
   { "TKFONTMEASURE"         ,TkFontMeasure         ,"TkFontMeasure"         , 1 },
   { "TKFONTMETRICS"         ,TkFontMetrics         ,"TkFontMetrics"         , 1 },
   { "TKFONTNAMES"           ,TkFontNames           ,"TkFontNames"           , 1 },
   { "TKFRAME"               ,TkFrame               ,"TkFrame"               , 1 },
   { "TKGET"                 ,TkGet                 ,"TkGet"                 , 1 },
   { "TKGETOPENFILE"         ,TkGetOpenFile         ,"TkGetOpenFile"         , 1 },
   { "TKGETSAVEFILE"         ,TkGetOpenFile         ,"TkGetOpenFile"         , 1 },
   { "TKGRAB"                ,TkGrab                ,"TkGrab"                , 1 },
   { "TKGRID"                ,TkGrid                ,"TkGrid"                , 1 },
   { "TKGRIDBBOX"            ,TkGridBbox            ,"TkGridBbox"            , 1 },
   { "TKGRIDCOLUMNCONFIG"    ,TkGridColumnConfig    ,"TkGridColumnConfig"    , 1 },
   { "TKGRIDCONFIG"          ,TkGridConfig          ,"TkGridConfig"          , 1 },
   { "TKGRIDFORGET"          ,TkGridForget          ,"TkGridForget"          , 1 },
   { "TKGRIDINFO"            ,TkGridInfo            ,"TkGridInfo"            , 1 },
   { "TKGRIDLOCATION"        ,TkGridLocation        ,"TkGridLocation"        , 1 },
   { "TKGRIDPROPAGATE"       ,TkGridPropagate       ,"TkGridPropagate"       , 1 },
   { "TKGRIDROWCONFIG"       ,TkGridRowConfig       ,"TkGridRowConfig"       , 1 },
   { "TKGRIDREMOVE"          ,TkGridRemove          ,"TkGridRemove"          , 1 },
   { "TKGRIDSIZE"            ,TkGridSize            ,"TkGridSize"            , 1 },
   { "TKGRIDSLAVES"          ,TkGridSlaves          ,"TkGridSlaves"          , 1 },
   { "TKIMAGEBITMAP"         ,TkImageBitmap         ,"TkImageBitmap"         , 1 },
   { "TKIMAGEPHOTO"          ,TkImagePhoto          ,"TkImagePhoto"          , 1 },
   { "TKINDEX"               ,TkIndex               ,"TkIndex"               , 1 },
   { "TKINSERT"              ,TkInsert              ,"TkInsert"              , 1 },
   { "TKITEMCONFIG"          ,TkItemConfig          ,"TkItemConfig"          , 1 },
   { "TKLABEL"               ,TkLabel               ,"TkLabel"               , 1 },
   { "TKLISTBOX"             ,TkListBox             ,"TkListBox"             , 1 },
   { "TKLOADFUNCS"           ,TkLoadFuncs           ,"TkLoadFuncs"           , 0 }, /* don't load this from a DLL */
   { "TKMENU"                ,TkMenu                ,"TkMenu"                , 1 },
   { "TKMENUCLONE"           ,TkMenuClone           ,"TkMenuClone"           , 1 },
   { "TKMENUENTRYCGET"       ,TkMenuEntryCget       ,"TkMenuEntryCget"       , 1 },
   { "TKMENUENTRYCONFIG"     ,TkMenuEntryConfig     ,"TkMenuEntryConfig"     , 1 },
   { "TKMENUINVOKE"          ,TkMenuInvoke          ,"TkMenuInvoke"          , 1 },
   { "TKMENUPOST"            ,TkMenuPost            ,"TkMenuPost"            , 1 },
   { "TKMENUPOSTCASCADE"     ,TkMenuPostCascade     ,"TkMenuPostCascade"     , 1 },
   { "TKMENUTYPE"            ,TkMenuType            ,"TkMenuType"            , 1 },
   { "TKMENUUNPOST"          ,TkMenuUnPost          ,"TkMenuUnPost"          , 1 },
   { "TKMENUYPOSITION"       ,TkMenuYPosition       ,"TkMenuYPosition"       , 1 },
   { "TKMESSAGEBOX"          ,TkMessageBox          ,"TkMessageBox"          , 1 },
   { "TKNEAREST"             ,TkNearest             ,"TkNearest"             , 1 },
   { "TKPACK"                ,TkPack                ,"TkPack"                , 1 },
   { "TKPOPUP"               ,TkPopup               ,"TkPopup"               , 1 },
   { "TKRADIOBUTTON"         ,TkRadioButton         ,"TkRadioButton"         , 1 },
   { "TKSCALE"               ,TkScale               ,"TkScale"               , 1 },
   { "TKSCAN"                ,TkScan                ,"TkScan"                , 1 },
   { "TKSCROLLBAR"           ,TkScrollBar           ,"TkScrollBar"           , 1 },
   { "TKSEE"                 ,TkSee                 ,"TkSee"                 , 1 },
   { "TKSELECTION"           ,TkSelection           ,"TkSelection"           , 1 },
   { "TKSET"                 ,TkSet                 ,"TkSet"                 , 1 },
   { "TKSETFILETYPE"         ,TkSetFileType         ,"TkSetFileType"         , 1 },
   { "TKTCL"                 ,TkTcl                 ,"TkTcl"                 , 1 },
   { "TKTEXT"                ,TkText                ,"TkText"                , 1 },
   { "TKTEXTTAGBIND"         ,TkTextTagBind         ,"TkTextTagBind"         , 1 },
   { "TKTEXTTAGCONFIG"       ,TkTextTagConfig       ,"TkTextTagConfig"       , 1 },
   { "TKTOPLEVEL"            ,TkTopLevel            ,"TkTopLevel"            , 1 },
   { "TKVAR"                 ,TkVar                 ,"TkVar"                 , 1 },
   { "TKVARIABLE"            ,TkVariable            ,"TkVariable"            , 1 },
   { "TKWAIT"                ,TkWait                ,"TkWait"                , 1 },
   { "TKWINFO"               ,TkWinfo               ,"TkWinfo"               , 1 },
   { "TKWM"                  ,TkWm                  ,"TkWm"                  , 1 },
   { "TKXVIEW"               ,TkXView               ,"TkXView"               , 1 },
   { "TKYVIEW"               ,TkYView               ,"TkYView"               , 1 },
   { "TKGETBASEDATA"         ,TkGetBaseData         ,"TkGetBaseData"         , 1 },
   { NULL, NULL, NULL, 0 }
};

#ifdef WIN32
int GetTclTkLibraries(void);
char *tcllibs[] = { "tcl84", "tcl83", "tcl82", "tcl81", "tcl80", NULL };
char *tklibs[]  = { "tk84",  "tk83",  "tk82",  "tk81",  "tk80",  NULL };
#endif
/*
 * The Tcl code that implements TkWait() is defined here. It has to be
 * copied into a variable that points to writeable memory, otherwise
 * Tcl 8.1 and above seg fault!
 */
static char *rexxtk_setrexxtk="global rexxtkcommandlist\n"
                              "global rexxtkcommandcount\n"
                              "if {$rexxtkcommandcount==0} {vwait rexxtkcommandcount}\n"
                              "set rexxtkcommandcount [expr $rexxtkcommandcount-1]\n"
                              "set rexxtk [lindex $rexxtkcommandlist $rexxtkcommandcount]\n"
                              "if {$rexxtkcommandcount==0} {\n"
                              " set rexxtkcommandlist {}\n"
                              "} else {\n"
                              " set rexxtkcommandlist [lrange $rexxtkcommandlist 0 $rexxtkcommandcount]}\n"
                              "set rexxtk\n";

static char czTclCommand[TCLCOMMANDLEN+1000];
static REXXTKDATA RexxTkData;

#ifdef WIN32
Tcl_Interp *RexxTk_TclCreateInterp(void)
{
   return RexxTkData.Dyn_TclCreateInterp();
}

int RexxTk_TclEval(Tcl_Interp *interp, char *string)
{
   return RexxTkData.Dyn_TclEval( interp, string );
}

int RexxTk_TclInit(Tcl_Interp *interp)
{
   return RexxTkData.Dyn_TclInit( interp );
}

int RexxTk_TkInit(Tcl_Interp *interp)
{
   return RexxTkData.Dyn_TkInit( interp );
}

void RexxTk_TclFindExecutable(char *argv)
{
   RexxTkData.Dyn_TclFindExecutable( argv );
}
#endif

/*
 * Rexx/Tk functions start here...
 */
RFH_RETURN_TYPE TkTcl
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   int i;

   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   czTclCommand[0] = '\0';
   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);

   for (i = 1; i < (int)argc; i++){
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[i].strptr, argv[i].strlength);
   }

   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkTcl) command: %s\n",__FILE__,__LINE__,czTclCommand);)
   
   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }

   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}


RFH_RETURN_TYPE TkCanvas
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name, "canvas", argc, argv, retstr);
}

/*
 * pathName create window x y ?option...?
 * TkCanvasWindow(pathName, x, y [,options])
 */
RFH_RETURN_TYPE TkCanvasWindow
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 3, 0 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create window ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[2].strptr, argv[2].strlength);
   if (argc > 3)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,3) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasWindow) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*
 * pathName create text x y ?option...?
 * TkCanvasText(pathName, x, y [,options])
 */
RFH_RETURN_TYPE TkCanvasText
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 3, 0 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create text ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[2].strptr, argv[2].strlength);
   if (argc > 3)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,3) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasText) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*
 * pathName create image x y ?option...?
 * TkCanvasImage(pathName, x, y [,options])
 */
RFH_RETURN_TYPE TkCanvasImage
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 3, 0 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create image ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[2].strptr, argv[2].strlength);
   if (argc > 3)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,3) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasImage) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*
 * pathName create bitmap x y ?option...?
 * TkCanvasBitmap(pathName, x, y [,options])
 */
RFH_RETURN_TYPE TkCanvasBitmap
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 3, 0 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create bitmap ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[2].strptr, argv[2].strlength);
   if (argc > 3)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,3) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasBitmap) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*
 * pathName addtag tag searchSpec ?arg...?
 * TkCanvasAddtag(pathName ,tag [, searchSpec [,arg] )
 */
RFH_RETURN_TYPE TkCanvasAddTag
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name, "addtag", argc, argv, retstr);
}
/*
 * pathName create arc x1 y1 x2 y2 ?option...?
 * TkCanvasArc(pathName, x1, y1, x2, y2, [,options])
 */
RFH_RETURN_TYPE TkCanvasArc
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   int i;
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 5, 0 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create arc");
   for (i = 1; i < 5; i++)
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[i].strptr, argv[i].strlength);
   }
   if (argc > 5)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,5) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasArc) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*
 * pathName bind tag sequence [+]script
 * TkCanvasBind(pathName ,tagOrId [,sequence [,[+|*]tcl script]]] )
 */
RFH_RETURN_TYPE TkCanvasBind
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 4 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " bind");
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   if ( argc > 2)
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[2].strptr, argv[2].strlength);
   }
   if ( argc > 3)
   {
      if ( argv[3].strptr[0] == '*' )
      {
         strcat(czTclCommand, " {setRexxtk ");
         strncat(czTclCommand, argv[3].strptr+1, argv[3].strlength);
         strcat(czTclCommand, "} "); 
      }
      else
      {
         strcat(czTclCommand, " ");
         strncat(czTclCommand, argv[3].strptr, argv[3].strlength);
      }
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasBind) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*
 * pathName canvasx screenx ?gridspacing?
 * TkCanvasCanvasx(pathName ,screenx [,gridspacing] )
 */
RFH_RETURN_TYPE TkCanvasCanvasx
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 3 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"canvasxx", argc, argv, retstr);
}
/*
 * pathName canvasy screeny ?gridspacing?
 * TkCanvasCanvasy(pathName ,screeny [,gridspacing] )
 */
RFH_RETURN_TYPE TkCanvasCanvasy
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 3 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"canvasxy", argc, argv, retstr);
}
/*
 * pathName coords option
 * TkCanvasCoords(pathName, tagOrId [,x0, y0, ...] )
 */
RFH_RETURN_TYPE TkCanvasCoords
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"coords", argc, argv, retstr);
}
/*
 * pathName dchars tagOrId first ?last?
 * TkCanvasDChars(pathName ,tagOrId, first [,last] )
 */
RFH_RETURN_TYPE TkCanvasDChars
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 3, 4 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"dchars", argc, argv, retstr);
}
/*
 * pathName dtag tagOrId ?tagToDelete?
 * TkCanvasDTag(pathName ,tagOrId, [,deleteTagOrId] )
 */
RFH_RETURN_TYPE TkCanvasDTag
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 3 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"dtag", argc, argv, retstr);
}
/*
 * pathName find searchCommand ?arg arg...?
 * TkCanvasFind(pathName ,searchCommand [,arg ...] )
 */
RFH_RETURN_TYPE TkCanvasFind
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 0 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"find", argc, argv, retstr);
}
/*
 * pathName focus ?tagOrId?
 * TkCanvasFocus(pathName [,tagOrId] )
 */
RFH_RETURN_TYPE TkCanvasFocus
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"focus", argc, argv, retstr);
}
/*
 * pathName create rectangle x1 y1 x2 y2 ?option...?
 * TkCanvasRectangle(pathName, x1, y1, x2, y2, [,options])
 */
RFH_RETURN_TYPE TkCanvasRectangle
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   int i;
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 5, 0 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create rectangle");
   for (i = 1; i < 5; i++)
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[i].strptr, argv[i].strlength);
   }
   if (argc > 5)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,5) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasRectangle) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*                                           
 * pathName create oval x1 y1 x2 y2 ?option...?
 * TkCanvasOval(pathName, x1, y1, x2, y2 [,options])
 */
RFH_RETURN_TYPE TkCanvasOval
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   int i;
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 5, 0 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create oval");
   for (i = 1; i < 5; i++)
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[i].strptr, argv[i].strlength);
   }
   if (argc > 5)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,5) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasOval) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*                                           
 * pathName create line x1 y1 x2 y2 ?option...?
 * TkCanvasLine(pathName, x1, y1, x2, y2, [xn, yn [,options]])
 */
RFH_RETURN_TYPE TkCanvasLine
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   RFH_ARG1_TYPE i;
   int number_coords=0;
   RFH_ARG1_TYPE first_option=argc;

   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 5, 0 ) )
      return 1;
   /*
    * Find first (if any) option argument; ie starts with '-'
    * All arguments up to that point must be in pairs; x/y coords
    */
   for ( i = 5; i < argc; i++ )
   {
      if ( argv[i].strlength != 0
      &&   argv[i].strptr != NULL )
      {
         if ( argv[i].strptr[0] == '-' )
         {
            first_option = i;
            break;
         }
         else
            number_coords++;
      }
   }
   if ( number_coords % 2 )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create line");
   for (i = 1; i < first_option; i++)
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[i].strptr, argv[i].strlength);
   }
   if (argc > first_option)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,first_option) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasLine) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

/*                                           
 * pathName create polygon x1 y1 x2 y2 ?xn yn? ?option...?
 * TkCanvasPolygon(pathName, x1, y1, x2, y2, [xn, yn [,options]])
 */
RFH_RETURN_TYPE TkCanvasPolygon
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   RFH_ARG1_TYPE i;
   int number_coords=0;
   RFH_ARG1_TYPE first_option=argc;

   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 5, 0 ) )
      return 1;
   /*
    * Find first (if any) option argument; ie starts with '-'
    * All arguments up to that point must be in pairs; x/y coords
    */
   for ( i = 5; i < argc; i++ )
   {
      if ( argv[i].strlength != 0
      &&   argv[i].strptr != NULL )
      {
         if ( argv[i].strptr[0] == '-' )
         {
            first_option = i;
            break;
         }
         else
            number_coords++;
      }
   }
   if ( number_coords % 2 )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " create polygon");
   for (i = 1; i < first_option; i++)
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[i].strptr, argv[i].strlength);
   }
   if (argc > first_option)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,first_option) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkCanvasPolygon) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

RFH_RETURN_TYPE TkCanvasDelete
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"delete", argc, argv, retstr);
}

RFH_RETURN_TYPE TkCanvasPostscript
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeE(&RexxTkData,czTclCommand,name,"postscript", argc, argv, retstr);
}
   
/*                                           
 * pathName type tagOrid
 * TkCanvasType(pathName, tagOrid)
 */
RFH_RETURN_TYPE TkCanvasType
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"type", argc, argv, retstr);
}
   
/*                                           
 * pathName itemconfig tagOrid|index option ?option...?
 * TkItemConfig(pathName, tagOrid|index, [options])
 */
RFH_RETURN_TYPE TkItemConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeD(&RexxTkData,czTclCommand,name,"itemconfigure", argc, argv, retstr);
}
/*
 * pathName bbox ?args?
 * TkBBox(pathName ,tagorId [,tagOrId...] )
 */
RFH_RETURN_TYPE TkBBox
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"bbox", argc, argv, retstr);
}
/*
 * command tag sequence [+]script
 * TkBind( tag [,sequence [,[+|*]tcl script]]] )
 */
RFH_RETURN_TYPE TkBind
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 3 ) )
      return 1;

   strcpy(czTclCommand, "bind ");
   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   if ( argc > 1)
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   }
   if ( argc > 2)
   {
      if ( argv[2].strptr[0] == '*' )
      {
         strcat(czTclCommand, " {setRexxtk ");
         strncat(czTclCommand, argv[2].strptr+1, argv[2].strlength);
         strcat(czTclCommand, "} "); 
      }
      else
      {
         strcat(czTclCommand, " ");
         strncat(czTclCommand, argv[2].strptr, argv[2].strlength);
      }
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkBind) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
   
RFH_RETURN_TYPE TkButton
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"button", argc, argv, retstr);
}

RFH_RETURN_TYPE TkScale
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"scale", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenu
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"menu", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuClone
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 3 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"clone", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuPost
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 3, 3 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"post", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuEntryCget
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 3 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"entrycget", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuPostCascade
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"postcascade", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuInvoke
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"invoke", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuType
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"type", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuYPosition
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"yposition", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuEntryConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeD(&RexxTkData,czTclCommand,name,"entryconfigure", argc, argv, retstr);
}

RFH_RETURN_TYPE TkMenuUnPost
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 1 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"unpost", argc, argv, retstr);
}

RFH_RETURN_TYPE TkActivate
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"activate", argc, argv, retstr);
}

RFH_RETURN_TYPE TkAdd
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeD(&RexxTkData,czTclCommand,name,"add", argc, argv, retstr);
}

RFH_RETURN_TYPE TkLabel
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"label", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFrame
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"frame", argc, argv, retstr);
}

RFH_RETURN_TYPE TkText
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"text", argc, argv, retstr);
}

/*
 * pathName tag bind tagName ?sequence? ?[+]script?
 * TkTextTagBind(pathName, tagName [,sequence [,[+|*]script]]] )
 */
RFH_RETURN_TYPE TkTextTagBind
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 4 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " tag bind");
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   if ( argc > 2)
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[2].strptr, argv[2].strlength);
   }
   if ( argc > 3)
   {
      if ( argv[3].strptr[0] == '*' )
      {
         strcat(czTclCommand, " {setRexxtk ");
         strncat(czTclCommand, argv[3].strptr+1, argv[3].strlength);
         strcat(czTclCommand, "} "); 
      }
      else
      {
         strcat(czTclCommand, " ");
         strncat(czTclCommand, argv[3].strptr, argv[3].strlength);
      }
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkTextTagBind) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) 
   {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}
/*
 * pathName tag configure tagName ?options?
 * TkTextTagConfig(pathName, tagName [,option, value[ ,option, value...]] )
 */
RFH_RETURN_TYPE TkTextTagConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeD(&RexxTkData,czTclCommand,name,"tag configure", argc, argv, retstr);
}

RFH_RETURN_TYPE TkTopLevel
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"toplevel", argc, argv, retstr);
}

RFH_RETURN_TYPE TkWm
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"wm", argc, argv, retstr);
}

RFH_RETURN_TYPE TkXView
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"xview", argc, argv, retstr);
}

RFH_RETURN_TYPE TkYView
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"yview", argc, argv, retstr);
}

RFH_RETURN_TYPE TkDestroy
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"destroy", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGrab
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"grab", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGrid
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeF(&RexxTkData,czTclCommand,name,"grid configure", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridBbox
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 5 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"grid bbox", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridColumnConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError(&RexxTkData);

   if ( my_checkparam( name, argc, 2, 0 ) )
      return 1;
   
   strcpy(czTclCommand, "grid columnconfigure ");
   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   strcat(czTclCommand, " ");
   if (argc > 2)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,2) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkGridColumnConfig) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError( &RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

RFH_RETURN_TYPE TkGridConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeF(&RexxTkData,czTclCommand,name,"grid configure", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridForget
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 0 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"grid forget", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridInfo
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 1 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"grid info", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridLocation
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 3, 3 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"grid location", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridPropagate
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 2 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"grid propagate", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridRowConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError(&RexxTkData);

   if ( my_checkparam( name, argc, 2, 0 ) )
      return 1;
   
   strcpy(czTclCommand, "grid rowconfigure ");
   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   strcat(czTclCommand, " ");
   if (argc > 2)
   {
      if ( rtk_procOptArgs(name,czTclCommand,argc,argv,2) )
         return 1;
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkGridRowConfig) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError( &RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

RFH_RETURN_TYPE TkGridRemove
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 0 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"grid remove", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridSize
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"grid size", argc, argv, retstr);
}

RFH_RETURN_TYPE TkGridSlaves
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeF(&RexxTkData,czTclCommand,name,"grid slaves", argc, argv, retstr);
}

RFH_RETURN_TYPE TkVar
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"set", argc, argv, retstr);
}

RFH_RETURN_TYPE TkSetFileType
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"setFileTypes", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFocus
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"focus", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFontActual
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"font actual", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFontConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeE(&RexxTkData,czTclCommand,name,"font config", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFontCreate
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeE(&RexxTkData,czTclCommand,name,"font create", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFontDelete
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"font delete", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFontFamilies
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError(&RexxTkData);

   if ( my_checkparam( name, argc, 0, 2 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"font families", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFontMeasure
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError(&RexxTkData);

   if ( my_checkparam( name, argc, 2, 4 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"font measure", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFontMetrics
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError(&RexxTkData);

   if ( my_checkparam( name, argc, 1, 0 ) )
      return 1;

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"font metrics", argc, argv, retstr);
}

RFH_RETURN_TYPE TkFontNames
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError(&RexxTkData);

   if ( my_checkparam( name, argc, 0, 0 ) )
      return 1;

   strcpy(czTclCommand, "font names");

   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkFontNames) command: %s\n",__FILE__,__LINE__,czTclCommand);)
   
   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }

   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

RFH_RETURN_TYPE TkCget
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"cget", argc, argv, retstr);
}

RFH_RETURN_TYPE TkCheckButton
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"checkbutton", argc, argv, retstr);
}

RFH_RETURN_TYPE TkRadioButton
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"radiobutton", argc, argv, retstr);
}

RFH_RETURN_TYPE TkIndex
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"index", argc, argv, retstr);
}

RFH_RETURN_TYPE TkSee
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"see", argc, argv, retstr);
}

RFH_RETURN_TYPE TkScan
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"scan", argc, argv, retstr);
}

RFH_RETURN_TYPE TkSelection
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"selection", argc, argv, retstr);
}

RFH_RETURN_TYPE TkEntry
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"entry", argc, argv, retstr);
}

RFH_RETURN_TYPE TkError
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return RxReturnString( retstr, RexxTkData.REXXTK_ErrMsg ) ;
}

RFH_RETURN_TYPE TkListBox
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"listbox", argc, argv, retstr);
}

RFH_RETURN_TYPE TkScrollBar
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"scrollbar", argc, argv, retstr);
}

RFH_RETURN_TYPE TkImageBitmap
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"image create bitmap", argc, argv, retstr);
}

RFH_RETURN_TYPE TkImagePhoto
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(&RexxTkData,czTclCommand,name,"image create photo", argc, argv, retstr);
}

RFH_RETURN_TYPE TkPopup
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 3, 4 ) )
      return( 1 );

   return rtk_TypeB(&RexxTkData,czTclCommand,name,"tk_popup", argc, argv, retstr);
}

RFH_RETURN_TYPE TkConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " configure");
   if (argc >= 2) 
   {
      if ( rtk_procOptArgs(name, czTclCommand,argc,argv,1) )
         return 1;
   }

   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkConfig) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }

   return RxReturnString( retstr, "" ) ;
}

RFH_RETURN_TYPE TkGet
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"get", argc, argv, retstr);
}

RFH_RETURN_TYPE TkCurSelection
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"curselection", argc, argv, retstr);
}

RFH_RETURN_TYPE TkSet
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"set", argc, argv, retstr);
}

RFH_RETURN_TYPE TkDelete
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"delete", argc, argv, retstr);
}

RFH_RETURN_TYPE TkInsert
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"insert", argc, argv, retstr);
}

RFH_RETURN_TYPE TkNearest
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return( 1 );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"nearest", argc, argv, retstr);
}

RFH_RETURN_TYPE TkChooseColor
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeC(&RexxTkData,czTclCommand,name,"tk_chooseColor", argc, argv, retstr);
}

RFH_RETURN_TYPE TkAfter
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   czTclCommand[0] = '\0';
      
   strcat(czTclCommand, "after ");

   /* check if "cancel" or not */
   if (argv[0].strptr[0] == 'c') {
      strcat(czTclCommand, "cancel ");
      strcat(czTclCommand, argv[1].strptr);
   } else {
      strcat(czTclCommand, argv[0].strptr);
      if (argc > 1) {
         strcat(czTclCommand, " {setRexxtk ");
         strcat(czTclCommand, argv[1].strptr);
         strcat(czTclCommand, "}");
      }
   }
      
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkAfter) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

RFH_RETURN_TYPE TkMessageBox
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   czTclCommand[0] = '\0';

   strcat(czTclCommand, "tk_messageBox");

   switch(argc) {
      
      case 6:
        if (argv[5].strptr != NULL) {
           strcat(czTclCommand, " -parent ");
           strcat(czTclCommand, argv[5].strptr);
        }
      case 5:
        if (argv[4].strptr != NULL) {
           strcat(czTclCommand, " -default ");
           strcat(czTclCommand, argv[4].strptr);
        }
      case 4:
        if (argv[3].strptr != NULL) {
           strcat(czTclCommand, " -icon ");
           strcat(czTclCommand, argv[3].strptr);
        }
      case 3:
        if (argv[2].strptr != NULL) {
           strcat(czTclCommand, " -type ");
           strcat(czTclCommand, argv[2].strptr);
        }
      case 2:
        if (argv[1].strptr != NULL) {
           strcat(czTclCommand, " -title {");
           strcat(czTclCommand, argv[1].strptr);
           strcat(czTclCommand, "}");
        }
      case 1:
        if (argv[0].strptr != NULL) {
           strcat(czTclCommand, " -message {");
           strcat(czTclCommand, argv[0].strptr);
           strcat(czTclCommand, "}");
        }
        break;
   }
   
   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

RFH_RETURN_TYPE TkGetOpenFile
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   czTclCommand[0] = '\0';

   if (!strcmp(name, "TKGETSAVEFILE")) 
      strcat(czTclCommand, "tk_getSaveFile -filetypes $rtFileTypes");
   else
      strcat(czTclCommand, "tk_getOpenFile -filetypes $rtFileTypes");

   switch(argc) {
      
      case 5:
        if (argv[4].strptr != NULL) {
           strcat(czTclCommand, " -parent ");
           strcat(czTclCommand, argv[4].strptr);
        }
      case 4:
        if (argv[3].strptr != NULL) {
           strcat(czTclCommand, " -defaultextension ");
           strcat(czTclCommand, argv[3].strptr);
        }
      case 3:
        if (argv[2].strptr != NULL) {
           strcat(czTclCommand, " -title {");
           strcat(czTclCommand, argv[2].strptr);
           strcat(czTclCommand, "}");
        }
      case 2:
        if (argv[1].strptr != NULL) {
           strcat(czTclCommand, " -initialfile ");
           strcat(czTclCommand, argv[1].strptr);
        }
      case 1:
        if (argv[0].strptr != NULL) {
           strcat(czTclCommand, " -initialdir ");
           strcat(czTclCommand, argv[0].strptr);
        }
        break;
   }

   DEBUGDUMP(fprintf(stderr,"%s-%d: (%s) command: %s\n",__FILE__,__LINE__,name,czTclCommand);)
   
   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

RFH_RETURN_TYPE TkPack
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeF(&RexxTkData,czTclCommand,name,"pack", argc, argv, retstr);
}

/*
 * winfo command ?arg?
 * TkWinfo(command [,arg,...])
 */
RFH_RETURN_TYPE TkWinfo
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   int i;

   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 0 ) )
      return 1;

   czTclCommand[0] = '\0';
   strcpy( czTclCommand, "winfo " );
   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   for ( i = 1; i < argc; i++ )
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[i].strptr, argv[i].strlength);
   }
      
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkWinfo) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) != TCL_OK) {
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   
   return RxReturnString( retstr, RexxTkData.RexxTkInterp->result ) ;
}

RFH_RETURN_TYPE TkWait
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   char *cmd=czTclCommand;
   int state=0,len,i;
   int word2_start=0;
   int word1_length=0;

   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   /*
    * Need to copy the static string "rexxtk_setrexxtk" to a piece of
    * memory that is writeable, because Tcl updates this data :-( Grrrr.
    * Tcl 8.1 broke this.
    */
   strcpy( czTclCommand, rexxtk_setrexxtk);
   if (Tcl_Eval(RexxTkData.RexxTkInterp, czTclCommand) !=TCL_OK)
   {
      DEBUGDUMP(fprintf(stderr,"%s-%d: (TkWait) error: %s at %d\n",__FILE__,__LINE__,RexxTkData.RexxTkInterp->result, RexxTkData.RexxTkInterp->errorLine);)
      return ReturnError(&RexxTkData, retstr, -1, RexxTkData.RexxTkInterp->result );
   }
   /*
    * TkWait returns the Rexx function to be called as the first word,
    * followed by optional parameters. When using the standard method
    * of calling TkWait; ie 
    *   RexxTkData.RexxTkInterpret 'call' Tkwait()
    * any optional parameters will always be uppercased.
    * We need to split the return from Tcl_Eval() into the Rexx
    * function, and then the optional parameters. The value returned to
    * the Rexx program will have quotes around the optional parameters
    * to ensure they are NOT uppercased.
    */
   len = strlen( RexxTkData.RexxTkInterp->result ) ;
   if ( len > TCLCOMMANDLEN + 2)
   {
      cmd = malloc( len + 3 );
   }
   for (i = 0; i < len; i++ )
   {
      if ( state == 0 )
      {
         if ( RexxTkData.RexxTkInterp->result[i] == ' ' )
         {
            state = 1;
            word1_length = i;
         }
      }
      else
      {
         if ( RexxTkData.RexxTkInterp->result[i] != ' ' )
         {
            word2_start = i;
            break;
         }
      }
   }
   if ( word2_start == 0 )
   {
      /*
       * No parameters...
       */
      strcpy( cmd, RexxTkData.RexxTkInterp->result );
   }
   else
   {
      strncpy( cmd, RexxTkData.RexxTkInterp->result, word1_length );
      cmd[word1_length] = '\0';
      strcat( cmd, " \"");
      strcat( cmd, RexxTkData.RexxTkInterp->result+word2_start );
      strcat( cmd, "\"");
   }
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkWait) result: %s\n",__FILE__,__LINE__,cmd);)
   /*
    * Free cmd if it was allocated by us.
    */
   return RxReturnStringAndFree( retstr, cmd, (cmd!=czTclCommand) ) ;
}

RFH_RETURN_TYPE TkDropFuncs
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
 ULONG rc=0;
 int unload=0;

 if ( my_checkparam(name, argc, 0, 1 ) )
    return( 1 );
 if ( argv[0].strlength == 6
 &&   memcmpi( argv[0].strptr, "UNLOAD", 6 ) == 0 )
    unload = 1;
 rc = DeregisterRxFunctions( unload );
 return RxReturnNumber( retstr, rc );
}

RFH_RETURN_TYPE TkVariable
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   ULONG rc = 0L;
   char buf[50];

   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData.REXXTK_IntCode) ClearIntError( &RexxTkData);

   if ( my_checkparam( name, argc, 1, 2 ) )
      return( 1 );
   if ( memcmp( "DEBUG", argv[0].strptr, argv[0].strlength ) == 0 )
   {
      if ( argc == 1 )
      {
         sprintf( buf, "%d", RxGetRunFlags( ) );
         return RxReturnString( retstr, buf );
      }
      else
      {
         RxSetRunFlags ( atoi( (char *)argv[1].strptr ) );
         return RxReturnNumber( retstr, 0 );
      }
   }
   else if ( memcmp( "VERSION", argv[0].strptr, argv[0].strlength ) == 0 )
   {
      if ( argc == 1 )
      {
         sprintf( buf, "%s %s %s", RxPackageName, REXXTK_VERSION, REXXTK_DATE );
         return RxReturnString( retstr, buf );
      }
      else
         return RxReturnString( retstr, "ERROR: Cannot set variable; VERSION" );
   }
   else if ( memcmp( "DEBUGFILE", argv[0].strptr, argv[0].strlength ) == 0 )
   {
      if ( argc == 1 )
         return RxReturnString( retstr, RxGetTraceFile() );
      else
      {
         rc = RxSetTraceFile( (char *)argv[1].strptr );
         return RxReturnNumber( retstr, rc );
      }
   }
   sprintf( buf, "ERROR: Invalid variable; %s", argv[0].strptr );
   return RxReturnString( retstr, buf );
}


RFH_RETURN_TYPE TkLoadFuncs
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   ULONG rc = 0L;

#if defined(DYNAMIC_LIBRARY)
   if ( !QueryRxFunction( "TKWAIT" ) )
   {
      rc = InitRxPackage( NULL );
      /* 
       * Register all external functions
       */
      if ( !rc )
      {
         rc = RegisterRxFunctions( );
      }
   }
#endif
   return RxReturnNumber( retstr, rc );
}
   
/*
 * The following functions are used in rxpackage.c
 */

/*-----------------------------------------------------------------------------
 * Print a usage message.
 *----------------------------------------------------------------------------*/
void usage

#ifdef HAVE_PROTO
   (void)
#else
   ()
#endif

{
   (void)fprintf(stderr,
      "\nVersion: %s %s %s\n\nUsage:   %s [-h]\n         %s [-idvf<trace file>] [Rexx program name]\n\n",
      RxPackageName,
      REXXTK_VERSION,
      REXXTK_DATE,
      RxPackageName,
      RxPackageName);
   exit( 1 );
}

/*-----------------------------------------------------------------------------
 * Execute any initialisation
 *----------------------------------------------------------------------------*/
int InitialisePackage

#ifdef HAVE_PROTO
   ( void )
#else
   ( )
#endif

{
   int rc;

   InternalTrace( "InitialisePackage", NULL );
   ClearIntError( &RexxTkData);
#ifdef WIN32
   /*
    * Get the entry points in the tlc and tk libraries
    */
   if ( GetTclTkLibraries() )
   {
      fprintf(stderr, "Could not find any supported Tcl/Tk DLLs.\n");
      return 1;
   }
#endif
   /*
    * create the tcl RexxTkData.RexxTkInterperator
    */
   RexxTkData.RexxTkInterp = Tcl_CreateInterp();

Tcl_FindExecutable("rexxtk");

   DEBUGDUMP(fprintf(stderr,"%s-%d: After Tcl_CreateInterp()\n",__FILE__,__LINE__);)
   /*
    * Init the tcl RexxTkData.RexxTkInterp and the tk stuff, too.
    */
   if (( rc = Tcl_Init(RexxTkData.RexxTkInterp)) != TCL_OK )
   {
      fprintf(stderr, "Tcl_Init failed miserably. rc: %d.", rc );
      if ( RexxTkData.RexxTkInterp && RexxTkData.RexxTkInterp->result )
         fprintf(stderr, " Result: %s\n", RexxTkData.RexxTkInterp->result);
      else
         fprintf(stderr, "\n" );
      return(1);
   }
   DEBUGDUMP(fprintf(stderr,"%s-%d: After Tcl_Init()\n",__FILE__,__LINE__);)
   if (( rc = Tk_Init(RexxTkData.RexxTkInterp)) != TCL_OK )
   {
      fprintf(stderr, "Tk_Init failed miserably. rc: %d.", rc );
      if ( RexxTkData.RexxTkInterp && RexxTkData.RexxTkInterp->result )
         fprintf(stderr, " Result: %s\n", RexxTkData.RexxTkInterp->result);
      else
         fprintf(stderr, "\n" );
      return(1);
   }
   DEBUGDUMP(fprintf(stderr,"%s-%d: After Tk_Init()\n",__FILE__,__LINE__);)

   /*
    * Install the root window destroy binding and
    * a proceedure for handling the return value for the
    * rexx/tk commands and setting the rtFileTypes var
    * for the tk_getOpenFile filetypes option.
    */
   if (Tcl_Eval(RexxTkData.RexxTkInterp,
      "bind . <Destroy> {setRexxtk Quit %W}\n"
      "set rtFileTypes {}\n"
      "set rexxtkcommandlist {}\n"
      "set rexxtkcommandcount 0\n"
      "proc setRexxtk {args} {\n"
         "global rexxtkcommandlist\n"
         "global rexxtkcommandcount\n"
         "if {[llength $args] == 2} {\n"
         "   set arg0 [lindex $args 0]\n"
         "   set arg1 [lindex $args 1]\n"
         "   if {[string compare $arg0 \"Quit\"] == 0} {\n"
         "      if {[string compare $arg1 \".\"] == 0} {\n"
         "         set args {Quit}\n"
         "      } else {return}\n"
         "   }\n"
         "}\n"
         "set rexxtkcommandlist [linsert $rexxtkcommandlist 0 $args]\n"
         "set rexxtkcommandcount [expr $rexxtkcommandcount+1]\n"
      "}\n"
      "proc setFileTypes {type args} {\n"
         "global rtFileTypes\n"
         "if {$type == {clear}} {\n"
            "set rtFileTypes {}\n"
            "return\n"
         "}\n"
         "lappend rtFileTypes [list $type $args]\n"
      "}\n"
      ) !=TCL_OK) {
      fprintf(stderr, "Tk_Eval failed miserably at line %d: %s\n", RexxTkData.RexxTkInterp->errorLine, RexxTkData.RexxTkInterp->result);
      return 1;
   }
   DEBUGDUMP(fprintf(stderr,"%s-%d: After Tcl_Eval()\n",__FILE__,__LINE__);)
   return 0;
}

/*-----------------------------------------------------------------------------
 * Execute any termination
 *----------------------------------------------------------------------------*/
int TerminatePackage

#ifdef HAVE_PROTO
   ( void )
#else
   ( )
#endif

{
   return 0;
}

/*
 * This function is used to expose the base Rexx/Tk environment
 * include the Tcl interpreter
 * to other Rexx/Tk external function libraries
 */
RFH_RETURN_TYPE TkGetBaseData
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return RxReturnNumber( retstr, (long)&RexxTkData );
}

#if defined(USE_REXX6000)
/*
 * This function is used as the entry point for the REXX/6000
 * Rexx Interpreter
 * If you change this table, don't forget to change the table at the
 * start of this file.
 */
USHORT InitFunc( RXFUNCBLOCK **FuncBlock )
{
   static RXFUNCBLOCK funcarray[] =
   {
      { "TKACTIVATE"            ,TkActivate           ,NULL },
      { "TKADD"                 ,TkAdd                ,NULL },
      { "TKAFTER"               ,TkAfter              ,NULL },
      { "TKBBOX"                ,TkBBox               ,NULL },
      { "TKBIND"                ,TkBind               ,NULL },
      { "TKBUTTON"              ,TkButton             ,NULL },
      { "TKCANVAS"              ,TkCanvas             ,NULL },
      { "TKCANVASADDTAG"        ,TkCanvasAddTag       ,NULL },
      { "TKCANVASARC"           ,TkCanvasArc          ,NULL },
      { "TKCANVASBIND"          ,TkCanvasBind         ,NULL },
      { "TKCANVASBITMAP"        ,TkCanvasBitmap       ,NULL },
      { "TKCANVASCANVASX"       ,TkCanvasCanvasx      ,NULL },
      { "TKCANVASCANVASY"       ,TkCanvasCanvasy      ,NULL },
      { "TKCANVASCGET"          ,TkCanvasCget         ,NULL },
      { "TKCANVASCOORDS"        ,TkCanvasCoords       ,NULL },
      { "TKCANVASDCHARS"        ,TkCanvasDChars       ,NULL },
      { "TKCANVASDTAG"          ,TkCanvasDTag         ,NULL },
      { "TKCANVASDELETE"        ,TkCanvasDelete       ,NULL },
      { "TKCANVASFIND"          ,TkCanvasFind         ,NULL },
      { "TKCANVASFOCUS"         ,TkCanvasFocus        ,NULL },
      { "TKCANVASIMAGE"         ,TkCanvasImage        ,NULL },
      { "TKCANVASLINE"          ,TkCanvasLine         ,NULL },
      { "TKCANVASOVAL"          ,TkCanvasOval         ,NULL },
      { "TKCANVASPOLYGON"       ,TkCanvasPolygon      ,NULL },
      { "TKCANVASPOSTSCRIPT"    ,TkCanvasPostscript   ,NULL },
      { "TKCANVASRECTANGLE"     ,TkCanvasRectangle    ,NULL },
      { "TKCANVASTEXT"          ,TkCanvasText         ,NULL },
      { "TKCANVASTYPE"          ,TkCanvasType         ,NULL },
      { "TKCANVASWINDOW"        ,TkCanvasWindow       ,NULL },
      { "TKCGET"                ,TkCget               ,NULL },
      { "TKCHECKBUTTON"         ,TkCheckButton        ,NULL },
      { "TKCHOOSECOLOR"         ,TkChooseColor        ,NULL },
      { "TKCONFIG"              ,TkConfig             ,NULL },
      { "TKCURSELECTION"        ,TkCurSelection       ,NULL },
      { "TKDELETE"              ,TkDelete             ,NULL },
      { "TKDESTROY"             ,TkDestroy            ,NULL },
      { "TKDROPFUNCS"           ,TkDropFuncs          ,NULL },
      { "TKENTRY"               ,TkEntry              ,NULL },
      { "TKERROR"               ,TkError              ,NULL },
      { "TKFOCUS"               ,TkFocus              ,NULL },
      { "TKFONTACTUAL"          ,TkFontActual         ,NULL },
      { "TKFONTCONFIG"          ,TkFontConfig         ,NULL },
      { "TKFONTCREATE"          ,TkFontCreate         ,NULL },
      { "TKFONTDELETE"          ,TkFontDelete         ,NULL },
      { "TKFONTFAMILIES"        ,TkFontFamilies       ,NULL },
      { "TKFONTMEASURE"         ,TkFontMeasure        ,NULL },
      { "TKFONTMETRICS"         ,TkFontMetrics        ,NULL },
      { "TKFONTNAMES"           ,TkFontNames          ,NULL },
      { "TKFRAME"               ,TkFrame              ,NULL },
      { "TKGET"                 ,TkGet                ,NULL },
      { "TKGETOPENFILE"         ,TkGetOpenFile        ,NULL },
      { "TKGETSAVEFILE"         ,TkGetOpenFile        ,NULL },
      { "TKGRAB"                ,TkGrab               ,NULL },
      { "TKGRID"                ,TkGrid               ,NULL },
      { "TKGRIDBBOX"            ,TkGridBbox           ,NULL },
      { "TKGRIDCOLUMNCONFIG"    ,TkGridColumnConfig   ,NULL },
      { "TKGRIDCONFIG"          ,TkGridConfig         ,NULL },
      { "TKGRIDFORGET"          ,TkGridForget         ,NULL },
      { "TKGRIDINFO"            ,TkGridInfo           ,NULL },
      { "TKGRIDLOCATION"        ,TkGridLocation       ,NULL },
      { "TKGRIDPROPAGATE"       ,TkGridPropagate      ,NULL },
      { "TKGRIDROWCONFIG"       ,TkGridRowConfig      ,NULL },
      { "TKGRIDREMOVE"          ,TkGridRemove         ,NULL },
      { "TKGRIDSIZE"            ,TkGridSize           ,NULL },
      { "TKGRIDSLAVES"          ,TkGridSlaves         ,NULL },
      { "TKIMAGEBITMAP"         ,TkImageBitmap        ,NULL },
      { "TKIMAGEPHOTO"          ,TkImagePhoto         ,NULL },
      { "TKINDEX"               ,TkIndex              ,NULL },
      { "TKINSERT"              ,TkInsert             ,NULL },
      { "TKITEMCONFIG"          ,TkItemConfig         ,NULL },
      { "TKLABEL"               ,TkLabel              ,NULL },
      { "TKLISTBOX"             ,TkListBox            ,NULL },
      { "TKLOADFUNCS"           ,TkLoadFuncs          ,NULL },
      { "TKMENU"                ,TkMenu               ,NULL },
      { "TKMENUCLONE"           ,TkMenuClone          ,NULL },
      { "TKMENUENTRYCGET"       ,TkMenuEntryCget      ,NULL },
      { "TKMENUENTRYCONFIG"     ,TkMenuEntryConfig    ,NULL },
      { "TKMENUINVOKE"          ,TkMenuInvoke         ,NULL },
      { "TKMENUPOST"            ,TkMenuPost           ,NULL },
      { "TKMENUPOSTCASCADE"     ,TkMenuPostCascade    ,NULL },
      { "TKMENUTYPE"            ,TkMenuType           ,NULL },
      { "TKMENUUNPOST"          ,TkMenuUnPost         ,NULL },
      { "TKMENUYPOSITION"       ,TkMenuYPosition      ,NULL },
      { "TKMESSAGEBOX"          ,TkMessageBox         ,NULL },
      { "TKNEAREST"             ,TkNearest            ,NULL },
      { "TKPACK"                ,TkPack               ,NULL },
      { "TKPOPUP"               ,TkPopup              ,NULL },
      { "TKRADIOBUTTON"         ,TkRadioButton        ,NULL },
      { "TKSCALE"               ,TkScale              ,NULL },
      { "TKSCAN"                ,TkScan               ,NULL },
      { "TKSEE"                 ,TkSee                ,NULL },
      { "TKSELECTION"           ,TkSelection          ,NULL },
      { "TKSCROLLBAR"           ,TkScrollBar          ,NULL },
      { "TKSET"                 ,TkSet                ,NULL },
      { "TKSETFILETYPE"         ,TkSetFileType        ,NULL },
      { "TKTCL"                 ,TkTcl                ,NULL },
      { "TKTEXT"                ,TkText               ,NULL },
      { "TKTEXTTAGBIND"         ,TkTextTagBind        ,NULL },
      { "TKTEXTTAGCONFIG"       ,TkTextTagConfig      ,NULL },
      { "TKTOPLEVEL"            ,TkTopLevel           ,NULL },
      { "TKVAR"                 ,TkVar                ,NULL },
      { "TKVARIABLE"            ,TkVariable           ,NULL },
      { "TKWAIT"                ,TkWait               ,NULL },
      { "TKWINFO"               ,TkWinfo              ,NULL },
      { "TKWM"                  ,TkWm                 ,NULL },
      { "TKXVIEW"               ,TkXView              ,NULL },
      { "TKYVIEW"               ,TkYView              ,NULL },
      { NULL, NULL, NULL }
   } ;
   *FuncBlock = funcarray;
   return (USHORT)0;
}
#endif

#ifdef WIN32
int GetTclTkLibraries(void)
{
   HINSTANCE tcl_handle=NULL,tk_handle;
   int i;
   for ( i = 0; tcllibs[i] != NULL; i++ )
   {
      tcl_handle = LoadLibrary( tcllibs[i] );
      if ( tcl_handle != NULL )
      {
         tk_handle = LoadLibrary( tklibs[i] );
         if ( tk_handle == NULL )
         {
            return 1;
         }
         if (( RexxTkData.Dyn_TclInit = (TclInitType*)GetProcAddress( (HMODULE)tcl_handle, "Tcl_Init" )) == NULL )
         {
            return 1;
         }
         if (( RexxTkData.Dyn_TclEval = (TclEvalType*)GetProcAddress( (HMODULE)tcl_handle, "Tcl_Eval" )) == NULL )
         {
            return 1;
         }
         if (( RexxTkData.Dyn_TclCreateInterp = (TclCreateInterpType*)GetProcAddress( (HMODULE)tcl_handle, "Tcl_CreateInterp" )) == NULL )
         {
            return 1;
         }
         if (( RexxTkData.Dyn_TkInit = (TkInitType*)GetProcAddress( (HMODULE)tk_handle, "Tk_Init" )) == NULL )
         {
            return 1;
         }
         if (( RexxTkData.Dyn_TclFindExecutable = (TclFindExecutableType*)GetProcAddress( (HMODULE)tcl_handle, "Tcl_FindExecutable" )) == NULL )
         {
            return 1;
         }
         break;
      }
   }
   if ( tcl_handle = NULL )
      return 1;
   return 0;
}
#endif
