/**/
Call Rxfuncadd 'TkLoadFuncs','rexxtk','TkLoadFuncs'

If TkLoadFuncs() \= 0 Then exit

Trace o

call SetupMainWindow

/* do our "normal" Rexx/Tk main loop */

do forever
   interpret 'call' TkWait()
end

exit:
exit

/* call the UI code for the main window that was created by
   SpecTcl */
SetupMainWindow:

   /* first set a title for our app's main window */
   call TkWm 'title', '.', 'SpecTcl Test App'

   /* Now add the menus that we want for the main window.
      SpecTcl doesn't create menus is why we have to do that
      with code.  (Oh, well) */
   
   /* make a menu that will be our menubar */
   menubar = TkMenu('.m1')

   /* add a File menu to the menubar.  the file
      menu will 'cascade' off of the menu bar */
   /* create another menu widget to be our file menu
      and tell the menubar menu about it... the "tearoff"
      option, well, just remove it and see what happens.*/
   menu = TkMenu('.m1.m1','-tearoff', 0)
   label = 'File'
   call TkAdd menubar, 'cascade', 'label', 'menu', 

   /* now add items to the File menu */
   call TkAdd menu, 'command', '-label', 'Test...', '-command', 'AnotherWin'

   /* adding another item... */
   label = 'Quit'
   command = 'exit'
   call TkAdd '.m1.m1', 'command', 'label', 'command'

   /* attach the menubar to the main window */
   call TkConfig '.', '-menu', menubar

   /* NOW we get to use the UI code generated by SpecTcl...
      Call TCL to load in the UI code with the "source" command. */
   rc = TkTcl('source', 'mdlog.ui.tcl')

   /* AND now initialize the window.
      The 1st arg is the name of the window that was created in
      SpecTcl, which is just the name of the file plus an
      underscore and "ui"... The 2nd arg is the TK pathname
      of the window and Since this will be
      our "root" or main window, we are passing the root
      window name, "." 
   */
   rc = TkTcl('mdlog_ui','.')

   /* Finally, we'll go ahead and load the other windows
      UI files for the program, but just not initialize
      (and thus display) them right yet */
   rc = TkTcl('source', 'dlog2.ui.tcl')
   
   return

/* Display the other window that we 'sourced' in the SetupMainWindow
   routine above */
AnotherWin:

   /* make a new toplevel window to load our UI
      design into */
   call TkToplevel '.another'

   /* grab it straight off */
   call TkGrab '.another'

   /* make the window so it isn't resizable.
      This is what most temporary dialogs are */
   call TkWm 'resizable', '.another', 0, 0

   /* create and display the window using the new toplevel */
   call TkTcl 'dlog2_ui', '.another'
  
   return

/* A routine to handle when the user presses Okay
   in the dlog2 dialog window */
D2Okay:

   /* The name and phone text are in textvariables defined
      in the properties of the text field using SpecTcl.
      These are TK Variables, so we just use TkVar to get
      their value.  Remember that TK variables are case
      specific...  Upper/lower case matters.*/
   name = TkVar('name')
   phone = TkVar('phone')

   /* Now let's set the prompt in the main window with that info.
      Note that the name of the objects in SpecTcl are the name
      of the window PLUS the name of the object concated on.  So,
      since we named the label at the bottom of the main window,
      "prompt" that would make it ".prompt" since it is in the main
      window, which is called "." (since it's the root window).*/
   text = 'Your name is' name 'and your phone is' phone '.'
   call TkConfig '.prompt', 'text'

   /* Of course,  we should close the little window by just
      destroying it. */
   call TkDestroy '.another'
      
   return


Up: /* the up button was pressed... fetch the radio button value */
   
   /* The radio buttons are an example of a control that is
      not currently buildable in "native" Rexx/Tk, but since
      it has a "variable" it can be set and queried.

      NOTE: The "variable" in radio buttons is what makes them
      mutually exclusive.  Any button that shares the same variable
      will be automatically grouped as a radio button should.  The
      frame around the buttons in the included UI file is just an example
      of using a frame to group elements and is not needed to group
      the radio buttons together. */

   radio = TkVar('radio')

   text = 'Radio button "'radio'" was pressed.'
   call TkConfig '.prompt', 'text'

   /* now clear the radio button variable to clear
      the selection */
   call TkVar 'radio', ''

   return

Down: /* fetch the slider value */

   /* we assigned a textvariable to the scale,
      so we can just fetch that value */
   scale = TkVar('scale')

   text = 'Slide at' scale'. Moving back 10.'
   call TkConfig '.prompt', 'text'

   if scale >= 10 then scale = scale - 10

   call TkVar 'scale', scale

   return

D2Cancel: /* just kill the window */

   call TkDestroy '.another'
   return




/****** NOT FINISHED *********/
Around:
   

   Return
