\name{VersionNumber-class}
\docType{class}
\alias{VersionNumber-class}
\alias{major}
\alias{minor}
\alias{stringRep}
\alias{revision}
\alias{VersionNumber}
\alias{max.VersionNumber}
\alias{min.VersionNumber}
\alias{!=,VersionNumber-method}
\alias{<,VersionNumber-method}
\alias{<=,VersionNumber-method}
\alias{==,VersionNumber-method}
\alias{>,VersionNumber-method}
\alias{>=,VersionNumber-method}
\alias{as.character,VersionNumber-method}
\alias{major,VersionNumber-method}
\alias{minor,VersionNumber-method}
\alias{revision,VersionNumber-method}
\alias{show,VersionNumber-method}
\alias{stringRep,VersionNumber-method}
\title{A class to handle version numbers}
\description{This class maintains a version number and provides
  appropriate operations to manipulate it}
\section{Objects from the Class}{
  VersionNumber objects should be created with the function buildVersionNumber.
}
\section{Slots}{
  \describe{
    \item{\code{stringRep}:}{Object of class \code{"character"}, string
      representation of the version (e.g. "1.2.3")}
  }
}

\section{Methods}{
  \describe{
    \item{major}{\code{(VersionNumber)}: The major number of the
      version number }
    \item{minor}{\code{(VersionNumber)}: The minor number of the
      version number }
    \item{revision}{\code{(VersionNumber)}: The revision portion of
      the version number }
    \item{stringRep}{\code{(VersionNumber)}: The string representation
      of the version number }
    \item{show}{\code{(VersionNumber)}: Outputs a string representation.}
    \item{as.character}{\code{(VersionNumber)}: Outputs a string representation.}
    \item{==}{\code{(VersionNumber)}: Equals comparitor}
    \item{!=}{\code{(VersionNumber)}: Not equals comparitor}
    \item{>=}{\code{(VersionNumber)}: Greater or equal comparitor}
    \item{<=}{\code{(VersionNumber)}: Less or equal comparitor}
    \item{<}{\code{(VersionNumber)}: Less than comparitor}
    \item{>}{\code{(VersionNumber)}: Greater than comparitor}    
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{buildVersionNumber}}}
\examples{
a <- buildVersionNumber("1.2.3")
major(a)
minor(a)
revision(a)
stringRep(a)
}
\keyword{classes}
