/* io-utils.h - Various utilities dealing with files.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __IO_UTILS_H__
#define __IO_UTILS_H__

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "common.h"
#include "llist.h"

bool file_exists(const char *file);
#define is_directory(x)		S_ISDIR(stat_mode(x))
mode_t stat_mode(const char *file);
off_t file_size(const char *file);
char *read_line(FILE *in);
char *create_temporary_file(char *base);
char *backticks(const char *program, char *const args[], int *rc);
LList *read_directory(const char *dir);
/* ssize_t xread(int fd, void *buf, size_t count); */
/* ssize_t xwrite(int fd, const void *buf, size_t count); */
int fskip(FILE *file, uint32_t bytes);
int fpad(FILE *file, char byte, uint32_t bytes);

#endif
