
/**************************************************************************
 *                                                                        *
 *  Regina - A Normal Surface Theory Calculator                           *
 *  KDE User Interface                                                    *
 *                                                                        *
 *  Copyright (c) 1999-2006, Ben Burton                                   *
 *  For further details contact Ben Burton (bab@debian.org).              *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,       *
 *  MA 02110-1301, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

#include "surfaces/nnormalsurfacelist.h"
#include "utilities/stringutils.h"

#include "reginaprefset.h"

#include <fstream>
#include <qdir.h>

namespace {
    std::string INACTIVE("## INACTIVE ##");
}

ReginaPrefSet::ReginaPrefSet() :
        autoDock(true),
        autoFileExtension(true),
        censusFiles(defaultCensusFiles()),
        displayIcon(true),
        displayTagsInTree(false),
        pythonAutoIndent(true),
        pythonSpacesPerTab(4),
        pythonWordWrap(false),
        snapPeaClosed(false),
        surfacesCreationCoords(regina::NNormalSurfaceList::STANDARD),
        treeJumpSize(10),
        triEditMode(DirectEdit),
        triGAPExec("gap"),
        triGraphvizExec("neato"),
        triInitialTab(Gluings),
        triInitialSkeletonTab(SkelComp),
        triInitialAlgebraTab(Homology),
        triSurfacePropsThreshold(6) {
}

ReginaFilePrefList ReginaPrefSet::defaultCensusFiles() {
    ReginaFilePrefList ans;

    ans.push_back(ReginaFilePref(REGINA_DATADIR
        "/examples/closed-or-census.rga"));
    ans.push_back(ReginaFilePref(REGINA_DATADIR
        "/examples/closed-nor-census.rga"));
    ans.push_back(ReginaFilePref(REGINA_DATADIR
        "/examples/knot-link-census.rga"));
    ans.push_back(ReginaFilePref(REGINA_DATADIR
        "/examples/snappea-census.rga"));
    ans.push_back(ReginaFilePref(REGINA_DATADIR
        "/examples/closed-hyp-census.rga"));

    return ans;
}

QString ReginaPrefSet::pythonLibrariesConfig() {
    return QDir::homeDirPath() + "/.regina-libs";
}

bool ReginaPrefSet::readPythonLibraries() {
    pythonLibraries.clear();

    std::ifstream in(pythonLibrariesConfig().ascii());
    if (! in)
        return false;

    bool active;
    std::string line;
    while (! in.eof()) {
        line.clear();
        std::getline(in, line);

        // Is the file inactive?
        active = true;
        if (regina::startsWith(line, INACTIVE)) {
            active = false;
            line = line.substr(INACTIVE.length());
        }

        line = regina::stripWhitespace(line);

        // Is it a file at all?
        if (line.empty() || line[0] == '#')
            continue;

        // Add the file.
        pythonLibraries.push_back(ReginaFilePref(line.c_str(), active));
    }

    return true;
}

bool ReginaPrefSet::writePythonLibraries() const {
    std::ofstream out(pythonLibrariesConfig().ascii());
    if (! out)
        return false;

    out << "# Python libraries configuration file\n#\n";
    out << "# Automatically generated by the KDE user interface.\n\n";

    for (ReginaFilePrefList::const_iterator it = pythonLibraries.begin();
            it != pythonLibraries.end(); it++)
        if ((*it).active)
            out << (*it).filename << '\n';
        else
            out << INACTIVE << ' ' << (*it).filename << '\n';

    return true;
}

