#include "allegro.h"
#include "trigtable.h"
#include "defs.h"
#include "hull_rotate.h"

RotateHull::RotateHull( int _color, int mY, int mX, int sf, int * _shade ):
HullObject( NULL, 100, 0, 1, 1, 10, false, NULL ) {

	color = _color;

	maxX = mX;
	maxY = mY;

	sd = sf;

	angX = rnd(360);
	angY = rnd(360);

	dX = (rnd(8)+sd)*(rnd(2)*2-1);
	dY = (rnd(8)+sd)*(rnd(2)*2-1);

	//dX = rnd(20) - 10;
	//dY = rnd(20) - 10;
	dwX = dX;
	dwY = dY;
	ox = angX;
	oy = angY;

	ox2 = angX;
	oy2 = angY;
	shade = _shade;
}


void RotateHull::Draw( BITMAP * who, int x, int y ) {

	ox2 = ox;
	oy2 = oy;
	ox = angX;
	oy = angY;
	angX += dX;
	angY += dY;
	while( angX >= 360 ) angX -= 360;
	while ( angX < 0 ) angX += 360;
	while ( angY >= 360 ) angY -= 360;
	while( angY < 0 ) angY += 360;
	int zz = (rnd(2)*2)-1;
	if ( rnd(15) == rnd(15) )
		dwX = (rnd(8)+sd )*zz;
	zz = (rnd(2)*2)-1;
	if ( rnd(15) == rnd(15) )
		dwY = (rnd(8)+sd )*zz;
	if ( dX < dwX ) dX++;
	if ( dX > dwX ) dX--;
	if ( dY < dwY ) dY++;
	if ( dY > dwY ) dY--;
	int nx = (int)(x+tcos[angX]*maxX/2);
	int ny = (int)(y+tsine[angY]*maxY/2);
	int lx = (int)(x+tcos[ox]*maxX/2);
	int ly = (int)(y+tsine[oy]*maxY/2);
	line( who, lx, ly, nx, ny, shade[color] );
	nx = (int)(x+tcos[ox2]*maxX/2);
	ny = (int)(y+tsine[oy2]*maxY/2);
	line( who, lx, ly, nx, ny, shade[color] );

}
