# Copyright 2004-2005 Joe Wreschnig, Michael Urman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# $Id: wavpack.py 3874 2006-09-24 23:57:49Z piman $

import gst

from formats._apev2 import APEv2File

extensions = [".wv"]
try:
    from mutagen.wavpack import WavPack
except ImportError:
    extensions = []
else:
    if gst.registry_get_default().find_plugin("wavpack") is None:
        extensions = []

class WavpackFile(APEv2File):
    format = "WavPack"
    
    def __init__(self, filename):
        audio = WavPack(filename)
        super(WavpackFile, self).__init__(filename, audio)
        self["~#length"] = int(audio.info.length)
        self.sanitize(filename)

info = WavpackFile
