#ifndef _QTERMDECODE_H_
#define _QTERMDECODE_H_

#include "qtermtextline.h"
#include <qlist.h>

class QTermDecode;

// this for FSM
typedef void ( QTermDecode::*StateFunc )();

struct StateOption
{
	int byte;		// char value to look for; -1==end/default
	StateFunc action;
	StateOption *nextState;
};

// i think not use signal and slot in this class
class QTermDecode	// : QObject
{
//	Q_OBJECT
	
public:
	QTermDecode( QList<QTermTextLine> *list );
	~QTermDecode();

	void setBBSCode( int );
	// translate data from telnet socket to our own buffer
	void ansiDecode( char *cstr, int length );
	
	bool bellReceive()	{ return bBell; }
	int currentCaretX()	{ return caretX; }
	int currentCaretY()	{ return caretY; }

	bool pageState()	{ return bPage; }
	
//signals:
//	void decodeFinished();
		
private:		
// escape sequence actions
// you'd better see FSM structure array in QTermDecode.cpp

	void nextLine();
	
	void getAttr();	

	// char screen functions
	void deleteStr();
	void deleteLine();
	void insertStr();
	void insertLine();
	void eraseStr();	
	void eraseLine();
	
	void eraseDisplay();
	
	void scrollLines( int startY, int endY, int num );	// does clear
	void shiftStr( int index, int startX, int len, int num );
	void clearArea( int startX, int startY, int width, int height, short attr);

	// cursor functions
	void moveCursor( int x, int y );
	void saveCursor() { saveX = caretX; saveY = caretY; }
	void restoreCursor();
	void cursorLeft();
	void cursorDown();
	void cursorRight();
	void cursorUp();
	void cursorPosition();	

/*****************************************************************************/
// other escape sequence actions
	void normalInput();
	
	// action parameters
	void clearParam();
	void paramDigit();
	void nextParam();	
		
	// non-printing characters
	void cr(), lf(), ff(), bell(), tab(), bs();
/******************************************************************************/	
	
private:
	int caretX, caretY, saveX, saveY;
	
	bool bBell;
	
	short m_attr, defaultAttr;

// ********** ansi decoder states ****************	
	StateOption *currentState;
	static StateOption normalState[], escState[], bracketState[];

// ********** decoder		*****************
	//QCString inputData;
	char *inputData;
	int inputLength, dataIndex;

	bool bPage;

	int nParam, param[30];
	bool bParam;

	QTermTextLine *currentLine;
	QList<QTermTextLine> *lineList;

	int nBBSCode;
};
	
#endif
